/* Copyright (c) 1999 Thorsten Kukuk
   Author: Thorsten Kukuk <kukuk@suse.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "nis_db.h"
#include "db_private.h"
#include "nisdb_priv.h"

db_status
db_destroy_table (const char *table_name)
{
  table_t *tobj;

  if (table_name == NULL || strlen (table_name) == 0)
    return DB_BADTABLE;

  /* Get the table entries to delete all */
  tobj = __destroy_table (table_name);
  if (tobj == NULL)
    return DB_BADTABLE;

  while (tobj->entry != NULL)
    {
      entry_t *eobj = tobj->entry;

      xdr_free ((xdrproc_t) __nisdb_xdr_entry_obj, (caddr_t) eobj->object);
      free (eobj->object);
      free (eobj->hashes);
      tobj->entry = tobj->entry->next;
      free (eobj);
    }

  if (tobj->name)
    free (tobj->name);

  if (tobj->fp_log)
    fclose (tobj->fp_log);

  if (tobj->path)
    {
      unlink (tobj->path);
      free (tobj->path);
    }

  if (tobj->path_log)
    {
      unlink (tobj->path_log);
      free (tobj->path_log);
    }

  xdr_free ((xdrproc_t) __nisdb_xdr_table_obj, (caddr_t) tobj->object);
  free (tobj->object);

  /* In the moment we don't allocate anything for the header */
  /* xdr_free ((xdrproc_t) xdr_xdb_header, (caddr_t) &tobj->header); */

  free (tobj);

  return DB_SUCCESS;
}
