# -*- coding: utf-8 -*-

# Simpilfied Chinese to Traditional Chinese
S_2_T = {
    u"㑇" : (u"㑳", ),  # 3447 => 3473
    u"㖞" : (u"喎", ),  # 359E => 558E
    u"㘎" : (u"㘚", ),  # 360E => 361A
    u"㤘" : (u"㥮", ),  # 3918 => 396E
    u"㧏" : (u"掆", ),  # 39CF => 6386
    u"㧐" : (u"㩳", ),  # 39D0 => 3A73
    u"㧟" : (u"擓", ),  # 39DF => 64D3
    u"㭎" : (u"棡", ),  # 3B4E => 68E1
    u"㳠" : (u"澾", ),  # 3CE0 => 6FBE
    u"䁖" : (u"瞜", ),  # 4056 => 779C
    u"䅟" : (u"穇", ),  # 415F => 7A47
    u"䌷" : (u"紬", ),  # 4337 => 7D2C
    u"䎬" : (u"䎱", ),  # 43AC => 43B1
    u"䏝" : (u"膞", ),  # 43DD => 819E
    u"䓖" : (u"藭", ),  # 44D6 => 85ED
    u"䙌" : (u"䙡", ),  # 464C => 4661
    u"䜣" : (u"訢", ),  # 4723 => 8A22
    u"䜩" : (u"讌", ),  # 4729 => 8B8C
    u"䞍" : (u"䝼", ),  # 478D => 477C
    u"䥺" : (u"釾", ),  # 497A => 91FE
    u"䥽" : (u"鏺", ),  # 497D => 93FA
    u"䦂" : (u"䥇", ),  # 4982 => 4947
    u"䦃" : (u"鐯", ),  # 4983 => 942F
    u"䦅" : (u"鐥", ),  # 4985 => 9425
    u"䦆" : (u"钁", ),  # 4986 => 9481
    u"䦶" : (u"䦛", ),  # 49B6 => 499B
    u"䦷" : (u"䦟", ),  # 49B7 => 499F
    u"䲟" : (u"鮣", ),  # 4C9F => 9BA3
    u"䲠" : (u"鰆", ),  # 4CA0 => 9C06
    u"䲡" : (u"鰌", ),  # 4CA1 => 9C0C
    u"䲢" : (u"鰧", ),  # 4CA2 => 9C27
    u"䲣" : (u"䱷", ),  # 4CA3 => 4C77
    u"䴓" : (u"鳾", ),  # 4D13 => 9CFE
    u"䴔" : (u"鵁", ),  # 4D14 => 9D41
    u"䴕" : (u"鴷", ),  # 4D15 => 9D37
    u"䴖" : (u"鶄", ),  # 4D16 => 9D84
    u"䴗" : (u"鶪", ),  # 4D17 => 9DAA
    u"䴘" : (u"鷉", ),  # 4D18 => 9DC9
    u"䴙" : (u"鸊", ),  # 4D19 => 9E0A
    u"䶮" : (u"龑", ),  # 4DAE => 9F91
    u"万" : (u"萬", ),  # 4E07 => 842C
    u"与" : (u"與", ),  # 4E0E => 8207
    u"丑" : (u"醜", ),  # 4E11 => 919C
    u"专" : (u"專", ),  # 4E13 => 5C08
    u"业" : (u"業", ),  # 4E1A => 696D
    u"丛" : (u"叢", ),  # 4E1B => 53E2
    u"东" : (u"東", ),  # 4E1C => 6771
    u"丝" : (u"絲", ),  # 4E1D => 7D72
    u"丢" : (u"丟", ),  # 4E22 => 4E1F
    u"两" : (u"兩", ),  # 4E24 => 5169
    u"严" : (u"嚴", ),  # 4E25 => 56B4
    u"丧" : (u"喪", ),  # 4E27 => 55AA
    u"个" : (u"個", ),  # 4E2A => 500B
    u"丬" : (u"爿", ),  # 4E2C => 723F
    u"丰" : (u"豐", ),  # 4E30 => 8C50
    u"临" : (u"臨", ),  # 4E34 => 81E8
    u"为" : (u"為", ),  # 4E3A => 70BA
    u"丽" : (u"麗", ),  # 4E3D => 9E97
    u"举" : (u"舉", ),  # 4E3E => 8209
    u"么" : (u"麼", u"麽"),  # 4E48 => 9EBC 9EBD
    u"义" : (u"義", ),  # 4E49 => 7FA9
    u"乌" : (u"烏", ),  # 4E4C => 70CF
    u"乐" : (u"樂", ),  # 4E50 => 6A02
    u"乔" : (u"喬", ),  # 4E54 => 55AC
    u"习" : (u"習", ),  # 4E60 => 7FD2
    u"乡" : (u"鄉", ),  # 4E61 => 9109
    u"书" : (u"書", ),  # 4E66 => 66F8
    u"买" : (u"買", ),  # 4E70 => 8CB7
    u"乱" : (u"亂", ),  # 4E71 => 4E82
    u"了" : (u"瞭", ),  # 4E86 => 77AD
    u"争" : (u"爭", ),  # 4E89 => 722D
    u"亏" : (u"虧", ),  # 4E8F => 8667
    u"云" : (u"雲", ),  # 4E91 => 96F2
    u"亘" : (u"亙", ),  # 4E98 => 4E99
    u"亚" : (u"亞", ),  # 4E9A => 4E9E
    u"产" : (u"產", u"産"),  # 4EA7 => 7522 7523
    u"亩" : (u"畝", ),  # 4EA9 => 755D
    u"亲" : (u"親", ),  # 4EB2 => 89AA
    u"亵" : (u"褻", ),  # 4EB5 => 893B
    u"亿" : (u"億", ),  # 4EBF => 5104
    u"仅" : (u"僅", ),  # 4EC5 => 50C5
    u"仆" : (u"僕", ),  # 4EC6 => 50D5
    u"从" : (u"從", ),  # 4ECE => 5F9E
    u"仑" : (u"侖", ),  # 4ED1 => 4F96
    u"仓" : (u"倉", ),  # 4ED3 => 5009
    u"仪" : (u"儀", ),  # 4EEA => 5100
    u"们" : (u"們", ),  # 4EEC => 5011
    u"价" : (u"價", ),  # 4EF7 => 50F9
    u"众" : (u"眾", u"衆"),  # 4F17 => 773E 8846
    u"优" : (u"優", ),  # 4F18 => 512A
    u"伙" : (u"夥", ),  # 4F19 => 5925
    u"会" : (u"會", ),  # 4F1A => 6703
    u"伛" : (u"傴", ),  # 4F1B => 50B4
    u"伞" : (u"傘", ),  # 4F1E => 5098
    u"伟" : (u"偉", ),  # 4F1F => 5049
    u"传" : (u"傳", ),  # 4F20 => 50B3
    u"伤" : (u"傷", ),  # 4F24 => 50B7
    u"伥" : (u"倀", ),  # 4F25 => 5000
    u"伦" : (u"倫", ),  # 4F26 => 502B
    u"伧" : (u"傖", ),  # 4F27 => 5096
    u"伪" : (u"偽", u"僞"),  # 4F2A => 507D 50DE
    u"伫" : (u"佇", ),  # 4F2B => 4F47
    u"体" : (u"體", ),  # 4F53 => 9AD4
    u"余" : (u"餘", ),  # 4F59 => 9918
    u"佣" : (u"傭", ),  # 4F63 => 50AD
    u"佥" : (u"僉", ),  # 4F65 => 50C9
    u"侠" : (u"俠", ),  # 4FA0 => 4FE0
    u"侣" : (u"侶", ),  # 4FA3 => 4FB6
    u"侥" : (u"僥", ),  # 4FA5 => 50E5
    u"侦" : (u"偵", ),  # 4FA6 => 5075
    u"侧" : (u"側", ),  # 4FA7 => 5074
    u"侨" : (u"僑", ),  # 4FA8 => 50D1
    u"侩" : (u"儈", ),  # 4FA9 => 5108
    u"侪" : (u"儕", ),  # 4FAA => 5115
    u"侬" : (u"儂", ),  # 4FAC => 5102
    u"俣" : (u"俁", ),  # 4FE3 => 4FC1
    u"俦" : (u"儔", ),  # 4FE6 => 5114
    u"俨" : (u"儼", ),  # 4FE8 => 513C
    u"俩" : (u"倆", ),  # 4FE9 => 5006
    u"俪" : (u"儷", ),  # 4FEA => 5137
    u"俭" : (u"儉", ),  # 4FED => 5109
    u"借" : (u"藉", ),  # 501F => 85C9
    u"债" : (u"債", ),  # 503A => 50B5
    u"倾" : (u"傾", ),  # 503E => 50BE
    u"偬" : (u"傯", ),  # 506C => 50AF
    u"偻" : (u"僂", ),  # 507B => 50C2
    u"偾" : (u"僨", ),  # 507E => 50E8
    u"偿" : (u"償", ),  # 507F => 511F
    u"傥" : (u"儻", ),  # 50A5 => 513B
    u"傧" : (u"儐", ),  # 50A7 => 5110
    u"储" : (u"儲", ),  # 50A8 => 5132
    u"傩" : (u"儺", ),  # 50A9 => 513A
    u"儿" : (u"兒", ),  # 513F => 5152
    u"克" : (u"剋", ),  # 514B => 524B
    u"兑" : (u"兌", ),  # 5151 => 514C
    u"兖" : (u"兗", ),  # 5156 => 5157
    u"党" : (u"黨", ),  # 515A => 9EE8
    u"兰" : (u"蘭", ),  # 5170 => 862D
    u"关" : (u"關", ),  # 5173 => 95DC
    u"兴" : (u"興", ),  # 5174 => 8208
    u"兹" : (u"茲", ),  # 5179 => 8332
    u"养" : (u"養", ),  # 517B => 990A
    u"兽" : (u"獸", ),  # 517D => 7378
    u"冁" : (u"囅", ),  # 5181 => 56C5
    u"内" : (u"內", ),  # 5185 => 5167
    u"冈" : (u"岡", ),  # 5188 => 5CA1
    u"册" : (u"冊", ),  # 518C => 518A
    u"写" : (u"寫", ),  # 5199 => 5BEB
    u"军" : (u"軍", ),  # 519B => 8ECD
    u"农" : (u"農", ),  # 519C => 8FB2
    u"冢" : (u"塚", ),  # 51A2 => 585A
    u"冬" : (u"鼕", ),  # 51AC => 9F15
    u"冯" : (u"馮", ),  # 51AF => 99AE
    u"冲" : (u"沖", u"衝"),  # 51B2 => 6C96 885D
    u"决" : (u"決", ),  # 51B3 => 6C7A
    u"况" : (u"況", ),  # 51B5 => 6CC1
    u"冻" : (u"凍", ),  # 51BB => 51CD
    u"净" : (u"淨", ),  # 51C0 => 6DE8
    u"凄" : (u"淒", ),  # 51C4 => 6DD2
    u"准" : (u"凖", ),  # 51C6 => 51D6
    u"凉" : (u"涼", ),  # 51C9 => 6DBC
    u"凌" : (u"淩", ),  # 51CC => 6DE9
    u"减" : (u"減", ),  # 51CF => 6E1B
    u"凑" : (u"湊", ),  # 51D1 => 6E4A
    u"凛" : (u"凜", ),  # 51DB => 51DC
    u"几" : (u"幾", ),  # 51E0 => 5E7E
    u"凤" : (u"鳳", ),  # 51E4 => 9CF3
    u"凫" : (u"鳧", u"鳬"),  # 51EB => 9CE7 9CEC
    u"凭" : (u"憑", ),  # 51ED => 6191
    u"凯" : (u"凱", ),  # 51EF => 51F1
    u"出" : (u"齣", ),  # 51FA => 9F63
    u"击" : (u"撃", u"擊"),  # 51FB => 6483 64CA
    u"凼" : (u"氹", ),  # 51FC => 6C39
    u"凿" : (u"鑿", ),  # 51FF => 947F
    u"刍" : (u"芻", ),  # 520D => 82BB
    u"划" : (u"劃", ),  # 5212 => 5283
    u"刘" : (u"劉", ),  # 5218 => 5289
    u"则" : (u"則", ),  # 5219 => 5247
    u"刚" : (u"剛", ),  # 521A => 525B
    u"创" : (u"創", ),  # 521B => 5275
    u"删" : (u"刪", ),  # 5220 => 522A
    u"别" : (u"別", u"彆"),  # 522B => 5225 5F46
    u"刬" : (u"剗", ),  # 522C => 5257
    u"刭" : (u"剄", ),  # 522D => 5244
    u"刮" : (u"颳", ),  # 522E => 98B3
    u"制" : (u"製", ),  # 5236 => 88FD
    u"刽" : (u"劊", ),  # 523D => 528A
    u"刿" : (u"劌", ),  # 523F => 528C
    u"剀" : (u"剴", ),  # 5240 => 5274
    u"剂" : (u"劑", ),  # 5242 => 5291
    u"剐" : (u"剮", ),  # 5250 => 526E
    u"剑" : (u"劍", ),  # 5251 => 528D
    u"剥" : (u"剝", ),  # 5265 => 525D
    u"剧" : (u"劇", ),  # 5267 => 5287
    u"劝" : (u"勸", ),  # 529D => 52F8
    u"办" : (u"辦", ),  # 529E => 8FA6
    u"务" : (u"務", ),  # 52A1 => 52D9
    u"劢" : (u"勱", ),  # 52A2 => 52F1
    u"动" : (u"動", ),  # 52A8 => 52D5
    u"励" : (u"勵", ),  # 52B1 => 52F5
    u"劲" : (u"勁", ),  # 52B2 => 52C1
    u"劳" : (u"勞", ),  # 52B3 => 52DE
    u"势" : (u"勢", ),  # 52BF => 52E2
    u"勋" : (u"勛", u"勳"),  # 52CB => 52DB 52F3
    u"勐" : (u"猛", ),  # 52D0 => 731B
    u"勚" : (u"勩", ),  # 52DA => 52E9
    u"匀" : (u"勻", ),  # 5300 => 52FB
    u"匦" : (u"匭", ),  # 5326 => 532D
    u"匮" : (u"匱", ),  # 532E => 5331
    u"区" : (u"區", ),  # 533A => 5340
    u"医" : (u"醫", ),  # 533B => 91AB
    u"千" : (u"韆", ),  # 5343 => 97C6
    u"华" : (u"華", ),  # 534E => 83EF
    u"协" : (u"協", ),  # 534F => 5354
    u"单" : (u"單", ),  # 5355 => 55AE
    u"卖" : (u"賣", ),  # 5356 => 8CE3
    u"卜" : (u"蔔", ),  # 535C => 8514
    u"卢" : (u"盧", ),  # 5362 => 76E7
    u"卤" : (u"滷", u"鹵"),  # 5364 => 6EF7 9E75
    u"卧" : (u"臥", ),  # 5367 => 81E5
    u"卫" : (u"衛", ),  # 536B => 885B
    u"却" : (u"卻", ),  # 5374 => 537B
    u"卷" : (u"捲", ),  # 5377 => 6372
    u"卺" : (u"巹", ),  # 537A => 5DF9
    u"厂" : (u"廠", ),  # 5382 => 5EE0
    u"厅" : (u"廳", ),  # 5385 => 5EF3
    u"历" : (u"曆", u"歷"),  # 5386 => 66C6 6B77
    u"厉" : (u"厲", ),  # 5389 => 53B2
    u"压" : (u"壓", ),  # 538B => 58D3
    u"厌" : (u"厭", ),  # 538C => 53AD
    u"厍" : (u"厙", ),  # 538D => 5399
    u"厕" : (u"厠", u"廁"),  # 5395 => 53A0 5EC1
    u"厢" : (u"廂", ),  # 53A2 => 5EC2
    u"厣" : (u"厴", ),  # 53A3 => 53B4
    u"厦" : (u"廈", ),  # 53A6 => 5EC8
    u"厨" : (u"廚", ),  # 53A8 => 5EDA
    u"厩" : (u"廄", ),  # 53A9 => 5EC4
    u"厮" : (u"廝", ),  # 53AE => 5EDD
    u"县" : (u"縣", ),  # 53BF => 7E23
    u"叁" : (u"參", ),  # 53C1 => 53C3
    u"参" : (u"參", ),  # 53C2 => 53C3
    u"叆" : (u"靉", ),  # 53C6 => 9749
    u"叇" : (u"靆", ),  # 53C7 => 9746
    u"双" : (u"雙", ),  # 53CC => 96D9
    u"发" : (u"發", u"髮"),  # 53D1 => 767C 9AEE
    u"变" : (u"變", ),  # 53D8 => 8B8A
    u"叙" : (u"敘", ),  # 53D9 => 6558
    u"叠" : (u"疊", ),  # 53E0 => 758A
    u"只" : (u"戠", u"祗", u"衹", u"隻"),  # 53EA => 6220 7957 8879 96BB
    u"台" : (u"檯", u"臺", u"颱"),  # 53F0 => 6AAF 81FA 98B1
    u"叶" : (u"葉", ),  # 53F6 => 8449
    u"号" : (u"號", ),  # 53F7 => 865F
    u"叹" : (u"嘆", u"歎"),  # 53F9 => 5606 6B4E
    u"叽" : (u"嘰", ),  # 53FD => 5630
    u"吁" : (u"籲", ),  # 5401 => 7C72
    u"合" : (u"閤", ),  # 5408 => 95A4
    u"后" : (u"後", ),  # 540E => 5F8C
    u"向" : (u"嚮", ),  # 5411 => 56AE
    u"吓" : (u"嚇", ),  # 5413 => 5687
    u"吕" : (u"呂", ),  # 5415 => 5442
    u"吗" : (u"嗎", ),  # 5417 => 55CE
    u"吣" : (u"唚", ),  # 5423 => 551A
    u"吨" : (u"噸", ),  # 5428 => 5678
    u"听" : (u"聽", ),  # 542C => 807D
    u"启" : (u"啓", u"啟"),  # 542F => 5553 555F
    u"吴" : (u"吳", ),  # 5434 => 5433
    u"呒" : (u"嘸", ),  # 5452 => 5638
    u"呓" : (u"囈", ),  # 5453 => 56C8
    u"呕" : (u"嘔", ),  # 5455 => 5614
    u"呖" : (u"嚦", ),  # 5456 => 56A6
    u"呗" : (u"唄", ),  # 5457 => 5504
    u"员" : (u"員", ),  # 5458 => 54E1
    u"呙" : (u"咼", ),  # 5459 => 54BC
    u"呛" : (u"嗆", ),  # 545B => 55C6
    u"呜" : (u"嗚", ),  # 545C => 55DA
    u"咏" : (u"詠", ),  # 548F => 8A60
    u"咔" : (u"哢", ),  # 5494 => 54E2
    u"咙" : (u"嚨", ),  # 5499 => 56A8
    u"咛" : (u"嚀", ),  # 549B => 5680
    u"咝" : (u"噝", ),  # 549D => 565D
    u"咤" : (u"吒", ),  # 54A4 => 5412
    u"咴" : (u"噅", ),  # 54B4 => 5645
    u"咸" : (u"鹹", ),  # 54B8 => 9E79
    u"哌" : (u"呱", ),  # 54CC => 5471
    u"响" : (u"響", ),  # 54CD => 97FF
    u"哑" : (u"啞", ),  # 54D1 => 555E
    u"哒" : (u"噠", ),  # 54D2 => 5660
    u"哓" : (u"嘵", ),  # 54D3 => 5635
    u"哔" : (u"嗶", ),  # 54D4 => 55F6
    u"哕" : (u"噦", ),  # 54D5 => 5666
    u"哗" : (u"嘩", ),  # 54D7 => 5629
    u"哙" : (u"噲", ),  # 54D9 => 5672
    u"哜" : (u"嚌", ),  # 54DC => 568C
    u"哝" : (u"噥", ),  # 54DD => 5665
    u"哟" : (u"喲", ),  # 54DF => 55B2
    u"唛" : (u"嘜", ),  # 551B => 561C
    u"唝" : (u"嗊", ),  # 551D => 55CA
    u"唠" : (u"嘮", ),  # 5520 => 562E
    u"唡" : (u"啢", ),  # 5521 => 5562
    u"唢" : (u"嗩", ),  # 5522 => 55E9
    u"唣" : (u"唕", ),  # 5523 => 5515
    u"唤" : (u"喚", ),  # 5524 => 559A
    u"唿" : (u"呼", ),  # 553F => 547C
    u"啧" : (u"嘖", ),  # 5567 => 5616
    u"啬" : (u"嗇", ),  # 556C => 55C7
    u"啭" : (u"囀", ),  # 556D => 56C0
    u"啮" : (u"嚙", u"齧"),  # 556E => 5699 9F67
    u"啰" : (u"囉", ),  # 5570 => 56C9
    u"啸" : (u"嘯", ),  # 5578 => 562F
    u"喷" : (u"噴", ),  # 55B7 => 5674
    u"喽" : (u"嘍", ),  # 55BD => 560D
    u"喾" : (u"嚳", ),  # 55BE => 56B3
    u"嗫" : (u"囁", ),  # 55EB => 56C1
    u"嗬" : (u"呵", ),  # 55EC => 5475
    u"嗳" : (u"噯", ),  # 55F3 => 566F
    u"嘘" : (u"噓", ),  # 5618 => 5653
    u"嘤" : (u"嚶", ),  # 5624 => 56B6
    u"嘱" : (u"囑", ),  # 5631 => 56D1
    u"噜" : (u"嚕", ),  # 565C => 5695
    u"噼" : (u"劈", ),  # 567C => 5288
    u"嚣" : (u"囂", ),  # 56A3 => 56C2
    u"嚯" : (u"謔", ),  # 56AF => 8B14
    u"回" : (u"迴", ),  # 56DE => 8FF4
    u"团" : (u"團", u"糰"),  # 56E2 => 5718 7CF0
    u"园" : (u"園", ),  # 56ED => 5712
    u"困" : (u"睏", ),  # 56F0 => 774F
    u"囱" : (u"囪", ),  # 56F1 => 56EA
    u"围" : (u"圍", ),  # 56F4 => 570D
    u"囵" : (u"圇", ),  # 56F5 => 5707
    u"国" : (u"國", ),  # 56FD => 570B
    u"图" : (u"圖", ),  # 56FE => 5716
    u"圆" : (u"圓", ),  # 5706 => 5713
    u"圣" : (u"聖", ),  # 5723 => 8056
    u"圹" : (u"壙", ),  # 5739 => 58D9
    u"场" : (u"場", ),  # 573A => 5834
    u"坂" : (u"阪", ),  # 5742 => 962A
    u"坏" : (u"壞", ),  # 574F => 58DE
    u"块" : (u"塊", ),  # 5757 => 584A
    u"坚" : (u"堅", ),  # 575A => 5805
    u"坛" : (u"壇", u"罎"),  # 575B => 58C7 7F4E
    u"坜" : (u"壢", ),  # 575C => 58E2
    u"坝" : (u"壩", ),  # 575D => 58E9
    u"坞" : (u"塢", ),  # 575E => 5862
    u"坟" : (u"墳", ),  # 575F => 58B3
    u"坠" : (u"墜", ),  # 5760 => 589C
    u"垄" : (u"壟", ),  # 5784 => 58DF
    u"垅" : (u"壟", ),  # 5785 => 58DF
    u"垆" : (u"壚", ),  # 5786 => 58DA
    u"垒" : (u"壘", ),  # 5792 => 58D8
    u"垦" : (u"墾", ),  # 57A6 => 58BE
    u"垧" : (u"坰", ),  # 57A7 => 5770
    u"垩" : (u"堊", ),  # 57A9 => 580A
    u"垫" : (u"墊", ),  # 57AB => 588A
    u"垭" : (u"埡", ),  # 57AD => 57E1
    u"垲" : (u"塏", ),  # 57B2 => 584F
    u"垴" : (u"堖", ),  # 57B4 => 5816
    u"埘" : (u"塒", ),  # 57D8 => 5852
    u"埙" : (u"塤", ),  # 57D9 => 5864
    u"埚" : (u"堝", ),  # 57DA => 581D
    u"埝" : (u"墊", ),  # 57DD => 588A
    u"埯" : (u"垵", ),  # 57EF => 57B5
    u"堑" : (u"塹", ),  # 5811 => 5879
    u"堕" : (u"墮", ),  # 5815 => 58AE
    u"塬" : (u"原", ),  # 586C => 539F
    u"墙" : (u"墻", u"牆"),  # 5899 => 58BB 7246
    u"壮" : (u"壯", ),  # 58EE => 58EF
    u"声" : (u"聲", ),  # 58F0 => 8072
    u"壳" : (u"殻", u"殼"),  # 58F3 => 6BBB 6BBC
    u"壶" : (u"壺", ),  # 58F6 => 58FA
    u"处" : (u"處", ),  # 5904 => 8655
    u"备" : (u"備", ),  # 5907 => 5099
    u"复" : (u"復", u"複"),  # 590D => 5FA9 8907
    u"够" : (u"夠", ),  # 591F => 5920
    u"头" : (u"頭", ),  # 5934 => 982D
    u"夸" : (u"誇", ),  # 5938 => 8A87
    u"夹" : (u"夾", ),  # 5939 => 593E
    u"夺" : (u"奪", ),  # 593A => 596A
    u"奁" : (u"奩", ),  # 5941 => 5969
    u"奂" : (u"奐", ),  # 5942 => 5950
    u"奋" : (u"奮", ),  # 594B => 596E
    u"奖" : (u"奬", u"獎"),  # 5956 => 596C 734E
    u"奥" : (u"奧", ),  # 5965 => 5967
    u"妆" : (u"妝", ),  # 5986 => 599D
    u"妇" : (u"婦", ),  # 5987 => 5A66
    u"妈" : (u"媽", ),  # 5988 => 5ABD
    u"妩" : (u"嫵", ),  # 59A9 => 5AF5
    u"妪" : (u"嫗", ),  # 59AA => 5AD7
    u"妫" : (u"媯", ),  # 59AB => 5AAF
    u"姗" : (u"姍", ),  # 59D7 => 59CD
    u"姜" : (u"薑", ),  # 59DC => 8591
    u"娄" : (u"婁", ),  # 5A04 => 5A41
    u"娅" : (u"婭", ),  # 5A05 => 5A6D
    u"娆" : (u"嬈", ),  # 5A06 => 5B08
    u"娇" : (u"嬌", ),  # 5A07 => 5B0C
    u"娈" : (u"孌", ),  # 5A08 => 5B4C
    u"娱" : (u"娛", ),  # 5A31 => 5A1B
    u"娲" : (u"媧", ),  # 5A32 => 5AA7
    u"娴" : (u"嫻", ),  # 5A34 => 5AFB
    u"婳" : (u"嫿", ),  # 5A73 => 5AFF
    u"婴" : (u"嬰", ),  # 5A74 => 5B30
    u"婵" : (u"嬋", ),  # 5A75 => 5B0B
    u"婶" : (u"嬸", ),  # 5A76 => 5B38
    u"媪" : (u"媼", ),  # 5AAA => 5ABC
    u"嫒" : (u"嬡", ),  # 5AD2 => 5B21
    u"嫔" : (u"嬪", ),  # 5AD4 => 5B2A
    u"嫱" : (u"嬙", ),  # 5AF1 => 5B19
    u"嬷" : (u"嬤", ),  # 5B37 => 5B24
    u"孙" : (u"孫", ),  # 5B59 => 5B6B
    u"学" : (u"學", ),  # 5B66 => 5B78
    u"孪" : (u"孿", ),  # 5B6A => 5B7F
    u"宁" : (u"寜", u"甯"),  # 5B81 => 5BDC 752F
    u"宝" : (u"寶", ),  # 5B9D => 5BF6
    u"实" : (u"實", ),  # 5B9E => 5BE6
    u"宠" : (u"寵", ),  # 5BA0 => 5BF5
    u"审" : (u"審", ),  # 5BA1 => 5BE9
    u"宪" : (u"憲", ),  # 5BAA => 61B2
    u"宫" : (u"宮", ),  # 5BAB => 5BAE
    u"家" : (u"傢", ),  # 5BB6 => 50A2
    u"宽" : (u"寬", ),  # 5BBD => 5BEC
    u"宾" : (u"賓", ),  # 5BBE => 8CD3
    u"寝" : (u"寢", ),  # 5BDD => 5BE2
    u"对" : (u"對", ),  # 5BF9 => 5C0D
    u"寻" : (u"尋", ),  # 5BFB => 5C0B
    u"导" : (u"導", ),  # 5BFC => 5C0E
    u"寿" : (u"壽", u"夀"),  # 5BFF => 58FD 5900
    u"将" : (u"將", ),  # 5C06 => 5C07
    u"尔" : (u"爾", ),  # 5C14 => 723E
    u"尘" : (u"塵", ),  # 5C18 => 5875
    u"尝" : (u"嘗", ),  # 5C1D => 5617
    u"尧" : (u"堯", ),  # 5C27 => 582F
    u"尴" : (u"尷", ),  # 5C34 => 5C37
    u"尸" : (u"屍", ),  # 5C38 => 5C4D
    u"尽" : (u"儘", u"盡"),  # 5C3D => 5118 76E1
    u"层" : (u"層", ),  # 5C42 => 5C64
    u"屉" : (u"屜", ),  # 5C49 => 5C5C
    u"届" : (u"屆", ),  # 5C4A => 5C46
    u"属" : (u"屬", ),  # 5C5E => 5C6C
    u"屡" : (u"屢", ),  # 5C61 => 5C62
    u"屦" : (u"屨", ),  # 5C66 => 5C68
    u"屿" : (u"嶼", ),  # 5C7F => 5DBC
    u"岁" : (u"嵗", u"歲"),  # 5C81 => 5D57 6B72
    u"岂" : (u"豈", ),  # 5C82 => 8C48
    u"岖" : (u"嶇", ),  # 5C96 => 5D87
    u"岗" : (u"崗", ),  # 5C97 => 5D17
    u"岘" : (u"峴", ),  # 5C98 => 5CF4
    u"岙" : (u"嶴", ),  # 5C99 => 5DB4
    u"岚" : (u"嵐", ),  # 5C9A => 5D50
    u"岛" : (u"島", ),  # 5C9B => 5CF6
    u"岭" : (u"嶺", ),  # 5CAD => 5DBA
    u"岳" : (u"嶽", ),  # 5CB3 => 5DBD
    u"岽" : (u"崠", u"崬"),  # 5CBD => 5D20 5D2C
    u"岿" : (u"巋", ),  # 5CBF => 5DCB
    u"峃" : (u"嶨", ),  # 5CC3 => 5DA8
    u"峄" : (u"嶧", ),  # 5CC4 => 5DA7
    u"峡" : (u"峽", ),  # 5CE1 => 5CFD
    u"峣" : (u"嶢", ),  # 5CE3 => 5DA2
    u"峤" : (u"嶠", ),  # 5CE4 => 5DA0
    u"峥" : (u"崢", ),  # 5CE5 => 5D22
    u"峦" : (u"巒", ),  # 5CE6 => 5DD2
    u"崂" : (u"嶗", ),  # 5D02 => 5D97
    u"崃" : (u"崍", ),  # 5D03 => 5D0D
    u"崭" : (u"嶄", ),  # 5D2D => 5D84
    u"嵘" : (u"嶸", ),  # 5D58 => 5DB8
    u"嵚" : (u"嶔", ),  # 5D5A => 5D94
    u"嵛" : (u"崳", ),  # 5D5B => 5D33
    u"嵝" : (u"嶁", ),  # 5D5D => 5D81
    u"嵴" : (u"脊", ),  # 5D74 => 810A
    u"巅" : (u"巔", ),  # 5DC5 => 5DD4
    u"巩" : (u"鞏", ),  # 5DE9 => 978F
    u"巯" : (u"巰", ),  # 5DEF => 5DF0
    u"币" : (u"幣", ),  # 5E01 => 5E63
    u"帅" : (u"帥", ),  # 5E05 => 5E25
    u"师" : (u"師", ),  # 5E08 => 5E2B
    u"帏" : (u"幃", ),  # 5E0F => 5E43
    u"帐" : (u"帳", ),  # 5E10 => 5E33
    u"帘" : (u"簾", ),  # 5E18 => 7C3E
    u"帜" : (u"幟", ),  # 5E1C => 5E5F
    u"带" : (u"帶", ),  # 5E26 => 5E36
    u"帧" : (u"幀", ),  # 5E27 => 5E40
    u"帮" : (u"幫", ),  # 5E2E => 5E6B
    u"帱" : (u"幬", ),  # 5E31 => 5E6C
    u"帻" : (u"幘", ),  # 5E3B => 5E58
    u"帼" : (u"幗", ),  # 5E3C => 5E57
    u"幂" : (u"冪", ),  # 5E42 => 51AA
    u"幞" : (u"襆", ),  # 5E5E => 8946
    u"干" : (u"乾", u"幹"),  # 5E72 => 4E7E 5E79
    u"并" : (u"並", ),  # 5E76 => 4E26
    u"幺" : (u"么", ),  # 5E7A => 4E48
    u"广" : (u"廣", ),  # 5E7F => 5EE3
    u"庄" : (u"莊", ),  # 5E84 => 838A
    u"庆" : (u"慶", ),  # 5E86 => 6176
    u"庐" : (u"廬", ),  # 5E90 => 5EEC
    u"庑" : (u"廡", ),  # 5E91 => 5EE1
    u"库" : (u"庫", ),  # 5E93 => 5EAB
    u"应" : (u"應", ),  # 5E94 => 61C9
    u"庙" : (u"廟", ),  # 5E99 => 5EDF
    u"庞" : (u"龐", ),  # 5E9E => 9F90
    u"废" : (u"廢", ),  # 5E9F => 5EE2
    u"庼" : (u"廎", ),  # 5EBC => 5ECE
    u"廪" : (u"廩", ),  # 5EEA => 5EE9
    u"开" : (u"開", ),  # 5F00 => 958B
    u"异" : (u"異", ),  # 5F02 => 7570
    u"弃" : (u"棄", ),  # 5F03 => 68C4
    u"张" : (u"張", ),  # 5F20 => 5F35
    u"弥" : (u"彌", u"瀰"),  # 5F25 => 5F4C 7030
    u"弪" : (u"弳", ),  # 5F2A => 5F33
    u"弯" : (u"彎", ),  # 5F2F => 5F4E
    u"弹" : (u"彈", ),  # 5F39 => 5F48
    u"强" : (u"強", ),  # 5F3A => 5F37
    u"归" : (u"歸", ),  # 5F52 => 6B78
    u"当" : (u"噹", u"當"),  # 5F53 => 5679 7576
    u"录" : (u"錄", u"録"),  # 5F55 => 9304 9332
    u"彦" : (u"彥", ),  # 5F66 => 5F65
    u"彻" : (u"徹", ),  # 5F7B => 5FB9
    u"征" : (u"徵", ),  # 5F81 => 5FB5
    u"径" : (u"徑", ),  # 5F84 => 5F91
    u"徕" : (u"徠", ),  # 5F95 => 5FA0
    u"御" : (u"禦", ),  # 5FA1 => 79A6
    u"忆" : (u"憶", ),  # 5FC6 => 61B6
    u"忏" : (u"懺", ),  # 5FCF => 61FA
    u"忧" : (u"憂", ),  # 5FE7 => 6182
    u"忾" : (u"愾", ),  # 5FFE => 613E
    u"怀" : (u"懷", ),  # 6000 => 61F7
    u"态" : (u"態", ),  # 6001 => 614B
    u"怂" : (u"慫", ),  # 6002 => 616B
    u"怃" : (u"憮", ),  # 6003 => 61AE
    u"怄" : (u"慪", ),  # 6004 => 616A
    u"怅" : (u"悵", ),  # 6005 => 60B5
    u"怆" : (u"愴", ),  # 6006 => 6134
    u"怜" : (u"憐", ),  # 601C => 6190
    u"总" : (u"總", ),  # 603B => 7E3D
    u"怼" : (u"懟", ),  # 603C => 61DF
    u"怿" : (u"懌", ),  # 603F => 61CC
    u"恋" : (u"戀", ),  # 604B => 6200
    u"恳" : (u"懇", ),  # 6073 => 61C7
    u"恶" : (u"噁", u"惡"),  # 6076 => 5641 60E1
    u"恸" : (u"慟", ),  # 6078 => 615F
    u"恹" : (u"懨", ),  # 6079 => 61E8
    u"恺" : (u"愷", ),  # 607A => 6137
    u"恻" : (u"惻", ),  # 607B => 60FB
    u"恼" : (u"惱", ),  # 607C => 60F1
    u"恽" : (u"惲", ),  # 607D => 60F2
    u"悦" : (u"悅", ),  # 60A6 => 6085
    u"悫" : (u"愨", u"慤"),  # 60AB => 6128 6164
    u"悬" : (u"懸", ),  # 60AC => 61F8
    u"悭" : (u"慳", ),  # 60AD => 6173
    u"悯" : (u"憫", ),  # 60AF => 61AB
    u"惊" : (u"驚", ),  # 60CA => 9A5A
    u"惧" : (u"懼", ),  # 60E7 => 61FC
    u"惨" : (u"慘", ),  # 60E8 => 6158
    u"惩" : (u"懲", ),  # 60E9 => 61F2
    u"惫" : (u"憊", ),  # 60EB => 618A
    u"惬" : (u"愜", ),  # 60EC => 611C
    u"惭" : (u"慚", ),  # 60ED => 615A
    u"惮" : (u"憚", ),  # 60EE => 619A
    u"惯" : (u"慣", ),  # 60EF => 6163
    u"愍" : (u"湣", ),  # 610D => 6E63
    u"愠" : (u"慍", ),  # 6120 => 614D
    u"愤" : (u"憤", ),  # 6124 => 61A4
    u"愦" : (u"憒", ),  # 6126 => 6192
    u"愿" : (u"願", ),  # 613F => 9858
    u"慑" : (u"懾", ),  # 6151 => 61FE
    u"憷" : (u"怵", ),  # 61B7 => 6035
    u"懑" : (u"懣", ),  # 61D1 => 61E3
    u"懒" : (u"懶", ),  # 61D2 => 61F6
    u"懔" : (u"懍", ),  # 61D4 => 61CD
    u"戆" : (u"戇", ),  # 6206 => 6207
    u"戋" : (u"戔", ),  # 620B => 6214
    u"戏" : (u"戲", ),  # 620F => 6232
    u"戗" : (u"戧", ),  # 6217 => 6227
    u"战" : (u"戰", ),  # 6218 => 6230
    u"戬" : (u"戩", ),  # 622C => 6229
    u"户" : (u"戶", ),  # 6237 => 6236
    u"才" : (u"纔", ),  # 624D => 7E94
    u"扎" : (u"紮", ),  # 624E => 7D2E
    u"扑" : (u"撲", ),  # 6251 => 64B2
    u"扦" : (u"扡", ),  # 6266 => 6261
    u"执" : (u"執", ),  # 6267 => 57F7
    u"扩" : (u"擴", ),  # 6269 => 64F4
    u"扪" : (u"捫", ),  # 626A => 636B
    u"扫" : (u"掃", ),  # 626B => 6383
    u"扬" : (u"揚", ),  # 626C => 63DA
    u"扰" : (u"擾", ),  # 6270 => 64FE
    u"折" : (u"摺", ),  # 6298 => 647A
    u"抚" : (u"撫", ),  # 629A => 64AB
    u"抛" : (u"拋", ),  # 629B => 62CB
    u"抟" : (u"摶", ),  # 629F => 6476
    u"抠" : (u"摳", ),  # 62A0 => 6473
    u"抡" : (u"掄", ),  # 62A1 => 6384
    u"抢" : (u"搶", ),  # 62A2 => 6436
    u"护" : (u"護", ),  # 62A4 => 8B77
    u"报" : (u"報", ),  # 62A5 => 5831
    u"担" : (u"擔", ),  # 62C5 => 64D4
    u"拟" : (u"擬", ),  # 62DF => 64EC
    u"拢" : (u"攏", ),  # 62E2 => 650F
    u"拣" : (u"揀", ),  # 62E3 => 63C0
    u"拥" : (u"擁", ),  # 62E5 => 64C1
    u"拦" : (u"攔", ),  # 62E6 => 6514
    u"拧" : (u"擰", ),  # 62E7 => 64F0
    u"拨" : (u"撥", ),  # 62E8 => 64A5
    u"择" : (u"擇", ),  # 62E9 => 64C7
    u"挂" : (u"掛", ),  # 6302 => 639B
    u"挚" : (u"摯", ),  # 631A => 646F
    u"挛" : (u"攣", ),  # 631B => 6523
    u"挜" : (u"掗", ),  # 631C => 6397
    u"挝" : (u"撾", ),  # 631D => 64BE
    u"挞" : (u"撻", ),  # 631E => 64BB
    u"挟" : (u"挾", ),  # 631F => 633E
    u"挠" : (u"撓", ),  # 6320 => 6493
    u"挡" : (u"擋", ),  # 6321 => 64CB
    u"挢" : (u"撟", ),  # 6322 => 649F
    u"挣" : (u"掙", ),  # 6323 => 6399
    u"挤" : (u"擠", ),  # 6324 => 64E0
    u"挥" : (u"揮", ),  # 6325 => 63EE
    u"挦" : (u"撏", ),  # 6326 => 648F
    u"捞" : (u"撈", ),  # 635E => 6488
    u"损" : (u"損", ),  # 635F => 640D
    u"捡" : (u"撿", ),  # 6361 => 64BF
    u"换" : (u"換", ),  # 6362 => 63DB
    u"捣" : (u"搗", ),  # 6363 => 6417
    u"据" : (u"據", ),  # 636E => 64DA
    u"捻" : (u"撚", ),  # 637B => 649A
    u"掳" : (u"擄", ),  # 63B3 => 64C4
    u"掴" : (u"摑", ),  # 63B4 => 6451
    u"掷" : (u"擲", ),  # 63B7 => 64F2
    u"掸" : (u"撣", ),  # 63B8 => 64A3
    u"掺" : (u"摻", ),  # 63BA => 647B
    u"掼" : (u"摜", ),  # 63BC => 645C
    u"揸" : (u"摣", ),  # 63F8 => 6463
    u"揽" : (u"攬", ),  # 63FD => 652C
    u"揿" : (u"撳", ),  # 63FF => 64B3
    u"搀" : (u"攙", ),  # 6400 => 6519
    u"搁" : (u"擱", ),  # 6401 => 64F1
    u"搂" : (u"摟", ),  # 6402 => 645F
    u"搅" : (u"攪", ),  # 6405 => 652A
    u"携" : (u"攜", ),  # 643A => 651C
    u"摄" : (u"攝", ),  # 6444 => 651D
    u"摅" : (u"攄", ),  # 6445 => 6504
    u"摆" : (u"擺", u"襬"),  # 6446 => 64FA 896C
    u"摇" : (u"搖", ),  # 6447 => 6416
    u"摈" : (u"擯", ),  # 6448 => 64EF
    u"摊" : (u"擹", u"攤"),  # 644A => 64F9 6524
    u"撄" : (u"攖", ),  # 6484 => 6516
    u"撑" : (u"撐", ),  # 6491 => 6490
    u"撵" : (u"攆", ),  # 64B5 => 6506
    u"撷" : (u"擷", ),  # 64B7 => 64F7
    u"撸" : (u"擼", ),  # 64B8 => 64FC
    u"撺" : (u"攛", ),  # 64BA => 651B
    u"擞" : (u"擻", ),  # 64DE => 64FB
    u"攒" : (u"攢", ),  # 6512 => 6522
    u"敌" : (u"敵", ),  # 654C => 6575
    u"敛" : (u"斂", ),  # 655B => 6582
    u"数" : (u"數", ),  # 6570 => 6578
    u"斋" : (u"齋", ),  # 658B => 9F4B
    u"斓" : (u"斕", ),  # 6593 => 6595
    u"斗" : (u"鬥", ),  # 6597 => 9B25
    u"斩" : (u"斬", ),  # 65A9 => 65AC
    u"断" : (u"斷", ),  # 65AD => 65B7
    u"旋" : (u"鏇", ),  # 65CB => 93C7
    u"无" : (u"無", ),  # 65E0 => 7121
    u"旧" : (u"舊", ),  # 65E7 => 820A
    u"时" : (u"時", ),  # 65F6 => 6642
    u"旷" : (u"曠", ),  # 65F7 => 66E0
    u"旸" : (u"暘", ),  # 65F8 => 6698
    u"昙" : (u"曇", ),  # 6619 => 66C7
    u"昼" : (u"晝", ),  # 663C => 665D
    u"昽" : (u"曨", ),  # 663D => 66E8
    u"显" : (u"顯", ),  # 663E => 986F
    u"晋" : (u"晉", ),  # 664B => 6649
    u"晒" : (u"曬", ),  # 6652 => 66EC
    u"晓" : (u"曉", ),  # 6653 => 66C9
    u"晔" : (u"曄", ),  # 6654 => 66C4
    u"晕" : (u"暈", ),  # 6655 => 6688
    u"晖" : (u"暉", ),  # 6656 => 6689
    u"暂" : (u"暫", ),  # 6682 => 66AB
    u"暧" : (u"曖", ),  # 66A7 => 66D6
    u"曲" : (u"麯", ),  # 66F2 => 9EAF
    u"札" : (u"劄", ),  # 672D => 5284
    u"术" : (u"術", ),  # 672F => 8853
    u"朱" : (u"硃", ),  # 6731 => 7843
    u"朴" : (u"樸", ),  # 6734 => 6A38
    u"机" : (u"機", ),  # 673A => 6A5F
    u"杀" : (u"殺", ),  # 6740 => 6BBA
    u"杂" : (u"雜", ),  # 6742 => 96DC
    u"权" : (u"權", ),  # 6743 => 6B0A
    u"条" : (u"條", ),  # 6761 => 689D
    u"来" : (u"來", ),  # 6765 => 4F86
    u"杨" : (u"楊", ),  # 6768 => 694A
    u"杩" : (u"榪", ),  # 6769 => 69AA
    u"杰" : (u"傑", ),  # 6770 => 5091
    u"松" : (u"鬆", ),  # 677E => 9B06
    u"板" : (u"闆", ),  # 677F => 95C6
    u"极" : (u"極", ),  # 6781 => 6975
    u"构" : (u"構", ),  # 6784 => 69CB
    u"枞" : (u"樅", ),  # 679E => 6A05
    u"枢" : (u"樞", ),  # 67A2 => 6A1E
    u"枣" : (u"棗", ),  # 67A3 => 68D7
    u"枥" : (u"櫪", ),  # 67A5 => 6AEA
    u"枧" : (u"梘", ),  # 67A7 => 6898
    u"枨" : (u"棖", ),  # 67A8 => 68D6
    u"枪" : (u"槍", ),  # 67AA => 69CD
    u"枫" : (u"楓", ),  # 67AB => 6953
    u"枭" : (u"梟", ),  # 67AD => 689F
    u"柜" : (u"櫃", ),  # 67DC => 6AC3
    u"柠" : (u"檸", ),  # 67E0 => 6AB8
    u"柽" : (u"檉", ),  # 67FD => 6A89
    u"栀" : (u"梔", ),  # 6800 => 6894
    u"栅" : (u"柵", ),  # 6805 => 67F5
    u"标" : (u"標", ),  # 6807 => 6A19
    u"栈" : (u"棧", ),  # 6808 => 68E7
    u"栉" : (u"櫛", ),  # 6809 => 6ADB
    u"栊" : (u"櫳", ),  # 680A => 6AF3
    u"栋" : (u"棟", ),  # 680B => 68DF
    u"栌" : (u"櫨", ),  # 680C => 6AE8
    u"栎" : (u"櫟", ),  # 680E => 6ADF
    u"栏" : (u"欄", ),  # 680F => 6B04
    u"树" : (u"樹", ),  # 6811 => 6A39
    u"栖" : (u"棲", ),  # 6816 => 68F2
    u"样" : (u"様", u"樣"),  # 6837 => 69D8 6A23
    u"栾" : (u"欒", ),  # 683E => 6B12
    u"桊" : (u"棬", ),  # 684A => 68EC
    u"桠" : (u"椏", ),  # 6860 => 690F
    u"桡" : (u"橈", ),  # 6861 => 6A48
    u"桢" : (u"楨", ),  # 6862 => 6968
    u"档" : (u"檔", ),  # 6863 => 6A94
    u"桤" : (u"榿", ),  # 6864 => 69BF
    u"桥" : (u"橋", ),  # 6865 => 6A4B
    u"桦" : (u"樺", ),  # 6866 => 6A3A
    u"桧" : (u"檜", ),  # 6867 => 6A9C
    u"桨" : (u"槳", ),  # 6868 => 69F3
    u"桩" : (u"樁", ),  # 6869 => 6A01
    u"梦" : (u"夢", ),  # 68A6 => 5922
    u"检" : (u"檢", ),  # 68C0 => 6AA2
    u"棂" : (u"欞", ),  # 68C2 => 6B1E
    u"椁" : (u"槨", ),  # 6901 => 69E8
    u"椟" : (u"櫝", ),  # 691F => 6ADD
    u"椠" : (u"槧", ),  # 6920 => 69E7
    u"椤" : (u"欏", ),  # 6924 => 6B0F
    u"椭" : (u"橢", ),  # 692D => 6A62
    u"楼" : (u"樓", ),  # 697C => 6A13
    u"榄" : (u"欖", ),  # 6984 => 6B16
    u"榇" : (u"櫬", ),  # 6987 => 6AEC
    u"榈" : (u"櫚", ),  # 6988 => 6ADA
    u"榉" : (u"櫸", ),  # 6989 => 6AF8
    u"槚" : (u"檟", ),  # 69DA => 6A9F
    u"槛" : (u"檻", ),  # 69DB => 6ABB
    u"槟" : (u"檳", ),  # 69DF => 6AB3
    u"槠" : (u"櫧", ),  # 69E0 => 6AE7
    u"横" : (u"橫", ),  # 6A2A => 6A6B
    u"樯" : (u"檣", ),  # 6A2F => 6AA3
    u"樱" : (u"櫻", ),  # 6A31 => 6AFB
    u"橥" : (u"櫫", ),  # 6A65 => 6AEB
    u"橱" : (u"櫥", ),  # 6A71 => 6AE5
    u"橹" : (u"櫓", ),  # 6A79 => 6AD3
    u"橼" : (u"櫞", ),  # 6A7C => 6ADE
    u"檐" : (u"簷", ),  # 6A90 => 7C37
    u"檩" : (u"檁", ),  # 6AA9 => 6A81
    u"欢" : (u"歡", ),  # 6B22 => 6B61
    u"欤" : (u"歟", ),  # 6B24 => 6B5F
    u"欧" : (u"歐", ),  # 6B27 => 6B50
    u"歼" : (u"殲", ),  # 6B7C => 6BB2
    u"殁" : (u"歿", ),  # 6B81 => 6B7F
    u"殇" : (u"殤", ),  # 6B87 => 6BA4
    u"残" : (u"殘", ),  # 6B8B => 6B98
    u"殒" : (u"殞", ),  # 6B92 => 6B9E
    u"殓" : (u"殮", ),  # 6B93 => 6BAE
    u"殚" : (u"殫", ),  # 6B9A => 6BAB
    u"殡" : (u"殯", ),  # 6BA1 => 6BAF
    u"殴" : (u"毆", ),  # 6BB4 => 6BC6
    u"毁" : (u"毀", ),  # 6BC1 => 6BC0
    u"毂" : (u"轂", ),  # 6BC2 => 8F42
    u"毕" : (u"畢", ),  # 6BD5 => 7562
    u"毙" : (u"斃", ),  # 6BD9 => 6583
    u"毡" : (u"氈", ),  # 6BE1 => 6C08
    u"毵" : (u"毿", ),  # 6BF5 => 6BFF
    u"氇" : (u"氌", ),  # 6C07 => 6C0C
    u"气" : (u"氣", ),  # 6C14 => 6C23
    u"氢" : (u"氫", ),  # 6C22 => 6C2B
    u"氩" : (u"氬", ),  # 6C29 => 6C2C
    u"氲" : (u"氳", ),  # 6C32 => 6C33
    u"汇" : (u"匯", u"彙"),  # 6C47 => 532F 5F59
    u"汉" : (u"漢", ),  # 6C49 => 6F22
    u"污" : (u"汙", ),  # 6C61 => 6C59
    u"汤" : (u"湯", ),  # 6C64 => 6E6F
    u"汹" : (u"洶", ),  # 6C79 => 6D36
    u"沈" : (u"瀋", ),  # 6C88 => 700B
    u"沓" : (u"遝", ),  # 6C93 => 905D
    u"沟" : (u"溝", ),  # 6C9F => 6E9D
    u"没" : (u"沒", ),  # 6CA1 => 6C92
    u"沣" : (u"灃", ),  # 6CA3 => 7043
    u"沤" : (u"漚", ),  # 6CA4 => 6F1A
    u"沥" : (u"瀝", ),  # 6CA5 => 701D
    u"沦" : (u"淪", ),  # 6CA6 => 6DEA
    u"沧" : (u"滄", ),  # 6CA7 => 6EC4
    u"沨" : (u"渢", ),  # 6CA8 => 6E22
    u"沩" : (u"溈", ),  # 6CA9 => 6E88
    u"沪" : (u"滬", ),  # 6CAA => 6EEC
    u"泞" : (u"濘", ),  # 6CDE => 6FD8
    u"泪" : (u"淚", ),  # 6CEA => 6DDA
    u"泶" : (u"澩", ),  # 6CF6 => 6FA9
    u"泷" : (u"瀧", ),  # 6CF7 => 7027
    u"泸" : (u"瀘", ),  # 6CF8 => 7018
    u"泺" : (u"濼", ),  # 6CFA => 6FFC
    u"泻" : (u"瀉", ),  # 6CFB => 7009
    u"泼" : (u"潑", ),  # 6CFC => 6F51
    u"泽" : (u"澤", ),  # 6CFD => 6FA4
    u"泾" : (u"涇", ),  # 6CFE => 6D87
    u"洁" : (u"潔", ),  # 6D01 => 6F54
    u"洒" : (u"灑", ),  # 6D12 => 7051
    u"洼" : (u"窪", ),  # 6D3C => 7AAA
    u"浃" : (u"浹", ),  # 6D43 => 6D79
    u"浅" : (u"淺", ),  # 6D45 => 6DFA
    u"浆" : (u"漿", ),  # 6D46 => 6F3F
    u"浇" : (u"澆", ),  # 6D47 => 6F86
    u"浈" : (u"湞", ),  # 6D48 => 6E5E
    u"浉" : (u"溮", ),  # 6D49 => 6EAE
    u"浊" : (u"濁", ),  # 6D4A => 6FC1
    u"测" : (u"測", ),  # 6D4B => 6E2C
    u"浍" : (u"澮", ),  # 6D4D => 6FAE
    u"济" : (u"濟", ),  # 6D4E => 6FDF
    u"浏" : (u"瀏", ),  # 6D4F => 700F
    u"浐" : (u"滻", ),  # 6D50 => 6EFB
    u"浑" : (u"渾", ),  # 6D51 => 6E3E
    u"浒" : (u"滸", ),  # 6D52 => 6EF8
    u"浓" : (u"濃", ),  # 6D53 => 6FC3
    u"浔" : (u"潯", ),  # 6D54 => 6F6F
    u"浕" : (u"濜", ),  # 6D55 => 6FDC
    u"涂" : (u"塗", ),  # 6D82 => 5857
    u"涌" : (u"湧", ),  # 6D8C => 6E67
    u"涛" : (u"濤", ),  # 6D9B => 6FE4
    u"涝" : (u"澇", ),  # 6D9D => 6F87
    u"涞" : (u"淶", ),  # 6D9E => 6DF6
    u"涟" : (u"漣", ),  # 6D9F => 6F23
    u"涠" : (u"潿", ),  # 6DA0 => 6F7F
    u"涡" : (u"渦", ),  # 6DA1 => 6E26
    u"涢" : (u"溳", ),  # 6DA2 => 6EB3
    u"涣" : (u"渙", ),  # 6DA3 => 6E19
    u"涤" : (u"滌", ),  # 6DA4 => 6ECC
    u"润" : (u"潤", ),  # 6DA6 => 6F64
    u"涧" : (u"澗", ),  # 6DA7 => 6F97
    u"涨" : (u"漲", ),  # 6DA8 => 6F32
    u"涩" : (u"澀", ),  # 6DA9 => 6F80
    u"淀" : (u"澱", ),  # 6DC0 => 6FB1
    u"渊" : (u"淵", ),  # 6E0A => 6DF5
    u"渌" : (u"淥", ),  # 6E0C => 6DE5
    u"渍" : (u"漬", ),  # 6E0D => 6F2C
    u"渎" : (u"瀆", ),  # 6E0E => 7006
    u"渐" : (u"漸", ),  # 6E10 => 6F38
    u"渑" : (u"澠", ),  # 6E11 => 6FA0
    u"渔" : (u"漁", ),  # 6E14 => 6F01
    u"渖" : (u"瀋", ),  # 6E16 => 700B
    u"渗" : (u"滲", ),  # 6E17 => 6EF2
    u"温" : (u"溫", ),  # 6E29 => 6EAB
    u"湾" : (u"灣", ),  # 6E7E => 7063
    u"湿" : (u"濕", ),  # 6E7F => 6FD5
    u"溃" : (u"潰", ),  # 6E83 => 6F70
    u"溅" : (u"濺", ),  # 6E85 => 6FFA
    u"溆" : (u"漵", ),  # 6E86 => 6F35
    u"溇" : (u"漊", ),  # 6E87 => 6F0A
    u"滗" : (u"潷", ),  # 6ED7 => 6F77
    u"滚" : (u"滾", ),  # 6EDA => 6EFE
    u"滞" : (u"滯", ),  # 6EDE => 6EEF
    u"滟" : (u"灧", u"灩"),  # 6EDF => 7067 7069
    u"滠" : (u"灄", ),  # 6EE0 => 7044
    u"满" : (u"滿", ),  # 6EE1 => 6EFF
    u"滢" : (u"瀅", ),  # 6EE2 => 7005
    u"滤" : (u"濾", ),  # 6EE4 => 6FFE
    u"滥" : (u"濫", ),  # 6EE5 => 6FEB
    u"滦" : (u"灤", ),  # 6EE6 => 7064
    u"滨" : (u"濱", ),  # 6EE8 => 6FF1
    u"滩" : (u"灘", ),  # 6EE9 => 7058
    u"滪" : (u"澦", ),  # 6EEA => 6FA6
    u"漓" : (u"灕", ),  # 6F13 => 7055
    u"漤" : (u"濫", ),  # 6F24 => 6FEB
    u"潆" : (u"瀠", ),  # 6F46 => 7020
    u"潇" : (u"瀟", ),  # 6F47 => 701F
    u"潋" : (u"瀲", ),  # 6F4B => 7032
    u"潍" : (u"濰", ),  # 6F4D => 6FF0
    u"潜" : (u"潛", ),  # 6F5C => 6F5B
    u"潴" : (u"瀦", ),  # 6F74 => 7026
    u"澜" : (u"瀾", ),  # 6F9C => 703E
    u"濑" : (u"瀨", ),  # 6FD1 => 7028
    u"濒" : (u"瀕", ),  # 6FD2 => 7015
    u"灏" : (u"灝", ),  # 704F => 705D
    u"灭" : (u"滅", ),  # 706D => 6EC5
    u"灯" : (u"燈", ),  # 706F => 71C8
    u"灵" : (u"靈", ),  # 7075 => 9748
    u"灶" : (u"竈", ),  # 7076 => 7AC8
    u"灾" : (u"災", ),  # 707E => 707D
    u"灿" : (u"燦", ),  # 707F => 71E6
    u"炀" : (u"煬", ),  # 7080 => 716C
    u"炉" : (u"爐", ),  # 7089 => 7210
    u"炖" : (u"燉", ),  # 7096 => 71C9
    u"炜" : (u"煒", ),  # 709C => 7152
    u"炝" : (u"熗", ),  # 709D => 7197
    u"点" : (u"點", ),  # 70B9 => 9EDE
    u"炼" : (u"煉", ),  # 70BC => 7149
    u"炽" : (u"熾", ),  # 70BD => 71BE
    u"烁" : (u"爍", ),  # 70C1 => 720D
    u"烂" : (u"爛", ),  # 70C2 => 721B
    u"烃" : (u"烴", ),  # 70C3 => 70F4
    u"烛" : (u"燭", ),  # 70DB => 71ED
    u"烟" : (u"煙", ),  # 70DF => 7159
    u"烦" : (u"煩", ),  # 70E6 => 7169
    u"烧" : (u"焼", u"燒"),  # 70E7 => 713C 71D2
    u"烨" : (u"燁", ),  # 70E8 => 71C1
    u"烩" : (u"燴", ),  # 70E9 => 71F4
    u"烫" : (u"燙", ),  # 70EB => 71D9
    u"烬" : (u"燼", ),  # 70EC => 71FC
    u"热" : (u"熱", ),  # 70ED => 71B1
    u"焕" : (u"煥", ),  # 7115 => 7165
    u"焖" : (u"燜", ),  # 7116 => 71DC
    u"焘" : (u"燾", ),  # 7118 => 71FE
    u"煅" : (u"煆", ),  # 7145 => 7146
    u"煳" : (u"糊", ),  # 7173 => 7CCA
    u"煺" : (u"退", ),  # 717A => 9000
    u"熘" : (u"溜", ),  # 7198 => 6E9C
    u"爱" : (u"愛", ),  # 7231 => 611B
    u"爷" : (u"爺", ),  # 7237 => 723A
    u"牍" : (u"牘", ),  # 724D => 7258
    u"牦" : (u"犛", ),  # 7266 => 729B
    u"牵" : (u"牽", ),  # 7275 => 727D
    u"牺" : (u"犧", ),  # 727A => 72A7
    u"犊" : (u"犢", ),  # 728A => 72A2
    u"犟" : (u"強", ),  # 729F => 5F37
    u"犭" : (u"犬", ),  # 72AD => 72AC
    u"状" : (u"狀", ),  # 72B6 => 72C0
    u"犷" : (u"獷", ),  # 72B7 => 7377
    u"犸" : (u"獁", ),  # 72B8 => 7341
    u"犹" : (u"猶", ),  # 72B9 => 7336
    u"狈" : (u"狽", ),  # 72C8 => 72FD
    u"狍" : (u"麅", ),  # 72CD => 9E85
    u"狞" : (u"獰", ),  # 72DE => 7370
    u"独" : (u"獨", ),  # 72EC => 7368
    u"狭" : (u"狹", ),  # 72ED => 72F9
    u"狮" : (u"獅", ),  # 72EE => 7345
    u"狯" : (u"獪", ),  # 72EF => 736A
    u"狰" : (u"猙", ),  # 72F0 => 7319
    u"狱" : (u"獄", ),  # 72F1 => 7344
    u"狲" : (u"猻", ),  # 72F2 => 733B
    u"猃" : (u"獫", ),  # 7303 => 736B
    u"猎" : (u"獵", ),  # 730E => 7375
    u"猕" : (u"獼", ),  # 7315 => 737C
    u"猡" : (u"玀", ),  # 7321 => 7380
    u"猪" : (u"豬", ),  # 732A => 8C6C
    u"猫" : (u"貓", ),  # 732B => 8C93
    u"猬" : (u"蝟", ),  # 732C => 875F
    u"献" : (u"獻", ),  # 732E => 737B
    u"獭" : (u"獺", ),  # 736D => 737A
    u"玑" : (u"璣", ),  # 7391 => 74A3
    u"玛" : (u"瑪", ),  # 739B => 746A
    u"玮" : (u"瑋", ),  # 73AE => 744B
    u"环" : (u"環", ),  # 73AF => 74B0
    u"现" : (u"現", ),  # 73B0 => 73FE
    u"玱" : (u"瑲", ),  # 73B1 => 7472
    u"玺" : (u"壐", u"璽"),  # 73BA => 58D0 74BD
    u"珉" : (u"瑉", ),  # 73C9 => 7449
    u"珏" : (u"玨", ),  # 73CF => 73A8
    u"珐" : (u"琺", ),  # 73D0 => 743A
    u"珑" : (u"瓏", ),  # 73D1 => 74CF
    u"珲" : (u"琿", ),  # 73F2 => 743F
    u"琎" : (u"璡", ),  # 740E => 74A1
    u"琏" : (u"璉", ),  # 740F => 7489
    u"琐" : (u"瑣", ),  # 7410 => 7463
    u"琼" : (u"瓊", ),  # 743C => 74CA
    u"瑶" : (u"瑤", ),  # 7476 => 7464
    u"瑷" : (u"璦", ),  # 7477 => 74A6
    u"璇" : (u"璿", ),  # 7487 => 74BF
    u"璎" : (u"瓔", ),  # 748E => 74D4
    u"瓒" : (u"瓚", ),  # 74D2 => 74DA
    u"瓮" : (u"甕", ),  # 74EE => 7515
    u"瓯" : (u"甌", ),  # 74EF => 750C
    u"电" : (u"電", ),  # 7535 => 96FB
    u"画" : (u"畫", ),  # 753B => 756B
    u"畅" : (u"暢", ),  # 7545 => 66A2
    u"畲" : (u"佘", ),  # 7572 => 4F58
    u"畴" : (u"疇", ),  # 7574 => 7587
    u"疖" : (u"癤", ),  # 7596 => 7664
    u"疗" : (u"療", ),  # 7597 => 7642
    u"疟" : (u"瘧", ),  # 759F => 7627
    u"疠" : (u"癘", ),  # 75A0 => 7658
    u"疡" : (u"瘍", ),  # 75A1 => 760D
    u"疬" : (u"癧", u"鬁"),  # 75AC => 7667 9B01
    u"疮" : (u"瘡", ),  # 75AE => 7621
    u"疯" : (u"瘋", ),  # 75AF => 760B
    u"疱" : (u"皰", ),  # 75B1 => 76B0
    u"疴" : (u"屙", ),  # 75B4 => 5C59
    u"症" : (u"癥", ),  # 75C7 => 7665
    u"痈" : (u"癰", ),  # 75C8 => 7670
    u"痉" : (u"痙", ),  # 75C9 => 75D9
    u"痒" : (u"癢", ),  # 75D2 => 7662
    u"痖" : (u"瘂", ),  # 75D6 => 7602
    u"痨" : (u"癆", ),  # 75E8 => 7646
    u"痪" : (u"瘓", ),  # 75EA => 7613
    u"痫" : (u"癇", ),  # 75EB => 7647
    u"痴" : (u"癡", ),  # 75F4 => 7661
    u"瘅" : (u"癉", ),  # 7605 => 7649
    u"瘆" : (u"瘮", ),  # 7606 => 762E
    u"瘗" : (u"瘞", ),  # 7617 => 761E
    u"瘘" : (u"瘺", u"瘻"),  # 7618 => 763A 763B
    u"瘪" : (u"癟", ),  # 762A => 765F
    u"瘫" : (u"癱", ),  # 762B => 7671
    u"瘾" : (u"癮", ),  # 763E => 766E
    u"瘿" : (u"癭", ),  # 763F => 766D
    u"癞" : (u"癩", ),  # 765E => 7669
    u"癣" : (u"癬", ),  # 7663 => 766C
    u"癫" : (u"癲", ),  # 766B => 7672
    u"癯" : (u"臒", ),  # 766F => 81D2
    u"皑" : (u"皚", ),  # 7691 => 769A
    u"皱" : (u"皺", ),  # 76B1 => 76BA
    u"皲" : (u"皸", ),  # 76B2 => 76B8
    u"盏" : (u"盞", ),  # 76CF => 76DE
    u"盐" : (u"鹽", ),  # 76D0 => 9E7D
    u"监" : (u"監", ),  # 76D1 => 76E3
    u"盖" : (u"蓋", ),  # 76D6 => 84CB
    u"盗" : (u"盜", ),  # 76D7 => 76DC
    u"盘" : (u"盤", ),  # 76D8 => 76E4
    u"眍" : (u"瞘", ),  # 770D => 7798
    u"眦" : (u"眥", ),  # 7726 => 7725
    u"着" : (u"著", ),  # 7740 => 8457
    u"睁" : (u"睜", ),  # 7741 => 775C
    u"睐" : (u"睞", ),  # 7750 => 775E
    u"睑" : (u"瞼", ),  # 7751 => 77BC
    u"瞒" : (u"瞞", ),  # 7792 => 779E
    u"瞩" : (u"矚", ),  # 77A9 => 77DA
    u"矫" : (u"矯", ),  # 77EB => 77EF
    u"矶" : (u"磯", ),  # 77F6 => 78EF
    u"矾" : (u"礬", ),  # 77FE => 792C
    u"矿" : (u"礦", ),  # 77FF => 7926
    u"砀" : (u"碭", ),  # 7800 => 78AD
    u"码" : (u"碼", ),  # 7801 => 78BC
    u"砖" : (u"磚", ),  # 7816 => 78DA
    u"砗" : (u"硨", ),  # 7817 => 7868
    u"砚" : (u"硯", ),  # 781A => 786F
    u"砜" : (u"碸", ),  # 781C => 78B8
    u"砺" : (u"礪", ),  # 783A => 792A
    u"砻" : (u"礱", ),  # 783B => 7931
    u"砾" : (u"礫", ),  # 783E => 792B
    u"础" : (u"礎", ),  # 7840 => 790E
    u"硅" : (u"矽", ),  # 7845 => 77FD
    u"硕" : (u"碩", ),  # 7855 => 78A9
    u"硖" : (u"硤", ),  # 7856 => 7864
    u"硗" : (u"磽", ),  # 7857 => 78FD
    u"硙" : (u"磑", ),  # 7859 => 78D1
    u"硚" : (u"礄", ),  # 785A => 7904
    u"确" : (u"確", ),  # 786E => 78BA
    u"硷" : (u"鹸", u"鹼"),  # 7877 => 9E78 9E7C
    u"碍" : (u"礙", ),  # 788D => 7919
    u"碛" : (u"磧", ),  # 789B => 78E7
    u"碜" : (u"磣", ),  # 789C => 78E3
    u"碱" : (u"堿", ),  # 78B1 => 583F
    u"碹" : (u"镟", ),  # 78B9 => 955F
    u"磙" : (u"滾", ),  # 78D9 => 6EFE
    u"礼" : (u"禮", ),  # 793C => 79AE
    u"祎" : (u"禕", ),  # 794E => 7995
    u"祢" : (u"禰", ),  # 7962 => 79B0
    u"祯" : (u"禎", ),  # 796F => 798E
    u"祷" : (u"禱", ),  # 7977 => 79B1
    u"祸" : (u"禍", ),  # 7978 => 798D
    u"禀" : (u"稟", ),  # 7980 => 7A1F
    u"禄" : (u"祿", ),  # 7984 => 797F
    u"禅" : (u"禪", ),  # 7985 => 79AA
    u"离" : (u"離", ),  # 79BB => 96E2
    u"秃" : (u"禿", ),  # 79C3 => 79BF
    u"秆" : (u"稈", ),  # 79C6 => 7A08
    u"秋" : (u"鞦", ),  # 79CB => 97A6
    u"种" : (u"種", ),  # 79CD => 7A2E
    u"积" : (u"積", ),  # 79EF => 7A4D
    u"称" : (u"稱", ),  # 79F0 => 7A31
    u"秽" : (u"穢", ),  # 79FD => 7A62
    u"稆" : (u"穭", ),  # 7A06 => 7A6D
    u"税" : (u"稅", ),  # 7A0E => 7A05
    u"稣" : (u"穌", ),  # 7A23 => 7A4C
    u"稳" : (u"穩", ),  # 7A33 => 7A69
    u"穑" : (u"穡", ),  # 7A51 => 7A61
    u"穷" : (u"窮", ),  # 7A77 => 7AAE
    u"窃" : (u"竊", ),  # 7A83 => 7ACA
    u"窍" : (u"竅", ),  # 7A8D => 7AC5
    u"窎" : (u"窵", ),  # 7A8E => 7AB5
    u"窑" : (u"窯", ),  # 7A91 => 7AAF
    u"窜" : (u"竄", ),  # 7A9C => 7AC4
    u"窝" : (u"窩", ),  # 7A9D => 7AA9
    u"窥" : (u"窺", ),  # 7AA5 => 7ABA
    u"窦" : (u"竇", ),  # 7AA6 => 7AC7
    u"窭" : (u"窶", ),  # 7AAD => 7AB6
    u"竖" : (u"竪", u"豎"),  # 7AD6 => 7AEA 8C4E
    u"竞" : (u"競", ),  # 7ADE => 7AF6
    u"笃" : (u"篤", ),  # 7B03 => 7BE4
    u"笋" : (u"筍", ),  # 7B0B => 7B4D
    u"笔" : (u"筆", ),  # 7B14 => 7B46
    u"笕" : (u"筧", ),  # 7B15 => 7B67
    u"笺" : (u"箋", ),  # 7B3A => 7B8B
    u"笼" : (u"籠", ),  # 7B3C => 7C60
    u"笾" : (u"籩", ),  # 7B3E => 7C69
    u"筑" : (u"築", ),  # 7B51 => 7BC9
    u"筚" : (u"篳", ),  # 7B5A => 7BF3
    u"筛" : (u"篩", ),  # 7B5B => 7BE9
    u"筝" : (u"箏", ),  # 7B5D => 7B8F
    u"筹" : (u"籌", ),  # 7B79 => 7C4C
    u"签" : (u"簽", u"籤"),  # 7B7E => 7C3D 7C64
    u"简" : (u"簡", ),  # 7B80 => 7C21
    u"箓" : (u"籙", ),  # 7B93 => 7C59
    u"箦" : (u"簀", ),  # 7BA6 => 7C00
    u"箧" : (u"篋", ),  # 7BA7 => 7BCB
    u"箨" : (u"籜", ),  # 7BA8 => 7C5C
    u"箩" : (u"籮", ),  # 7BA9 => 7C6E
    u"箪" : (u"簞", ),  # 7BAA => 7C1E
    u"箫" : (u"簫", ),  # 7BAB => 7C2B
    u"篑" : (u"簣", ),  # 7BD1 => 7C23
    u"篓" : (u"簍", ),  # 7BD3 => 7C0D
    u"篮" : (u"籃", ),  # 7BEE => 7C43
    u"篱" : (u"籬", ),  # 7BF1 => 7C6C
    u"簖" : (u"籪", ),  # 7C16 => 7C6A
    u"籁" : (u"籟", ),  # 7C41 => 7C5F
    u"籴" : (u"糴", ),  # 7C74 => 7CF4
    u"类" : (u"類", ),  # 7C7B => 985E
    u"籼" : (u"秈", ),  # 7C7C => 79C8
    u"粜" : (u"糶", ),  # 7C9C => 7CF6
    u"粝" : (u"糲", ),  # 7C9D => 7CF2
    u"粤" : (u"粵", ),  # 7CA4 => 7CB5
    u"粪" : (u"糞", ),  # 7CAA => 7CDE
    u"粮" : (u"糧", ),  # 7CAE => 7CE7
    u"糁" : (u"糝", ),  # 7CC1 => 7CDD
    u"糇" : (u"餱", ),  # 7CC7 => 9931
    u"系" : (u"係", u"繫"),  # 7CFB => 4FC2 7E6B
    u"紧" : (u"緊", ),  # 7D27 => 7DCA
    u"累" : (u"纍", ),  # 7D2F => 7E8D
    u"絷" : (u"縶", ),  # 7D77 => 7E36
    u"纟" : (u"糸", ),  # 7E9F => 7CF8
    u"纠" : (u"糾", ),  # 7EA0 => 7CFE
    u"纡" : (u"紆", ),  # 7EA1 => 7D06
    u"红" : (u"紅", ),  # 7EA2 => 7D05
    u"纣" : (u"紂", ),  # 7EA3 => 7D02
    u"纤" : (u"縴", u"纖"),  # 7EA4 => 7E34 7E96
    u"纥" : (u"紇", ),  # 7EA5 => 7D07
    u"约" : (u"約", ),  # 7EA6 => 7D04
    u"级" : (u"級", ),  # 7EA7 => 7D1A
    u"纨" : (u"紈", ),  # 7EA8 => 7D08
    u"纩" : (u"纊", ),  # 7EA9 => 7E8A
    u"纪" : (u"紀", ),  # 7EAA => 7D00
    u"纫" : (u"紉", ),  # 7EAB => 7D09
    u"纬" : (u"緯", ),  # 7EAC => 7DEF
    u"纭" : (u"紜", ),  # 7EAD => 7D1C
    u"纯" : (u"純", ),  # 7EAF => 7D14
    u"纰" : (u"紕", ),  # 7EB0 => 7D15
    u"纱" : (u"紗", ),  # 7EB1 => 7D17
    u"纲" : (u"綱", ),  # 7EB2 => 7DB1
    u"纳" : (u"納", ),  # 7EB3 => 7D0D
    u"纴" : (u"紝", ),  # 7EB4 => 7D1D
    u"纵" : (u"縱", ),  # 7EB5 => 7E31
    u"纶" : (u"綸", ),  # 7EB6 => 7DB8
    u"纷" : (u"紛", ),  # 7EB7 => 7D1B
    u"纸" : (u"紙", ),  # 7EB8 => 7D19
    u"纹" : (u"紋", ),  # 7EB9 => 7D0B
    u"纺" : (u"紡", ),  # 7EBA => 7D21
    u"纼" : (u"紖", ),  # 7EBC => 7D16
    u"纽" : (u"紐", ),  # 7EBD => 7D10
    u"纾" : (u"紓", ),  # 7EBE => 7D13
    u"线" : (u"綫", u"線"),  # 7EBF => 7DAB 7DDA
    u"绀" : (u"紺", ),  # 7EC0 => 7D3A
    u"绁" : (u"紲", u"絏"),  # 7EC1 => 7D32 7D4F
    u"绂" : (u"紱", ),  # 7EC2 => 7D31
    u"练" : (u"練", ),  # 7EC3 => 7DF4
    u"组" : (u"組", ),  # 7EC4 => 7D44
    u"绅" : (u"紳", ),  # 7EC5 => 7D33
    u"细" : (u"細", ),  # 7EC6 => 7D30
    u"织" : (u"織", ),  # 7EC7 => 7E54
    u"终" : (u"終", ),  # 7EC8 => 7D42
    u"绉" : (u"縐", ),  # 7EC9 => 7E10
    u"绊" : (u"絆", ),  # 7ECA => 7D46
    u"绋" : (u"紼", ),  # 7ECB => 7D3C
    u"绌" : (u"絀", ),  # 7ECC => 7D40
    u"绍" : (u"紹", ),  # 7ECD => 7D39
    u"绎" : (u"繹", ),  # 7ECE => 7E79
    u"经" : (u"經", ),  # 7ECF => 7D93
    u"绐" : (u"紿", ),  # 7ED0 => 7D3F
    u"绑" : (u"綁", ),  # 7ED1 => 7D81
    u"绒" : (u"絨", ),  # 7ED2 => 7D68
    u"结" : (u"結", ),  # 7ED3 => 7D50
    u"绔" : (u"絝", ),  # 7ED4 => 7D5D
    u"绕" : (u"繞", ),  # 7ED5 => 7E5E
    u"绖" : (u"絰", ),  # 7ED6 => 7D70
    u"绗" : (u"絎", ),  # 7ED7 => 7D4E
    u"绘" : (u"繪", ),  # 7ED8 => 7E6A
    u"给" : (u"給", ),  # 7ED9 => 7D66
    u"绚" : (u"絢", ),  # 7EDA => 7D62
    u"绛" : (u"絳", ),  # 7EDB => 7D73
    u"络" : (u"絡", ),  # 7EDC => 7D61
    u"绝" : (u"絕", u"絶"),  # 7EDD => 7D55 7D76
    u"绞" : (u"絞", ),  # 7EDE => 7D5E
    u"统" : (u"統", ),  # 7EDF => 7D71
    u"绠" : (u"綆", ),  # 7EE0 => 7D86
    u"绡" : (u"綃", ),  # 7EE1 => 7D83
    u"绢" : (u"絹", ),  # 7EE2 => 7D79
    u"绣" : (u"綉", u"繡"),  # 7EE3 => 7D89 7E61
    u"绥" : (u"綏", ),  # 7EE5 => 7D8F
    u"绦" : (u"絛", u"縧"),  # 7EE6 => 7D5B 7E27
    u"继" : (u"繼", ),  # 7EE7 => 7E7C
    u"绨" : (u"綈", ),  # 7EE8 => 7D88
    u"绩" : (u"績", ),  # 7EE9 => 7E3E
    u"绪" : (u"緒", ),  # 7EEA => 7DD2
    u"绫" : (u"綾", ),  # 7EEB => 7DBE
    u"续" : (u"續", ),  # 7EED => 7E8C
    u"绮" : (u"綺", ),  # 7EEE => 7DBA
    u"绯" : (u"緋", ),  # 7EEF => 7DCB
    u"绰" : (u"綽", ),  # 7EF0 => 7DBD
    u"绱" : (u"緔", ),  # 7EF1 => 7DD4
    u"绲" : (u"緄", ),  # 7EF2 => 7DC4
    u"绳" : (u"繩", ),  # 7EF3 => 7E69
    u"维" : (u"維", ),  # 7EF4 => 7DAD
    u"绵" : (u"綿", ),  # 7EF5 => 7DBF
    u"绶" : (u"綬", ),  # 7EF6 => 7DAC
    u"绷" : (u"綳", u"繃"),  # 7EF7 => 7DB3 7E43
    u"绸" : (u"綢", ),  # 7EF8 => 7DA2
    u"绺" : (u"綹", ),  # 7EFA => 7DB9
    u"绻" : (u"綣", ),  # 7EFB => 7DA3
    u"综" : (u"綜", ),  # 7EFC => 7D9C
    u"绽" : (u"綻", ),  # 7EFD => 7DBB
    u"绾" : (u"綰", ),  # 7EFE => 7DB0
    u"绿" : (u"綠", u"緑"),  # 7EFF => 7DA0 7DD1
    u"缀" : (u"綴", ),  # 7F00 => 7DB4
    u"缁" : (u"緇", ),  # 7F01 => 7DC7
    u"缂" : (u"緙", ),  # 7F02 => 7DD9
    u"缃" : (u"緗", ),  # 7F03 => 7DD7
    u"缄" : (u"緘", ),  # 7F04 => 7DD8
    u"缅" : (u"緬", ),  # 7F05 => 7DEC
    u"缆" : (u"纜", ),  # 7F06 => 7E9C
    u"缇" : (u"緹", ),  # 7F07 => 7DF9
    u"缈" : (u"緲", ),  # 7F08 => 7DF2
    u"缉" : (u"緝", ),  # 7F09 => 7DDD
    u"缊" : (u"緼", ),  # 7F0A => 7DFC
    u"缋" : (u"繢", ),  # 7F0B => 7E62
    u"缌" : (u"緦", ),  # 7F0C => 7DE6
    u"缍" : (u"綞", ),  # 7F0D => 7D9E
    u"缎" : (u"緞", ),  # 7F0E => 7DDE
    u"缏" : (u"緶", ),  # 7F0F => 7DF6
    u"缑" : (u"緱", ),  # 7F11 => 7DF1
    u"缒" : (u"縋", ),  # 7F12 => 7E0B
    u"缓" : (u"緩", ),  # 7F13 => 7DE9
    u"缔" : (u"締", ),  # 7F14 => 7DE0
    u"缕" : (u"縷", ),  # 7F15 => 7E37
    u"编" : (u"編", ),  # 7F16 => 7DE8
    u"缗" : (u"緡", ),  # 7F17 => 7DE1
    u"缘" : (u"緣", ),  # 7F18 => 7DE3
    u"缙" : (u"縉", ),  # 7F19 => 7E09
    u"缚" : (u"縛", ),  # 7F1A => 7E1B
    u"缛" : (u"縟", ),  # 7F1B => 7E1F
    u"缜" : (u"縝", ),  # 7F1C => 7E1D
    u"缝" : (u"縫", ),  # 7F1D => 7E2B
    u"缞" : (u"縗", ),  # 7F1E => 7E17
    u"缟" : (u"縞", ),  # 7F1F => 7E1E
    u"缠" : (u"纏", ),  # 7F20 => 7E8F
    u"缡" : (u"縭", ),  # 7F21 => 7E2D
    u"缢" : (u"縊", ),  # 7F22 => 7E0A
    u"缣" : (u"縑", ),  # 7F23 => 7E11
    u"缤" : (u"繽", ),  # 7F24 => 7E7D
    u"缥" : (u"縹", ),  # 7F25 => 7E39
    u"缦" : (u"縵", ),  # 7F26 => 7E35
    u"缧" : (u"縲", ),  # 7F27 => 7E32
    u"缨" : (u"纓", ),  # 7F28 => 7E93
    u"缩" : (u"縮", ),  # 7F29 => 7E2E
    u"缪" : (u"繆", ),  # 7F2A => 7E46
    u"缫" : (u"繅", ),  # 7F2B => 7E45
    u"缬" : (u"纈", ),  # 7F2C => 7E88
    u"缭" : (u"繚", ),  # 7F2D => 7E5A
    u"缮" : (u"繕", ),  # 7F2E => 7E55
    u"缯" : (u"繒", ),  # 7F2F => 7E52
    u"缰" : (u"繮", u"韁"),  # 7F30 => 7E6E 97C1
    u"缱" : (u"繾", ),  # 7F31 => 7E7E
    u"缲" : (u"繰", ),  # 7F32 => 7E70
    u"缳" : (u"繯", ),  # 7F33 => 7E6F
    u"缴" : (u"繳", ),  # 7F34 => 7E73
    u"缵" : (u"纘", ),  # 7F35 => 7E98
    u"罂" : (u"罌", ),  # 7F42 => 7F4C
    u"网" : (u"網", ),  # 7F51 => 7DB2
    u"罗" : (u"羅", ),  # 7F57 => 7F85
    u"罚" : (u"罰", u"罸"),  # 7F5A => 7F70 7F78
    u"罢" : (u"罷", ),  # 7F62 => 7F77
    u"罴" : (u"羆", ),  # 7F74 => 7F86
    u"羁" : (u"羈", u"覊"),  # 7F81 => 7F88 898A
    u"羟" : (u"羥", ),  # 7F9F => 7FA5
    u"羡" : (u"羨", ),  # 7FA1 => 7FA8
    u"翘" : (u"翹", ),  # 7FD8 => 7FF9
    u"翚" : (u"翬", ),  # 7FDA => 7FEC
    u"耢" : (u"耮", ),  # 8022 => 802E
    u"耧" : (u"耬", ),  # 8027 => 802C
    u"耸" : (u"聳", ),  # 8038 => 8073
    u"耻" : (u"恥", ),  # 803B => 6065
    u"聂" : (u"聶", ),  # 8042 => 8076
    u"聋" : (u"聾", ),  # 804B => 807E
    u"职" : (u"職", ),  # 804C => 8077
    u"聍" : (u"聹", ),  # 804D => 8079
    u"联" : (u"聯", ),  # 8054 => 806F
    u"聩" : (u"聵", ),  # 8069 => 8075
    u"聪" : (u"聰", ),  # 806A => 8070
    u"肃" : (u"肅", ),  # 8083 => 8085
    u"肠" : (u"腸", ),  # 80A0 => 8178
    u"肤" : (u"膚", ),  # 80A4 => 819A
    u"肮" : (u"骯", ),  # 80AE => 9AAF
    u"肷" : (u"膁", ),  # 80B7 => 8181
    u"肾" : (u"腎", ),  # 80BE => 814E
    u"肿" : (u"腫", ),  # 80BF => 816B
    u"胀" : (u"脹", ),  # 80C0 => 8139
    u"胁" : (u"脅", ),  # 80C1 => 8105
    u"胆" : (u"膽", ),  # 80C6 => 81BD
    u"胜" : (u"勝", ),  # 80DC => 52DD
    u"胡" : (u"鬍", ),  # 80E1 => 9B0D
    u"胧" : (u"朧", ),  # 80E7 => 6727
    u"胨" : (u"腖", ),  # 80E8 => 8156
    u"胪" : (u"臚", ),  # 80EA => 81DA
    u"胫" : (u"脛", ),  # 80EB => 811B
    u"胶" : (u"膠", ),  # 80F6 => 81A0
    u"脉" : (u"脈", ),  # 8109 => 8108
    u"脍" : (u"膾", ),  # 810D => 81BE
    u"脏" : (u"贜", u"髒"),  # 810F => 8D1C 9AD2
    u"脐" : (u"臍", ),  # 8110 => 81CD
    u"脑" : (u"腦", ),  # 8111 => 8166
    u"脓" : (u"膿", ),  # 8113 => 81BF
    u"脔" : (u"臠", ),  # 8114 => 81E0
    u"脚" : (u"腳", ),  # 811A => 8173
    u"脱" : (u"脫", ),  # 8131 => 812B
    u"脶" : (u"腡", ),  # 8136 => 8161
    u"脸" : (u"臉", ),  # 8138 => 81C9
    u"腊" : (u"臘", ),  # 814A => 81D8
    u"腌" : (u"醃", ),  # 814C => 9183
    u"腘" : (u"膕", ),  # 8158 => 8195
    u"腭" : (u"齶", ),  # 816D => 9F76
    u"腻" : (u"膩", ),  # 817B => 81A9
    u"腼" : (u"靦", ),  # 817C => 9766
    u"腽" : (u"膃", ),  # 817D => 8183
    u"腾" : (u"騰", ),  # 817E => 9A30
    u"膑" : (u"臏", ),  # 8191 => 81CF
    u"臜" : (u"臢", ),  # 81DC => 81E2
    u"致" : (u"緻", ),  # 81F4 => 7DFB
    u"舆" : (u"輿", ),  # 8206 => 8F3F
    u"舍" : (u"捨", ),  # 820D => 6368
    u"舣" : (u"艤", ),  # 8223 => 8264
    u"舰" : (u"艦", ),  # 8230 => 8266
    u"舱" : (u"艙", ),  # 8231 => 8259
    u"舻" : (u"艫", ),  # 823B => 826B
    u"艰" : (u"艱", ),  # 8270 => 8271
    u"艳" : (u"艶", u"豔"),  # 8273 => 8276 8C54
    u"艹" : (u"艸", ),  # 8279 => 8278
    u"艺" : (u"兿", u"藝"),  # 827A => 517F 85DD
    u"节" : (u"節", ),  # 8282 => 7BC0
    u"芈" : (u"羋", ),  # 8288 => 7F8B
    u"芗" : (u"薌", ),  # 8297 => 858C
    u"芜" : (u"蕪", ),  # 829C => 856A
    u"芦" : (u"蘆", ),  # 82A6 => 8606
    u"芸" : (u"蕓", ),  # 82B8 => 8553
    u"苁" : (u"蓯", ),  # 82C1 => 84EF
    u"苇" : (u"葦", ),  # 82C7 => 8466
    u"苈" : (u"藶", ),  # 82C8 => 85F6
    u"苋" : (u"莧", ),  # 82CB => 83A7
    u"苌" : (u"萇", ),  # 82CC => 8407
    u"苍" : (u"蒼", ),  # 82CD => 84BC
    u"苎" : (u"苧", ),  # 82CE => 82E7
    u"苏" : (u"囌", u"蘇"),  # 82CF => 56CC 8607
    u"苘" : (u"檾", ),  # 82D8 => 6ABE
    u"苹" : (u"蘋", ),  # 82F9 => 860B
    u"范" : (u"範", ),  # 8303 => 7BC4
    u"茎" : (u"莖", ),  # 830E => 8396
    u"茏" : (u"蘢", ),  # 830F => 8622
    u"茑" : (u"蔦", ),  # 8311 => 8526
    u"茔" : (u"塋", ),  # 8314 => 584B
    u"茕" : (u"煢", ),  # 8315 => 7162
    u"茧" : (u"繭", ),  # 8327 => 7E6D
    u"荆" : (u"荊", ),  # 8346 => 834A
    u"荐" : (u"薦", ),  # 8350 => 85A6
    u"荚" : (u"莢", ),  # 835A => 83A2
    u"荛" : (u"蕘", ),  # 835B => 8558
    u"荜" : (u"蓽", ),  # 835C => 84FD
    u"荞" : (u"蕎", ),  # 835E => 854E
    u"荟" : (u"薈", ),  # 835F => 8588
    u"荠" : (u"薺", ),  # 8360 => 85BA
    u"荡" : (u"蕩", ),  # 8361 => 8569
    u"荣" : (u"榮", ),  # 8363 => 69AE
    u"荤" : (u"葷", ),  # 8364 => 8477
    u"荥" : (u"滎", ),  # 8365 => 6ECE
    u"荦" : (u"犖", ),  # 8366 => 7296
    u"荧" : (u"熒", ),  # 8367 => 7192
    u"荨" : (u"蕁", ),  # 8368 => 8541
    u"荩" : (u"藎", ),  # 8369 => 85CE
    u"荪" : (u"蓀", ),  # 836A => 84C0
    u"荫" : (u"蔭", ),  # 836B => 852D
    u"荬" : (u"蕒", ),  # 836C => 8552
    u"荭" : (u"葒", ),  # 836D => 8452
    u"荮" : (u"葤", ),  # 836E => 8464
    u"药" : (u"藥", ),  # 836F => 85E5
    u"莅" : (u"蒞", ),  # 8385 => 849E
    u"莜" : (u"蓧", ),  # 839C => 84E7
    u"莱" : (u"萊", ),  # 83B1 => 840A
    u"莲" : (u"蓮", ),  # 83B2 => 84EE
    u"莳" : (u"蒔", ),  # 83B3 => 8494
    u"莴" : (u"萵", ),  # 83B4 => 8435
    u"莶" : (u"薟", ),  # 83B6 => 859F
    u"获" : (u"獲", u"穫"),  # 83B7 => 7372 7A6B
    u"莸" : (u"蕕", ),  # 83B8 => 8555
    u"莹" : (u"瑩", ),  # 83B9 => 7469
    u"莺" : (u"鶯", ),  # 83BA => 9DAF
    u"莼" : (u"蒓", u"蓴"),  # 83BC => 8493 84F4
    u"萚" : (u"蘀", ),  # 841A => 8600
    u"萝" : (u"蘿", ),  # 841D => 863F
    u"萤" : (u"螢", ),  # 8424 => 87A2
    u"营" : (u"營", ),  # 8425 => 71DF
    u"萦" : (u"縈", ),  # 8426 => 7E08
    u"萧" : (u"蕭", ),  # 8427 => 856D
    u"萨" : (u"薩", ),  # 8428 => 85A9
    u"葱" : (u"蔥", ),  # 8471 => 8525
    u"蒇" : (u"蕆", ),  # 8487 => 8546
    u"蒉" : (u"蕢", ),  # 8489 => 8562
    u"蒋" : (u"蔣", ),  # 848B => 8523
    u"蒌" : (u"蔞", ),  # 848C => 851E
    u"蒙" : (u"懞", u"濛", u"矇"),  # 8499 => 61DE 6FDB 77C7
    u"蓝" : (u"藍", ),  # 84DD => 85CD
    u"蓟" : (u"薊", ),  # 84DF => 858A
    u"蓠" : (u"蘺", ),  # 84E0 => 863A
    u"蓣" : (u"蕷", ),  # 84E3 => 8577
    u"蓥" : (u"鎣", ),  # 84E5 => 93A3
    u"蓦" : (u"驀", ),  # 84E6 => 9A40
    u"蔑" : (u"衊", ),  # 8511 => 884A
    u"蔷" : (u"薔", ),  # 8537 => 8594
    u"蔹" : (u"蘞", ),  # 8539 => 861E
    u"蔺" : (u"藺", ),  # 853A => 85FA
    u"蔼" : (u"藹", ),  # 853C => 85F9
    u"蕲" : (u"蘄", ),  # 8572 => 8604
    u"蕴" : (u"藴", u"蘊"),  # 8574 => 85F4 860A
    u"薮" : (u"藪", ),  # 85AE => 85EA
    u"藁" : (u"槁", ),  # 85C1 => 69C1
    u"藓" : (u"蘚", ),  # 85D3 => 861A
    u"虏" : (u"虜", ),  # 864F => 865C
    u"虑" : (u"慮", ),  # 8651 => 616E
    u"虚" : (u"虛", ),  # 865A => 865B
    u"虫" : (u"蟲", ),  # 866B => 87F2
    u"虬" : (u"虯", ),  # 866C => 866F
    u"虮" : (u"蟣", ),  # 866E => 87E3
    u"虽" : (u"雖", ),  # 867D => 96D6
    u"虾" : (u"蝦", ),  # 867E => 8766
    u"虿" : (u"蠆", ),  # 867F => 8806
    u"蚀" : (u"蝕", ),  # 8680 => 8755
    u"蚁" : (u"蟻", ),  # 8681 => 87FB
    u"蚂" : (u"螞", ),  # 8682 => 879E
    u"蚕" : (u"蠶", ),  # 8695 => 8836
    u"蚝" : (u"蠔", ),  # 869D => 8814
    u"蚬" : (u"蜆", ),  # 86AC => 8706
    u"蛊" : (u"蠱", ),  # 86CA => 8831
    u"蛎" : (u"蠣", ),  # 86CE => 8823
    u"蛏" : (u"蟶", ),  # 86CF => 87F6
    u"蛮" : (u"蠻", ),  # 86EE => 883B
    u"蛰" : (u"蟄", ),  # 86F0 => 87C4
    u"蛱" : (u"蛺", ),  # 86F1 => 86FA
    u"蛲" : (u"蟯", ),  # 86F2 => 87EF
    u"蛳" : (u"螄", ),  # 86F3 => 8784
    u"蛴" : (u"蠐", ),  # 86F4 => 8810
    u"蜕" : (u"蛻", ),  # 8715 => 86FB
    u"蜗" : (u"蝸", ),  # 8717 => 8778
    u"蜡" : (u"蠟", ),  # 8721 => 881F
    u"蝇" : (u"蠅", ),  # 8747 => 8805
    u"蝈" : (u"蟈", ),  # 8748 => 87C8
    u"蝉" : (u"蟬", ),  # 8749 => 87EC
    u"蝎" : (u"蠍", ),  # 874E => 880D
    u"蝼" : (u"螻", ),  # 877C => 87BB
    u"蝾" : (u"蠑", ),  # 877E => 8811
    u"螨" : (u"蟎", ),  # 87A8 => 87CE
    u"蟏" : (u"蠨", ),  # 87CF => 8828
    u"衅" : (u"釁", ),  # 8845 => 91C1
    u"衔" : (u"銜", ),  # 8854 => 929C
    u"补" : (u"補", ),  # 8865 => 88DC
    u"表" : (u"錶", ),  # 8868 => 9336
    u"衬" : (u"襯", ),  # 886C => 896F
    u"衮" : (u"袞", ),  # 886E => 889E
    u"袄" : (u"襖", ),  # 8884 => 8956
    u"袅" : (u"嫋", u"裊"),  # 8885 => 5ACB 88CA
    u"袜" : (u"襪", ),  # 889C => 896A
    u"袭" : (u"襲", ),  # 88AD => 8972
    u"装" : (u"裝", ),  # 88C5 => 88DD
    u"裆" : (u"襠", ),  # 88C6 => 8960
    u"裢" : (u"褳", ),  # 88E2 => 8933
    u"裣" : (u"襝", ),  # 88E3 => 895D
    u"裤" : (u"褲", ),  # 88E4 => 8932
    u"裥" : (u"襇", ),  # 88E5 => 8947
    u"褛" : (u"褸", ),  # 891B => 8938
    u"褴" : (u"襤", ),  # 8934 => 8964
    u"襁" : (u"繈", ),  # 8941 => 7E48
    u"见" : (u"見", ),  # 89C1 => 898B
    u"观" : (u"觀", ),  # 89C2 => 89C0
    u"觃" : (u"覎", ),  # 89C3 => 898E
    u"规" : (u"規", ),  # 89C4 => 898F
    u"觅" : (u"覓", ),  # 89C5 => 8993
    u"视" : (u"視", ),  # 89C6 => 8996
    u"觇" : (u"覘", ),  # 89C7 => 8998
    u"览" : (u"覧", u"覽"),  # 89C8 => 89A7 89BD
    u"觉" : (u"覺", ),  # 89C9 => 89BA
    u"觊" : (u"覬", ),  # 89CA => 89AC
    u"觋" : (u"覡", ),  # 89CB => 89A1
    u"觌" : (u"覿", ),  # 89CC => 89BF
    u"觎" : (u"覦", ),  # 89CE => 89A6
    u"觏" : (u"覯", ),  # 89CF => 89AF
    u"觐" : (u"覲", ),  # 89D0 => 89B2
    u"觑" : (u"覷", ),  # 89D1 => 89B7
    u"觞" : (u"觴", ),  # 89DE => 89F4
    u"触" : (u"觸", ),  # 89E6 => 89F8
    u"觯" : (u"觶", ),  # 89EF => 89F6
    u"誉" : (u"譽", ),  # 8A89 => 8B7D
    u"誊" : (u"謄", ),  # 8A8A => 8B04
    u"讠" : (u"訁", ),  # 8BA0 => 8A01
    u"计" : (u"計", ),  # 8BA1 => 8A08
    u"订" : (u"訂", ),  # 8BA2 => 8A02
    u"讣" : (u"訃", ),  # 8BA3 => 8A03
    u"认" : (u"認", ),  # 8BA4 => 8A8D
    u"讥" : (u"譏", ),  # 8BA5 => 8B4F
    u"讦" : (u"訐", ),  # 8BA6 => 8A10
    u"讧" : (u"訌", ),  # 8BA7 => 8A0C
    u"讨" : (u"討", ),  # 8BA8 => 8A0E
    u"让" : (u"讓", ),  # 8BA9 => 8B93
    u"讪" : (u"訕", ),  # 8BAA => 8A15
    u"讫" : (u"訖", ),  # 8BAB => 8A16
    u"训" : (u"訓", ),  # 8BAD => 8A13
    u"议" : (u"議", ),  # 8BAE => 8B70
    u"讯" : (u"訊", ),  # 8BAF => 8A0A
    u"记" : (u"記", ),  # 8BB0 => 8A18
    u"讲" : (u"講", ),  # 8BB2 => 8B1B
    u"讳" : (u"諱", ),  # 8BB3 => 8AF1
    u"讴" : (u"謳", ),  # 8BB4 => 8B33
    u"讵" : (u"詎", ),  # 8BB5 => 8A4E
    u"讶" : (u"訝", ),  # 8BB6 => 8A1D
    u"讷" : (u"訥", ),  # 8BB7 => 8A25
    u"许" : (u"許", ),  # 8BB8 => 8A31
    u"讹" : (u"訛", ),  # 8BB9 => 8A1B
    u"论" : (u"論", ),  # 8BBA => 8AD6
    u"讻" : (u"訩", ),  # 8BBB => 8A29
    u"讼" : (u"訟", ),  # 8BBC => 8A1F
    u"讽" : (u"諷", ),  # 8BBD => 8AF7
    u"设" : (u"設", ),  # 8BBE => 8A2D
    u"访" : (u"訪", ),  # 8BBF => 8A2A
    u"诀" : (u"訣", ),  # 8BC0 => 8A23
    u"证" : (u"證", ),  # 8BC1 => 8B49
    u"诂" : (u"詁", ),  # 8BC2 => 8A41
    u"诃" : (u"訶", ),  # 8BC3 => 8A36
    u"评" : (u"評", ),  # 8BC4 => 8A55
    u"诅" : (u"詛", ),  # 8BC5 => 8A5B
    u"识" : (u"識", ),  # 8BC6 => 8B58
    u"诇" : (u"詗", ),  # 8BC7 => 8A57
    u"诈" : (u"詐", ),  # 8BC8 => 8A50
    u"诉" : (u"訴", ),  # 8BC9 => 8A34
    u"诊" : (u"診", ),  # 8BCA => 8A3A
    u"诋" : (u"詆", ),  # 8BCB => 8A46
    u"诌" : (u"謅", ),  # 8BCC => 8B05
    u"词" : (u"詞", ),  # 8BCD => 8A5E
    u"诎" : (u"詘", ),  # 8BCE => 8A58
    u"诏" : (u"詔", ),  # 8BCF => 8A54
    u"译" : (u"譯", ),  # 8BD1 => 8B6F
    u"诒" : (u"詒", ),  # 8BD2 => 8A52
    u"诓" : (u"誆", ),  # 8BD3 => 8A86
    u"诔" : (u"誄", ),  # 8BD4 => 8A84
    u"试" : (u"試", ),  # 8BD5 => 8A66
    u"诖" : (u"詿", ),  # 8BD6 => 8A7F
    u"诗" : (u"詩", ),  # 8BD7 => 8A69
    u"诘" : (u"詰", ),  # 8BD8 => 8A70
    u"诙" : (u"詼", ),  # 8BD9 => 8A7C
    u"诚" : (u"誠", ),  # 8BDA => 8AA0
    u"诛" : (u"誅", ),  # 8BDB => 8A85
    u"诜" : (u"詵", ),  # 8BDC => 8A75
    u"话" : (u"話", ),  # 8BDD => 8A71
    u"诞" : (u"誕", ),  # 8BDE => 8A95
    u"诟" : (u"詬", ),  # 8BDF => 8A6C
    u"诠" : (u"詮", ),  # 8BE0 => 8A6E
    u"诡" : (u"詭", ),  # 8BE1 => 8A6D
    u"询" : (u"詢", ),  # 8BE2 => 8A62
    u"诣" : (u"詣", ),  # 8BE3 => 8A63
    u"诤" : (u"諍", ),  # 8BE4 => 8ACD
    u"该" : (u"該", ),  # 8BE5 => 8A72
    u"详" : (u"詳", ),  # 8BE6 => 8A73
    u"诧" : (u"詫", ),  # 8BE7 => 8A6B
    u"诨" : (u"諢", ),  # 8BE8 => 8AE2
    u"诩" : (u"詡", ),  # 8BE9 => 8A61
    u"诫" : (u"誡", ),  # 8BEB => 8AA1
    u"诬" : (u"誣", ),  # 8BEC => 8AA3
    u"语" : (u"語", ),  # 8BED => 8A9E
    u"诮" : (u"誚", ),  # 8BEE => 8A9A
    u"误" : (u"誤", ),  # 8BEF => 8AA4
    u"诰" : (u"誥", ),  # 8BF0 => 8AA5
    u"诱" : (u"誘", ),  # 8BF1 => 8A98
    u"诲" : (u"誨", ),  # 8BF2 => 8AA8
    u"诳" : (u"誑", ),  # 8BF3 => 8A91
    u"说" : (u"說", u"説"),  # 8BF4 => 8AAA 8AAC
    u"诵" : (u"誦", ),  # 8BF5 => 8AA6
    u"诶" : (u"誒", ),  # 8BF6 => 8A92
    u"请" : (u"請", ),  # 8BF7 => 8ACB
    u"诸" : (u"諸", ),  # 8BF8 => 8AF8
    u"诹" : (u"諏", ),  # 8BF9 => 8ACF
    u"诺" : (u"諾", ),  # 8BFA => 8AFE
    u"读" : (u"讀", ),  # 8BFB => 8B80
    u"诼" : (u"諑", ),  # 8BFC => 8AD1
    u"诽" : (u"誹", ),  # 8BFD => 8AB9
    u"课" : (u"課", ),  # 8BFE => 8AB2
    u"诿" : (u"諉", ),  # 8BFF => 8AC9
    u"谀" : (u"諛", ),  # 8C00 => 8ADB
    u"谁" : (u"誰", ),  # 8C01 => 8AB0
    u"谂" : (u"諗", ),  # 8C02 => 8AD7
    u"调" : (u"調", ),  # 8C03 => 8ABF
    u"谄" : (u"諂", ),  # 8C04 => 8AC2
    u"谅" : (u"諒", ),  # 8C05 => 8AD2
    u"谆" : (u"諄", ),  # 8C06 => 8AC4
    u"谇" : (u"誶", ),  # 8C07 => 8AB6
    u"谈" : (u"談", ),  # 8C08 => 8AC7
    u"谉" : (u"讅", ),  # 8C09 => 8B85
    u"谊" : (u"誼", ),  # 8C0A => 8ABC
    u"谋" : (u"謀", ),  # 8C0B => 8B00
    u"谌" : (u"諶", ),  # 8C0C => 8AF6
    u"谍" : (u"諜", ),  # 8C0D => 8ADC
    u"谎" : (u"謊", ),  # 8C0E => 8B0A
    u"谏" : (u"諫", ),  # 8C0F => 8AEB
    u"谐" : (u"諧", ),  # 8C10 => 8AE7
    u"谑" : (u"謔", ),  # 8C11 => 8B14
    u"谒" : (u"謁", ),  # 8C12 => 8B01
    u"谓" : (u"謂", ),  # 8C13 => 8B02
    u"谔" : (u"諤", ),  # 8C14 => 8AE4
    u"谕" : (u"諭", ),  # 8C15 => 8AED
    u"谖" : (u"諼", ),  # 8C16 => 8AFC
    u"谗" : (u"讒", ),  # 8C17 => 8B92
    u"谘" : (u"諮", ),  # 8C18 => 8AEE
    u"谙" : (u"諳", ),  # 8C19 => 8AF3
    u"谚" : (u"諺", ),  # 8C1A => 8AFA
    u"谛" : (u"諦", ),  # 8C1B => 8AE6
    u"谜" : (u"謎", ),  # 8C1C => 8B0E
    u"谝" : (u"諞", ),  # 8C1D => 8ADE
    u"谞" : (u"諝", ),  # 8C1E => 8ADD
    u"谟" : (u"謨", ),  # 8C1F => 8B28
    u"谠" : (u"讜", ),  # 8C20 => 8B9C
    u"谡" : (u"謖", ),  # 8C21 => 8B16
    u"谢" : (u"謝", ),  # 8C22 => 8B1D
    u"谣" : (u"謠", u"謡"),  # 8C23 => 8B20 8B21
    u"谤" : (u"謗", ),  # 8C24 => 8B17
    u"谥" : (u"諡", u"謚"),  # 8C25 => 8AE1 8B1A
    u"谦" : (u"謙", ),  # 8C26 => 8B19
    u"谧" : (u"謐", ),  # 8C27 => 8B10
    u"谨" : (u"謹", ),  # 8C28 => 8B39
    u"谩" : (u"謾", ),  # 8C29 => 8B3E
    u"谪" : (u"謫", ),  # 8C2A => 8B2B
    u"谫" : (u"譾", ),  # 8C2B => 8B7E
    u"谬" : (u"謬", ),  # 8C2C => 8B2C
    u"谭" : (u"譚", ),  # 8C2D => 8B5A
    u"谮" : (u"譖", ),  # 8C2E => 8B56
    u"谯" : (u"譙", ),  # 8C2F => 8B59
    u"谰" : (u"讕", ),  # 8C30 => 8B95
    u"谱" : (u"譜", ),  # 8C31 => 8B5C
    u"谲" : (u"譎", ),  # 8C32 => 8B4E
    u"谳" : (u"讞", ),  # 8C33 => 8B9E
    u"谴" : (u"譴", ),  # 8C34 => 8B74
    u"谵" : (u"譫", ),  # 8C35 => 8B6B
    u"谶" : (u"讖", ),  # 8C36 => 8B96
    u"谷" : (u"榖", ),  # 8C37 => 6996
    u"豮" : (u"豶", ),  # 8C6E => 8C76
    u"贝" : (u"貝", ),  # 8D1D => 8C9D
    u"贞" : (u"貞", ),  # 8D1E => 8C9E
    u"负" : (u"負", ),  # 8D1F => 8CA0
    u"贡" : (u"貢", ),  # 8D21 => 8CA2
    u"财" : (u"財", ),  # 8D22 => 8CA1
    u"责" : (u"責", ),  # 8D23 => 8CAC
    u"贤" : (u"賢", ),  # 8D24 => 8CE2
    u"败" : (u"敗", ),  # 8D25 => 6557
    u"账" : (u"賬", ),  # 8D26 => 8CEC
    u"货" : (u"貨", ),  # 8D27 => 8CA8
    u"质" : (u"質", ),  # 8D28 => 8CEA
    u"贩" : (u"販", ),  # 8D29 => 8CA9
    u"贪" : (u"貪", ),  # 8D2A => 8CAA
    u"贫" : (u"貧", ),  # 8D2B => 8CA7
    u"贬" : (u"貶", ),  # 8D2C => 8CB6
    u"购" : (u"購", ),  # 8D2D => 8CFC
    u"贮" : (u"貯", ),  # 8D2E => 8CAF
    u"贯" : (u"貫", ),  # 8D2F => 8CAB
    u"贰" : (u"貳", ),  # 8D30 => 8CB3
    u"贱" : (u"賤", ),  # 8D31 => 8CE4
    u"贲" : (u"賁", ),  # 8D32 => 8CC1
    u"贳" : (u"貰", ),  # 8D33 => 8CB0
    u"贴" : (u"貼", ),  # 8D34 => 8CBC
    u"贵" : (u"貴", ),  # 8D35 => 8CB4
    u"贶" : (u"貺", ),  # 8D36 => 8CBA
    u"贷" : (u"貸", ),  # 8D37 => 8CB8
    u"贸" : (u"貿", ),  # 8D38 => 8CBF
    u"费" : (u"費", ),  # 8D39 => 8CBB
    u"贺" : (u"賀", ),  # 8D3A => 8CC0
    u"贻" : (u"貽", ),  # 8D3B => 8CBD
    u"贼" : (u"賊", ),  # 8D3C => 8CCA
    u"贽" : (u"贄", ),  # 8D3D => 8D04
    u"贾" : (u"賈", ),  # 8D3E => 8CC8
    u"贿" : (u"賄", ),  # 8D3F => 8CC4
    u"赀" : (u"貲", ),  # 8D40 => 8CB2
    u"赁" : (u"賃", ),  # 8D41 => 8CC3
    u"赂" : (u"賂", ),  # 8D42 => 8CC2
    u"赃" : (u"臓", u"贓"),  # 8D43 => 81D3 8D13
    u"资" : (u"資", ),  # 8D44 => 8CC7
    u"赅" : (u"賅", ),  # 8D45 => 8CC5
    u"赆" : (u"贐", ),  # 8D46 => 8D10
    u"赇" : (u"賕", ),  # 8D47 => 8CD5
    u"赈" : (u"賑", ),  # 8D48 => 8CD1
    u"赉" : (u"賚", ),  # 8D49 => 8CDA
    u"赊" : (u"賒", ),  # 8D4A => 8CD2
    u"赋" : (u"賦", ),  # 8D4B => 8CE6
    u"赌" : (u"賭", ),  # 8D4C => 8CED
    u"赍" : (u"賫", u"齎"),  # 8D4D => 8CEB 9F4E
    u"赎" : (u"贖", ),  # 8D4E => 8D16
    u"赏" : (u"賞", ),  # 8D4F => 8CDE
    u"赐" : (u"賜", ),  # 8D50 => 8CDC
    u"赒" : (u"賙", ),  # 8D52 => 8CD9
    u"赓" : (u"賡", ),  # 8D53 => 8CE1
    u"赔" : (u"賠", ),  # 8D54 => 8CE0
    u"赕" : (u"賧", ),  # 8D55 => 8CE7
    u"赖" : (u"賴", ),  # 8D56 => 8CF4
    u"赗" : (u"賵", ),  # 8D57 => 8CF5
    u"赘" : (u"贅", ),  # 8D58 => 8D05
    u"赙" : (u"賻", ),  # 8D59 => 8CFB
    u"赚" : (u"賺", ),  # 8D5A => 8CFA
    u"赛" : (u"賽", ),  # 8D5B => 8CFD
    u"赜" : (u"賾", ),  # 8D5C => 8CFE
    u"赝" : (u"贋", u"贗"),  # 8D5D => 8D0B 8D17
    u"赞" : (u"贊", ),  # 8D5E => 8D0A
    u"赠" : (u"贈", ),  # 8D60 => 8D08
    u"赡" : (u"贍", ),  # 8D61 => 8D0D
    u"赢" : (u"贏", ),  # 8D62 => 8D0F
    u"赣" : (u"贛", ),  # 8D63 => 8D1B
    u"赪" : (u"赬", ),  # 8D6A => 8D6C
    u"赵" : (u"趙", ),  # 8D75 => 8D99
    u"赶" : (u"趕", ),  # 8D76 => 8D95
    u"趋" : (u"趨", ),  # 8D8B => 8DA8
    u"趱" : (u"趲", ),  # 8DB1 => 8DB2
    u"趸" : (u"躉", ),  # 8DB8 => 8E89
    u"跃" : (u"躍", ),  # 8DC3 => 8E8D
    u"跄" : (u"蹌", ),  # 8DC4 => 8E4C
    u"跖" : (u"蹠", ),  # 8DD6 => 8E60
    u"跞" : (u"躒", ),  # 8DDE => 8E92
    u"践" : (u"踐", ),  # 8DF5 => 8E10
    u"跷" : (u"蹺", ),  # 8DF7 => 8E7A
    u"跸" : (u"蹕", ),  # 8DF8 => 8E55
    u"跹" : (u"躚", ),  # 8DF9 => 8E9A
    u"跻" : (u"躋", ),  # 8DFB => 8E8B
    u"踊" : (u"踴", ),  # 8E0A => 8E34
    u"踌" : (u"躊", ),  # 8E0C => 8E8A
    u"踪" : (u"蹤", ),  # 8E2A => 8E64
    u"踬" : (u"躓", ),  # 8E2C => 8E93
    u"踯" : (u"躑", ),  # 8E2F => 8E91
    u"蹑" : (u"躡", ),  # 8E51 => 8EA1
    u"蹒" : (u"蹣", ),  # 8E52 => 8E63
    u"蹰" : (u"躕", ),  # 8E70 => 8E95
    u"蹿" : (u"躥", ),  # 8E7F => 8EA5
    u"躏" : (u"躪", ),  # 8E8F => 8EAA
    u"躜" : (u"躦", ),  # 8E9C => 8EA6
    u"躯" : (u"軀", ),  # 8EAF => 8EC0
    u"车" : (u"車", ),  # 8F66 => 8ECA
    u"轧" : (u"軋", ),  # 8F67 => 8ECB
    u"轨" : (u"軌", ),  # 8F68 => 8ECC
    u"轩" : (u"軒", ),  # 8F69 => 8ED2
    u"轫" : (u"軔", ),  # 8F6B => 8ED4
    u"转" : (u"轉", ),  # 8F6C => 8F49
    u"轭" : (u"軛", ),  # 8F6D => 8EDB
    u"轮" : (u"輪", ),  # 8F6E => 8F2A
    u"软" : (u"軟", ),  # 8F6F => 8EDF
    u"轰" : (u"轟", ),  # 8F70 => 8F5F
    u"轱" : (u"軲", ),  # 8F71 => 8EF2
    u"轲" : (u"軻", ),  # 8F72 => 8EFB
    u"轳" : (u"轤", ),  # 8F73 => 8F64
    u"轴" : (u"軸", ),  # 8F74 => 8EF8
    u"轵" : (u"軹", ),  # 8F75 => 8EF9
    u"轶" : (u"軼", ),  # 8F76 => 8EFC
    u"轷" : (u"軤", ),  # 8F77 => 8EE4
    u"轸" : (u"軫", ),  # 8F78 => 8EEB
    u"轹" : (u"轢", ),  # 8F79 => 8F62
    u"轺" : (u"軺", ),  # 8F7A => 8EFA
    u"轻" : (u"輕", ),  # 8F7B => 8F15
    u"轼" : (u"軾", ),  # 8F7C => 8EFE
    u"载" : (u"載", ),  # 8F7D => 8F09
    u"轾" : (u"輊", ),  # 8F7E => 8F0A
    u"轿" : (u"轎", ),  # 8F7F => 8F4E
    u"辁" : (u"輇", ),  # 8F81 => 8F07
    u"辂" : (u"輅", ),  # 8F82 => 8F05
    u"较" : (u"較", ),  # 8F83 => 8F03
    u"辄" : (u"輒", ),  # 8F84 => 8F12
    u"辅" : (u"輔", ),  # 8F85 => 8F14
    u"辆" : (u"輛", ),  # 8F86 => 8F1B
    u"辇" : (u"輦", ),  # 8F87 => 8F26
    u"辈" : (u"輩", ),  # 8F88 => 8F29
    u"辉" : (u"輝", ),  # 8F89 => 8F1D
    u"辊" : (u"輥", ),  # 8F8A => 8F25
    u"辋" : (u"輞", ),  # 8F8B => 8F1E
    u"辍" : (u"輟", ),  # 8F8D => 8F1F
    u"辎" : (u"輜", ),  # 8F8E => 8F1C
    u"辏" : (u"輳", ),  # 8F8F => 8F33
    u"辐" : (u"輻", ),  # 8F90 => 8F3B
    u"辑" : (u"輯", ),  # 8F91 => 8F2F
    u"输" : (u"輸", ),  # 8F93 => 8F38
    u"辔" : (u"轡", ),  # 8F94 => 8F61
    u"辕" : (u"轅", ),  # 8F95 => 8F45
    u"辖" : (u"轄", ),  # 8F96 => 8F44
    u"辗" : (u"輾", ),  # 8F97 => 8F3E
    u"辘" : (u"轆", ),  # 8F98 => 8F46
    u"辙" : (u"轍", ),  # 8F99 => 8F4D
    u"辚" : (u"轔", ),  # 8F9A => 8F54
    u"辞" : (u"辭", ),  # 8F9E => 8FAD
    u"辟" : (u"闢", ),  # 8F9F => 95E2
    u"辩" : (u"辯", ),  # 8FA9 => 8FAF
    u"辫" : (u"辮", ),  # 8FAB => 8FAE
    u"边" : (u"邊", ),  # 8FB9 => 908A
    u"辽" : (u"遼", ),  # 8FBD => 907C
    u"达" : (u"達", ),  # 8FBE => 9054
    u"迁" : (u"遷", ),  # 8FC1 => 9077
    u"过" : (u"過", ),  # 8FC7 => 904E
    u"迈" : (u"邁", ),  # 8FC8 => 9081
    u"运" : (u"運", ),  # 8FD0 => 904B
    u"还" : (u"還", ),  # 8FD8 => 9084
    u"这" : (u"這", ),  # 8FD9 => 9019
    u"进" : (u"進", ),  # 8FDB => 9032
    u"远" : (u"遠", ),  # 8FDC => 9060
    u"违" : (u"違", ),  # 8FDD => 9055
    u"连" : (u"連", ),  # 8FDE => 9023
    u"迟" : (u"遲", ),  # 8FDF => 9072
    u"迩" : (u"邇", ),  # 8FE9 => 9087
    u"迳" : (u"逕", ),  # 8FF3 => 9015
    u"迹" : (u"跡", ),  # 8FF9 => 8DE1
    u"适" : (u"適", ),  # 9002 => 9069
    u"选" : (u"選", ),  # 9009 => 9078
    u"逊" : (u"遜", ),  # 900A => 905C
    u"递" : (u"遞", ),  # 9012 => 905E
    u"逦" : (u"邐", ),  # 9026 => 9090
    u"逻" : (u"邏", ),  # 903B => 908F
    u"遗" : (u"遺", ),  # 9057 => 907A
    u"遥" : (u"遙", ),  # 9065 => 9059
    u"邓" : (u"鄧", ),  # 9093 => 9127
    u"邝" : (u"鄺", ),  # 909D => 913A
    u"邬" : (u"鄔", ),  # 90AC => 9114
    u"邮" : (u"郵", ),  # 90AE => 90F5
    u"邹" : (u"鄒", ),  # 90B9 => 9112
    u"邺" : (u"鄴", ),  # 90BA => 9134
    u"邻" : (u"鄰", ),  # 90BB => 9130
    u"郁" : (u"鬱", ),  # 90C1 => 9B31
    u"郄" : (u"郤", ),  # 90C4 => 90E4
    u"郏" : (u"郟", ),  # 90CF => 90DF
    u"郐" : (u"鄶", ),  # 90D0 => 9136
    u"郑" : (u"鄭", ),  # 90D1 => 912D
    u"郓" : (u"鄆", ),  # 90D3 => 9106
    u"郦" : (u"酈", ),  # 90E6 => 9148
    u"郧" : (u"鄖", ),  # 90E7 => 9116
    u"郸" : (u"鄲", ),  # 90F8 => 9132
    u"酝" : (u"醖", u"醞"),  # 915D => 9196 919E
    u"酰" : (u"醯", ),  # 9170 => 91AF
    u"酱" : (u"醤", u"醬"),  # 9171 => 91A4 91AC
    u"酽" : (u"釅", ),  # 917D => 91C5
    u"酾" : (u"釃", ),  # 917E => 91C3
    u"酿" : (u"釀", ),  # 917F => 91C0
    u"释" : (u"釋", ),  # 91CA => 91CB
    u"里" : (u"裏", ),  # 91CC => 88CF
    u"鉴" : (u"鑒", ),  # 9274 => 9452
    u"銮" : (u"鑾", ),  # 92AE => 947E
    u"錾" : (u"鏨", ),  # 933E => 93E8
    u"钆" : (u"釓", ),  # 9486 => 91D3
    u"钇" : (u"釔", ),  # 9487 => 91D4
    u"针" : (u"針", ),  # 9488 => 91DD
    u"钉" : (u"釘", ),  # 9489 => 91D8
    u"钊" : (u"釗", ),  # 948A => 91D7
    u"钋" : (u"釙", ),  # 948B => 91D9
    u"钌" : (u"釕", ),  # 948C => 91D5
    u"钍" : (u"釷", ),  # 948D => 91F7
    u"钎" : (u"釺", ),  # 948E => 91FA
    u"钏" : (u"釧", ),  # 948F => 91E7
    u"钐" : (u"釤", ),  # 9490 => 91E4
    u"钒" : (u"釩", ),  # 9492 => 91E9
    u"钓" : (u"釣", ),  # 9493 => 91E3
    u"钔" : (u"鍆", ),  # 9494 => 9346
    u"钕" : (u"釹", ),  # 9495 => 91F9
    u"钖" : (u"鍚", ),  # 9496 => 935A
    u"钗" : (u"釵", ),  # 9497 => 91F5
    u"钘" : (u"鈃", ),  # 9498 => 9203
    u"钙" : (u"鈣", ),  # 9499 => 9223
    u"钚" : (u"鈈", ),  # 949A => 9208
    u"钛" : (u"鈦", ),  # 949B => 9226
    u"钝" : (u"鈍", ),  # 949D => 920D
    u"钞" : (u"鈔", ),  # 949E => 9214
    u"钟" : (u"鐘", ),  # 949F => 9418
    u"钠" : (u"鈉", ),  # 94A0 => 9209
    u"钡" : (u"鋇", ),  # 94A1 => 92C7
    u"钢" : (u"鋼", ),  # 94A2 => 92FC
    u"钣" : (u"鈑", ),  # 94A3 => 9211
    u"钤" : (u"鈐", ),  # 94A4 => 9210
    u"钥" : (u"鑰", ),  # 94A5 => 9470
    u"钦" : (u"欽", ),  # 94A6 => 6B3D
    u"钧" : (u"鈞", ),  # 94A7 => 921E
    u"钨" : (u"鎢", ),  # 94A8 => 93A2
    u"钩" : (u"鈎", u"鉤"),  # 94A9 => 920E 9264
    u"钪" : (u"鈧", ),  # 94AA => 9227
    u"钫" : (u"鈁", ),  # 94AB => 9201
    u"钬" : (u"鈥", ),  # 94AC => 9225
    u"钭" : (u"鈄", ),  # 94AD => 9204
    u"钮" : (u"鈕", ),  # 94AE => 9215
    u"钯" : (u"鈀", ),  # 94AF => 9200
    u"钰" : (u"鈺", ),  # 94B0 => 923A
    u"钱" : (u"錢", ),  # 94B1 => 9322
    u"钲" : (u"鉦", ),  # 94B2 => 9266
    u"钳" : (u"鉗", ),  # 94B3 => 9257
    u"钴" : (u"鈷", ),  # 94B4 => 9237
    u"钵" : (u"缽", u"鉢"),  # 94B5 => 7F3D 9262
    u"钶" : (u"鈳", ),  # 94B6 => 9233
    u"钷" : (u"鉕", ),  # 94B7 => 9255
    u"钸" : (u"鈽", ),  # 94B8 => 923D
    u"钹" : (u"鈸", ),  # 94B9 => 9238
    u"钺" : (u"鉞", ),  # 94BA => 925E
    u"钻" : (u"鑽", ),  # 94BB => 947D
    u"钼" : (u"鉬", ),  # 94BC => 926C
    u"钽" : (u"鉭", ),  # 94BD => 926D
    u"钾" : (u"鉀", ),  # 94BE => 9240
    u"钿" : (u"鈿", ),  # 94BF => 923F
    u"铀" : (u"鈾", ),  # 94C0 => 923E
    u"铁" : (u"鐵", ),  # 94C1 => 9435
    u"铂" : (u"鉑", ),  # 94C2 => 9251
    u"铃" : (u"鈴", ),  # 94C3 => 9234
    u"铄" : (u"鑠", ),  # 94C4 => 9460
    u"铅" : (u"鉛", ),  # 94C5 => 925B
    u"铆" : (u"鉚", ),  # 94C6 => 925A
    u"铈" : (u"鈰", ),  # 94C8 => 9230
    u"铉" : (u"鉉", ),  # 94C9 => 9249
    u"铊" : (u"鉈", ),  # 94CA => 9248
    u"铋" : (u"鉍", ),  # 94CB => 924D
    u"铌" : (u"鈮", ),  # 94CC => 922E
    u"铍" : (u"鈹", ),  # 94CD => 9239
    u"铎" : (u"鐸", ),  # 94CE => 9438
    u"铏" : (u"鉶", ),  # 94CF => 9276
    u"铐" : (u"銬", ),  # 94D0 => 92AC
    u"铑" : (u"銠", ),  # 94D1 => 92A0
    u"铒" : (u"鉺", ),  # 94D2 => 927A
    u"铓" : (u"鋩", ),  # 94D3 => 92E9
    u"铕" : (u"銪", ),  # 94D5 => 92AA
    u"铖" : (u"鋮", ),  # 94D6 => 92EE
    u"铗" : (u"鋏", ),  # 94D7 => 92CF
    u"铘" : (u"鋣", ),  # 94D8 => 92E3
    u"铙" : (u"鐃", ),  # 94D9 => 9403
    u"铛" : (u"鐺", ),  # 94DB => 943A
    u"铜" : (u"銅", ),  # 94DC => 9285
    u"铝" : (u"鋁", ),  # 94DD => 92C1
    u"铞" : (u"銱", ),  # 94DE => 92B1
    u"铟" : (u"銦", ),  # 94DF => 92A6
    u"铠" : (u"鎧", ),  # 94E0 => 93A7
    u"铡" : (u"鍘", ),  # 94E1 => 9358
    u"铢" : (u"銖", ),  # 94E2 => 9296
    u"铣" : (u"銑", ),  # 94E3 => 9291
    u"铤" : (u"鋌", ),  # 94E4 => 92CC
    u"铥" : (u"銩", ),  # 94E5 => 92A9
    u"铧" : (u"鏵", ),  # 94E7 => 93F5
    u"铨" : (u"銓", ),  # 94E8 => 9293
    u"铩" : (u"鎩", ),  # 94E9 => 93A9
    u"铪" : (u"鉿", ),  # 94EA => 927F
    u"铫" : (u"銚", ),  # 94EB => 929A
    u"铬" : (u"鉻", ),  # 94EC => 927B
    u"铭" : (u"銘", ),  # 94ED => 9298
    u"铮" : (u"錚", ),  # 94EE => 931A
    u"铯" : (u"銫", ),  # 94EF => 92AB
    u"铰" : (u"鉸", ),  # 94F0 => 9278
    u"铱" : (u"銥", ),  # 94F1 => 92A5
    u"铲" : (u"鏟", ),  # 94F2 => 93DF
    u"铳" : (u"銃", ),  # 94F3 => 9283
    u"铴" : (u"鐋", ),  # 94F4 => 940B
    u"铵" : (u"銨", ),  # 94F5 => 92A8
    u"银" : (u"銀", ),  # 94F6 => 9280
    u"铷" : (u"銣", ),  # 94F7 => 92A3
    u"铸" : (u"鑄", ),  # 94F8 => 9444
    u"铹" : (u"鐒", ),  # 94F9 => 9412
    u"铺" : (u"鋪", ),  # 94FA => 92EA
    u"铼" : (u"錸", ),  # 94FC => 9338
    u"铽" : (u"鋱", ),  # 94FD => 92F1
    u"链" : (u"鏈", ),  # 94FE => 93C8
    u"铿" : (u"鏗", ),  # 94FF => 93D7
    u"销" : (u"銷", ),  # 9500 => 92B7
    u"锁" : (u"鎖", ),  # 9501 => 9396
    u"锂" : (u"鋰", ),  # 9502 => 92F0
    u"锃" : (u"鋥", ),  # 9503 => 92E5
    u"锄" : (u"鋤", ),  # 9504 => 92E4
    u"锅" : (u"鍋", ),  # 9505 => 934B
    u"锆" : (u"鋯", ),  # 9506 => 92EF
    u"锇" : (u"鋨", ),  # 9507 => 92E8
    u"锈" : (u"銹", u"鏽"),  # 9508 => 92B9 93FD
    u"锉" : (u"銼", ),  # 9509 => 92BC
    u"锊" : (u"鋝", ),  # 950A => 92DD
    u"锋" : (u"鋒", ),  # 950B => 92D2
    u"锌" : (u"鋅", ),  # 950C => 92C5
    u"锍" : (u"鋶", ),  # 950D => 92F6
    u"锎" : (u"鉲", u"鐦"),  # 950E => 9272 9426
    u"锏" : (u"鐧", ),  # 950F => 9427
    u"锐" : (u"銳", u"鋭"),  # 9510 => 92B3 92ED
    u"锑" : (u"銻", ),  # 9511 => 92BB
    u"锒" : (u"鋃", ),  # 9512 => 92C3
    u"锓" : (u"鋟", ),  # 9513 => 92DF
    u"锔" : (u"鋦", ),  # 9514 => 92E6
    u"锕" : (u"錒", ),  # 9515 => 9312
    u"锖" : (u"錆", ),  # 9516 => 9306
    u"锗" : (u"鍺", ),  # 9517 => 937A
    u"锘" : (u"鍩", ),  # 9518 => 9369
    u"错" : (u"錯", ),  # 9519 => 932F
    u"锚" : (u"錨", ),  # 951A => 9328
    u"锛" : (u"錛", ),  # 951B => 931B
    u"锝" : (u"鍀", ),  # 951D => 9340
    u"锞" : (u"錁", ),  # 951E => 9301
    u"锟" : (u"錕", ),  # 951F => 9315
    u"锡" : (u"錫", ),  # 9521 => 932B
    u"锢" : (u"錮", ),  # 9522 => 932E
    u"锣" : (u"鑼", ),  # 9523 => 947C
    u"锤" : (u"錘", ),  # 9524 => 9318
    u"锥" : (u"錐", ),  # 9525 => 9310
    u"锦" : (u"錦", ),  # 9526 => 9326
    u"锧" : (u"鑕", ),  # 9527 => 9455
    u"锨" : (u"鍁", ),  # 9528 => 9341
    u"锩" : (u"錈", ),  # 9529 => 9308
    u"锪" : (u"鍃", ),  # 952A => 9343
    u"锫" : (u"錇", ),  # 952B => 9307
    u"锬" : (u"錟", ),  # 952C => 931F
    u"锭" : (u"錠", ),  # 952D => 9320
    u"键" : (u"鍵", ),  # 952E => 9375
    u"锯" : (u"鋸", ),  # 952F => 92F8
    u"锰" : (u"錳", ),  # 9530 => 9333
    u"锱" : (u"錙", ),  # 9531 => 9319
    u"锲" : (u"鍥", ),  # 9532 => 9365
    u"锴" : (u"鍇", ),  # 9534 => 9347
    u"锵" : (u"鏘", ),  # 9535 => 93D8
    u"锶" : (u"鍶", ),  # 9536 => 9376
    u"锷" : (u"鍔", ),  # 9537 => 9354
    u"锸" : (u"鍤", ),  # 9538 => 9364
    u"锹" : (u"鍬", ),  # 9539 => 936C
    u"锺" : (u"鍾", ),  # 953A => 937E
    u"锻" : (u"鍛", ),  # 953B => 935B
    u"锼" : (u"鎪", ),  # 953C => 93AA
    u"锾" : (u"鍰", ),  # 953E => 9370
    u"锿" : (u"鎄", ),  # 953F => 9384
    u"镀" : (u"鍍", ),  # 9540 => 934D
    u"镁" : (u"鎂", ),  # 9541 => 9382
    u"镂" : (u"鏤", ),  # 9542 => 93E4
    u"镃" : (u"鎡", ),  # 9543 => 93A1
    u"镄" : (u"鐨", ),  # 9544 => 9428
    u"镅" : (u"鋂", u"鎇"),  # 9545 => 92C2 9387
    u"镆" : (u"鏌", ),  # 9546 => 93CC
    u"镇" : (u"鎮", ),  # 9547 => 93AE
    u"镉" : (u"鎘", ),  # 9549 => 9398
    u"镊" : (u"鑷", ),  # 954A => 9477
    u"镋" : (u"钂", ),  # 954B => 9482
    u"镌" : (u"鎸", u"鐫"),  # 954C => 93B8 942B
    u"镍" : (u"鎳", ),  # 954D => 93B3
    u"镎" : (u"錼", u"鎿"),  # 954E => 933C 93BF
    u"镏" : (u"鎦", ),  # 954F => 93A6
    u"镐" : (u"鎬", ),  # 9550 => 93AC
    u"镑" : (u"鎊", ),  # 9551 => 938A
    u"镒" : (u"鎰", ),  # 9552 => 93B0
    u"镓" : (u"鎵", ),  # 9553 => 93B5
    u"镔" : (u"鑌", ),  # 9554 => 944C
    u"镖" : (u"鏢", ),  # 9556 => 93E2
    u"镗" : (u"鏜", ),  # 9557 => 93DC
    u"镘" : (u"鏝", ),  # 9558 => 93DD
    u"镙" : (u"鏍", ),  # 9559 => 93CD
    u"镚" : (u"鏰", ),  # 955A => 93F0
    u"镛" : (u"鏞", ),  # 955B => 93DE
    u"镜" : (u"鏡", ),  # 955C => 93E1
    u"镝" : (u"鏑", ),  # 955D => 93D1
    u"镞" : (u"鏃", ),  # 955E => 93C3
    u"镟" : (u"鏇", ),  # 955F => 93C7
    u"镡" : (u"鐔", ),  # 9561 => 9414
    u"镢" : (u"鐝", u"钁"),  # 9562 => 941D 9481
    u"镣" : (u"鐐", ),  # 9563 => 9410
    u"镤" : (u"鏷", ),  # 9564 => 93F7
    u"镥" : (u"鑥", ),  # 9565 => 9465
    u"镦" : (u"鐓", ),  # 9566 => 9413
    u"镧" : (u"鑭", ),  # 9567 => 946D
    u"镨" : (u"鐠", ),  # 9568 => 9420
    u"镩" : (u"鑹", ),  # 9569 => 9479
    u"镪" : (u"鏹", ),  # 956A => 93F9
    u"镫" : (u"鐙", ),  # 956B => 9419
    u"镬" : (u"鑊", ),  # 956C => 944A
    u"镭" : (u"鐳", ),  # 956D => 9433
    u"镮" : (u"鐶", ),  # 956E => 9436
    u"镯" : (u"鐲", ),  # 956F => 9432
    u"镰" : (u"鐮", ),  # 9570 => 942E
    u"镱" : (u"鐿", ),  # 9571 => 943F
    u"镲" : (u"鑔", ),  # 9572 => 9454
    u"镳" : (u"鑣", ),  # 9573 => 9463
    u"镴" : (u"鑞", ),  # 9574 => 945E
    u"镶" : (u"鑲", ),  # 9576 => 9472
    u"长" : (u"長", ),  # 957F => 9577
    u"门" : (u"門", ),  # 95E8 => 9580
    u"闩" : (u"閂", ),  # 95E9 => 9582
    u"闪" : (u"閃", ),  # 95EA => 9583
    u"闫" : (u"閆", ),  # 95EB => 9586
    u"闭" : (u"閉", ),  # 95ED => 9589
    u"问" : (u"問", ),  # 95EE => 554F
    u"闯" : (u"闖", ),  # 95EF => 95D6
    u"闰" : (u"閏", ),  # 95F0 => 958F
    u"闱" : (u"闈", ),  # 95F1 => 95C8
    u"闲" : (u"閑", ),  # 95F2 => 9591
    u"闳" : (u"閎", ),  # 95F3 => 958E
    u"间" : (u"間", ),  # 95F4 => 9593
    u"闵" : (u"閔", ),  # 95F5 => 9594
    u"闶" : (u"閌", ),  # 95F6 => 958C
    u"闷" : (u"悶", ),  # 95F7 => 60B6
    u"闸" : (u"閘", ),  # 95F8 => 9598
    u"闹" : (u"閙", u"鬧"),  # 95F9 => 9599 9B27
    u"闺" : (u"閨", ),  # 95FA => 95A8
    u"闻" : (u"聞", ),  # 95FB => 805E
    u"闼" : (u"闥", ),  # 95FC => 95E5
    u"闽" : (u"閩", ),  # 95FD => 95A9
    u"闾" : (u"閭", ),  # 95FE => 95AD
    u"闿" : (u"闓", ),  # 95FF => 95D3
    u"阀" : (u"閥", ),  # 9600 => 95A5
    u"阁" : (u"閣", ),  # 9601 => 95A3
    u"阂" : (u"閡", ),  # 9602 => 95A1
    u"阃" : (u"閫", ),  # 9603 => 95AB
    u"阄" : (u"鬮", ),  # 9604 => 9B2E
    u"阅" : (u"閱", u"閲"),  # 9605 => 95B1 95B2
    u"阆" : (u"閬", ),  # 9606 => 95AC
    u"阈" : (u"閾", ),  # 9608 => 95BE
    u"阉" : (u"閹", ),  # 9609 => 95B9
    u"阊" : (u"閶", ),  # 960A => 95B6
    u"阋" : (u"鬩", ),  # 960B => 9B29
    u"阌" : (u"閿", ),  # 960C => 95BF
    u"阍" : (u"閽", ),  # 960D => 95BD
    u"阎" : (u"閻", ),  # 960E => 95BB
    u"阏" : (u"閼", ),  # 960F => 95BC
    u"阐" : (u"闡", ),  # 9610 => 95E1
    u"阑" : (u"闌", ),  # 9611 => 95CC
    u"阒" : (u"闃", ),  # 9612 => 95C3
    u"阔" : (u"闊", ),  # 9614 => 95CA
    u"阕" : (u"闋", ),  # 9615 => 95CB
    u"阖" : (u"闔", ),  # 9616 => 95D4
    u"阗" : (u"闐", ),  # 9617 => 95D0
    u"阙" : (u"闕", ),  # 9619 => 95D5
    u"阚" : (u"闞", ),  # 961A => 95DE
    u"队" : (u"隊", ),  # 961F => 968A
    u"阳" : (u"陽", ),  # 9633 => 967D
    u"阴" : (u"陰", ),  # 9634 => 9670
    u"阵" : (u"陣", ),  # 9635 => 9663
    u"阶" : (u"階", ),  # 9636 => 968E
    u"际" : (u"際", ),  # 9645 => 969B
    u"陆" : (u"陸", ),  # 9646 => 9678
    u"陇" : (u"隴", ),  # 9647 => 96B4
    u"陈" : (u"陳", ),  # 9648 => 9673
    u"陉" : (u"陘", ),  # 9649 => 9658
    u"陕" : (u"陝", ),  # 9655 => 965D
    u"陧" : (u"隉", ),  # 9667 => 9689
    u"陨" : (u"隕", ),  # 9668 => 9695
    u"险" : (u"險", ),  # 9669 => 96AA
    u"随" : (u"隨", ),  # 968F => 96A8
    u"隐" : (u"隱", ),  # 9690 => 96B1
    u"隶" : (u"隷", u"隸"),  # 96B6 => 96B7 96B8
    u"隽" : (u"雋", ),  # 96BD => 96CB
    u"难" : (u"難", ),  # 96BE => 96E3
    u"雏" : (u"雛", ),  # 96CF => 96DB
    u"雠" : (u"讎", ),  # 96E0 => 8B8E
    u"雳" : (u"靂", ),  # 96F3 => 9742
    u"雾" : (u"霧", ),  # 96FE => 9727
    u"霁" : (u"霽", ),  # 9701 => 973D
    u"霉" : (u"黴", ),  # 9709 => 9EF4
    u"霭" : (u"靄", ),  # 972D => 9744
    u"靓" : (u"靚", ),  # 9753 => 975A
    u"静" : (u"靜", ),  # 9759 => 975C
    u"面" : (u"麵", ),  # 9762 => 9EB5
    u"靥" : (u"靨", ),  # 9765 => 9768
    u"鞑" : (u"韃", ),  # 9791 => 97C3
    u"鞒" : (u"鞽", ),  # 9792 => 97BD
    u"鞯" : (u"韉", ),  # 97AF => 97C9
    u"鞴" : (u"韝", ),  # 97B4 => 97DD
    u"韦" : (u"韋", ),  # 97E6 => 97CB
    u"韧" : (u"韌", ),  # 97E7 => 97CC
    u"韨" : (u"韍", ),  # 97E8 => 97CD
    u"韩" : (u"韓", ),  # 97E9 => 97D3
    u"韪" : (u"韙", ),  # 97EA => 97D9
    u"韫" : (u"韞", ),  # 97EB => 97DE
    u"韬" : (u"韜", ),  # 97EC => 97DC
    u"韵" : (u"韻", ),  # 97F5 => 97FB
    u"页" : (u"頁", ),  # 9875 => 9801
    u"顶" : (u"頂", ),  # 9876 => 9802
    u"顷" : (u"頃", ),  # 9877 => 9803
    u"顸" : (u"頇", ),  # 9878 => 9807
    u"项" : (u"項", ),  # 9879 => 9805
    u"顺" : (u"順", ),  # 987A => 9806
    u"须" : (u"須", u"鬚"),  # 987B => 9808 9B1A
    u"顼" : (u"頊", ),  # 987C => 980A
    u"顽" : (u"頑", ),  # 987D => 9811
    u"顾" : (u"顧", ),  # 987E => 9867
    u"顿" : (u"頓", ),  # 987F => 9813
    u"颀" : (u"頎", ),  # 9880 => 980E
    u"颁" : (u"頒", ),  # 9881 => 9812
    u"颂" : (u"頌", ),  # 9882 => 980C
    u"颃" : (u"頏", ),  # 9883 => 980F
    u"预" : (u"預", ),  # 9884 => 9810
    u"颅" : (u"顱", ),  # 9885 => 9871
    u"领" : (u"領", ),  # 9886 => 9818
    u"颇" : (u"頗", ),  # 9887 => 9817
    u"颈" : (u"頸", ),  # 9888 => 9838
    u"颉" : (u"頡", ),  # 9889 => 9821
    u"颊" : (u"頰", ),  # 988A => 9830
    u"颋" : (u"頲", ),  # 988B => 9832
    u"颌" : (u"頜", ),  # 988C => 981C
    u"颍" : (u"潁", ),  # 988D => 6F41
    u"颏" : (u"頦", ),  # 988F => 9826
    u"颐" : (u"頤", ),  # 9890 => 9824
    u"频" : (u"頻", ),  # 9891 => 983B
    u"颓" : (u"頹", u"頽"),  # 9893 => 9839 983D
    u"颔" : (u"頷", ),  # 9894 => 9837
    u"颖" : (u"穎", ),  # 9896 => 7A4E
    u"颗" : (u"顆", ),  # 9897 => 9846
    u"题" : (u"題", ),  # 9898 => 984C
    u"颙" : (u"顒", ),  # 9899 => 9852
    u"颚" : (u"顎", ),  # 989A => 984E
    u"颛" : (u"顓", ),  # 989B => 9853
    u"颜" : (u"顏", u"顔"),  # 989C => 984F 9854
    u"额" : (u"額", ),  # 989D => 984D
    u"颞" : (u"顳", ),  # 989E => 9873
    u"颟" : (u"顢", ),  # 989F => 9862
    u"颠" : (u"顛", ),  # 98A0 => 985B
    u"颡" : (u"顙", ),  # 98A1 => 9859
    u"颢" : (u"顥", ),  # 98A2 => 9865
    u"颤" : (u"顫", ),  # 98A4 => 986B
    u"颥" : (u"顬", ),  # 98A5 => 986C
    u"颦" : (u"顰", ),  # 98A6 => 9870
    u"颧" : (u"顴", ),  # 98A7 => 9874
    u"风" : (u"風", ),  # 98CE => 98A8
    u"飑" : (u"颮", ),  # 98D1 => 98AE
    u"飒" : (u"颯", ),  # 98D2 => 98AF
    u"飓" : (u"颶", ),  # 98D3 => 98B6
    u"飔" : (u"颸", ),  # 98D4 => 98B8
    u"飕" : (u"颼", ),  # 98D5 => 98BC
    u"飗" : (u"飀", ),  # 98D7 => 98C0
    u"飘" : (u"飄", ),  # 98D8 => 98C4
    u"飙" : (u"飆", ),  # 98D9 => 98C6
    u"飚" : (u"飆", ),  # 98DA => 98C6
    u"飞" : (u"飛", ),  # 98DE => 98DB
    u"飨" : (u"饗", ),  # 98E8 => 9957
    u"餍" : (u"饜", ),  # 990D => 995C
    u"饥" : (u"饑", ),  # 9965 => 9951
    u"饦" : (u"飥", ),  # 9966 => 98E5
    u"饧" : (u"餳", ),  # 9967 => 9933
    u"饨" : (u"飩", ),  # 9968 => 98E9
    u"饩" : (u"餼", ),  # 9969 => 993C
    u"饪" : (u"飪", ),  # 996A => 98EA
    u"饫" : (u"飫", ),  # 996B => 98EB
    u"饬" : (u"飭", ),  # 996C => 98ED
    u"饭" : (u"飯", ),  # 996D => 98EF
    u"饮" : (u"飲", ),  # 996E => 98F2
    u"饯" : (u"餞", ),  # 996F => 991E
    u"饰" : (u"飾", ),  # 9970 => 98FE
    u"饱" : (u"飽", ),  # 9971 => 98FD
    u"饲" : (u"飼", ),  # 9972 => 98FC
    u"饳" : (u"飿", ),  # 9973 => 98FF
    u"饴" : (u"飴", ),  # 9974 => 98F4
    u"饵" : (u"餌", ),  # 9975 => 990C
    u"饶" : (u"饒", ),  # 9976 => 9952
    u"饷" : (u"餉", ),  # 9977 => 9909
    u"饸" : (u"餄", ),  # 9978 => 9904
    u"饹" : (u"餎", ),  # 9979 => 990E
    u"饺" : (u"餃", ),  # 997A => 9903
    u"饻" : (u"餏", ),  # 997B => 990F
    u"饼" : (u"餅", u"餠"),  # 997C => 9905 9920
    u"饽" : (u"餑", ),  # 997D => 9911
    u"饿" : (u"餓", ),  # 997F => 9913
    u"馀" : (u"餘", ),  # 9980 => 9918
    u"馁" : (u"餒", ),  # 9981 => 9912
    u"馃" : (u"餜", ),  # 9983 => 991C
    u"馄" : (u"餛", ),  # 9984 => 991B
    u"馅" : (u"餡", ),  # 9985 => 9921
    u"馆" : (u"館", ),  # 9986 => 9928
    u"馇" : (u"餷", ),  # 9987 => 9937
    u"馈" : (u"饋", ),  # 9988 => 994B
    u"馉" : (u"餶", ),  # 9989 => 9936
    u"馊" : (u"餿", ),  # 998A => 993F
    u"馋" : (u"饞", ),  # 998B => 995E
    u"馍" : (u"饃", ),  # 998D => 9943
    u"馎" : (u"餺", ),  # 998E => 993A
    u"馏" : (u"餾", ),  # 998F => 993E
    u"馐" : (u"饈", ),  # 9990 => 9948
    u"馑" : (u"饉", ),  # 9991 => 9949
    u"馒" : (u"饅", ),  # 9992 => 9945
    u"馓" : (u"饊", ),  # 9993 => 994A
    u"馔" : (u"饌", ),  # 9994 => 994C
    u"馕" : (u"饟", u"饢"),  # 9995 => 995F 9962
    u"马" : (u"馬", ),  # 9A6C => 99AC
    u"驭" : (u"馭", ),  # 9A6D => 99AD
    u"驮" : (u"馱", ),  # 9A6E => 99B1
    u"驯" : (u"馴", ),  # 9A6F => 99B4
    u"驰" : (u"馳", ),  # 9A70 => 99B3
    u"驱" : (u"驅", ),  # 9A71 => 9A45
    u"驳" : (u"駁", ),  # 9A73 => 99C1
    u"驴" : (u"驢", ),  # 9A74 => 9A62
    u"驵" : (u"駔", ),  # 9A75 => 99D4
    u"驶" : (u"駛", ),  # 9A76 => 99DB
    u"驷" : (u"駟", ),  # 9A77 => 99DF
    u"驸" : (u"駙", ),  # 9A78 => 99D9
    u"驹" : (u"駒", ),  # 9A79 => 99D2
    u"驺" : (u"騶", ),  # 9A7A => 9A36
    u"驻" : (u"駐", ),  # 9A7B => 99D0
    u"驼" : (u"駝", ),  # 9A7C => 99DD
    u"驽" : (u"駑", ),  # 9A7D => 99D1
    u"驾" : (u"駕", ),  # 9A7E => 99D5
    u"驿" : (u"驛", ),  # 9A7F => 9A5B
    u"骀" : (u"駘", ),  # 9A80 => 99D8
    u"骁" : (u"驍", ),  # 9A81 => 9A4D
    u"骂" : (u"罵", u"駡"),  # 9A82 => 7F75 99E1
    u"骄" : (u"驕", ),  # 9A84 => 9A55
    u"骅" : (u"驊", ),  # 9A85 => 9A4A
    u"骆" : (u"駱", ),  # 9A86 => 99F1
    u"骇" : (u"駭", ),  # 9A87 => 99ED
    u"骈" : (u"駢", ),  # 9A88 => 99E2
    u"骊" : (u"驪", ),  # 9A8A => 9A6A
    u"骋" : (u"騁", ),  # 9A8B => 9A01
    u"验" : (u"驗", ),  # 9A8C => 9A57
    u"骎" : (u"駸", ),  # 9A8E => 99F8
    u"骏" : (u"駿", ),  # 9A8F => 99FF
    u"骐" : (u"騏", ),  # 9A90 => 9A0F
    u"骑" : (u"騎", ),  # 9A91 => 9A0E
    u"骒" : (u"騍", ),  # 9A92 => 9A0D
    u"骓" : (u"騅", ),  # 9A93 => 9A05
    u"骖" : (u"驂", ),  # 9A96 => 9A42
    u"骗" : (u"騙", ),  # 9A97 => 9A19
    u"骘" : (u"騭", ),  # 9A98 => 9A2D
    u"骚" : (u"騷", ),  # 9A9A => 9A37
    u"骛" : (u"騖", ),  # 9A9B => 9A16
    u"骜" : (u"驁", ),  # 9A9C => 9A41
    u"骝" : (u"騮", ),  # 9A9D => 9A2E
    u"骞" : (u"騫", ),  # 9A9E => 9A2B
    u"骟" : (u"騸", ),  # 9A9F => 9A38
    u"骠" : (u"驃", ),  # 9AA0 => 9A43
    u"骡" : (u"騾", ),  # 9AA1 => 9A3E
    u"骢" : (u"驄", ),  # 9AA2 => 9A44
    u"骣" : (u"驏", ),  # 9AA3 => 9A4F
    u"骤" : (u"驟", ),  # 9AA4 => 9A5F
    u"骥" : (u"驥", ),  # 9AA5 => 9A65
    u"骧" : (u"驤", ),  # 9AA7 => 9A64
    u"髅" : (u"髏", ),  # 9AC5 => 9ACF
    u"髋" : (u"髖", ),  # 9ACB => 9AD6
    u"髌" : (u"髕", ),  # 9ACC => 9AD5
    u"鬓" : (u"鬢", ),  # 9B13 => 9B22
    u"魇" : (u"魘", ),  # 9B47 => 9B58
    u"魉" : (u"魎", ),  # 9B49 => 9B4E
    u"鱼" : (u"魚", ),  # 9C7C => 9B5A
    u"鱽" : (u"魛", ),  # 9C7D => 9B5B
    u"鱿" : (u"魷", ),  # 9C7F => 9B77
    u"鲁" : (u"魯", ),  # 9C81 => 9B6F
    u"鲂" : (u"魴", ),  # 9C82 => 9B74
    u"鲅" : (u"鮁", ),  # 9C85 => 9B81
    u"鲆" : (u"鮃", ),  # 9C86 => 9B83
    u"鲇" : (u"鯰", ),  # 9C87 => 9BF0
    u"鲈" : (u"鱸", ),  # 9C88 => 9C78
    u"鲊" : (u"鮓", ),  # 9C8A => 9B93
    u"鲋" : (u"鮒", ),  # 9C8B => 9B92
    u"鲍" : (u"鮑", ),  # 9C8D => 9B91
    u"鲎" : (u"鱟", ),  # 9C8E => 9C5F
    u"鲏" : (u"鮍", ),  # 9C8F => 9B8D
    u"鲐" : (u"鮐", ),  # 9C90 => 9B90
    u"鲑" : (u"鮭", ),  # 9C91 => 9BAD
    u"鲒" : (u"鮚", ),  # 9C92 => 9B9A
    u"鲔" : (u"鮪", ),  # 9C94 => 9BAA
    u"鲕" : (u"鮞", ),  # 9C95 => 9B9E
    u"鲖" : (u"鮦", ),  # 9C96 => 9BA6
    u"鲗" : (u"鰂", ),  # 9C97 => 9C02
    u"鲙" : (u"鱠", ),  # 9C99 => 9C60
    u"鲚" : (u"鱭", ),  # 9C9A => 9C6D
    u"鲛" : (u"鮫", ),  # 9C9B => 9BAB
    u"鲜" : (u"鮮", ),  # 9C9C => 9BAE
    u"鲝" : (u"鮺", ),  # 9C9D => 9BBA
    u"鲞" : (u"鯗", ),  # 9C9E => 9BD7
    u"鲟" : (u"鱘", ),  # 9C9F => 9C58
    u"鲠" : (u"鯁", ),  # 9CA0 => 9BC1
    u"鲡" : (u"鱺", ),  # 9CA1 => 9C7A
    u"鲢" : (u"鰱", ),  # 9CA2 => 9C31
    u"鲣" : (u"鰹", ),  # 9CA3 => 9C39
    u"鲤" : (u"鯉", ),  # 9CA4 => 9BC9
    u"鲥" : (u"鰣", ),  # 9CA5 => 9C23
    u"鲦" : (u"鰷", ),  # 9CA6 => 9C37
    u"鲧" : (u"鯀", ),  # 9CA7 => 9BC0
    u"鲨" : (u"鯊", ),  # 9CA8 => 9BCA
    u"鲩" : (u"鯇", ),  # 9CA9 => 9BC7
    u"鲫" : (u"鯽", ),  # 9CAB => 9BFD
    u"鲭" : (u"鯖", ),  # 9CAD => 9BD6
    u"鲮" : (u"鯪", ),  # 9CAE => 9BEA
    u"鲰" : (u"鯫", ),  # 9CB0 => 9BEB
    u"鲱" : (u"鯡", ),  # 9CB1 => 9BE1
    u"鲲" : (u"鯤", ),  # 9CB2 => 9BE4
    u"鲳" : (u"鯧", ),  # 9CB3 => 9BE7
    u"鲴" : (u"鯝", ),  # 9CB4 => 9BDD
    u"鲵" : (u"鯢", ),  # 9CB5 => 9BE2
    u"鲶" : (u"鯰", ),  # 9CB6 => 9BF0
    u"鲷" : (u"鯛", ),  # 9CB7 => 9BDB
    u"鲸" : (u"鯨", ),  # 9CB8 => 9BE8
    u"鲺" : (u"鯴", ),  # 9CBA => 9BF4
    u"鲻" : (u"鯔", ),  # 9CBB => 9BD4
    u"鲼" : (u"鱝", ),  # 9CBC => 9C5D
    u"鲽" : (u"鰈", ),  # 9CBD => 9C08
    u"鲿" : (u"鱨", ),  # 9CBF => 9C68
    u"鳁" : (u"鰛", ),  # 9CC1 => 9C1B
    u"鳃" : (u"鰓", ),  # 9CC3 => 9C13
    u"鳄" : (u"鰐", u"鱷"),  # 9CC4 => 9C10 9C77
    u"鳅" : (u"鰍", ),  # 9CC5 => 9C0D
    u"鳆" : (u"鰒", ),  # 9CC6 => 9C12
    u"鳇" : (u"鰉", ),  # 9CC7 => 9C09
    u"鳊" : (u"鯿", ),  # 9CCA => 9BFF
    u"鳋" : (u"鰠", ),  # 9CCB => 9C20
    u"鳌" : (u"鰲", u"鼇"),  # 9CCC => 9C32 9F07
    u"鳍" : (u"鰭", ),  # 9CCD => 9C2D
    u"鳎" : (u"鰨", ),  # 9CCE => 9C28
    u"鳏" : (u"鰥", ),  # 9CCF => 9C25
    u"鳐" : (u"鰩", ),  # 9CD0 => 9C29
    u"鳑" : (u"鰟", ),  # 9CD1 => 9C1F
    u"鳒" : (u"鰜", ),  # 9CD2 => 9C1C
    u"鳓" : (u"鰳", ),  # 9CD3 => 9C33
    u"鳔" : (u"鰾", ),  # 9CD4 => 9C3E
    u"鳕" : (u"鱈", ),  # 9CD5 => 9C48
    u"鳖" : (u"鱉", ),  # 9CD6 => 9C49
    u"鳗" : (u"鰻", ),  # 9CD7 => 9C3B
    u"鳘" : (u"鰵", ),  # 9CD8 => 9C35
    u"鳙" : (u"鱅", ),  # 9CD9 => 9C45
    u"鳛" : (u"鰼", ),  # 9CDB => 9C3C
    u"鳜" : (u"鱖", ),  # 9CDC => 9C56
    u"鳝" : (u"鱔", ),  # 9CDD => 9C54
    u"鳞" : (u"鱗", ),  # 9CDE => 9C57
    u"鳟" : (u"鱒", ),  # 9CDF => 9C52
    u"鳢" : (u"鱧", ),  # 9CE2 => 9C67
    u"鳣" : (u"鱣", ),  # 9CE3 => 9C63
    u"鸟" : (u"鳥", ),  # 9E1F => 9CE5
    u"鸠" : (u"鳩", ),  # 9E20 => 9CE9
    u"鸡" : (u"雞", u"鷄"),  # 9E21 => 96DE 9DC4
    u"鸢" : (u"鳶", ),  # 9E22 => 9CF6
    u"鸣" : (u"鳴", ),  # 9E23 => 9CF4
    u"鸥" : (u"鷗", ),  # 9E25 => 9DD7
    u"鸦" : (u"鴉", ),  # 9E26 => 9D09
    u"鸧" : (u"鶬", ),  # 9E27 => 9DAC
    u"鸨" : (u"鴇", ),  # 9E28 => 9D07
    u"鸩" : (u"鴆", ),  # 9E29 => 9D06
    u"鸪" : (u"鴣", ),  # 9E2A => 9D23
    u"鸫" : (u"鶇", ),  # 9E2B => 9D87
    u"鸬" : (u"鸕", ),  # 9E2C => 9E15
    u"鸭" : (u"鴨", ),  # 9E2D => 9D28
    u"鸮" : (u"鴞", ),  # 9E2E => 9D1E
    u"鸯" : (u"鴦", ),  # 9E2F => 9D26
    u"鸰" : (u"鴒", ),  # 9E30 => 9D12
    u"鸱" : (u"鴟", ),  # 9E31 => 9D1F
    u"鸲" : (u"鴝", ),  # 9E32 => 9D1D
    u"鸳" : (u"鴛", ),  # 9E33 => 9D1B
    u"鸵" : (u"鴕", ),  # 9E35 => 9D15
    u"鸶" : (u"鷥", ),  # 9E36 => 9DE5
    u"鸷" : (u"鷙", ),  # 9E37 => 9DD9
    u"鸸" : (u"鴯", ),  # 9E38 => 9D2F
    u"鸹" : (u"鴰", ),  # 9E39 => 9D30
    u"鸺" : (u"鵂", ),  # 9E3A => 9D42
    u"鸻" : (u"鴴", ),  # 9E3B => 9D34
    u"鸼" : (u"鵃", ),  # 9E3C => 9D43
    u"鸽" : (u"鴿", ),  # 9E3D => 9D3F
    u"鸾" : (u"鵉", u"鸞"),  # 9E3E => 9D49 9E1E
    u"鸿" : (u"鴻", ),  # 9E3F => 9D3B
    u"鹁" : (u"鵓", ),  # 9E41 => 9D53
    u"鹂" : (u"鸝", ),  # 9E42 => 9E1D
    u"鹃" : (u"鵑", ),  # 9E43 => 9D51
    u"鹄" : (u"鵠", ),  # 9E44 => 9D60
    u"鹅" : (u"鵝", ),  # 9E45 => 9D5D
    u"鹆" : (u"鵒", ),  # 9E46 => 9D52
    u"鹇" : (u"鷳", ),  # 9E47 => 9DF3
    u"鹈" : (u"鵜", ),  # 9E48 => 9D5C
    u"鹉" : (u"鵡", ),  # 9E49 => 9D61
    u"鹊" : (u"鵲", ),  # 9E4A => 9D72
    u"鹋" : (u"鶓", ),  # 9E4B => 9D93
    u"鹌" : (u"鵪", ),  # 9E4C => 9D6A
    u"鹎" : (u"鵯", ),  # 9E4E => 9D6F
    u"鹏" : (u"鵬", ),  # 9E4F => 9D6C
    u"鹐" : (u"鵮", ),  # 9E50 => 9D6E
    u"鹑" : (u"鶉", ),  # 9E51 => 9D89
    u"鹒" : (u"鶊", ),  # 9E52 => 9D8A
    u"鹕" : (u"鶘", ),  # 9E55 => 9D98
    u"鹖" : (u"鶡", ),  # 9E56 => 9DA1
    u"鹗" : (u"鶚", ),  # 9E57 => 9D9A
    u"鹘" : (u"鶻", ),  # 9E58 => 9DBB
    u"鹙" : (u"鶖", ),  # 9E59 => 9D96
    u"鹚" : (u"鶿", u"鷀"),  # 9E5A => 9DBF 9DC0
    u"鹛" : (u"鶥", ),  # 9E5B => 9DA5
    u"鹜" : (u"鶩", ),  # 9E5C => 9DA9
    u"鹞" : (u"鷂", ),  # 9E5E => 9DC2
    u"鹡" : (u"鶺", ),  # 9E61 => 9DBA
    u"鹣" : (u"鶼", ),  # 9E63 => 9DBC
    u"鹤" : (u"鶴", ),  # 9E64 => 9DB4
    u"鹥" : (u"鷖", ),  # 9E65 => 9DD6
    u"鹦" : (u"鸚", ),  # 9E66 => 9E1A
    u"鹧" : (u"鷓", ),  # 9E67 => 9DD3
    u"鹨" : (u"鷚", ),  # 9E68 => 9DDA
    u"鹩" : (u"鷯", ),  # 9E69 => 9DEF
    u"鹪" : (u"鷦", ),  # 9E6A => 9DE6
    u"鹫" : (u"鷲", ),  # 9E6B => 9DF2
    u"鹬" : (u"鷸", ),  # 9E6C => 9DF8
    u"鹭" : (u"鷺", ),  # 9E6D => 9DFA
    u"鹯" : (u"鸇", ),  # 9E6F => 9E07
    u"鹰" : (u"鷹", ),  # 9E70 => 9DF9
    u"鹱" : (u"鸌", ),  # 9E71 => 9E0C
    u"鹳" : (u"鸛", ),  # 9E73 => 9E1B
    u"鹾" : (u"鹺", ),  # 9E7E => 9E7A
    u"麦" : (u"麥", ),  # 9EA6 => 9EA5
    u"麸" : (u"麩", ),  # 9EB8 => 9EA9
    u"黄" : (u"黃", ),  # 9EC4 => 9EC3
    u"黉" : (u"黌", ),  # 9EC9 => 9ECC
    u"黡" : (u"黶", ),  # 9EE1 => 9EF6
    u"黩" : (u"黷", ),  # 9EE9 => 9EF7
    u"黪" : (u"黲", ),  # 9EEA => 9EF2
    u"黾" : (u"黽", ),  # 9EFE => 9EFD
    u"鼋" : (u"黿", ),  # 9F0B => 9EFF
    u"鼍" : (u"鼉", ),  # 9F0D => 9F09
    u"鼗" : (u"鞀", ),  # 9F17 => 9780
    u"鼹" : (u"鼴", ),  # 9F39 => 9F34
    u"齄" : (u"齇", ),  # 9F44 => 9F47
    u"齐" : (u"齊", ),  # 9F50 => 9F4A
    u"齑" : (u"齏", ),  # 9F51 => 9F4F
    u"齿" : (u"齒", ),  # 9F7F => 9F52
    u"龀" : (u"齔", ),  # 9F80 => 9F54
    u"龃" : (u"齟", ),  # 9F83 => 9F5F
    u"龄" : (u"齡", ),  # 9F84 => 9F61
    u"龅" : (u"齙", ),  # 9F85 => 9F59
    u"龆" : (u"齠", ),  # 9F86 => 9F60
    u"龇" : (u"齜", ),  # 9F87 => 9F5C
    u"龈" : (u"齦", ),  # 9F88 => 9F66
    u"龉" : (u"齬", ),  # 9F89 => 9F6C
    u"龊" : (u"齪", ),  # 9F8A => 9F6A
    u"龋" : (u"齲", ),  # 9F8B => 9F72
    u"龌" : (u"齷", ),  # 9F8C => 9F77
    u"龙" : (u"龍", ),  # 9F99 => 9F8D
    u"龚" : (u"龔", ),  # 9F9A => 9F94
    u"龛" : (u"龕", ),  # 9F9B => 9F95
    u"龟" : (u"龜", ),  # 9F9F => 9F9C
}

# Traditional Chinese to Simplified Chinese
T_2_S = {
    u"㑳" : (u"㑇", ),  # 3473 => 3447
    u"㘚" : (u"㘎", ),  # 361A => 360E
    u"㥮" : (u"㤘", ),  # 396E => 3918
    u"㩳" : (u"㧐", ),  # 3A73 => 39D0
    u"䎱" : (u"䎬", ),  # 43B1 => 43AC
    u"䙡" : (u"䙌", ),  # 4661 => 464C
    u"䝼" : (u"䞍", ),  # 477C => 478D
    u"䥇" : (u"䦂", ),  # 4947 => 4982
    u"䦛" : (u"䦶", ),  # 499B => 49B6
    u"䦟" : (u"䦷", ),  # 499F => 49B7
    u"䱷" : (u"䲣", ),  # 4C77 => 4CA3
    u"丟" : (u"丢", ),  # 4E1F => 4E22
    u"並" : (u"并", ),  # 4E26 => 5E76
    u"么" : (u"幺", ),  # 4E48 => 5E7A
    u"乾" : (u"干", ),  # 4E7E => 5E72
    u"亂" : (u"乱", ),  # 4E82 => 4E71
    u"亙" : (u"亘", ),  # 4E99 => 4E98
    u"亞" : (u"亚", ),  # 4E9E => 4E9A
    u"佇" : (u"伫", ),  # 4F47 => 4F2B
    u"佘" : (u"畲", ),  # 4F58 => 7572
    u"來" : (u"来", ),  # 4F86 => 6765
    u"侖" : (u"仑", ),  # 4F96 => 4ED1
    u"侶" : (u"侣", ),  # 4FB6 => 4FA3
    u"俁" : (u"俣", ),  # 4FC1 => 4FE3
    u"係" : (u"系", ),  # 4FC2 => 7CFB
    u"俠" : (u"侠", ),  # 4FE0 => 4FA0
    u"倀" : (u"伥", ),  # 5000 => 4F25
    u"倆" : (u"俩", ),  # 5006 => 4FE9
    u"倉" : (u"仓", ),  # 5009 => 4ED3
    u"個" : (u"个", ),  # 500B => 4E2A
    u"們" : (u"们", ),  # 5011 => 4EEC
    u"倫" : (u"伦", ),  # 502B => 4F26
    u"偉" : (u"伟", ),  # 5049 => 4F1F
    u"側" : (u"侧", ),  # 5074 => 4FA7
    u"偵" : (u"侦", ),  # 5075 => 4FA6
    u"偽" : (u"伪", ),  # 507D => 4F2A
    u"傑" : (u"杰", ),  # 5091 => 6770
    u"傖" : (u"伧", ),  # 5096 => 4F27
    u"傘" : (u"伞", ),  # 5098 => 4F1E
    u"備" : (u"备", ),  # 5099 => 5907
    u"傢" : (u"家", ),  # 50A2 => 5BB6
    u"傭" : (u"佣", ),  # 50AD => 4F63
    u"傯" : (u"偬", ),  # 50AF => 506C
    u"傳" : (u"传", ),  # 50B3 => 4F20
    u"傴" : (u"伛", ),  # 50B4 => 4F1B
    u"債" : (u"债", ),  # 50B5 => 503A
    u"傷" : (u"伤", ),  # 50B7 => 4F24
    u"傾" : (u"倾", ),  # 50BE => 503E
    u"僂" : (u"偻", ),  # 50C2 => 507B
    u"僅" : (u"仅", ),  # 50C5 => 4EC5
    u"僉" : (u"佥", ),  # 50C9 => 4F65
    u"僑" : (u"侨", ),  # 50D1 => 4FA8
    u"僕" : (u"仆", ),  # 50D5 => 4EC6
    u"僞" : (u"伪", ),  # 50DE => 4F2A
    u"僥" : (u"侥", ),  # 50E5 => 4FA5
    u"僨" : (u"偾", ),  # 50E8 => 507E
    u"價" : (u"价", ),  # 50F9 => 4EF7
    u"儀" : (u"仪", ),  # 5100 => 4EEA
    u"儂" : (u"侬", ),  # 5102 => 4FAC
    u"億" : (u"亿", ),  # 5104 => 4EBF
    u"儈" : (u"侩", ),  # 5108 => 4FA9
    u"儉" : (u"俭", ),  # 5109 => 4FED
    u"儐" : (u"傧", ),  # 5110 => 50A7
    u"儔" : (u"俦", ),  # 5114 => 4FE6
    u"儕" : (u"侪", ),  # 5115 => 4FAA
    u"儘" : (u"尽", ),  # 5118 => 5C3D
    u"償" : (u"偿", ),  # 511F => 507F
    u"優" : (u"优", ),  # 512A => 4F18
    u"儲" : (u"储", ),  # 5132 => 50A8
    u"儷" : (u"俪", ),  # 5137 => 4FEA
    u"儺" : (u"傩", ),  # 513A => 50A9
    u"儻" : (u"傥", ),  # 513B => 50A5
    u"儼" : (u"俨", ),  # 513C => 4FE8
    u"兌" : (u"兑", ),  # 514C => 5151
    u"兒" : (u"儿", ),  # 5152 => 513F
    u"兗" : (u"兖", ),  # 5157 => 5156
    u"內" : (u"内", ),  # 5167 => 5185
    u"兩" : (u"两", ),  # 5169 => 4E24
    u"兿" : (u"艺", ),  # 517F => 827A
    u"冊" : (u"册", ),  # 518A => 518C
    u"冪" : (u"幂", ),  # 51AA => 5E42
    u"凍" : (u"冻", ),  # 51CD => 51BB
    u"凖" : (u"准", ),  # 51D6 => 51C6
    u"凜" : (u"凛", ),  # 51DC => 51DB
    u"凱" : (u"凯", ),  # 51F1 => 51EF
    u"別" : (u"别", ),  # 5225 => 522B
    u"刪" : (u"删", ),  # 522A => 5220
    u"剄" : (u"刭", ),  # 5244 => 522D
    u"則" : (u"则", ),  # 5247 => 5219
    u"剋" : (u"克", ),  # 524B => 514B
    u"剗" : (u"刬", ),  # 5257 => 522C
    u"剛" : (u"刚", ),  # 525B => 521A
    u"剝" : (u"剥", ),  # 525D => 5265
    u"剮" : (u"剐", ),  # 526E => 5250
    u"剴" : (u"剀", ),  # 5274 => 5240
    u"創" : (u"创", ),  # 5275 => 521B
    u"劃" : (u"划", ),  # 5283 => 5212
    u"劄" : (u"札", ),  # 5284 => 672D
    u"劇" : (u"剧", ),  # 5287 => 5267
    u"劈" : (u"噼", ),  # 5288 => 567C
    u"劉" : (u"刘", ),  # 5289 => 5218
    u"劊" : (u"刽", ),  # 528A => 523D
    u"劌" : (u"刿", ),  # 528C => 523F
    u"劍" : (u"剑", ),  # 528D => 5251
    u"劑" : (u"剂", ),  # 5291 => 5242
    u"勁" : (u"劲", ),  # 52C1 => 52B2
    u"動" : (u"动", ),  # 52D5 => 52A8
    u"務" : (u"务", ),  # 52D9 => 52A1
    u"勛" : (u"勋", ),  # 52DB => 52CB
    u"勝" : (u"胜", ),  # 52DD => 80DC
    u"勞" : (u"劳", ),  # 52DE => 52B3
    u"勢" : (u"势", ),  # 52E2 => 52BF
    u"勩" : (u"勚", ),  # 52E9 => 52DA
    u"勱" : (u"劢", ),  # 52F1 => 52A2
    u"勳" : (u"勋", ),  # 52F3 => 52CB
    u"勵" : (u"励", ),  # 52F5 => 52B1
    u"勸" : (u"劝", ),  # 52F8 => 529D
    u"勻" : (u"匀", ),  # 52FB => 5300
    u"匭" : (u"匦", ),  # 532D => 5326
    u"匯" : (u"汇", ),  # 532F => 6C47
    u"匱" : (u"匮", ),  # 5331 => 532E
    u"區" : (u"区", ),  # 5340 => 533A
    u"協" : (u"协", ),  # 5354 => 534F
    u"卻" : (u"却", ),  # 537B => 5374
    u"厙" : (u"厍", ),  # 5399 => 538D
    u"原" : (u"塬", ),  # 539F => 586C
    u"厠" : (u"厕", ),  # 53A0 => 5395
    u"厭" : (u"厌", ),  # 53AD => 538C
    u"厲" : (u"厉", ),  # 53B2 => 5389
    u"厴" : (u"厣", ),  # 53B4 => 53A3
    u"參" : (u"叁", u"参"),  # 53C3 => 53C1 53C2
    u"叢" : (u"丛", ),  # 53E2 => 4E1B
    u"吒" : (u"咤", ),  # 5412 => 54A4
    u"吳" : (u"吴", ),  # 5433 => 5434
    u"呂" : (u"吕", ),  # 5442 => 5415
    u"呱" : (u"哌", ),  # 5471 => 54CC
    u"呵" : (u"嗬", ),  # 5475 => 55EC
    u"呼" : (u"唿", ),  # 547C => 553F
    u"咼" : (u"呙", ),  # 54BC => 5459
    u"員" : (u"员", ),  # 54E1 => 5458
    u"哢" : (u"咔", ),  # 54E2 => 5494
    u"唄" : (u"呗", ),  # 5504 => 5457
    u"唕" : (u"唣", ),  # 5515 => 5523
    u"唚" : (u"吣", ),  # 551A => 5423
    u"問" : (u"问", ),  # 554F => 95EE
    u"啓" : (u"启", ),  # 5553 => 542F
    u"啞" : (u"哑", ),  # 555E => 54D1
    u"啟" : (u"启", ),  # 555F => 542F
    u"啢" : (u"唡", ),  # 5562 => 5521
    u"喎" : (u"㖞", ),  # 558E => 359E
    u"喚" : (u"唤", ),  # 559A => 5524
    u"喪" : (u"丧", ),  # 55AA => 4E27
    u"喬" : (u"乔", ),  # 55AC => 4E54
    u"單" : (u"单", ),  # 55AE => 5355
    u"喲" : (u"哟", ),  # 55B2 => 54DF
    u"嗆" : (u"呛", ),  # 55C6 => 545B
    u"嗇" : (u"啬", ),  # 55C7 => 556C
    u"嗊" : (u"唝", ),  # 55CA => 551D
    u"嗎" : (u"吗", ),  # 55CE => 5417
    u"嗚" : (u"呜", ),  # 55DA => 545C
    u"嗩" : (u"唢", ),  # 55E9 => 5522
    u"嗶" : (u"哔", ),  # 55F6 => 54D4
    u"嘆" : (u"叹", ),  # 5606 => 53F9
    u"嘍" : (u"喽", ),  # 560D => 55BD
    u"嘔" : (u"呕", ),  # 5614 => 5455
    u"嘖" : (u"啧", ),  # 5616 => 5567
    u"嘗" : (u"尝", ),  # 5617 => 5C1D
    u"嘜" : (u"唛", ),  # 561C => 551B
    u"嘩" : (u"哗", ),  # 5629 => 54D7
    u"嘮" : (u"唠", ),  # 562E => 5520
    u"嘯" : (u"啸", ),  # 562F => 5578
    u"嘰" : (u"叽", ),  # 5630 => 53FD
    u"嘵" : (u"哓", ),  # 5635 => 54D3
    u"嘸" : (u"呒", ),  # 5638 => 5452
    u"噁" : (u"恶", ),  # 5641 => 6076
    u"噅" : (u"咴", ),  # 5645 => 54B4
    u"噓" : (u"嘘", ),  # 5653 => 5618
    u"噝" : (u"咝", ),  # 565D => 549D
    u"噠" : (u"哒", ),  # 5660 => 54D2
    u"噥" : (u"哝", ),  # 5665 => 54DD
    u"噦" : (u"哕", ),  # 5666 => 54D5
    u"噯" : (u"嗳", ),  # 566F => 55F3
    u"噲" : (u"哙", ),  # 5672 => 54D9
    u"噴" : (u"喷", ),  # 5674 => 55B7
    u"噸" : (u"吨", ),  # 5678 => 5428
    u"噹" : (u"当", ),  # 5679 => 5F53
    u"嚀" : (u"咛", ),  # 5680 => 549B
    u"嚇" : (u"吓", ),  # 5687 => 5413
    u"嚌" : (u"哜", ),  # 568C => 54DC
    u"嚕" : (u"噜", ),  # 5695 => 565C
    u"嚙" : (u"啮", ),  # 5699 => 556E
    u"嚦" : (u"呖", ),  # 56A6 => 5456
    u"嚨" : (u"咙", ),  # 56A8 => 5499
    u"嚮" : (u"向", ),  # 56AE => 5411
    u"嚳" : (u"喾", ),  # 56B3 => 55BE
    u"嚴" : (u"严", ),  # 56B4 => 4E25
    u"嚶" : (u"嘤", ),  # 56B6 => 5624
    u"囀" : (u"啭", ),  # 56C0 => 556D
    u"囁" : (u"嗫", ),  # 56C1 => 55EB
    u"囂" : (u"嚣", ),  # 56C2 => 56A3
    u"囅" : (u"冁", ),  # 56C5 => 5181
    u"囈" : (u"呓", ),  # 56C8 => 5453
    u"囉" : (u"啰", ),  # 56C9 => 5570
    u"囌" : (u"苏", ),  # 56CC => 82CF
    u"囑" : (u"嘱", ),  # 56D1 => 5631
    u"囪" : (u"囱", ),  # 56EA => 56F1
    u"圇" : (u"囵", ),  # 5707 => 56F5
    u"國" : (u"国", ),  # 570B => 56FD
    u"圍" : (u"围", ),  # 570D => 56F4
    u"園" : (u"园", ),  # 5712 => 56ED
    u"圓" : (u"圆", ),  # 5713 => 5706
    u"圖" : (u"图", ),  # 5716 => 56FE
    u"團" : (u"团", ),  # 5718 => 56E2
    u"坰" : (u"垧", ),  # 5770 => 57A7
    u"垵" : (u"埯", ),  # 57B5 => 57EF
    u"埡" : (u"垭", ),  # 57E1 => 57AD
    u"執" : (u"执", ),  # 57F7 => 6267
    u"堅" : (u"坚", ),  # 5805 => 575A
    u"堊" : (u"垩", ),  # 580A => 57A9
    u"堖" : (u"垴", ),  # 5816 => 57B4
    u"堝" : (u"埚", ),  # 581D => 57DA
    u"堯" : (u"尧", ),  # 582F => 5C27
    u"報" : (u"报", ),  # 5831 => 62A5
    u"場" : (u"场", ),  # 5834 => 573A
    u"堿" : (u"碱", ),  # 583F => 78B1
    u"塊" : (u"块", ),  # 584A => 5757
    u"塋" : (u"茔", ),  # 584B => 8314
    u"塏" : (u"垲", ),  # 584F => 57B2
    u"塒" : (u"埘", ),  # 5852 => 57D8
    u"塗" : (u"涂", ),  # 5857 => 6D82
    u"塚" : (u"冢", ),  # 585A => 51A2
    u"塢" : (u"坞", ),  # 5862 => 575E
    u"塤" : (u"埙", ),  # 5864 => 57D9
    u"塵" : (u"尘", ),  # 5875 => 5C18
    u"塹" : (u"堑", ),  # 5879 => 5811
    u"墊" : (u"垫", u"埝"),  # 588A => 57AB 57DD
    u"墜" : (u"坠", ),  # 589C => 5760
    u"墮" : (u"堕", ),  # 58AE => 5815
    u"墳" : (u"坟", ),  # 58B3 => 575F
    u"墻" : (u"墙", ),  # 58BB => 5899
    u"墾" : (u"垦", ),  # 58BE => 57A6
    u"壇" : (u"坛", ),  # 58C7 => 575B
    u"壐" : (u"玺", ),  # 58D0 => 73BA
    u"壓" : (u"压", ),  # 58D3 => 538B
    u"壘" : (u"垒", ),  # 58D8 => 5792
    u"壙" : (u"圹", ),  # 58D9 => 5739
    u"壚" : (u"垆", ),  # 58DA => 5786
    u"壞" : (u"坏", ),  # 58DE => 574F
    u"壟" : (u"垄", u"垅"),  # 58DF => 5784 5785
    u"壢" : (u"坜", ),  # 58E2 => 575C
    u"壩" : (u"坝", ),  # 58E9 => 575D
    u"壯" : (u"壮", ),  # 58EF => 58EE
    u"壺" : (u"壶", ),  # 58FA => 58F6
    u"壽" : (u"寿", ),  # 58FD => 5BFF
    u"夀" : (u"寿", ),  # 5900 => 5BFF
    u"夠" : (u"够", ),  # 5920 => 591F
    u"夢" : (u"梦", ),  # 5922 => 68A6
    u"夥" : (u"伙", ),  # 5925 => 4F19
    u"夾" : (u"夹", ),  # 593E => 5939
    u"奐" : (u"奂", ),  # 5950 => 5942
    u"奧" : (u"奥", ),  # 5967 => 5965
    u"奩" : (u"奁", ),  # 5969 => 5941
    u"奪" : (u"夺", ),  # 596A => 593A
    u"奬" : (u"奖", ),  # 596C => 5956
    u"奮" : (u"奋", ),  # 596E => 594B
    u"妝" : (u"妆", ),  # 599D => 5986
    u"姍" : (u"姗", ),  # 59CD => 59D7
    u"娛" : (u"娱", ),  # 5A1B => 5A31
    u"婁" : (u"娄", ),  # 5A41 => 5A04
    u"婦" : (u"妇", ),  # 5A66 => 5987
    u"婭" : (u"娅", ),  # 5A6D => 5A05
    u"媧" : (u"娲", ),  # 5AA7 => 5A32
    u"媯" : (u"妫", ),  # 5AAF => 59AB
    u"媼" : (u"媪", ),  # 5ABC => 5AAA
    u"媽" : (u"妈", ),  # 5ABD => 5988
    u"嫋" : (u"袅", ),  # 5ACB => 8885
    u"嫗" : (u"妪", ),  # 5AD7 => 59AA
    u"嫵" : (u"妩", ),  # 5AF5 => 59A9
    u"嫻" : (u"娴", ),  # 5AFB => 5A34
    u"嫿" : (u"婳", ),  # 5AFF => 5A73
    u"嬈" : (u"娆", ),  # 5B08 => 5A06
    u"嬋" : (u"婵", ),  # 5B0B => 5A75
    u"嬌" : (u"娇", ),  # 5B0C => 5A07
    u"嬙" : (u"嫱", ),  # 5B19 => 5AF1
    u"嬡" : (u"嫒", ),  # 5B21 => 5AD2
    u"嬤" : (u"嬷", ),  # 5B24 => 5B37
    u"嬪" : (u"嫔", ),  # 5B2A => 5AD4
    u"嬰" : (u"婴", ),  # 5B30 => 5A74
    u"嬸" : (u"婶", ),  # 5B38 => 5A76
    u"孌" : (u"娈", ),  # 5B4C => 5A08
    u"孫" : (u"孙", ),  # 5B6B => 5B59
    u"學" : (u"学", ),  # 5B78 => 5B66
    u"孿" : (u"孪", ),  # 5B7F => 5B6A
    u"宮" : (u"宫", ),  # 5BAE => 5BAB
    u"寜" : (u"宁", ),  # 5BDC => 5B81
    u"寢" : (u"寝", ),  # 5BE2 => 5BDD
    u"實" : (u"实", ),  # 5BE6 => 5B9E
    u"審" : (u"审", ),  # 5BE9 => 5BA1
    u"寫" : (u"写", ),  # 5BEB => 5199
    u"寬" : (u"宽", ),  # 5BEC => 5BBD
    u"寵" : (u"宠", ),  # 5BF5 => 5BA0
    u"寶" : (u"宝", ),  # 5BF6 => 5B9D
    u"將" : (u"将", ),  # 5C07 => 5C06
    u"專" : (u"专", ),  # 5C08 => 4E13
    u"尋" : (u"寻", ),  # 5C0B => 5BFB
    u"對" : (u"对", ),  # 5C0D => 5BF9
    u"導" : (u"导", ),  # 5C0E => 5BFC
    u"尷" : (u"尴", ),  # 5C37 => 5C34
    u"屆" : (u"届", ),  # 5C46 => 5C4A
    u"屍" : (u"尸", ),  # 5C4D => 5C38
    u"屙" : (u"疴", ),  # 5C59 => 75B4
    u"屜" : (u"屉", ),  # 5C5C => 5C49
    u"屢" : (u"屡", ),  # 5C62 => 5C61
    u"層" : (u"层", ),  # 5C64 => 5C42
    u"屨" : (u"屦", ),  # 5C68 => 5C66
    u"屬" : (u"属", ),  # 5C6C => 5C5E
    u"岡" : (u"冈", ),  # 5CA1 => 5188
    u"峴" : (u"岘", ),  # 5CF4 => 5C98
    u"島" : (u"岛", ),  # 5CF6 => 5C9B
    u"峽" : (u"峡", ),  # 5CFD => 5CE1
    u"崍" : (u"崃", ),  # 5D0D => 5D03
    u"崗" : (u"岗", ),  # 5D17 => 5C97
    u"崠" : (u"岽", ),  # 5D20 => 5CBD
    u"崢" : (u"峥", ),  # 5D22 => 5CE5
    u"崬" : (u"岽", ),  # 5D2C => 5CBD
    u"崳" : (u"嵛", ),  # 5D33 => 5D5B
    u"嵐" : (u"岚", ),  # 5D50 => 5C9A
    u"嵗" : (u"岁", ),  # 5D57 => 5C81
    u"嶁" : (u"嵝", ),  # 5D81 => 5D5D
    u"嶄" : (u"崭", ),  # 5D84 => 5D2D
    u"嶇" : (u"岖", ),  # 5D87 => 5C96
    u"嶔" : (u"嵚", ),  # 5D94 => 5D5A
    u"嶗" : (u"崂", ),  # 5D97 => 5D02
    u"嶠" : (u"峤", ),  # 5DA0 => 5CE4
    u"嶢" : (u"峣", ),  # 5DA2 => 5CE3
    u"嶧" : (u"峄", ),  # 5DA7 => 5CC4
    u"嶨" : (u"峃", ),  # 5DA8 => 5CC3
    u"嶴" : (u"岙", ),  # 5DB4 => 5C99
    u"嶸" : (u"嵘", ),  # 5DB8 => 5D58
    u"嶺" : (u"岭", ),  # 5DBA => 5CAD
    u"嶼" : (u"屿", ),  # 5DBC => 5C7F
    u"嶽" : (u"岳", ),  # 5DBD => 5CB3
    u"巋" : (u"岿", ),  # 5DCB => 5CBF
    u"巒" : (u"峦", ),  # 5DD2 => 5CE6
    u"巔" : (u"巅", ),  # 5DD4 => 5DC5
    u"巰" : (u"巯", ),  # 5DF0 => 5DEF
    u"巹" : (u"卺", ),  # 5DF9 => 537A
    u"帥" : (u"帅", ),  # 5E25 => 5E05
    u"師" : (u"师", ),  # 5E2B => 5E08
    u"帳" : (u"帐", ),  # 5E33 => 5E10
    u"帶" : (u"带", ),  # 5E36 => 5E26
    u"幀" : (u"帧", ),  # 5E40 => 5E27
    u"幃" : (u"帏", ),  # 5E43 => 5E0F
    u"幗" : (u"帼", ),  # 5E57 => 5E3C
    u"幘" : (u"帻", ),  # 5E58 => 5E3B
    u"幟" : (u"帜", ),  # 5E5F => 5E1C
    u"幣" : (u"币", ),  # 5E63 => 5E01
    u"幫" : (u"帮", ),  # 5E6B => 5E2E
    u"幬" : (u"帱", ),  # 5E6C => 5E31
    u"幹" : (u"干", ),  # 5E79 => 5E72
    u"幾" : (u"几", ),  # 5E7E => 51E0
    u"庫" : (u"库", ),  # 5EAB => 5E93
    u"廁" : (u"厕", ),  # 5EC1 => 5395
    u"廂" : (u"厢", ),  # 5EC2 => 53A2
    u"廄" : (u"厩", ),  # 5EC4 => 53A9
    u"廈" : (u"厦", ),  # 5EC8 => 53A6
    u"廎" : (u"庼", ),  # 5ECE => 5EBC
    u"廚" : (u"厨", ),  # 5EDA => 53A8
    u"廝" : (u"厮", ),  # 5EDD => 53AE
    u"廟" : (u"庙", ),  # 5EDF => 5E99
    u"廠" : (u"厂", ),  # 5EE0 => 5382
    u"廡" : (u"庑", ),  # 5EE1 => 5E91
    u"廢" : (u"废", ),  # 5EE2 => 5E9F
    u"廣" : (u"广", ),  # 5EE3 => 5E7F
    u"廩" : (u"廪", ),  # 5EE9 => 5EEA
    u"廬" : (u"庐", ),  # 5EEC => 5E90
    u"廳" : (u"厅", ),  # 5EF3 => 5385
    u"弳" : (u"弪", ),  # 5F33 => 5F2A
    u"張" : (u"张", ),  # 5F35 => 5F20
    u"強" : (u"强", u"犟"),  # 5F37 => 5F3A 729F
    u"彆" : (u"别", ),  # 5F46 => 522B
    u"彈" : (u"弹", ),  # 5F48 => 5F39
    u"彌" : (u"弥", ),  # 5F4C => 5F25
    u"彎" : (u"弯", ),  # 5F4E => 5F2F
    u"彙" : (u"汇", ),  # 5F59 => 6C47
    u"彥" : (u"彦", ),  # 5F65 => 5F66
    u"後" : (u"后", ),  # 5F8C => 540E
    u"徑" : (u"径", ),  # 5F91 => 5F84
    u"從" : (u"从", ),  # 5F9E => 4ECE
    u"徠" : (u"徕", ),  # 5FA0 => 5F95
    u"復" : (u"复", ),  # 5FA9 => 590D
    u"徵" : (u"征", ),  # 5FB5 => 5F81
    u"徹" : (u"彻", ),  # 5FB9 => 5F7B
    u"怵" : (u"憷", ),  # 6035 => 61B7
    u"恥" : (u"耻", ),  # 6065 => 803B
    u"悅" : (u"悦", ),  # 6085 => 60A6
    u"悵" : (u"怅", ),  # 60B5 => 6005
    u"悶" : (u"闷", ),  # 60B6 => 95F7
    u"惡" : (u"恶", ),  # 60E1 => 6076
    u"惱" : (u"恼", ),  # 60F1 => 607C
    u"惲" : (u"恽", ),  # 60F2 => 607D
    u"惻" : (u"恻", ),  # 60FB => 607B
    u"愛" : (u"爱", ),  # 611B => 7231
    u"愜" : (u"惬", ),  # 611C => 60EC
    u"愨" : (u"悫", ),  # 6128 => 60AB
    u"愴" : (u"怆", ),  # 6134 => 6006
    u"愷" : (u"恺", ),  # 6137 => 607A
    u"愾" : (u"忾", ),  # 613E => 5FFE
    u"態" : (u"态", ),  # 614B => 6001
    u"慍" : (u"愠", ),  # 614D => 6120
    u"慘" : (u"惨", ),  # 6158 => 60E8
    u"慚" : (u"惭", ),  # 615A => 60ED
    u"慟" : (u"恸", ),  # 615F => 6078
    u"慣" : (u"惯", ),  # 6163 => 60EF
    u"慤" : (u"悫", ),  # 6164 => 60AB
    u"慪" : (u"怄", ),  # 616A => 6004
    u"慫" : (u"怂", ),  # 616B => 6002
    u"慮" : (u"虑", ),  # 616E => 8651
    u"慳" : (u"悭", ),  # 6173 => 60AD
    u"慶" : (u"庆", ),  # 6176 => 5E86
    u"憂" : (u"忧", ),  # 6182 => 5FE7
    u"憊" : (u"惫", ),  # 618A => 60EB
    u"憐" : (u"怜", ),  # 6190 => 601C
    u"憑" : (u"凭", ),  # 6191 => 51ED
    u"憒" : (u"愦", ),  # 6192 => 6126
    u"憚" : (u"惮", ),  # 619A => 60EE
    u"憤" : (u"愤", ),  # 61A4 => 6124
    u"憫" : (u"悯", ),  # 61AB => 60AF
    u"憮" : (u"怃", ),  # 61AE => 6003
    u"憲" : (u"宪", ),  # 61B2 => 5BAA
    u"憶" : (u"忆", ),  # 61B6 => 5FC6
    u"懇" : (u"恳", ),  # 61C7 => 6073
    u"應" : (u"应", ),  # 61C9 => 5E94
    u"懌" : (u"怿", ),  # 61CC => 603F
    u"懍" : (u"懔", ),  # 61CD => 61D4
    u"懞" : (u"蒙", ),  # 61DE => 8499
    u"懟" : (u"怼", ),  # 61DF => 603C
    u"懣" : (u"懑", ),  # 61E3 => 61D1
    u"懨" : (u"恹", ),  # 61E8 => 6079
    u"懲" : (u"惩", ),  # 61F2 => 60E9
    u"懶" : (u"懒", ),  # 61F6 => 61D2
    u"懷" : (u"怀", ),  # 61F7 => 6000
    u"懸" : (u"悬", ),  # 61F8 => 60AC
    u"懺" : (u"忏", ),  # 61FA => 5FCF
    u"懼" : (u"惧", ),  # 61FC => 60E7
    u"懾" : (u"慑", ),  # 61FE => 6151
    u"戀" : (u"恋", ),  # 6200 => 604B
    u"戇" : (u"戆", ),  # 6207 => 6206
    u"戔" : (u"戋", ),  # 6214 => 620B
    u"戠" : (u"只", ),  # 6220 => 53EA
    u"戧" : (u"戗", ),  # 6227 => 6217
    u"戩" : (u"戬", ),  # 6229 => 622C
    u"戰" : (u"战", ),  # 6230 => 6218
    u"戲" : (u"戏", ),  # 6232 => 620F
    u"戶" : (u"户", ),  # 6236 => 6237
    u"扡" : (u"扦", ),  # 6261 => 6266
    u"拋" : (u"抛", ),  # 62CB => 629B
    u"挾" : (u"挟", ),  # 633E => 631F
    u"捨" : (u"舍", ),  # 6368 => 820D
    u"捫" : (u"扪", ),  # 636B => 626A
    u"捲" : (u"卷", ),  # 6372 => 5377
    u"掃" : (u"扫", ),  # 6383 => 626B
    u"掄" : (u"抡", ),  # 6384 => 62A1
    u"掆" : (u"㧏", ),  # 6386 => 39CF
    u"掗" : (u"挜", ),  # 6397 => 631C
    u"掙" : (u"挣", ),  # 6399 => 6323
    u"掛" : (u"挂", ),  # 639B => 6302
    u"揀" : (u"拣", ),  # 63C0 => 62E3
    u"揚" : (u"扬", ),  # 63DA => 626C
    u"換" : (u"换", ),  # 63DB => 6362
    u"揮" : (u"挥", ),  # 63EE => 6325
    u"損" : (u"损", ),  # 640D => 635F
    u"搖" : (u"摇", ),  # 6416 => 6447
    u"搗" : (u"捣", ),  # 6417 => 6363
    u"搶" : (u"抢", ),  # 6436 => 62A2
    u"摑" : (u"掴", ),  # 6451 => 63B4
    u"摜" : (u"掼", ),  # 645C => 63BC
    u"摟" : (u"搂", ),  # 645F => 6402
    u"摣" : (u"揸", ),  # 6463 => 63F8
    u"摯" : (u"挚", ),  # 646F => 631A
    u"摳" : (u"抠", ),  # 6473 => 62A0
    u"摶" : (u"抟", ),  # 6476 => 629F
    u"摺" : (u"折", ),  # 647A => 6298
    u"摻" : (u"掺", ),  # 647B => 63BA
    u"撃" : (u"击", ),  # 6483 => 51FB
    u"撈" : (u"捞", ),  # 6488 => 635E
    u"撏" : (u"挦", ),  # 648F => 6326
    u"撐" : (u"撑", ),  # 6490 => 6491
    u"撓" : (u"挠", ),  # 6493 => 6320
    u"撚" : (u"捻", ),  # 649A => 637B
    u"撟" : (u"挢", ),  # 649F => 6322
    u"撣" : (u"掸", ),  # 64A3 => 63B8
    u"撥" : (u"拨", ),  # 64A5 => 62E8
    u"撫" : (u"抚", ),  # 64AB => 629A
    u"撲" : (u"扑", ),  # 64B2 => 6251
    u"撳" : (u"揿", ),  # 64B3 => 63FF
    u"撻" : (u"挞", ),  # 64BB => 631E
    u"撾" : (u"挝", ),  # 64BE => 631D
    u"撿" : (u"捡", ),  # 64BF => 6361
    u"擁" : (u"拥", ),  # 64C1 => 62E5
    u"擄" : (u"掳", ),  # 64C4 => 63B3
    u"擇" : (u"择", ),  # 64C7 => 62E9
    u"擊" : (u"击", ),  # 64CA => 51FB
    u"擋" : (u"挡", ),  # 64CB => 6321
    u"擓" : (u"㧟", ),  # 64D3 => 39DF
    u"擔" : (u"担", ),  # 64D4 => 62C5
    u"據" : (u"据", ),  # 64DA => 636E
    u"擠" : (u"挤", ),  # 64E0 => 6324
    u"擬" : (u"拟", ),  # 64EC => 62DF
    u"擯" : (u"摈", ),  # 64EF => 6448
    u"擰" : (u"拧", ),  # 64F0 => 62E7
    u"擱" : (u"搁", ),  # 64F1 => 6401
    u"擲" : (u"掷", ),  # 64F2 => 63B7
    u"擴" : (u"扩", ),  # 64F4 => 6269
    u"擷" : (u"撷", ),  # 64F7 => 64B7
    u"擹" : (u"摊", ),  # 64F9 => 644A
    u"擺" : (u"摆", ),  # 64FA => 6446
    u"擻" : (u"擞", ),  # 64FB => 64DE
    u"擼" : (u"撸", ),  # 64FC => 64B8
    u"擾" : (u"扰", ),  # 64FE => 6270
    u"攄" : (u"摅", ),  # 6504 => 6445
    u"攆" : (u"撵", ),  # 6506 => 64B5
    u"攏" : (u"拢", ),  # 650F => 62E2
    u"攔" : (u"拦", ),  # 6514 => 62E6
    u"攖" : (u"撄", ),  # 6516 => 6484
    u"攙" : (u"搀", ),  # 6519 => 6400
    u"攛" : (u"撺", ),  # 651B => 64BA
    u"攜" : (u"携", ),  # 651C => 643A
    u"攝" : (u"摄", ),  # 651D => 6444
    u"攢" : (u"攒", ),  # 6522 => 6512
    u"攣" : (u"挛", ),  # 6523 => 631B
    u"攤" : (u"摊", ),  # 6524 => 644A
    u"攪" : (u"搅", ),  # 652A => 6405
    u"攬" : (u"揽", ),  # 652C => 63FD
    u"敗" : (u"败", ),  # 6557 => 8D25
    u"敘" : (u"叙", ),  # 6558 => 53D9
    u"敵" : (u"敌", ),  # 6575 => 654C
    u"數" : (u"数", ),  # 6578 => 6570
    u"斂" : (u"敛", ),  # 6582 => 655B
    u"斃" : (u"毙", ),  # 6583 => 6BD9
    u"斕" : (u"斓", ),  # 6595 => 6593
    u"斬" : (u"斩", ),  # 65AC => 65A9
    u"斷" : (u"断", ),  # 65B7 => 65AD
    u"時" : (u"时", ),  # 6642 => 65F6
    u"晉" : (u"晋", ),  # 6649 => 664B
    u"晝" : (u"昼", ),  # 665D => 663C
    u"暈" : (u"晕", ),  # 6688 => 6655
    u"暉" : (u"晖", ),  # 6689 => 6656
    u"暘" : (u"旸", ),  # 6698 => 65F8
    u"暢" : (u"畅", ),  # 66A2 => 7545
    u"暫" : (u"暂", ),  # 66AB => 6682
    u"曄" : (u"晔", ),  # 66C4 => 6654
    u"曆" : (u"历", ),  # 66C6 => 5386
    u"曇" : (u"昙", ),  # 66C7 => 6619
    u"曉" : (u"晓", ),  # 66C9 => 6653
    u"曖" : (u"暧", ),  # 66D6 => 66A7
    u"曠" : (u"旷", ),  # 66E0 => 65F7
    u"曨" : (u"昽", ),  # 66E8 => 663D
    u"曬" : (u"晒", ),  # 66EC => 6652
    u"書" : (u"书", ),  # 66F8 => 4E66
    u"會" : (u"会", ),  # 6703 => 4F1A
    u"朧" : (u"胧", ),  # 6727 => 80E7
    u"東" : (u"东", ),  # 6771 => 4E1C
    u"柵" : (u"栅", ),  # 67F5 => 6805
    u"梔" : (u"栀", ),  # 6894 => 6800
    u"梘" : (u"枧", ),  # 6898 => 67A7
    u"條" : (u"条", ),  # 689D => 6761
    u"梟" : (u"枭", ),  # 689F => 67AD
    u"棄" : (u"弃", ),  # 68C4 => 5F03
    u"棖" : (u"枨", ),  # 68D6 => 67A8
    u"棗" : (u"枣", ),  # 68D7 => 67A3
    u"棟" : (u"栋", ),  # 68DF => 680B
    u"棡" : (u"㭎", ),  # 68E1 => 3B4E
    u"棧" : (u"栈", ),  # 68E7 => 6808
    u"棬" : (u"桊", ),  # 68EC => 684A
    u"棲" : (u"栖", ),  # 68F2 => 6816
    u"椏" : (u"桠", ),  # 690F => 6860
    u"楊" : (u"杨", ),  # 694A => 6768
    u"楓" : (u"枫", ),  # 6953 => 67AB
    u"楨" : (u"桢", ),  # 6968 => 6862
    u"業" : (u"业", ),  # 696D => 4E1A
    u"極" : (u"极", ),  # 6975 => 6781
    u"榖" : (u"谷", ),  # 6996 => 8C37
    u"榪" : (u"杩", ),  # 69AA => 6769
    u"榮" : (u"荣", ),  # 69AE => 8363
    u"榿" : (u"桤", ),  # 69BF => 6864
    u"槁" : (u"藁", ),  # 69C1 => 85C1
    u"構" : (u"构", ),  # 69CB => 6784
    u"槍" : (u"枪", ),  # 69CD => 67AA
    u"様" : (u"样", ),  # 69D8 => 6837
    u"槧" : (u"椠", ),  # 69E7 => 6920
    u"槨" : (u"椁", ),  # 69E8 => 6901
    u"槳" : (u"桨", ),  # 69F3 => 6868
    u"樁" : (u"桩", ),  # 6A01 => 6869
    u"樂" : (u"乐", ),  # 6A02 => 4E50
    u"樅" : (u"枞", ),  # 6A05 => 679E
    u"樓" : (u"楼", ),  # 6A13 => 697C
    u"標" : (u"标", ),  # 6A19 => 6807
    u"樞" : (u"枢", ),  # 6A1E => 67A2
    u"樣" : (u"样", ),  # 6A23 => 6837
    u"樸" : (u"朴", ),  # 6A38 => 6734
    u"樹" : (u"树", ),  # 6A39 => 6811
    u"樺" : (u"桦", ),  # 6A3A => 6866
    u"橈" : (u"桡", ),  # 6A48 => 6861
    u"橋" : (u"桥", ),  # 6A4B => 6865
    u"機" : (u"机", ),  # 6A5F => 673A
    u"橢" : (u"椭", ),  # 6A62 => 692D
    u"橫" : (u"横", ),  # 6A6B => 6A2A
    u"檁" : (u"檩", ),  # 6A81 => 6AA9
    u"檉" : (u"柽", ),  # 6A89 => 67FD
    u"檔" : (u"档", ),  # 6A94 => 6863
    u"檜" : (u"桧", ),  # 6A9C => 6867
    u"檟" : (u"槚", ),  # 6A9F => 69DA
    u"檢" : (u"检", ),  # 6AA2 => 68C0
    u"檣" : (u"樯", ),  # 6AA3 => 6A2F
    u"檯" : (u"台", ),  # 6AAF => 53F0
    u"檳" : (u"槟", ),  # 6AB3 => 69DF
    u"檸" : (u"柠", ),  # 6AB8 => 67E0
    u"檻" : (u"槛", ),  # 6ABB => 69DB
    u"檾" : (u"苘", ),  # 6ABE => 82D8
    u"櫃" : (u"柜", ),  # 6AC3 => 67DC
    u"櫓" : (u"橹", ),  # 6AD3 => 6A79
    u"櫚" : (u"榈", ),  # 6ADA => 6988
    u"櫛" : (u"栉", ),  # 6ADB => 6809
    u"櫝" : (u"椟", ),  # 6ADD => 691F
    u"櫞" : (u"橼", ),  # 6ADE => 6A7C
    u"櫟" : (u"栎", ),  # 6ADF => 680E
    u"櫥" : (u"橱", ),  # 6AE5 => 6A71
    u"櫧" : (u"槠", ),  # 6AE7 => 69E0
    u"櫨" : (u"栌", ),  # 6AE8 => 680C
    u"櫪" : (u"枥", ),  # 6AEA => 67A5
    u"櫫" : (u"橥", ),  # 6AEB => 6A65
    u"櫬" : (u"榇", ),  # 6AEC => 6987
    u"櫳" : (u"栊", ),  # 6AF3 => 680A
    u"櫸" : (u"榉", ),  # 6AF8 => 6989
    u"櫻" : (u"樱", ),  # 6AFB => 6A31
    u"欄" : (u"栏", ),  # 6B04 => 680F
    u"權" : (u"权", ),  # 6B0A => 6743
    u"欏" : (u"椤", ),  # 6B0F => 6924
    u"欒" : (u"栾", ),  # 6B12 => 683E
    u"欖" : (u"榄", ),  # 6B16 => 6984
    u"欞" : (u"棂", ),  # 6B1E => 68C2
    u"欽" : (u"钦", ),  # 6B3D => 94A6
    u"歎" : (u"叹", ),  # 6B4E => 53F9
    u"歐" : (u"欧", ),  # 6B50 => 6B27
    u"歟" : (u"欤", ),  # 6B5F => 6B24
    u"歡" : (u"欢", ),  # 6B61 => 6B22
    u"歲" : (u"岁", ),  # 6B72 => 5C81
    u"歷" : (u"历", ),  # 6B77 => 5386
    u"歸" : (u"归", ),  # 6B78 => 5F52
    u"歿" : (u"殁", ),  # 6B7F => 6B81
    u"殘" : (u"残", ),  # 6B98 => 6B8B
    u"殞" : (u"殒", ),  # 6B9E => 6B92
    u"殤" : (u"殇", ),  # 6BA4 => 6B87
    u"殫" : (u"殚", ),  # 6BAB => 6B9A
    u"殮" : (u"殓", ),  # 6BAE => 6B93
    u"殯" : (u"殡", ),  # 6BAF => 6BA1
    u"殲" : (u"歼", ),  # 6BB2 => 6B7C
    u"殺" : (u"杀", ),  # 6BBA => 6740
    u"殻" : (u"壳", ),  # 6BBB => 58F3
    u"殼" : (u"壳", ),  # 6BBC => 58F3
    u"毀" : (u"毁", ),  # 6BC0 => 6BC1
    u"毆" : (u"殴", ),  # 6BC6 => 6BB4
    u"毿" : (u"毵", ),  # 6BFF => 6BF5
    u"氈" : (u"毡", ),  # 6C08 => 6BE1
    u"氌" : (u"氇", ),  # 6C0C => 6C07
    u"氣" : (u"气", ),  # 6C23 => 6C14
    u"氫" : (u"氢", ),  # 6C2B => 6C22
    u"氬" : (u"氩", ),  # 6C2C => 6C29
    u"氳" : (u"氲", ),  # 6C33 => 6C32
    u"氹" : (u"凼", ),  # 6C39 => 51FC
    u"汙" : (u"污", ),  # 6C59 => 6C61
    u"決" : (u"决", ),  # 6C7A => 51B3
    u"沒" : (u"没", ),  # 6C92 => 6CA1
    u"沖" : (u"冲", ),  # 6C96 => 51B2
    u"況" : (u"况", ),  # 6CC1 => 51B5
    u"洶" : (u"汹", ),  # 6D36 => 6C79
    u"浹" : (u"浃", ),  # 6D79 => 6D43
    u"涇" : (u"泾", ),  # 6D87 => 6CFE
    u"涼" : (u"凉", ),  # 6DBC => 51C9
    u"淒" : (u"凄", ),  # 6DD2 => 51C4
    u"淚" : (u"泪", ),  # 6DDA => 6CEA
    u"淥" : (u"渌", ),  # 6DE5 => 6E0C
    u"淨" : (u"净", ),  # 6DE8 => 51C0
    u"淩" : (u"凌", ),  # 6DE9 => 51CC
    u"淪" : (u"沦", ),  # 6DEA => 6CA6
    u"淵" : (u"渊", ),  # 6DF5 => 6E0A
    u"淶" : (u"涞", ),  # 6DF6 => 6D9E
    u"淺" : (u"浅", ),  # 6DFA => 6D45
    u"渙" : (u"涣", ),  # 6E19 => 6DA3
    u"減" : (u"减", ),  # 6E1B => 51CF
    u"渢" : (u"沨", ),  # 6E22 => 6CA8
    u"渦" : (u"涡", ),  # 6E26 => 6DA1
    u"測" : (u"测", ),  # 6E2C => 6D4B
    u"渾" : (u"浑", ),  # 6E3E => 6D51
    u"湊" : (u"凑", ),  # 6E4A => 51D1
    u"湞" : (u"浈", ),  # 6E5E => 6D48
    u"湣" : (u"愍", ),  # 6E63 => 610D
    u"湧" : (u"涌", ),  # 6E67 => 6D8C
    u"湯" : (u"汤", ),  # 6E6F => 6C64
    u"溈" : (u"沩", ),  # 6E88 => 6CA9
    u"溜" : (u"熘", ),  # 6E9C => 7198
    u"溝" : (u"沟", ),  # 6E9D => 6C9F
    u"溫" : (u"温", ),  # 6EAB => 6E29
    u"溮" : (u"浉", ),  # 6EAE => 6D49
    u"溳" : (u"涢", ),  # 6EB3 => 6DA2
    u"滄" : (u"沧", ),  # 6EC4 => 6CA7
    u"滅" : (u"灭", ),  # 6EC5 => 706D
    u"滌" : (u"涤", ),  # 6ECC => 6DA4
    u"滎" : (u"荥", ),  # 6ECE => 8365
    u"滬" : (u"沪", ),  # 6EEC => 6CAA
    u"滯" : (u"滞", ),  # 6EEF => 6EDE
    u"滲" : (u"渗", ),  # 6EF2 => 6E17
    u"滷" : (u"卤", ),  # 6EF7 => 5364
    u"滸" : (u"浒", ),  # 6EF8 => 6D52
    u"滻" : (u"浐", ),  # 6EFB => 6D50
    u"滾" : (u"滚", u"磙"),  # 6EFE => 6EDA 78D9
    u"滿" : (u"满", ),  # 6EFF => 6EE1
    u"漁" : (u"渔", ),  # 6F01 => 6E14
    u"漊" : (u"溇", ),  # 6F0A => 6E87
    u"漚" : (u"沤", ),  # 6F1A => 6CA4
    u"漢" : (u"汉", ),  # 6F22 => 6C49
    u"漣" : (u"涟", ),  # 6F23 => 6D9F
    u"漬" : (u"渍", ),  # 6F2C => 6E0D
    u"漲" : (u"涨", ),  # 6F32 => 6DA8
    u"漵" : (u"溆", ),  # 6F35 => 6E86
    u"漸" : (u"渐", ),  # 6F38 => 6E10
    u"漿" : (u"浆", ),  # 6F3F => 6D46
    u"潁" : (u"颍", ),  # 6F41 => 988D
    u"潑" : (u"泼", ),  # 6F51 => 6CFC
    u"潔" : (u"洁", ),  # 6F54 => 6D01
    u"潛" : (u"潜", ),  # 6F5B => 6F5C
    u"潤" : (u"润", ),  # 6F64 => 6DA6
    u"潯" : (u"浔", ),  # 6F6F => 6D54
    u"潰" : (u"溃", ),  # 6F70 => 6E83
    u"潷" : (u"滗", ),  # 6F77 => 6ED7
    u"潿" : (u"涠", ),  # 6F7F => 6DA0
    u"澀" : (u"涩", ),  # 6F80 => 6DA9
    u"澆" : (u"浇", ),  # 6F86 => 6D47
    u"澇" : (u"涝", ),  # 6F87 => 6D9D
    u"澗" : (u"涧", ),  # 6F97 => 6DA7
    u"澠" : (u"渑", ),  # 6FA0 => 6E11
    u"澤" : (u"泽", ),  # 6FA4 => 6CFD
    u"澦" : (u"滪", ),  # 6FA6 => 6EEA
    u"澩" : (u"泶", ),  # 6FA9 => 6CF6
    u"澮" : (u"浍", ),  # 6FAE => 6D4D
    u"澱" : (u"淀", ),  # 6FB1 => 6DC0
    u"澾" : (u"㳠", ),  # 6FBE => 3CE0
    u"濁" : (u"浊", ),  # 6FC1 => 6D4A
    u"濃" : (u"浓", ),  # 6FC3 => 6D53
    u"濕" : (u"湿", ),  # 6FD5 => 6E7F
    u"濘" : (u"泞", ),  # 6FD8 => 6CDE
    u"濛" : (u"蒙", ),  # 6FDB => 8499
    u"濜" : (u"浕", ),  # 6FDC => 6D55
    u"濟" : (u"济", ),  # 6FDF => 6D4E
    u"濤" : (u"涛", ),  # 6FE4 => 6D9B
    u"濫" : (u"滥", u"漤"),  # 6FEB => 6EE5 6F24
    u"濰" : (u"潍", ),  # 6FF0 => 6F4D
    u"濱" : (u"滨", ),  # 6FF1 => 6EE8
    u"濺" : (u"溅", ),  # 6FFA => 6E85
    u"濼" : (u"泺", ),  # 6FFC => 6CFA
    u"濾" : (u"滤", ),  # 6FFE => 6EE4
    u"瀅" : (u"滢", ),  # 7005 => 6EE2
    u"瀆" : (u"渎", ),  # 7006 => 6E0E
    u"瀉" : (u"泻", ),  # 7009 => 6CFB
    u"瀋" : (u"沈", u"渖"),  # 700B => 6C88 6E16
    u"瀏" : (u"浏", ),  # 700F => 6D4F
    u"瀕" : (u"濒", ),  # 7015 => 6FD2
    u"瀘" : (u"泸", ),  # 7018 => 6CF8
    u"瀝" : (u"沥", ),  # 701D => 6CA5
    u"瀟" : (u"潇", ),  # 701F => 6F47
    u"瀠" : (u"潆", ),  # 7020 => 6F46
    u"瀦" : (u"潴", ),  # 7026 => 6F74
    u"瀧" : (u"泷", ),  # 7027 => 6CF7
    u"瀨" : (u"濑", ),  # 7028 => 6FD1
    u"瀰" : (u"弥", ),  # 7030 => 5F25
    u"瀲" : (u"潋", ),  # 7032 => 6F4B
    u"瀾" : (u"澜", ),  # 703E => 6F9C
    u"灃" : (u"沣", ),  # 7043 => 6CA3
    u"灄" : (u"滠", ),  # 7044 => 6EE0
    u"灑" : (u"洒", ),  # 7051 => 6D12
    u"灕" : (u"漓", ),  # 7055 => 6F13
    u"灘" : (u"滩", ),  # 7058 => 6EE9
    u"灝" : (u"灏", ),  # 705D => 704F
    u"灣" : (u"湾", ),  # 7063 => 6E7E
    u"灤" : (u"滦", ),  # 7064 => 6EE6
    u"灧" : (u"滟", ),  # 7067 => 6EDF
    u"灩" : (u"滟", ),  # 7069 => 6EDF
    u"災" : (u"灾", ),  # 707D => 707E
    u"為" : (u"为", ),  # 70BA => 4E3A
    u"烏" : (u"乌", ),  # 70CF => 4E4C
    u"烴" : (u"烃", ),  # 70F4 => 70C3
    u"無" : (u"无", ),  # 7121 => 65E0
    u"焼" : (u"烧", ),  # 713C => 70E7
    u"煆" : (u"煅", ),  # 7146 => 7145
    u"煉" : (u"炼", ),  # 7149 => 70BC
    u"煒" : (u"炜", ),  # 7152 => 709C
    u"煙" : (u"烟", ),  # 7159 => 70DF
    u"煢" : (u"茕", ),  # 7162 => 8315
    u"煥" : (u"焕", ),  # 7165 => 7115
    u"煩" : (u"烦", ),  # 7169 => 70E6
    u"煬" : (u"炀", ),  # 716C => 7080
    u"熒" : (u"荧", ),  # 7192 => 8367
    u"熗" : (u"炝", ),  # 7197 => 709D
    u"熱" : (u"热", ),  # 71B1 => 70ED
    u"熾" : (u"炽", ),  # 71BE => 70BD
    u"燁" : (u"烨", ),  # 71C1 => 70E8
    u"燈" : (u"灯", ),  # 71C8 => 706F
    u"燉" : (u"炖", ),  # 71C9 => 7096
    u"燒" : (u"烧", ),  # 71D2 => 70E7
    u"燙" : (u"烫", ),  # 71D9 => 70EB
    u"燜" : (u"焖", ),  # 71DC => 7116
    u"營" : (u"营", ),  # 71DF => 8425
    u"燦" : (u"灿", ),  # 71E6 => 707F
    u"燭" : (u"烛", ),  # 71ED => 70DB
    u"燴" : (u"烩", ),  # 71F4 => 70E9
    u"燼" : (u"烬", ),  # 71FC => 70EC
    u"燾" : (u"焘", ),  # 71FE => 7118
    u"爍" : (u"烁", ),  # 720D => 70C1
    u"爐" : (u"炉", ),  # 7210 => 7089
    u"爛" : (u"烂", ),  # 721B => 70C2
    u"爭" : (u"争", ),  # 722D => 4E89
    u"爺" : (u"爷", ),  # 723A => 7237
    u"爾" : (u"尔", ),  # 723E => 5C14
    u"爿" : (u"丬", ),  # 723F => 4E2C
    u"牆" : (u"墙", ),  # 7246 => 5899
    u"牘" : (u"牍", ),  # 7258 => 724D
    u"牽" : (u"牵", ),  # 727D => 7275
    u"犖" : (u"荦", ),  # 7296 => 8366
    u"犛" : (u"牦", ),  # 729B => 7266
    u"犢" : (u"犊", ),  # 72A2 => 728A
    u"犧" : (u"牺", ),  # 72A7 => 727A
    u"犬" : (u"犭", ),  # 72AC => 72AD
    u"狀" : (u"状", ),  # 72C0 => 72B6
    u"狹" : (u"狭", ),  # 72F9 => 72ED
    u"狽" : (u"狈", ),  # 72FD => 72C8
    u"猙" : (u"狰", ),  # 7319 => 72F0
    u"猛" : (u"勐", ),  # 731B => 52D0
    u"猶" : (u"犹", ),  # 7336 => 72B9
    u"猻" : (u"狲", ),  # 733B => 72F2
    u"獁" : (u"犸", ),  # 7341 => 72B8
    u"獄" : (u"狱", ),  # 7344 => 72F1
    u"獅" : (u"狮", ),  # 7345 => 72EE
    u"獎" : (u"奖", ),  # 734E => 5956
    u"獨" : (u"独", ),  # 7368 => 72EC
    u"獪" : (u"狯", ),  # 736A => 72EF
    u"獫" : (u"猃", ),  # 736B => 7303
    u"獰" : (u"狞", ),  # 7370 => 72DE
    u"獲" : (u"获", ),  # 7372 => 83B7
    u"獵" : (u"猎", ),  # 7375 => 730E
    u"獷" : (u"犷", ),  # 7377 => 72B7
    u"獸" : (u"兽", ),  # 7378 => 517D
    u"獺" : (u"獭", ),  # 737A => 736D
    u"獻" : (u"献", ),  # 737B => 732E
    u"獼" : (u"猕", ),  # 737C => 7315
    u"玀" : (u"猡", ),  # 7380 => 7321
    u"玨" : (u"珏", ),  # 73A8 => 73CF
    u"現" : (u"现", ),  # 73FE => 73B0
    u"琺" : (u"珐", ),  # 743A => 73D0
    u"琿" : (u"珲", ),  # 743F => 73F2
    u"瑉" : (u"珉", ),  # 7449 => 73C9
    u"瑋" : (u"玮", ),  # 744B => 73AE
    u"瑣" : (u"琐", ),  # 7463 => 7410
    u"瑤" : (u"瑶", ),  # 7464 => 7476
    u"瑩" : (u"莹", ),  # 7469 => 83B9
    u"瑪" : (u"玛", ),  # 746A => 739B
    u"瑲" : (u"玱", ),  # 7472 => 73B1
    u"璉" : (u"琏", ),  # 7489 => 740F
    u"璡" : (u"琎", ),  # 74A1 => 740E
    u"璣" : (u"玑", ),  # 74A3 => 7391
    u"璦" : (u"瑷", ),  # 74A6 => 7477
    u"環" : (u"环", ),  # 74B0 => 73AF
    u"璽" : (u"玺", ),  # 74BD => 73BA
    u"璿" : (u"璇", ),  # 74BF => 7487
    u"瓊" : (u"琼", ),  # 74CA => 743C
    u"瓏" : (u"珑", ),  # 74CF => 73D1
    u"瓔" : (u"璎", ),  # 74D4 => 748E
    u"瓚" : (u"瓒", ),  # 74DA => 74D2
    u"甌" : (u"瓯", ),  # 750C => 74EF
    u"甕" : (u"瓮", ),  # 7515 => 74EE
    u"產" : (u"产", ),  # 7522 => 4EA7
    u"産" : (u"产", ),  # 7523 => 4EA7
    u"甯" : (u"宁", ),  # 752F => 5B81
    u"畝" : (u"亩", ),  # 755D => 4EA9
    u"畢" : (u"毕", ),  # 7562 => 6BD5
    u"畫" : (u"画", ),  # 756B => 753B
    u"異" : (u"异", ),  # 7570 => 5F02
    u"當" : (u"当", ),  # 7576 => 5F53
    u"疇" : (u"畴", ),  # 7587 => 7574
    u"疊" : (u"叠", ),  # 758A => 53E0
    u"痙" : (u"痉", ),  # 75D9 => 75C9
    u"瘂" : (u"痖", ),  # 7602 => 75D6
    u"瘋" : (u"疯", ),  # 760B => 75AF
    u"瘍" : (u"疡", ),  # 760D => 75A1
    u"瘓" : (u"痪", ),  # 7613 => 75EA
    u"瘞" : (u"瘗", ),  # 761E => 7617
    u"瘡" : (u"疮", ),  # 7621 => 75AE
    u"瘧" : (u"疟", ),  # 7627 => 759F
    u"瘮" : (u"瘆", ),  # 762E => 7606
    u"瘺" : (u"瘘", ),  # 763A => 7618
    u"瘻" : (u"瘘", ),  # 763B => 7618
    u"療" : (u"疗", ),  # 7642 => 7597
    u"癆" : (u"痨", ),  # 7646 => 75E8
    u"癇" : (u"痫", ),  # 7647 => 75EB
    u"癉" : (u"瘅", ),  # 7649 => 7605
    u"癘" : (u"疠", ),  # 7658 => 75A0
    u"癟" : (u"瘪", ),  # 765F => 762A
    u"癡" : (u"痴", ),  # 7661 => 75F4
    u"癢" : (u"痒", ),  # 7662 => 75D2
    u"癤" : (u"疖", ),  # 7664 => 7596
    u"癥" : (u"症", ),  # 7665 => 75C7
    u"癧" : (u"疬", ),  # 7667 => 75AC
    u"癩" : (u"癞", ),  # 7669 => 765E
    u"癬" : (u"癣", ),  # 766C => 7663
    u"癭" : (u"瘿", ),  # 766D => 763F
    u"癮" : (u"瘾", ),  # 766E => 763E
    u"癰" : (u"痈", ),  # 7670 => 75C8
    u"癱" : (u"瘫", ),  # 7671 => 762B
    u"癲" : (u"癫", ),  # 7672 => 766B
    u"發" : (u"发", ),  # 767C => 53D1
    u"皚" : (u"皑", ),  # 769A => 7691
    u"皰" : (u"疱", ),  # 76B0 => 75B1
    u"皸" : (u"皲", ),  # 76B8 => 76B2
    u"皺" : (u"皱", ),  # 76BA => 76B1
    u"盜" : (u"盗", ),  # 76DC => 76D7
    u"盞" : (u"盏", ),  # 76DE => 76CF
    u"盡" : (u"尽", ),  # 76E1 => 5C3D
    u"監" : (u"监", ),  # 76E3 => 76D1
    u"盤" : (u"盘", ),  # 76E4 => 76D8
    u"盧" : (u"卢", ),  # 76E7 => 5362
    u"眥" : (u"眦", ),  # 7725 => 7726
    u"眾" : (u"众", ),  # 773E => 4F17
    u"睏" : (u"困", ),  # 774F => 56F0
    u"睜" : (u"睁", ),  # 775C => 7741
    u"睞" : (u"睐", ),  # 775E => 7750
    u"瞘" : (u"眍", ),  # 7798 => 770D
    u"瞜" : (u"䁖", ),  # 779C => 4056
    u"瞞" : (u"瞒", ),  # 779E => 7792
    u"瞭" : (u"了", ),  # 77AD => 4E86
    u"瞼" : (u"睑", ),  # 77BC => 7751
    u"矇" : (u"蒙", ),  # 77C7 => 8499
    u"矚" : (u"瞩", ),  # 77DA => 77A9
    u"矯" : (u"矫", ),  # 77EF => 77EB
    u"矽" : (u"硅", ),  # 77FD => 7845
    u"硃" : (u"朱", ),  # 7843 => 6731
    u"硤" : (u"硖", ),  # 7864 => 7856
    u"硨" : (u"砗", ),  # 7868 => 7817
    u"硯" : (u"砚", ),  # 786F => 781A
    u"碩" : (u"硕", ),  # 78A9 => 7855
    u"碭" : (u"砀", ),  # 78AD => 7800
    u"碸" : (u"砜", ),  # 78B8 => 781C
    u"確" : (u"确", ),  # 78BA => 786E
    u"碼" : (u"码", ),  # 78BC => 7801
    u"磑" : (u"硙", ),  # 78D1 => 7859
    u"磚" : (u"砖", ),  # 78DA => 7816
    u"磣" : (u"碜", ),  # 78E3 => 789C
    u"磧" : (u"碛", ),  # 78E7 => 789B
    u"磯" : (u"矶", ),  # 78EF => 77F6
    u"磽" : (u"硗", ),  # 78FD => 7857
    u"礄" : (u"硚", ),  # 7904 => 785A
    u"礎" : (u"础", ),  # 790E => 7840
    u"礙" : (u"碍", ),  # 7919 => 788D
    u"礦" : (u"矿", ),  # 7926 => 77FF
    u"礪" : (u"砺", ),  # 792A => 783A
    u"礫" : (u"砾", ),  # 792B => 783E
    u"礬" : (u"矾", ),  # 792C => 77FE
    u"礱" : (u"砻", ),  # 7931 => 783B
    u"祗" : (u"只", ),  # 7957 => 53EA
    u"祿" : (u"禄", ),  # 797F => 7984
    u"禍" : (u"祸", ),  # 798D => 7978
    u"禎" : (u"祯", ),  # 798E => 796F
    u"禕" : (u"祎", ),  # 7995 => 794E
    u"禦" : (u"御", ),  # 79A6 => 5FA1
    u"禪" : (u"禅", ),  # 79AA => 7985
    u"禮" : (u"礼", ),  # 79AE => 793C
    u"禰" : (u"祢", ),  # 79B0 => 7962
    u"禱" : (u"祷", ),  # 79B1 => 7977
    u"禿" : (u"秃", ),  # 79BF => 79C3
    u"秈" : (u"籼", ),  # 79C8 => 7C7C
    u"稅" : (u"税", ),  # 7A05 => 7A0E
    u"稈" : (u"秆", ),  # 7A08 => 79C6
    u"稟" : (u"禀", ),  # 7A1F => 7980
    u"種" : (u"种", ),  # 7A2E => 79CD
    u"稱" : (u"称", ),  # 7A31 => 79F0
    u"穇" : (u"䅟", ),  # 7A47 => 415F
    u"穌" : (u"稣", ),  # 7A4C => 7A23
    u"積" : (u"积", ),  # 7A4D => 79EF
    u"穎" : (u"颖", ),  # 7A4E => 9896
    u"穡" : (u"穑", ),  # 7A61 => 7A51
    u"穢" : (u"秽", ),  # 7A62 => 79FD
    u"穩" : (u"稳", ),  # 7A69 => 7A33
    u"穫" : (u"获", ),  # 7A6B => 83B7
    u"穭" : (u"稆", ),  # 7A6D => 7A06
    u"窩" : (u"窝", ),  # 7AA9 => 7A9D
    u"窪" : (u"洼", ),  # 7AAA => 6D3C
    u"窮" : (u"穷", ),  # 7AAE => 7A77
    u"窯" : (u"窑", ),  # 7AAF => 7A91
    u"窵" : (u"窎", ),  # 7AB5 => 7A8E
    u"窶" : (u"窭", ),  # 7AB6 => 7AAD
    u"窺" : (u"窥", ),  # 7ABA => 7AA5
    u"竄" : (u"窜", ),  # 7AC4 => 7A9C
    u"竅" : (u"窍", ),  # 7AC5 => 7A8D
    u"竇" : (u"窦", ),  # 7AC7 => 7AA6
    u"竈" : (u"灶", ),  # 7AC8 => 7076
    u"竊" : (u"窃", ),  # 7ACA => 7A83
    u"竪" : (u"竖", ),  # 7AEA => 7AD6
    u"競" : (u"竞", ),  # 7AF6 => 7ADE
    u"筆" : (u"笔", ),  # 7B46 => 7B14
    u"筍" : (u"笋", ),  # 7B4D => 7B0B
    u"筧" : (u"笕", ),  # 7B67 => 7B15
    u"箋" : (u"笺", ),  # 7B8B => 7B3A
    u"箏" : (u"筝", ),  # 7B8F => 7B5D
    u"節" : (u"节", ),  # 7BC0 => 8282
    u"範" : (u"范", ),  # 7BC4 => 8303
    u"築" : (u"筑", ),  # 7BC9 => 7B51
    u"篋" : (u"箧", ),  # 7BCB => 7BA7
    u"篤" : (u"笃", ),  # 7BE4 => 7B03
    u"篩" : (u"筛", ),  # 7BE9 => 7B5B
    u"篳" : (u"筚", ),  # 7BF3 => 7B5A
    u"簀" : (u"箦", ),  # 7C00 => 7BA6
    u"簍" : (u"篓", ),  # 7C0D => 7BD3
    u"簞" : (u"箪", ),  # 7C1E => 7BAA
    u"簡" : (u"简", ),  # 7C21 => 7B80
    u"簣" : (u"篑", ),  # 7C23 => 7BD1
    u"簫" : (u"箫", ),  # 7C2B => 7BAB
    u"簷" : (u"檐", ),  # 7C37 => 6A90
    u"簽" : (u"签", ),  # 7C3D => 7B7E
    u"簾" : (u"帘", ),  # 7C3E => 5E18
    u"籃" : (u"篮", ),  # 7C43 => 7BEE
    u"籌" : (u"筹", ),  # 7C4C => 7B79
    u"籙" : (u"箓", ),  # 7C59 => 7B93
    u"籜" : (u"箨", ),  # 7C5C => 7BA8
    u"籟" : (u"籁", ),  # 7C5F => 7C41
    u"籠" : (u"笼", ),  # 7C60 => 7B3C
    u"籤" : (u"签", ),  # 7C64 => 7B7E
    u"籩" : (u"笾", ),  # 7C69 => 7B3E
    u"籪" : (u"簖", ),  # 7C6A => 7C16
    u"籬" : (u"篱", ),  # 7C6C => 7BF1
    u"籮" : (u"箩", ),  # 7C6E => 7BA9
    u"籲" : (u"吁", ),  # 7C72 => 5401
    u"粵" : (u"粤", ),  # 7CB5 => 7CA4
    u"糊" : (u"煳", ),  # 7CCA => 7173
    u"糝" : (u"糁", ),  # 7CDD => 7CC1
    u"糞" : (u"粪", ),  # 7CDE => 7CAA
    u"糧" : (u"粮", ),  # 7CE7 => 7CAE
    u"糰" : (u"团", ),  # 7CF0 => 56E2
    u"糲" : (u"粝", ),  # 7CF2 => 7C9D
    u"糴" : (u"籴", ),  # 7CF4 => 7C74
    u"糶" : (u"粜", ),  # 7CF6 => 7C9C
    u"糸" : (u"纟", ),  # 7CF8 => 7E9F
    u"糾" : (u"纠", ),  # 7CFE => 7EA0
    u"紀" : (u"纪", ),  # 7D00 => 7EAA
    u"紂" : (u"纣", ),  # 7D02 => 7EA3
    u"約" : (u"约", ),  # 7D04 => 7EA6
    u"紅" : (u"红", ),  # 7D05 => 7EA2
    u"紆" : (u"纡", ),  # 7D06 => 7EA1
    u"紇" : (u"纥", ),  # 7D07 => 7EA5
    u"紈" : (u"纨", ),  # 7D08 => 7EA8
    u"紉" : (u"纫", ),  # 7D09 => 7EAB
    u"紋" : (u"纹", ),  # 7D0B => 7EB9
    u"納" : (u"纳", ),  # 7D0D => 7EB3
    u"紐" : (u"纽", ),  # 7D10 => 7EBD
    u"紓" : (u"纾", ),  # 7D13 => 7EBE
    u"純" : (u"纯", ),  # 7D14 => 7EAF
    u"紕" : (u"纰", ),  # 7D15 => 7EB0
    u"紖" : (u"纼", ),  # 7D16 => 7EBC
    u"紗" : (u"纱", ),  # 7D17 => 7EB1
    u"紙" : (u"纸", ),  # 7D19 => 7EB8
    u"級" : (u"级", ),  # 7D1A => 7EA7
    u"紛" : (u"纷", ),  # 7D1B => 7EB7
    u"紜" : (u"纭", ),  # 7D1C => 7EAD
    u"紝" : (u"纴", ),  # 7D1D => 7EB4
    u"紡" : (u"纺", ),  # 7D21 => 7EBA
    u"紬" : (u"䌷", ),  # 7D2C => 4337
    u"紮" : (u"扎", ),  # 7D2E => 624E
    u"細" : (u"细", ),  # 7D30 => 7EC6
    u"紱" : (u"绂", ),  # 7D31 => 7EC2
    u"紲" : (u"绁", ),  # 7D32 => 7EC1
    u"紳" : (u"绅", ),  # 7D33 => 7EC5
    u"紹" : (u"绍", ),  # 7D39 => 7ECD
    u"紺" : (u"绀", ),  # 7D3A => 7EC0
    u"紼" : (u"绋", ),  # 7D3C => 7ECB
    u"紿" : (u"绐", ),  # 7D3F => 7ED0
    u"絀" : (u"绌", ),  # 7D40 => 7ECC
    u"終" : (u"终", ),  # 7D42 => 7EC8
    u"組" : (u"组", ),  # 7D44 => 7EC4
    u"絆" : (u"绊", ),  # 7D46 => 7ECA
    u"絎" : (u"绗", ),  # 7D4E => 7ED7
    u"絏" : (u"绁", ),  # 7D4F => 7EC1
    u"結" : (u"结", ),  # 7D50 => 7ED3
    u"絕" : (u"绝", ),  # 7D55 => 7EDD
    u"絛" : (u"绦", ),  # 7D5B => 7EE6
    u"絝" : (u"绔", ),  # 7D5D => 7ED4
    u"絞" : (u"绞", ),  # 7D5E => 7EDE
    u"絡" : (u"络", ),  # 7D61 => 7EDC
    u"絢" : (u"绚", ),  # 7D62 => 7EDA
    u"給" : (u"给", ),  # 7D66 => 7ED9
    u"絨" : (u"绒", ),  # 7D68 => 7ED2
    u"絰" : (u"绖", ),  # 7D70 => 7ED6
    u"統" : (u"统", ),  # 7D71 => 7EDF
    u"絲" : (u"丝", ),  # 7D72 => 4E1D
    u"絳" : (u"绛", ),  # 7D73 => 7EDB
    u"絶" : (u"绝", ),  # 7D76 => 7EDD
    u"絹" : (u"绢", ),  # 7D79 => 7EE2
    u"綁" : (u"绑", ),  # 7D81 => 7ED1
    u"綃" : (u"绡", ),  # 7D83 => 7EE1
    u"綆" : (u"绠", ),  # 7D86 => 7EE0
    u"綈" : (u"绨", ),  # 7D88 => 7EE8
    u"綉" : (u"绣", ),  # 7D89 => 7EE3
    u"綏" : (u"绥", ),  # 7D8F => 7EE5
    u"經" : (u"经", ),  # 7D93 => 7ECF
    u"綜" : (u"综", ),  # 7D9C => 7EFC
    u"綞" : (u"缍", ),  # 7D9E => 7F0D
    u"綠" : (u"绿", ),  # 7DA0 => 7EFF
    u"綢" : (u"绸", ),  # 7DA2 => 7EF8
    u"綣" : (u"绻", ),  # 7DA3 => 7EFB
    u"綫" : (u"线", ),  # 7DAB => 7EBF
    u"綬" : (u"绶", ),  # 7DAC => 7EF6
    u"維" : (u"维", ),  # 7DAD => 7EF4
    u"綰" : (u"绾", ),  # 7DB0 => 7EFE
    u"綱" : (u"纲", ),  # 7DB1 => 7EB2
    u"網" : (u"网", ),  # 7DB2 => 7F51
    u"綳" : (u"绷", ),  # 7DB3 => 7EF7
    u"綴" : (u"缀", ),  # 7DB4 => 7F00
    u"綸" : (u"纶", ),  # 7DB8 => 7EB6
    u"綹" : (u"绺", ),  # 7DB9 => 7EFA
    u"綺" : (u"绮", ),  # 7DBA => 7EEE
    u"綻" : (u"绽", ),  # 7DBB => 7EFD
    u"綽" : (u"绰", ),  # 7DBD => 7EF0
    u"綾" : (u"绫", ),  # 7DBE => 7EEB
    u"綿" : (u"绵", ),  # 7DBF => 7EF5
    u"緄" : (u"绲", ),  # 7DC4 => 7EF2
    u"緇" : (u"缁", ),  # 7DC7 => 7F01
    u"緊" : (u"紧", ),  # 7DCA => 7D27
    u"緋" : (u"绯", ),  # 7DCB => 7EEF
    u"緑" : (u"绿", ),  # 7DD1 => 7EFF
    u"緒" : (u"绪", ),  # 7DD2 => 7EEA
    u"緔" : (u"绱", ),  # 7DD4 => 7EF1
    u"緗" : (u"缃", ),  # 7DD7 => 7F03
    u"緘" : (u"缄", ),  # 7DD8 => 7F04
    u"緙" : (u"缂", ),  # 7DD9 => 7F02
    u"線" : (u"线", ),  # 7DDA => 7EBF
    u"緝" : (u"缉", ),  # 7DDD => 7F09
    u"緞" : (u"缎", ),  # 7DDE => 7F0E
    u"締" : (u"缔", ),  # 7DE0 => 7F14
    u"緡" : (u"缗", ),  # 7DE1 => 7F17
    u"緣" : (u"缘", ),  # 7DE3 => 7F18
    u"緦" : (u"缌", ),  # 7DE6 => 7F0C
    u"編" : (u"编", ),  # 7DE8 => 7F16
    u"緩" : (u"缓", ),  # 7DE9 => 7F13
    u"緬" : (u"缅", ),  # 7DEC => 7F05
    u"緯" : (u"纬", ),  # 7DEF => 7EAC
    u"緱" : (u"缑", ),  # 7DF1 => 7F11
    u"緲" : (u"缈", ),  # 7DF2 => 7F08
    u"練" : (u"练", ),  # 7DF4 => 7EC3
    u"緶" : (u"缏", ),  # 7DF6 => 7F0F
    u"緹" : (u"缇", ),  # 7DF9 => 7F07
    u"緻" : (u"致", ),  # 7DFB => 81F4
    u"緼" : (u"缊", ),  # 7DFC => 7F0A
    u"縈" : (u"萦", ),  # 7E08 => 8426
    u"縉" : (u"缙", ),  # 7E09 => 7F19
    u"縊" : (u"缢", ),  # 7E0A => 7F22
    u"縋" : (u"缒", ),  # 7E0B => 7F12
    u"縐" : (u"绉", ),  # 7E10 => 7EC9
    u"縑" : (u"缣", ),  # 7E11 => 7F23
    u"縗" : (u"缞", ),  # 7E17 => 7F1E
    u"縛" : (u"缚", ),  # 7E1B => 7F1A
    u"縝" : (u"缜", ),  # 7E1D => 7F1C
    u"縞" : (u"缟", ),  # 7E1E => 7F1F
    u"縟" : (u"缛", ),  # 7E1F => 7F1B
    u"縣" : (u"县", ),  # 7E23 => 53BF
    u"縧" : (u"绦", ),  # 7E27 => 7EE6
    u"縫" : (u"缝", ),  # 7E2B => 7F1D
    u"縭" : (u"缡", ),  # 7E2D => 7F21
    u"縮" : (u"缩", ),  # 7E2E => 7F29
    u"縱" : (u"纵", ),  # 7E31 => 7EB5
    u"縲" : (u"缧", ),  # 7E32 => 7F27
    u"縴" : (u"纤", ),  # 7E34 => 7EA4
    u"縵" : (u"缦", ),  # 7E35 => 7F26
    u"縶" : (u"絷", ),  # 7E36 => 7D77
    u"縷" : (u"缕", ),  # 7E37 => 7F15
    u"縹" : (u"缥", ),  # 7E39 => 7F25
    u"總" : (u"总", ),  # 7E3D => 603B
    u"績" : (u"绩", ),  # 7E3E => 7EE9
    u"繃" : (u"绷", ),  # 7E43 => 7EF7
    u"繅" : (u"缫", ),  # 7E45 => 7F2B
    u"繆" : (u"缪", ),  # 7E46 => 7F2A
    u"繈" : (u"襁", ),  # 7E48 => 8941
    u"繒" : (u"缯", ),  # 7E52 => 7F2F
    u"織" : (u"织", ),  # 7E54 => 7EC7
    u"繕" : (u"缮", ),  # 7E55 => 7F2E
    u"繚" : (u"缭", ),  # 7E5A => 7F2D
    u"繞" : (u"绕", ),  # 7E5E => 7ED5
    u"繡" : (u"绣", ),  # 7E61 => 7EE3
    u"繢" : (u"缋", ),  # 7E62 => 7F0B
    u"繩" : (u"绳", ),  # 7E69 => 7EF3
    u"繪" : (u"绘", ),  # 7E6A => 7ED8
    u"繫" : (u"系", ),  # 7E6B => 7CFB
    u"繭" : (u"茧", ),  # 7E6D => 8327
    u"繮" : (u"缰", ),  # 7E6E => 7F30
    u"繯" : (u"缳", ),  # 7E6F => 7F33
    u"繰" : (u"缲", ),  # 7E70 => 7F32
    u"繳" : (u"缴", ),  # 7E73 => 7F34
    u"繹" : (u"绎", ),  # 7E79 => 7ECE
    u"繼" : (u"继", ),  # 7E7C => 7EE7
    u"繽" : (u"缤", ),  # 7E7D => 7F24
    u"繾" : (u"缱", ),  # 7E7E => 7F31
    u"纈" : (u"缬", ),  # 7E88 => 7F2C
    u"纊" : (u"纩", ),  # 7E8A => 7EA9
    u"續" : (u"续", ),  # 7E8C => 7EED
    u"纍" : (u"累", ),  # 7E8D => 7D2F
    u"纏" : (u"缠", ),  # 7E8F => 7F20
    u"纓" : (u"缨", ),  # 7E93 => 7F28
    u"纔" : (u"才", ),  # 7E94 => 624D
    u"纖" : (u"纤", ),  # 7E96 => 7EA4
    u"纘" : (u"缵", ),  # 7E98 => 7F35
    u"纜" : (u"缆", ),  # 7E9C => 7F06
    u"缽" : (u"钵", ),  # 7F3D => 94B5
    u"罌" : (u"罂", ),  # 7F4C => 7F42
    u"罎" : (u"坛", ),  # 7F4E => 575B
    u"罰" : (u"罚", ),  # 7F70 => 7F5A
    u"罵" : (u"骂", ),  # 7F75 => 9A82
    u"罷" : (u"罢", ),  # 7F77 => 7F62
    u"罸" : (u"罚", ),  # 7F78 => 7F5A
    u"羅" : (u"罗", ),  # 7F85 => 7F57
    u"羆" : (u"罴", ),  # 7F86 => 7F74
    u"羈" : (u"羁", ),  # 7F88 => 7F81
    u"羋" : (u"芈", ),  # 7F8B => 8288
    u"羥" : (u"羟", ),  # 7FA5 => 7F9F
    u"羨" : (u"羡", ),  # 7FA8 => 7FA1
    u"義" : (u"义", ),  # 7FA9 => 4E49
    u"習" : (u"习", ),  # 7FD2 => 4E60
    u"翬" : (u"翚", ),  # 7FEC => 7FDA
    u"翹" : (u"翘", ),  # 7FF9 => 7FD8
    u"耬" : (u"耧", ),  # 802C => 8027
    u"耮" : (u"耢", ),  # 802E => 8022
    u"聖" : (u"圣", ),  # 8056 => 5723
    u"聞" : (u"闻", ),  # 805E => 95FB
    u"聯" : (u"联", ),  # 806F => 8054
    u"聰" : (u"聪", ),  # 8070 => 806A
    u"聲" : (u"声", ),  # 8072 => 58F0
    u"聳" : (u"耸", ),  # 8073 => 8038
    u"聵" : (u"聩", ),  # 8075 => 8069
    u"聶" : (u"聂", ),  # 8076 => 8042
    u"職" : (u"职", ),  # 8077 => 804C
    u"聹" : (u"聍", ),  # 8079 => 804D
    u"聽" : (u"听", ),  # 807D => 542C
    u"聾" : (u"聋", ),  # 807E => 804B
    u"肅" : (u"肃", ),  # 8085 => 8083
    u"脅" : (u"胁", ),  # 8105 => 80C1
    u"脈" : (u"脉", ),  # 8108 => 8109
    u"脊" : (u"嵴", ),  # 810A => 5D74
    u"脛" : (u"胫", ),  # 811B => 80EB
    u"脫" : (u"脱", ),  # 812B => 8131
    u"脹" : (u"胀", ),  # 8139 => 80C0
    u"腎" : (u"肾", ),  # 814E => 80BE
    u"腖" : (u"胨", ),  # 8156 => 80E8
    u"腡" : (u"脶", ),  # 8161 => 8136
    u"腦" : (u"脑", ),  # 8166 => 8111
    u"腫" : (u"肿", ),  # 816B => 80BF
    u"腳" : (u"脚", ),  # 8173 => 811A
    u"腸" : (u"肠", ),  # 8178 => 80A0
    u"膁" : (u"肷", ),  # 8181 => 80B7
    u"膃" : (u"腽", ),  # 8183 => 817D
    u"膕" : (u"腘", ),  # 8195 => 8158
    u"膚" : (u"肤", ),  # 819A => 80A4
    u"膞" : (u"䏝", ),  # 819E => 43DD
    u"膠" : (u"胶", ),  # 81A0 => 80F6
    u"膩" : (u"腻", ),  # 81A9 => 817B
    u"膽" : (u"胆", ),  # 81BD => 80C6
    u"膾" : (u"脍", ),  # 81BE => 810D
    u"膿" : (u"脓", ),  # 81BF => 8113
    u"臉" : (u"脸", ),  # 81C9 => 8138
    u"臍" : (u"脐", ),  # 81CD => 8110
    u"臏" : (u"膑", ),  # 81CF => 8191
    u"臒" : (u"癯", ),  # 81D2 => 766F
    u"臓" : (u"赃", ),  # 81D3 => 8D43
    u"臘" : (u"腊", ),  # 81D8 => 814A
    u"臚" : (u"胪", ),  # 81DA => 80EA
    u"臠" : (u"脔", ),  # 81E0 => 8114
    u"臢" : (u"臜", ),  # 81E2 => 81DC
    u"臥" : (u"卧", ),  # 81E5 => 5367
    u"臨" : (u"临", ),  # 81E8 => 4E34
    u"臺" : (u"台", ),  # 81FA => 53F0
    u"與" : (u"与", ),  # 8207 => 4E0E
    u"興" : (u"兴", ),  # 8208 => 5174
    u"舉" : (u"举", ),  # 8209 => 4E3E
    u"舊" : (u"旧", ),  # 820A => 65E7
    u"艙" : (u"舱", ),  # 8259 => 8231
    u"艤" : (u"舣", ),  # 8264 => 8223
    u"艦" : (u"舰", ),  # 8266 => 8230
    u"艫" : (u"舻", ),  # 826B => 823B
    u"艱" : (u"艰", ),  # 8271 => 8270
    u"艶" : (u"艳", ),  # 8276 => 8273
    u"艸" : (u"艹", ),  # 8278 => 8279
    u"芻" : (u"刍", ),  # 82BB => 520D
    u"苧" : (u"苎", ),  # 82E7 => 82CE
    u"茲" : (u"兹", ),  # 8332 => 5179
    u"荊" : (u"荆", ),  # 834A => 8346
    u"莊" : (u"庄", ),  # 838A => 5E84
    u"莖" : (u"茎", ),  # 8396 => 830E
    u"莢" : (u"荚", ),  # 83A2 => 835A
    u"莧" : (u"苋", ),  # 83A7 => 82CB
    u"華" : (u"华", ),  # 83EF => 534E
    u"萇" : (u"苌", ),  # 8407 => 82CC
    u"萊" : (u"莱", ),  # 840A => 83B1
    u"萬" : (u"万", ),  # 842C => 4E07
    u"萵" : (u"莴", ),  # 8435 => 83B4
    u"葉" : (u"叶", ),  # 8449 => 53F6
    u"葒" : (u"荭", ),  # 8452 => 836D
    u"著" : (u"着", ),  # 8457 => 7740
    u"葤" : (u"荮", ),  # 8464 => 836E
    u"葦" : (u"苇", ),  # 8466 => 82C7
    u"葷" : (u"荤", ),  # 8477 => 8364
    u"蒓" : (u"莼", ),  # 8493 => 83BC
    u"蒔" : (u"莳", ),  # 8494 => 83B3
    u"蒞" : (u"莅", ),  # 849E => 8385
    u"蒼" : (u"苍", ),  # 84BC => 82CD
    u"蓀" : (u"荪", ),  # 84C0 => 836A
    u"蓋" : (u"盖", ),  # 84CB => 76D6
    u"蓧" : (u"莜", ),  # 84E7 => 839C
    u"蓮" : (u"莲", ),  # 84EE => 83B2
    u"蓯" : (u"苁", ),  # 84EF => 82C1
    u"蓴" : (u"莼", ),  # 84F4 => 83BC
    u"蓽" : (u"荜", ),  # 84FD => 835C
    u"蔔" : (u"卜", ),  # 8514 => 535C
    u"蔞" : (u"蒌", ),  # 851E => 848C
    u"蔣" : (u"蒋", ),  # 8523 => 848B
    u"蔥" : (u"葱", ),  # 8525 => 8471
    u"蔦" : (u"茑", ),  # 8526 => 8311
    u"蔭" : (u"荫", ),  # 852D => 836B
    u"蕁" : (u"荨", ),  # 8541 => 8368
    u"蕆" : (u"蒇", ),  # 8546 => 8487
    u"蕎" : (u"荞", ),  # 854E => 835E
    u"蕒" : (u"荬", ),  # 8552 => 836C
    u"蕓" : (u"芸", ),  # 8553 => 82B8
    u"蕕" : (u"莸", ),  # 8555 => 83B8
    u"蕘" : (u"荛", ),  # 8558 => 835B
    u"蕢" : (u"蒉", ),  # 8562 => 8489
    u"蕩" : (u"荡", ),  # 8569 => 8361
    u"蕪" : (u"芜", ),  # 856A => 829C
    u"蕭" : (u"萧", ),  # 856D => 8427
    u"蕷" : (u"蓣", ),  # 8577 => 84E3
    u"薈" : (u"荟", ),  # 8588 => 835F
    u"薊" : (u"蓟", ),  # 858A => 84DF
    u"薌" : (u"芗", ),  # 858C => 8297
    u"薑" : (u"姜", ),  # 8591 => 59DC
    u"薔" : (u"蔷", ),  # 8594 => 8537
    u"薟" : (u"莶", ),  # 859F => 83B6
    u"薦" : (u"荐", ),  # 85A6 => 8350
    u"薩" : (u"萨", ),  # 85A9 => 8428
    u"薺" : (u"荠", ),  # 85BA => 8360
    u"藉" : (u"借", ),  # 85C9 => 501F
    u"藍" : (u"蓝", ),  # 85CD => 84DD
    u"藎" : (u"荩", ),  # 85CE => 8369
    u"藝" : (u"艺", ),  # 85DD => 827A
    u"藥" : (u"药", ),  # 85E5 => 836F
    u"藪" : (u"薮", ),  # 85EA => 85AE
    u"藭" : (u"䓖", ),  # 85ED => 44D6
    u"藴" : (u"蕴", ),  # 85F4 => 8574
    u"藶" : (u"苈", ),  # 85F6 => 82C8
    u"藹" : (u"蔼", ),  # 85F9 => 853C
    u"藺" : (u"蔺", ),  # 85FA => 853A
    u"蘀" : (u"萚", ),  # 8600 => 841A
    u"蘄" : (u"蕲", ),  # 8604 => 8572
    u"蘆" : (u"芦", ),  # 8606 => 82A6
    u"蘇" : (u"苏", ),  # 8607 => 82CF
    u"蘊" : (u"蕴", ),  # 860A => 8574
    u"蘋" : (u"苹", ),  # 860B => 82F9
    u"蘚" : (u"藓", ),  # 861A => 85D3
    u"蘞" : (u"蔹", ),  # 861E => 8539
    u"蘢" : (u"茏", ),  # 8622 => 830F
    u"蘭" : (u"兰", ),  # 862D => 5170
    u"蘺" : (u"蓠", ),  # 863A => 84E0
    u"蘿" : (u"萝", ),  # 863F => 841D
    u"處" : (u"处", ),  # 8655 => 5904
    u"虛" : (u"虚", ),  # 865B => 865A
    u"虜" : (u"虏", ),  # 865C => 864F
    u"號" : (u"号", ),  # 865F => 53F7
    u"虧" : (u"亏", ),  # 8667 => 4E8F
    u"虯" : (u"虬", ),  # 866F => 866C
    u"蛺" : (u"蛱", ),  # 86FA => 86F1
    u"蛻" : (u"蜕", ),  # 86FB => 8715
    u"蜆" : (u"蚬", ),  # 8706 => 86AC
    u"蝕" : (u"蚀", ),  # 8755 => 8680
    u"蝟" : (u"猬", ),  # 875F => 732C
    u"蝦" : (u"虾", ),  # 8766 => 867E
    u"蝸" : (u"蜗", ),  # 8778 => 8717
    u"螄" : (u"蛳", ),  # 8784 => 86F3
    u"螞" : (u"蚂", ),  # 879E => 8682
    u"螢" : (u"萤", ),  # 87A2 => 8424
    u"螻" : (u"蝼", ),  # 87BB => 877C
    u"蟄" : (u"蛰", ),  # 87C4 => 86F0
    u"蟈" : (u"蝈", ),  # 87C8 => 8748
    u"蟎" : (u"螨", ),  # 87CE => 87A8
    u"蟣" : (u"虮", ),  # 87E3 => 866E
    u"蟬" : (u"蝉", ),  # 87EC => 8749
    u"蟯" : (u"蛲", ),  # 87EF => 86F2
    u"蟲" : (u"虫", ),  # 87F2 => 866B
    u"蟶" : (u"蛏", ),  # 87F6 => 86CF
    u"蟻" : (u"蚁", ),  # 87FB => 8681
    u"蠅" : (u"蝇", ),  # 8805 => 8747
    u"蠆" : (u"虿", ),  # 8806 => 867F
    u"蠍" : (u"蝎", ),  # 880D => 874E
    u"蠐" : (u"蛴", ),  # 8810 => 86F4
    u"蠑" : (u"蝾", ),  # 8811 => 877E
    u"蠔" : (u"蚝", ),  # 8814 => 869D
    u"蠟" : (u"蜡", ),  # 881F => 8721
    u"蠣" : (u"蛎", ),  # 8823 => 86CE
    u"蠨" : (u"蟏", ),  # 8828 => 87CF
    u"蠱" : (u"蛊", ),  # 8831 => 86CA
    u"蠶" : (u"蚕", ),  # 8836 => 8695
    u"蠻" : (u"蛮", ),  # 883B => 86EE
    u"衆" : (u"众", ),  # 8846 => 4F17
    u"衊" : (u"蔑", ),  # 884A => 8511
    u"術" : (u"术", ),  # 8853 => 672F
    u"衛" : (u"卫", ),  # 885B => 536B
    u"衝" : (u"冲", ),  # 885D => 51B2
    u"衹" : (u"只", ),  # 8879 => 53EA
    u"袞" : (u"衮", ),  # 889E => 886E
    u"裊" : (u"袅", ),  # 88CA => 8885
    u"裏" : (u"里", ),  # 88CF => 91CC
    u"補" : (u"补", ),  # 88DC => 8865
    u"裝" : (u"装", ),  # 88DD => 88C5
    u"製" : (u"制", ),  # 88FD => 5236
    u"複" : (u"复", ),  # 8907 => 590D
    u"褲" : (u"裤", ),  # 8932 => 88E4
    u"褳" : (u"裢", ),  # 8933 => 88E2
    u"褸" : (u"褛", ),  # 8938 => 891B
    u"褻" : (u"亵", ),  # 893B => 4EB5
    u"襆" : (u"幞", ),  # 8946 => 5E5E
    u"襇" : (u"裥", ),  # 8947 => 88E5
    u"襖" : (u"袄", ),  # 8956 => 8884
    u"襝" : (u"裣", ),  # 895D => 88E3
    u"襠" : (u"裆", ),  # 8960 => 88C6
    u"襤" : (u"褴", ),  # 8964 => 8934
    u"襪" : (u"袜", ),  # 896A => 889C
    u"襬" : (u"摆", ),  # 896C => 6446
    u"襯" : (u"衬", ),  # 896F => 886C
    u"襲" : (u"袭", ),  # 8972 => 88AD
    u"覊" : (u"羁", ),  # 898A => 7F81
    u"見" : (u"见", ),  # 898B => 89C1
    u"覎" : (u"觃", ),  # 898E => 89C3
    u"規" : (u"规", ),  # 898F => 89C4
    u"覓" : (u"觅", ),  # 8993 => 89C5
    u"視" : (u"视", ),  # 8996 => 89C6
    u"覘" : (u"觇", ),  # 8998 => 89C7
    u"覡" : (u"觋", ),  # 89A1 => 89CB
    u"覦" : (u"觎", ),  # 89A6 => 89CE
    u"覧" : (u"览", ),  # 89A7 => 89C8
    u"親" : (u"亲", ),  # 89AA => 4EB2
    u"覬" : (u"觊", ),  # 89AC => 89CA
    u"覯" : (u"觏", ),  # 89AF => 89CF
    u"覲" : (u"觐", ),  # 89B2 => 89D0
    u"覷" : (u"觑", ),  # 89B7 => 89D1
    u"覺" : (u"觉", ),  # 89BA => 89C9
    u"覽" : (u"览", ),  # 89BD => 89C8
    u"覿" : (u"觌", ),  # 89BF => 89CC
    u"觀" : (u"观", ),  # 89C0 => 89C2
    u"觴" : (u"觞", ),  # 89F4 => 89DE
    u"觶" : (u"觯", ),  # 89F6 => 89EF
    u"觸" : (u"触", ),  # 89F8 => 89E6
    u"訁" : (u"讠", ),  # 8A01 => 8BA0
    u"訂" : (u"订", ),  # 8A02 => 8BA2
    u"訃" : (u"讣", ),  # 8A03 => 8BA3
    u"計" : (u"计", ),  # 8A08 => 8BA1
    u"訊" : (u"讯", ),  # 8A0A => 8BAF
    u"訌" : (u"讧", ),  # 8A0C => 8BA7
    u"討" : (u"讨", ),  # 8A0E => 8BA8
    u"訐" : (u"讦", ),  # 8A10 => 8BA6
    u"訓" : (u"训", ),  # 8A13 => 8BAD
    u"訕" : (u"讪", ),  # 8A15 => 8BAA
    u"訖" : (u"讫", ),  # 8A16 => 8BAB
    u"記" : (u"记", ),  # 8A18 => 8BB0
    u"訛" : (u"讹", ),  # 8A1B => 8BB9
    u"訝" : (u"讶", ),  # 8A1D => 8BB6
    u"訟" : (u"讼", ),  # 8A1F => 8BBC
    u"訢" : (u"䜣", ),  # 8A22 => 4723
    u"訣" : (u"诀", ),  # 8A23 => 8BC0
    u"訥" : (u"讷", ),  # 8A25 => 8BB7
    u"訩" : (u"讻", ),  # 8A29 => 8BBB
    u"訪" : (u"访", ),  # 8A2A => 8BBF
    u"設" : (u"设", ),  # 8A2D => 8BBE
    u"許" : (u"许", ),  # 8A31 => 8BB8
    u"訴" : (u"诉", ),  # 8A34 => 8BC9
    u"訶" : (u"诃", ),  # 8A36 => 8BC3
    u"診" : (u"诊", ),  # 8A3A => 8BCA
    u"詁" : (u"诂", ),  # 8A41 => 8BC2
    u"詆" : (u"诋", ),  # 8A46 => 8BCB
    u"詎" : (u"讵", ),  # 8A4E => 8BB5
    u"詐" : (u"诈", ),  # 8A50 => 8BC8
    u"詒" : (u"诒", ),  # 8A52 => 8BD2
    u"詔" : (u"诏", ),  # 8A54 => 8BCF
    u"評" : (u"评", ),  # 8A55 => 8BC4
    u"詗" : (u"诇", ),  # 8A57 => 8BC7
    u"詘" : (u"诎", ),  # 8A58 => 8BCE
    u"詛" : (u"诅", ),  # 8A5B => 8BC5
    u"詞" : (u"词", ),  # 8A5E => 8BCD
    u"詠" : (u"咏", ),  # 8A60 => 548F
    u"詡" : (u"诩", ),  # 8A61 => 8BE9
    u"詢" : (u"询", ),  # 8A62 => 8BE2
    u"詣" : (u"诣", ),  # 8A63 => 8BE3
    u"試" : (u"试", ),  # 8A66 => 8BD5
    u"詩" : (u"诗", ),  # 8A69 => 8BD7
    u"詫" : (u"诧", ),  # 8A6B => 8BE7
    u"詬" : (u"诟", ),  # 8A6C => 8BDF
    u"詭" : (u"诡", ),  # 8A6D => 8BE1
    u"詮" : (u"诠", ),  # 8A6E => 8BE0
    u"詰" : (u"诘", ),  # 8A70 => 8BD8
    u"話" : (u"话", ),  # 8A71 => 8BDD
    u"該" : (u"该", ),  # 8A72 => 8BE5
    u"詳" : (u"详", ),  # 8A73 => 8BE6
    u"詵" : (u"诜", ),  # 8A75 => 8BDC
    u"詼" : (u"诙", ),  # 8A7C => 8BD9
    u"詿" : (u"诖", ),  # 8A7F => 8BD6
    u"誄" : (u"诔", ),  # 8A84 => 8BD4
    u"誅" : (u"诛", ),  # 8A85 => 8BDB
    u"誆" : (u"诓", ),  # 8A86 => 8BD3
    u"誇" : (u"夸", ),  # 8A87 => 5938
    u"認" : (u"认", ),  # 8A8D => 8BA4
    u"誑" : (u"诳", ),  # 8A91 => 8BF3
    u"誒" : (u"诶", ),  # 8A92 => 8BF6
    u"誕" : (u"诞", ),  # 8A95 => 8BDE
    u"誘" : (u"诱", ),  # 8A98 => 8BF1
    u"誚" : (u"诮", ),  # 8A9A => 8BEE
    u"語" : (u"语", ),  # 8A9E => 8BED
    u"誠" : (u"诚", ),  # 8AA0 => 8BDA
    u"誡" : (u"诫", ),  # 8AA1 => 8BEB
    u"誣" : (u"诬", ),  # 8AA3 => 8BEC
    u"誤" : (u"误", ),  # 8AA4 => 8BEF
    u"誥" : (u"诰", ),  # 8AA5 => 8BF0
    u"誦" : (u"诵", ),  # 8AA6 => 8BF5
    u"誨" : (u"诲", ),  # 8AA8 => 8BF2
    u"說" : (u"说", ),  # 8AAA => 8BF4
    u"説" : (u"说", ),  # 8AAC => 8BF4
    u"誰" : (u"谁", ),  # 8AB0 => 8C01
    u"課" : (u"课", ),  # 8AB2 => 8BFE
    u"誶" : (u"谇", ),  # 8AB6 => 8C07
    u"誹" : (u"诽", ),  # 8AB9 => 8BFD
    u"誼" : (u"谊", ),  # 8ABC => 8C0A
    u"調" : (u"调", ),  # 8ABF => 8C03
    u"諂" : (u"谄", ),  # 8AC2 => 8C04
    u"諄" : (u"谆", ),  # 8AC4 => 8C06
    u"談" : (u"谈", ),  # 8AC7 => 8C08
    u"諉" : (u"诿", ),  # 8AC9 => 8BFF
    u"請" : (u"请", ),  # 8ACB => 8BF7
    u"諍" : (u"诤", ),  # 8ACD => 8BE4
    u"諏" : (u"诹", ),  # 8ACF => 8BF9
    u"諑" : (u"诼", ),  # 8AD1 => 8BFC
    u"諒" : (u"谅", ),  # 8AD2 => 8C05
    u"論" : (u"论", ),  # 8AD6 => 8BBA
    u"諗" : (u"谂", ),  # 8AD7 => 8C02
    u"諛" : (u"谀", ),  # 8ADB => 8C00
    u"諜" : (u"谍", ),  # 8ADC => 8C0D
    u"諝" : (u"谞", ),  # 8ADD => 8C1E
    u"諞" : (u"谝", ),  # 8ADE => 8C1D
    u"諡" : (u"谥", ),  # 8AE1 => 8C25
    u"諢" : (u"诨", ),  # 8AE2 => 8BE8
    u"諤" : (u"谔", ),  # 8AE4 => 8C14
    u"諦" : (u"谛", ),  # 8AE6 => 8C1B
    u"諧" : (u"谐", ),  # 8AE7 => 8C10
    u"諫" : (u"谏", ),  # 8AEB => 8C0F
    u"諭" : (u"谕", ),  # 8AED => 8C15
    u"諮" : (u"谘", ),  # 8AEE => 8C18
    u"諱" : (u"讳", ),  # 8AF1 => 8BB3
    u"諳" : (u"谙", ),  # 8AF3 => 8C19
    u"諶" : (u"谌", ),  # 8AF6 => 8C0C
    u"諷" : (u"讽", ),  # 8AF7 => 8BBD
    u"諸" : (u"诸", ),  # 8AF8 => 8BF8
    u"諺" : (u"谚", ),  # 8AFA => 8C1A
    u"諼" : (u"谖", ),  # 8AFC => 8C16
    u"諾" : (u"诺", ),  # 8AFE => 8BFA
    u"謀" : (u"谋", ),  # 8B00 => 8C0B
    u"謁" : (u"谒", ),  # 8B01 => 8C12
    u"謂" : (u"谓", ),  # 8B02 => 8C13
    u"謄" : (u"誊", ),  # 8B04 => 8A8A
    u"謅" : (u"诌", ),  # 8B05 => 8BCC
    u"謊" : (u"谎", ),  # 8B0A => 8C0E
    u"謎" : (u"谜", ),  # 8B0E => 8C1C
    u"謐" : (u"谧", ),  # 8B10 => 8C27
    u"謔" : (u"嚯", u"谑"),  # 8B14 => 56AF 8C11
    u"謖" : (u"谡", ),  # 8B16 => 8C21
    u"謗" : (u"谤", ),  # 8B17 => 8C24
    u"謙" : (u"谦", ),  # 8B19 => 8C26
    u"謚" : (u"谥", ),  # 8B1A => 8C25
    u"講" : (u"讲", ),  # 8B1B => 8BB2
    u"謝" : (u"谢", ),  # 8B1D => 8C22
    u"謠" : (u"谣", ),  # 8B20 => 8C23
    u"謡" : (u"谣", ),  # 8B21 => 8C23
    u"謨" : (u"谟", ),  # 8B28 => 8C1F
    u"謫" : (u"谪", ),  # 8B2B => 8C2A
    u"謬" : (u"谬", ),  # 8B2C => 8C2C
    u"謳" : (u"讴", ),  # 8B33 => 8BB4
    u"謹" : (u"谨", ),  # 8B39 => 8C28
    u"謾" : (u"谩", ),  # 8B3E => 8C29
    u"證" : (u"证", ),  # 8B49 => 8BC1
    u"譎" : (u"谲", ),  # 8B4E => 8C32
    u"譏" : (u"讥", ),  # 8B4F => 8BA5
    u"譖" : (u"谮", ),  # 8B56 => 8C2E
    u"識" : (u"识", ),  # 8B58 => 8BC6
    u"譙" : (u"谯", ),  # 8B59 => 8C2F
    u"譚" : (u"谭", ),  # 8B5A => 8C2D
    u"譜" : (u"谱", ),  # 8B5C => 8C31
    u"譫" : (u"谵", ),  # 8B6B => 8C35
    u"譯" : (u"译", ),  # 8B6F => 8BD1
    u"議" : (u"议", ),  # 8B70 => 8BAE
    u"譴" : (u"谴", ),  # 8B74 => 8C34
    u"護" : (u"护", ),  # 8B77 => 62A4
    u"譽" : (u"誉", ),  # 8B7D => 8A89
    u"譾" : (u"谫", ),  # 8B7E => 8C2B
    u"讀" : (u"读", ),  # 8B80 => 8BFB
    u"讅" : (u"谉", ),  # 8B85 => 8C09
    u"變" : (u"变", ),  # 8B8A => 53D8
    u"讌" : (u"䜩", ),  # 8B8C => 4729
    u"讎" : (u"雠", ),  # 8B8E => 96E0
    u"讒" : (u"谗", ),  # 8B92 => 8C17
    u"讓" : (u"让", ),  # 8B93 => 8BA9
    u"讕" : (u"谰", ),  # 8B95 => 8C30
    u"讖" : (u"谶", ),  # 8B96 => 8C36
    u"讜" : (u"谠", ),  # 8B9C => 8C20
    u"讞" : (u"谳", ),  # 8B9E => 8C33
    u"豈" : (u"岂", ),  # 8C48 => 5C82
    u"豎" : (u"竖", ),  # 8C4E => 7AD6
    u"豐" : (u"丰", ),  # 8C50 => 4E30
    u"豔" : (u"艳", ),  # 8C54 => 8273
    u"豬" : (u"猪", ),  # 8C6C => 732A
    u"豶" : (u"豮", ),  # 8C76 => 8C6E
    u"貓" : (u"猫", ),  # 8C93 => 732B
    u"貝" : (u"贝", ),  # 8C9D => 8D1D
    u"貞" : (u"贞", ),  # 8C9E => 8D1E
    u"負" : (u"负", ),  # 8CA0 => 8D1F
    u"財" : (u"财", ),  # 8CA1 => 8D22
    u"貢" : (u"贡", ),  # 8CA2 => 8D21
    u"貧" : (u"贫", ),  # 8CA7 => 8D2B
    u"貨" : (u"货", ),  # 8CA8 => 8D27
    u"販" : (u"贩", ),  # 8CA9 => 8D29
    u"貪" : (u"贪", ),  # 8CAA => 8D2A
    u"貫" : (u"贯", ),  # 8CAB => 8D2F
    u"責" : (u"责", ),  # 8CAC => 8D23
    u"貯" : (u"贮", ),  # 8CAF => 8D2E
    u"貰" : (u"贳", ),  # 8CB0 => 8D33
    u"貲" : (u"赀", ),  # 8CB2 => 8D40
    u"貳" : (u"贰", ),  # 8CB3 => 8D30
    u"貴" : (u"贵", ),  # 8CB4 => 8D35
    u"貶" : (u"贬", ),  # 8CB6 => 8D2C
    u"買" : (u"买", ),  # 8CB7 => 4E70
    u"貸" : (u"贷", ),  # 8CB8 => 8D37
    u"貺" : (u"贶", ),  # 8CBA => 8D36
    u"費" : (u"费", ),  # 8CBB => 8D39
    u"貼" : (u"贴", ),  # 8CBC => 8D34
    u"貽" : (u"贻", ),  # 8CBD => 8D3B
    u"貿" : (u"贸", ),  # 8CBF => 8D38
    u"賀" : (u"贺", ),  # 8CC0 => 8D3A
    u"賁" : (u"贲", ),  # 8CC1 => 8D32
    u"賂" : (u"赂", ),  # 8CC2 => 8D42
    u"賃" : (u"赁", ),  # 8CC3 => 8D41
    u"賄" : (u"贿", ),  # 8CC4 => 8D3F
    u"賅" : (u"赅", ),  # 8CC5 => 8D45
    u"資" : (u"资", ),  # 8CC7 => 8D44
    u"賈" : (u"贾", ),  # 8CC8 => 8D3E
    u"賊" : (u"贼", ),  # 8CCA => 8D3C
    u"賑" : (u"赈", ),  # 8CD1 => 8D48
    u"賒" : (u"赊", ),  # 8CD2 => 8D4A
    u"賓" : (u"宾", ),  # 8CD3 => 5BBE
    u"賕" : (u"赇", ),  # 8CD5 => 8D47
    u"賙" : (u"赒", ),  # 8CD9 => 8D52
    u"賚" : (u"赉", ),  # 8CDA => 8D49
    u"賜" : (u"赐", ),  # 8CDC => 8D50
    u"賞" : (u"赏", ),  # 8CDE => 8D4F
    u"賠" : (u"赔", ),  # 8CE0 => 8D54
    u"賡" : (u"赓", ),  # 8CE1 => 8D53
    u"賢" : (u"贤", ),  # 8CE2 => 8D24
    u"賣" : (u"卖", ),  # 8CE3 => 5356
    u"賤" : (u"贱", ),  # 8CE4 => 8D31
    u"賦" : (u"赋", ),  # 8CE6 => 8D4B
    u"賧" : (u"赕", ),  # 8CE7 => 8D55
    u"質" : (u"质", ),  # 8CEA => 8D28
    u"賫" : (u"赍", ),  # 8CEB => 8D4D
    u"賬" : (u"账", ),  # 8CEC => 8D26
    u"賭" : (u"赌", ),  # 8CED => 8D4C
    u"賴" : (u"赖", ),  # 8CF4 => 8D56
    u"賵" : (u"赗", ),  # 8CF5 => 8D57
    u"賺" : (u"赚", ),  # 8CFA => 8D5A
    u"賻" : (u"赙", ),  # 8CFB => 8D59
    u"購" : (u"购", ),  # 8CFC => 8D2D
    u"賽" : (u"赛", ),  # 8CFD => 8D5B
    u"賾" : (u"赜", ),  # 8CFE => 8D5C
    u"贄" : (u"贽", ),  # 8D04 => 8D3D
    u"贅" : (u"赘", ),  # 8D05 => 8D58
    u"贈" : (u"赠", ),  # 8D08 => 8D60
    u"贊" : (u"赞", ),  # 8D0A => 8D5E
    u"贋" : (u"赝", ),  # 8D0B => 8D5D
    u"贍" : (u"赡", ),  # 8D0D => 8D61
    u"贏" : (u"赢", ),  # 8D0F => 8D62
    u"贐" : (u"赆", ),  # 8D10 => 8D46
    u"贓" : (u"赃", ),  # 8D13 => 8D43
    u"贖" : (u"赎", ),  # 8D16 => 8D4E
    u"贗" : (u"赝", ),  # 8D17 => 8D5D
    u"贛" : (u"赣", ),  # 8D1B => 8D63
    u"贜" : (u"脏", ),  # 8D1C => 810F
    u"赬" : (u"赪", ),  # 8D6C => 8D6A
    u"趕" : (u"赶", ),  # 8D95 => 8D76
    u"趙" : (u"赵", ),  # 8D99 => 8D75
    u"趨" : (u"趋", ),  # 8DA8 => 8D8B
    u"趲" : (u"趱", ),  # 8DB2 => 8DB1
    u"跡" : (u"迹", ),  # 8DE1 => 8FF9
    u"踐" : (u"践", ),  # 8E10 => 8DF5
    u"踴" : (u"踊", ),  # 8E34 => 8E0A
    u"蹌" : (u"跄", ),  # 8E4C => 8DC4
    u"蹕" : (u"跸", ),  # 8E55 => 8DF8
    u"蹠" : (u"跖", ),  # 8E60 => 8DD6
    u"蹣" : (u"蹒", ),  # 8E63 => 8E52
    u"蹤" : (u"踪", ),  # 8E64 => 8E2A
    u"蹺" : (u"跷", ),  # 8E7A => 8DF7
    u"躉" : (u"趸", ),  # 8E89 => 8DB8
    u"躊" : (u"踌", ),  # 8E8A => 8E0C
    u"躋" : (u"跻", ),  # 8E8B => 8DFB
    u"躍" : (u"跃", ),  # 8E8D => 8DC3
    u"躑" : (u"踯", ),  # 8E91 => 8E2F
    u"躒" : (u"跞", ),  # 8E92 => 8DDE
    u"躓" : (u"踬", ),  # 8E93 => 8E2C
    u"躕" : (u"蹰", ),  # 8E95 => 8E70
    u"躚" : (u"跹", ),  # 8E9A => 8DF9
    u"躡" : (u"蹑", ),  # 8EA1 => 8E51
    u"躥" : (u"蹿", ),  # 8EA5 => 8E7F
    u"躦" : (u"躜", ),  # 8EA6 => 8E9C
    u"躪" : (u"躏", ),  # 8EAA => 8E8F
    u"軀" : (u"躯", ),  # 8EC0 => 8EAF
    u"車" : (u"车", ),  # 8ECA => 8F66
    u"軋" : (u"轧", ),  # 8ECB => 8F67
    u"軌" : (u"轨", ),  # 8ECC => 8F68
    u"軍" : (u"军", ),  # 8ECD => 519B
    u"軒" : (u"轩", ),  # 8ED2 => 8F69
    u"軔" : (u"轫", ),  # 8ED4 => 8F6B
    u"軛" : (u"轭", ),  # 8EDB => 8F6D
    u"軟" : (u"软", ),  # 8EDF => 8F6F
    u"軤" : (u"轷", ),  # 8EE4 => 8F77
    u"軫" : (u"轸", ),  # 8EEB => 8F78
    u"軲" : (u"轱", ),  # 8EF2 => 8F71
    u"軸" : (u"轴", ),  # 8EF8 => 8F74
    u"軹" : (u"轵", ),  # 8EF9 => 8F75
    u"軺" : (u"轺", ),  # 8EFA => 8F7A
    u"軻" : (u"轲", ),  # 8EFB => 8F72
    u"軼" : (u"轶", ),  # 8EFC => 8F76
    u"軾" : (u"轼", ),  # 8EFE => 8F7C
    u"較" : (u"较", ),  # 8F03 => 8F83
    u"輅" : (u"辂", ),  # 8F05 => 8F82
    u"輇" : (u"辁", ),  # 8F07 => 8F81
    u"載" : (u"载", ),  # 8F09 => 8F7D
    u"輊" : (u"轾", ),  # 8F0A => 8F7E
    u"輒" : (u"辄", ),  # 8F12 => 8F84
    u"輔" : (u"辅", ),  # 8F14 => 8F85
    u"輕" : (u"轻", ),  # 8F15 => 8F7B
    u"輛" : (u"辆", ),  # 8F1B => 8F86
    u"輜" : (u"辎", ),  # 8F1C => 8F8E
    u"輝" : (u"辉", ),  # 8F1D => 8F89
    u"輞" : (u"辋", ),  # 8F1E => 8F8B
    u"輟" : (u"辍", ),  # 8F1F => 8F8D
    u"輥" : (u"辊", ),  # 8F25 => 8F8A
    u"輦" : (u"辇", ),  # 8F26 => 8F87
    u"輩" : (u"辈", ),  # 8F29 => 8F88
    u"輪" : (u"轮", ),  # 8F2A => 8F6E
    u"輯" : (u"辑", ),  # 8F2F => 8F91
    u"輳" : (u"辏", ),  # 8F33 => 8F8F
    u"輸" : (u"输", ),  # 8F38 => 8F93
    u"輻" : (u"辐", ),  # 8F3B => 8F90
    u"輾" : (u"辗", ),  # 8F3E => 8F97
    u"輿" : (u"舆", ),  # 8F3F => 8206
    u"轂" : (u"毂", ),  # 8F42 => 6BC2
    u"轄" : (u"辖", ),  # 8F44 => 8F96
    u"轅" : (u"辕", ),  # 8F45 => 8F95
    u"轆" : (u"辘", ),  # 8F46 => 8F98
    u"轉" : (u"转", ),  # 8F49 => 8F6C
    u"轍" : (u"辙", ),  # 8F4D => 8F99
    u"轎" : (u"轿", ),  # 8F4E => 8F7F
    u"轔" : (u"辚", ),  # 8F54 => 8F9A
    u"轟" : (u"轰", ),  # 8F5F => 8F70
    u"轡" : (u"辔", ),  # 8F61 => 8F94
    u"轢" : (u"轹", ),  # 8F62 => 8F79
    u"轤" : (u"轳", ),  # 8F64 => 8F73
    u"辦" : (u"办", ),  # 8FA6 => 529E
    u"辭" : (u"辞", ),  # 8FAD => 8F9E
    u"辮" : (u"辫", ),  # 8FAE => 8FAB
    u"辯" : (u"辩", ),  # 8FAF => 8FA9
    u"農" : (u"农", ),  # 8FB2 => 519C
    u"迴" : (u"回", ),  # 8FF4 => 56DE
    u"退" : (u"煺", ),  # 9000 => 717A
    u"逕" : (u"迳", ),  # 9015 => 8FF3
    u"這" : (u"这", ),  # 9019 => 8FD9
    u"連" : (u"连", ),  # 9023 => 8FDE
    u"進" : (u"进", ),  # 9032 => 8FDB
    u"運" : (u"运", ),  # 904B => 8FD0
    u"過" : (u"过", ),  # 904E => 8FC7
    u"達" : (u"达", ),  # 9054 => 8FBE
    u"違" : (u"违", ),  # 9055 => 8FDD
    u"遙" : (u"遥", ),  # 9059 => 9065
    u"遜" : (u"逊", ),  # 905C => 900A
    u"遝" : (u"沓", ),  # 905D => 6C93
    u"遞" : (u"递", ),  # 905E => 9012
    u"遠" : (u"远", ),  # 9060 => 8FDC
    u"適" : (u"适", ),  # 9069 => 9002
    u"遲" : (u"迟", ),  # 9072 => 8FDF
    u"遷" : (u"迁", ),  # 9077 => 8FC1
    u"選" : (u"选", ),  # 9078 => 9009
    u"遺" : (u"遗", ),  # 907A => 9057
    u"遼" : (u"辽", ),  # 907C => 8FBD
    u"邁" : (u"迈", ),  # 9081 => 8FC8
    u"還" : (u"还", ),  # 9084 => 8FD8
    u"邇" : (u"迩", ),  # 9087 => 8FE9
    u"邊" : (u"边", ),  # 908A => 8FB9
    u"邏" : (u"逻", ),  # 908F => 903B
    u"邐" : (u"逦", ),  # 9090 => 9026
    u"郟" : (u"郏", ),  # 90DF => 90CF
    u"郤" : (u"郄", ),  # 90E4 => 90C4
    u"郵" : (u"邮", ),  # 90F5 => 90AE
    u"鄆" : (u"郓", ),  # 9106 => 90D3
    u"鄉" : (u"乡", ),  # 9109 => 4E61
    u"鄒" : (u"邹", ),  # 9112 => 90B9
    u"鄔" : (u"邬", ),  # 9114 => 90AC
    u"鄖" : (u"郧", ),  # 9116 => 90E7
    u"鄧" : (u"邓", ),  # 9127 => 9093
    u"鄭" : (u"郑", ),  # 912D => 90D1
    u"鄰" : (u"邻", ),  # 9130 => 90BB
    u"鄲" : (u"郸", ),  # 9132 => 90F8
    u"鄴" : (u"邺", ),  # 9134 => 90BA
    u"鄶" : (u"郐", ),  # 9136 => 90D0
    u"鄺" : (u"邝", ),  # 913A => 909D
    u"酈" : (u"郦", ),  # 9148 => 90E6
    u"醃" : (u"腌", ),  # 9183 => 814C
    u"醖" : (u"酝", ),  # 9196 => 915D
    u"醜" : (u"丑", ),  # 919C => 4E11
    u"醞" : (u"酝", ),  # 919E => 915D
    u"醤" : (u"酱", ),  # 91A4 => 9171
    u"醫" : (u"医", ),  # 91AB => 533B
    u"醬" : (u"酱", ),  # 91AC => 9171
    u"醯" : (u"酰", ),  # 91AF => 9170
    u"釀" : (u"酿", ),  # 91C0 => 917F
    u"釁" : (u"衅", ),  # 91C1 => 8845
    u"釃" : (u"酾", ),  # 91C3 => 917E
    u"釅" : (u"酽", ),  # 91C5 => 917D
    u"釋" : (u"释", ),  # 91CB => 91CA
    u"釓" : (u"钆", ),  # 91D3 => 9486
    u"釔" : (u"钇", ),  # 91D4 => 9487
    u"釕" : (u"钌", ),  # 91D5 => 948C
    u"釗" : (u"钊", ),  # 91D7 => 948A
    u"釘" : (u"钉", ),  # 91D8 => 9489
    u"釙" : (u"钋", ),  # 91D9 => 948B
    u"針" : (u"针", ),  # 91DD => 9488
    u"釣" : (u"钓", ),  # 91E3 => 9493
    u"釤" : (u"钐", ),  # 91E4 => 9490
    u"釧" : (u"钏", ),  # 91E7 => 948F
    u"釩" : (u"钒", ),  # 91E9 => 9492
    u"釵" : (u"钗", ),  # 91F5 => 9497
    u"釷" : (u"钍", ),  # 91F7 => 948D
    u"釹" : (u"钕", ),  # 91F9 => 9495
    u"釺" : (u"钎", ),  # 91FA => 948E
    u"釾" : (u"䥺", ),  # 91FE => 497A
    u"鈀" : (u"钯", ),  # 9200 => 94AF
    u"鈁" : (u"钫", ),  # 9201 => 94AB
    u"鈃" : (u"钘", ),  # 9203 => 9498
    u"鈄" : (u"钭", ),  # 9204 => 94AD
    u"鈈" : (u"钚", ),  # 9208 => 949A
    u"鈉" : (u"钠", ),  # 9209 => 94A0
    u"鈍" : (u"钝", ),  # 920D => 949D
    u"鈎" : (u"钩", ),  # 920E => 94A9
    u"鈐" : (u"钤", ),  # 9210 => 94A4
    u"鈑" : (u"钣", ),  # 9211 => 94A3
    u"鈔" : (u"钞", ),  # 9214 => 949E
    u"鈕" : (u"钮", ),  # 9215 => 94AE
    u"鈞" : (u"钧", ),  # 921E => 94A7
    u"鈣" : (u"钙", ),  # 9223 => 9499
    u"鈥" : (u"钬", ),  # 9225 => 94AC
    u"鈦" : (u"钛", ),  # 9226 => 949B
    u"鈧" : (u"钪", ),  # 9227 => 94AA
    u"鈮" : (u"铌", ),  # 922E => 94CC
    u"鈰" : (u"铈", ),  # 9230 => 94C8
    u"鈳" : (u"钶", ),  # 9233 => 94B6
    u"鈴" : (u"铃", ),  # 9234 => 94C3
    u"鈷" : (u"钴", ),  # 9237 => 94B4
    u"鈸" : (u"钹", ),  # 9238 => 94B9
    u"鈹" : (u"铍", ),  # 9239 => 94CD
    u"鈺" : (u"钰", ),  # 923A => 94B0
    u"鈽" : (u"钸", ),  # 923D => 94B8
    u"鈾" : (u"铀", ),  # 923E => 94C0
    u"鈿" : (u"钿", ),  # 923F => 94BF
    u"鉀" : (u"钾", ),  # 9240 => 94BE
    u"鉈" : (u"铊", ),  # 9248 => 94CA
    u"鉉" : (u"铉", ),  # 9249 => 94C9
    u"鉍" : (u"铋", ),  # 924D => 94CB
    u"鉑" : (u"铂", ),  # 9251 => 94C2
    u"鉕" : (u"钷", ),  # 9255 => 94B7
    u"鉗" : (u"钳", ),  # 9257 => 94B3
    u"鉚" : (u"铆", ),  # 925A => 94C6
    u"鉛" : (u"铅", ),  # 925B => 94C5
    u"鉞" : (u"钺", ),  # 925E => 94BA
    u"鉢" : (u"钵", ),  # 9262 => 94B5
    u"鉤" : (u"钩", ),  # 9264 => 94A9
    u"鉦" : (u"钲", ),  # 9266 => 94B2
    u"鉬" : (u"钼", ),  # 926C => 94BC
    u"鉭" : (u"钽", ),  # 926D => 94BD
    u"鉲" : (u"锎", ),  # 9272 => 950E
    u"鉶" : (u"铏", ),  # 9276 => 94CF
    u"鉸" : (u"铰", ),  # 9278 => 94F0
    u"鉺" : (u"铒", ),  # 927A => 94D2
    u"鉻" : (u"铬", ),  # 927B => 94EC
    u"鉿" : (u"铪", ),  # 927F => 94EA
    u"銀" : (u"银", ),  # 9280 => 94F6
    u"銃" : (u"铳", ),  # 9283 => 94F3
    u"銅" : (u"铜", ),  # 9285 => 94DC
    u"銑" : (u"铣", ),  # 9291 => 94E3
    u"銓" : (u"铨", ),  # 9293 => 94E8
    u"銖" : (u"铢", ),  # 9296 => 94E2
    u"銘" : (u"铭", ),  # 9298 => 94ED
    u"銚" : (u"铫", ),  # 929A => 94EB
    u"銜" : (u"衔", ),  # 929C => 8854
    u"銠" : (u"铑", ),  # 92A0 => 94D1
    u"銣" : (u"铷", ),  # 92A3 => 94F7
    u"銥" : (u"铱", ),  # 92A5 => 94F1
    u"銦" : (u"铟", ),  # 92A6 => 94DF
    u"銨" : (u"铵", ),  # 92A8 => 94F5
    u"銩" : (u"铥", ),  # 92A9 => 94E5
    u"銪" : (u"铕", ),  # 92AA => 94D5
    u"銫" : (u"铯", ),  # 92AB => 94EF
    u"銬" : (u"铐", ),  # 92AC => 94D0
    u"銱" : (u"铞", ),  # 92B1 => 94DE
    u"銳" : (u"锐", ),  # 92B3 => 9510
    u"銷" : (u"销", ),  # 92B7 => 9500
    u"銹" : (u"锈", ),  # 92B9 => 9508
    u"銻" : (u"锑", ),  # 92BB => 9511
    u"銼" : (u"锉", ),  # 92BC => 9509
    u"鋁" : (u"铝", ),  # 92C1 => 94DD
    u"鋂" : (u"镅", ),  # 92C2 => 9545
    u"鋃" : (u"锒", ),  # 92C3 => 9512
    u"鋅" : (u"锌", ),  # 92C5 => 950C
    u"鋇" : (u"钡", ),  # 92C7 => 94A1
    u"鋌" : (u"铤", ),  # 92CC => 94E4
    u"鋏" : (u"铗", ),  # 92CF => 94D7
    u"鋒" : (u"锋", ),  # 92D2 => 950B
    u"鋝" : (u"锊", ),  # 92DD => 950A
    u"鋟" : (u"锓", ),  # 92DF => 9513
    u"鋣" : (u"铘", ),  # 92E3 => 94D8
    u"鋤" : (u"锄", ),  # 92E4 => 9504
    u"鋥" : (u"锃", ),  # 92E5 => 9503
    u"鋦" : (u"锔", ),  # 92E6 => 9514
    u"鋨" : (u"锇", ),  # 92E8 => 9507
    u"鋩" : (u"铓", ),  # 92E9 => 94D3
    u"鋪" : (u"铺", ),  # 92EA => 94FA
    u"鋭" : (u"锐", ),  # 92ED => 9510
    u"鋮" : (u"铖", ),  # 92EE => 94D6
    u"鋯" : (u"锆", ),  # 92EF => 9506
    u"鋰" : (u"锂", ),  # 92F0 => 9502
    u"鋱" : (u"铽", ),  # 92F1 => 94FD
    u"鋶" : (u"锍", ),  # 92F6 => 950D
    u"鋸" : (u"锯", ),  # 92F8 => 952F
    u"鋼" : (u"钢", ),  # 92FC => 94A2
    u"錁" : (u"锞", ),  # 9301 => 951E
    u"錄" : (u"录", ),  # 9304 => 5F55
    u"錆" : (u"锖", ),  # 9306 => 9516
    u"錇" : (u"锫", ),  # 9307 => 952B
    u"錈" : (u"锩", ),  # 9308 => 9529
    u"錐" : (u"锥", ),  # 9310 => 9525
    u"錒" : (u"锕", ),  # 9312 => 9515
    u"錕" : (u"锟", ),  # 9315 => 951F
    u"錘" : (u"锤", ),  # 9318 => 9524
    u"錙" : (u"锱", ),  # 9319 => 9531
    u"錚" : (u"铮", ),  # 931A => 94EE
    u"錛" : (u"锛", ),  # 931B => 951B
    u"錟" : (u"锬", ),  # 931F => 952C
    u"錠" : (u"锭", ),  # 9320 => 952D
    u"錢" : (u"钱", ),  # 9322 => 94B1
    u"錦" : (u"锦", ),  # 9326 => 9526
    u"錨" : (u"锚", ),  # 9328 => 951A
    u"錫" : (u"锡", ),  # 932B => 9521
    u"錮" : (u"锢", ),  # 932E => 9522
    u"錯" : (u"错", ),  # 932F => 9519
    u"録" : (u"录", ),  # 9332 => 5F55
    u"錳" : (u"锰", ),  # 9333 => 9530
    u"錶" : (u"表", ),  # 9336 => 8868
    u"錸" : (u"铼", ),  # 9338 => 94FC
    u"錼" : (u"镎", ),  # 933C => 954E
    u"鍀" : (u"锝", ),  # 9340 => 951D
    u"鍁" : (u"锨", ),  # 9341 => 9528
    u"鍃" : (u"锪", ),  # 9343 => 952A
    u"鍆" : (u"钔", ),  # 9346 => 9494
    u"鍇" : (u"锴", ),  # 9347 => 9534
    u"鍋" : (u"锅", ),  # 934B => 9505
    u"鍍" : (u"镀", ),  # 934D => 9540
    u"鍔" : (u"锷", ),  # 9354 => 9537
    u"鍘" : (u"铡", ),  # 9358 => 94E1
    u"鍚" : (u"钖", ),  # 935A => 9496
    u"鍛" : (u"锻", ),  # 935B => 953B
    u"鍤" : (u"锸", ),  # 9364 => 9538
    u"鍥" : (u"锲", ),  # 9365 => 9532
    u"鍩" : (u"锘", ),  # 9369 => 9518
    u"鍬" : (u"锹", ),  # 936C => 9539
    u"鍰" : (u"锾", ),  # 9370 => 953E
    u"鍵" : (u"键", ),  # 9375 => 952E
    u"鍶" : (u"锶", ),  # 9376 => 9536
    u"鍺" : (u"锗", ),  # 937A => 9517
    u"鍾" : (u"锺", ),  # 937E => 953A
    u"鎂" : (u"镁", ),  # 9382 => 9541
    u"鎄" : (u"锿", ),  # 9384 => 953F
    u"鎇" : (u"镅", ),  # 9387 => 9545
    u"鎊" : (u"镑", ),  # 938A => 9551
    u"鎖" : (u"锁", ),  # 9396 => 9501
    u"鎘" : (u"镉", ),  # 9398 => 9549
    u"鎡" : (u"镃", ),  # 93A1 => 9543
    u"鎢" : (u"钨", ),  # 93A2 => 94A8
    u"鎣" : (u"蓥", ),  # 93A3 => 84E5
    u"鎦" : (u"镏", ),  # 93A6 => 954F
    u"鎧" : (u"铠", ),  # 93A7 => 94E0
    u"鎩" : (u"铩", ),  # 93A9 => 94E9
    u"鎪" : (u"锼", ),  # 93AA => 953C
    u"鎬" : (u"镐", ),  # 93AC => 9550
    u"鎮" : (u"镇", ),  # 93AE => 9547
    u"鎰" : (u"镒", ),  # 93B0 => 9552
    u"鎳" : (u"镍", ),  # 93B3 => 954D
    u"鎵" : (u"镓", ),  # 93B5 => 9553
    u"鎸" : (u"镌", ),  # 93B8 => 954C
    u"鎿" : (u"镎", ),  # 93BF => 954E
    u"鏃" : (u"镞", ),  # 93C3 => 955E
    u"鏇" : (u"旋", u"镟"),  # 93C7 => 65CB 955F
    u"鏈" : (u"链", ),  # 93C8 => 94FE
    u"鏌" : (u"镆", ),  # 93CC => 9546
    u"鏍" : (u"镙", ),  # 93CD => 9559
    u"鏑" : (u"镝", ),  # 93D1 => 955D
    u"鏗" : (u"铿", ),  # 93D7 => 94FF
    u"鏘" : (u"锵", ),  # 93D8 => 9535
    u"鏜" : (u"镗", ),  # 93DC => 9557
    u"鏝" : (u"镘", ),  # 93DD => 9558
    u"鏞" : (u"镛", ),  # 93DE => 955B
    u"鏟" : (u"铲", ),  # 93DF => 94F2
    u"鏡" : (u"镜", ),  # 93E1 => 955C
    u"鏢" : (u"镖", ),  # 93E2 => 9556
    u"鏤" : (u"镂", ),  # 93E4 => 9542
    u"鏨" : (u"錾", ),  # 93E8 => 933E
    u"鏰" : (u"镚", ),  # 93F0 => 955A
    u"鏵" : (u"铧", ),  # 93F5 => 94E7
    u"鏷" : (u"镤", ),  # 93F7 => 9564
    u"鏹" : (u"镪", ),  # 93F9 => 956A
    u"鏺" : (u"䥽", ),  # 93FA => 497D
    u"鏽" : (u"锈", ),  # 93FD => 9508
    u"鐃" : (u"铙", ),  # 9403 => 94D9
    u"鐋" : (u"铴", ),  # 940B => 94F4
    u"鐐" : (u"镣", ),  # 9410 => 9563
    u"鐒" : (u"铹", ),  # 9412 => 94F9
    u"鐓" : (u"镦", ),  # 9413 => 9566
    u"鐔" : (u"镡", ),  # 9414 => 9561
    u"鐘" : (u"钟", ),  # 9418 => 949F
    u"鐙" : (u"镫", ),  # 9419 => 956B
    u"鐝" : (u"镢", ),  # 941D => 9562
    u"鐠" : (u"镨", ),  # 9420 => 9568
    u"鐥" : (u"䦅", ),  # 9425 => 4985
    u"鐦" : (u"锎", ),  # 9426 => 950E
    u"鐧" : (u"锏", ),  # 9427 => 950F
    u"鐨" : (u"镄", ),  # 9428 => 9544
    u"鐫" : (u"镌", ),  # 942B => 954C
    u"鐮" : (u"镰", ),  # 942E => 9570
    u"鐯" : (u"䦃", ),  # 942F => 4983
    u"鐲" : (u"镯", ),  # 9432 => 956F
    u"鐳" : (u"镭", ),  # 9433 => 956D
    u"鐵" : (u"铁", ),  # 9435 => 94C1
    u"鐶" : (u"镮", ),  # 9436 => 956E
    u"鐸" : (u"铎", ),  # 9438 => 94CE
    u"鐺" : (u"铛", ),  # 943A => 94DB
    u"鐿" : (u"镱", ),  # 943F => 9571
    u"鑄" : (u"铸", ),  # 9444 => 94F8
    u"鑊" : (u"镬", ),  # 944A => 956C
    u"鑌" : (u"镔", ),  # 944C => 9554
    u"鑒" : (u"鉴", ),  # 9452 => 9274
    u"鑔" : (u"镲", ),  # 9454 => 9572
    u"鑕" : (u"锧", ),  # 9455 => 9527
    u"鑞" : (u"镴", ),  # 945E => 9574
    u"鑠" : (u"铄", ),  # 9460 => 94C4
    u"鑣" : (u"镳", ),  # 9463 => 9573
    u"鑥" : (u"镥", ),  # 9465 => 9565
    u"鑭" : (u"镧", ),  # 946D => 9567
    u"鑰" : (u"钥", ),  # 9470 => 94A5
    u"鑲" : (u"镶", ),  # 9472 => 9576
    u"鑷" : (u"镊", ),  # 9477 => 954A
    u"鑹" : (u"镩", ),  # 9479 => 9569
    u"鑼" : (u"锣", ),  # 947C => 9523
    u"鑽" : (u"钻", ),  # 947D => 94BB
    u"鑾" : (u"銮", ),  # 947E => 92AE
    u"鑿" : (u"凿", ),  # 947F => 51FF
    u"钁" : (u"䦆", u"镢"),  # 9481 => 4986 9562
    u"钂" : (u"镋", ),  # 9482 => 954B
    u"镟" : (u"碹", ),  # 955F => 78B9
    u"長" : (u"长", ),  # 9577 => 957F
    u"門" : (u"门", ),  # 9580 => 95E8
    u"閂" : (u"闩", ),  # 9582 => 95E9
    u"閃" : (u"闪", ),  # 9583 => 95EA
    u"閆" : (u"闫", ),  # 9586 => 95EB
    u"閉" : (u"闭", ),  # 9589 => 95ED
    u"開" : (u"开", ),  # 958B => 5F00
    u"閌" : (u"闶", ),  # 958C => 95F6
    u"閎" : (u"闳", ),  # 958E => 95F3
    u"閏" : (u"闰", ),  # 958F => 95F0
    u"閑" : (u"闲", ),  # 9591 => 95F2
    u"間" : (u"间", ),  # 9593 => 95F4
    u"閔" : (u"闵", ),  # 9594 => 95F5
    u"閘" : (u"闸", ),  # 9598 => 95F8
    u"閙" : (u"闹", ),  # 9599 => 95F9
    u"閡" : (u"阂", ),  # 95A1 => 9602
    u"閣" : (u"阁", ),  # 95A3 => 9601
    u"閤" : (u"合", ),  # 95A4 => 5408
    u"閥" : (u"阀", ),  # 95A5 => 9600
    u"閨" : (u"闺", ),  # 95A8 => 95FA
    u"閩" : (u"闽", ),  # 95A9 => 95FD
    u"閫" : (u"阃", ),  # 95AB => 9603
    u"閬" : (u"阆", ),  # 95AC => 9606
    u"閭" : (u"闾", ),  # 95AD => 95FE
    u"閱" : (u"阅", ),  # 95B1 => 9605
    u"閲" : (u"阅", ),  # 95B2 => 9605
    u"閶" : (u"阊", ),  # 95B6 => 960A
    u"閹" : (u"阉", ),  # 95B9 => 9609
    u"閻" : (u"阎", ),  # 95BB => 960E
    u"閼" : (u"阏", ),  # 95BC => 960F
    u"閽" : (u"阍", ),  # 95BD => 960D
    u"閾" : (u"阈", ),  # 95BE => 9608
    u"閿" : (u"阌", ),  # 95BF => 960C
    u"闃" : (u"阒", ),  # 95C3 => 9612
    u"闆" : (u"板", ),  # 95C6 => 677F
    u"闈" : (u"闱", ),  # 95C8 => 95F1
    u"闊" : (u"阔", ),  # 95CA => 9614
    u"闋" : (u"阕", ),  # 95CB => 9615
    u"闌" : (u"阑", ),  # 95CC => 9611
    u"闐" : (u"阗", ),  # 95D0 => 9617
    u"闓" : (u"闿", ),  # 95D3 => 95FF
    u"闔" : (u"阖", ),  # 95D4 => 9616
    u"闕" : (u"阙", ),  # 95D5 => 9619
    u"闖" : (u"闯", ),  # 95D6 => 95EF
    u"關" : (u"关", ),  # 95DC => 5173
    u"闞" : (u"阚", ),  # 95DE => 961A
    u"闡" : (u"阐", ),  # 95E1 => 9610
    u"闢" : (u"辟", ),  # 95E2 => 8F9F
    u"闥" : (u"闼", ),  # 95E5 => 95FC
    u"阪" : (u"坂", ),  # 962A => 5742
    u"陘" : (u"陉", ),  # 9658 => 9649
    u"陝" : (u"陕", ),  # 965D => 9655
    u"陣" : (u"阵", ),  # 9663 => 9635
    u"陰" : (u"阴", ),  # 9670 => 9634
    u"陳" : (u"陈", ),  # 9673 => 9648
    u"陸" : (u"陆", ),  # 9678 => 9646
    u"陽" : (u"阳", ),  # 967D => 9633
    u"隉" : (u"陧", ),  # 9689 => 9667
    u"隊" : (u"队", ),  # 968A => 961F
    u"階" : (u"阶", ),  # 968E => 9636
    u"隕" : (u"陨", ),  # 9695 => 9668
    u"際" : (u"际", ),  # 969B => 9645
    u"隨" : (u"随", ),  # 96A8 => 968F
    u"險" : (u"险", ),  # 96AA => 9669
    u"隱" : (u"隐", ),  # 96B1 => 9690
    u"隴" : (u"陇", ),  # 96B4 => 9647
    u"隷" : (u"隶", ),  # 96B7 => 96B6
    u"隸" : (u"隶", ),  # 96B8 => 96B6
    u"隻" : (u"只", ),  # 96BB => 53EA
    u"雋" : (u"隽", ),  # 96CB => 96BD
    u"雖" : (u"虽", ),  # 96D6 => 867D
    u"雙" : (u"双", ),  # 96D9 => 53CC
    u"雛" : (u"雏", ),  # 96DB => 96CF
    u"雜" : (u"杂", ),  # 96DC => 6742
    u"雞" : (u"鸡", ),  # 96DE => 9E21
    u"離" : (u"离", ),  # 96E2 => 79BB
    u"難" : (u"难", ),  # 96E3 => 96BE
    u"雲" : (u"云", ),  # 96F2 => 4E91
    u"電" : (u"电", ),  # 96FB => 7535
    u"霧" : (u"雾", ),  # 9727 => 96FE
    u"霽" : (u"霁", ),  # 973D => 9701
    u"靂" : (u"雳", ),  # 9742 => 96F3
    u"靄" : (u"霭", ),  # 9744 => 972D
    u"靆" : (u"叇", ),  # 9746 => 53C7
    u"靈" : (u"灵", ),  # 9748 => 7075
    u"靉" : (u"叆", ),  # 9749 => 53C6
    u"靚" : (u"靓", ),  # 975A => 9753
    u"靜" : (u"静", ),  # 975C => 9759
    u"靦" : (u"腼", ),  # 9766 => 817C
    u"靨" : (u"靥", ),  # 9768 => 9765
    u"鞀" : (u"鼗", ),  # 9780 => 9F17
    u"鞏" : (u"巩", ),  # 978F => 5DE9
    u"鞦" : (u"秋", ),  # 97A6 => 79CB
    u"鞽" : (u"鞒", ),  # 97BD => 9792
    u"韁" : (u"缰", ),  # 97C1 => 7F30
    u"韃" : (u"鞑", ),  # 97C3 => 9791
    u"韆" : (u"千", ),  # 97C6 => 5343
    u"韉" : (u"鞯", ),  # 97C9 => 97AF
    u"韋" : (u"韦", ),  # 97CB => 97E6
    u"韌" : (u"韧", ),  # 97CC => 97E7
    u"韍" : (u"韨", ),  # 97CD => 97E8
    u"韓" : (u"韩", ),  # 97D3 => 97E9
    u"韙" : (u"韪", ),  # 97D9 => 97EA
    u"韜" : (u"韬", ),  # 97DC => 97EC
    u"韝" : (u"鞴", ),  # 97DD => 97B4
    u"韞" : (u"韫", ),  # 97DE => 97EB
    u"韻" : (u"韵", ),  # 97FB => 97F5
    u"響" : (u"响", ),  # 97FF => 54CD
    u"頁" : (u"页", ),  # 9801 => 9875
    u"頂" : (u"顶", ),  # 9802 => 9876
    u"頃" : (u"顷", ),  # 9803 => 9877
    u"項" : (u"项", ),  # 9805 => 9879
    u"順" : (u"顺", ),  # 9806 => 987A
    u"頇" : (u"顸", ),  # 9807 => 9878
    u"須" : (u"须", ),  # 9808 => 987B
    u"頊" : (u"顼", ),  # 980A => 987C
    u"頌" : (u"颂", ),  # 980C => 9882
    u"頎" : (u"颀", ),  # 980E => 9880
    u"頏" : (u"颃", ),  # 980F => 9883
    u"預" : (u"预", ),  # 9810 => 9884
    u"頑" : (u"顽", ),  # 9811 => 987D
    u"頒" : (u"颁", ),  # 9812 => 9881
    u"頓" : (u"顿", ),  # 9813 => 987F
    u"頗" : (u"颇", ),  # 9817 => 9887
    u"領" : (u"领", ),  # 9818 => 9886
    u"頜" : (u"颌", ),  # 981C => 988C
    u"頡" : (u"颉", ),  # 9821 => 9889
    u"頤" : (u"颐", ),  # 9824 => 9890
    u"頦" : (u"颏", ),  # 9826 => 988F
    u"頭" : (u"头", ),  # 982D => 5934
    u"頰" : (u"颊", ),  # 9830 => 988A
    u"頲" : (u"颋", ),  # 9832 => 988B
    u"頷" : (u"颔", ),  # 9837 => 9894
    u"頸" : (u"颈", ),  # 9838 => 9888
    u"頹" : (u"颓", ),  # 9839 => 9893
    u"頻" : (u"频", ),  # 983B => 9891
    u"頽" : (u"颓", ),  # 983D => 9893
    u"顆" : (u"颗", ),  # 9846 => 9897
    u"題" : (u"题", ),  # 984C => 9898
    u"額" : (u"额", ),  # 984D => 989D
    u"顎" : (u"颚", ),  # 984E => 989A
    u"顏" : (u"颜", ),  # 984F => 989C
    u"顒" : (u"颙", ),  # 9852 => 9899
    u"顓" : (u"颛", ),  # 9853 => 989B
    u"顔" : (u"颜", ),  # 9854 => 989C
    u"願" : (u"愿", ),  # 9858 => 613F
    u"顙" : (u"颡", ),  # 9859 => 98A1
    u"顛" : (u"颠", ),  # 985B => 98A0
    u"類" : (u"类", ),  # 985E => 7C7B
    u"顢" : (u"颟", ),  # 9862 => 989F
    u"顥" : (u"颢", ),  # 9865 => 98A2
    u"顧" : (u"顾", ),  # 9867 => 987E
    u"顫" : (u"颤", ),  # 986B => 98A4
    u"顬" : (u"颥", ),  # 986C => 98A5
    u"顯" : (u"显", ),  # 986F => 663E
    u"顰" : (u"颦", ),  # 9870 => 98A6
    u"顱" : (u"颅", ),  # 9871 => 9885
    u"顳" : (u"颞", ),  # 9873 => 989E
    u"顴" : (u"颧", ),  # 9874 => 98A7
    u"風" : (u"风", ),  # 98A8 => 98CE
    u"颮" : (u"飑", ),  # 98AE => 98D1
    u"颯" : (u"飒", ),  # 98AF => 98D2
    u"颱" : (u"台", ),  # 98B1 => 53F0
    u"颳" : (u"刮", ),  # 98B3 => 522E
    u"颶" : (u"飓", ),  # 98B6 => 98D3
    u"颸" : (u"飔", ),  # 98B8 => 98D4
    u"颼" : (u"飕", ),  # 98BC => 98D5
    u"飀" : (u"飗", ),  # 98C0 => 98D7
    u"飄" : (u"飘", ),  # 98C4 => 98D8
    u"飆" : (u"飙", u"飚"),  # 98C6 => 98D9 98DA
    u"飛" : (u"飞", ),  # 98DB => 98DE
    u"飥" : (u"饦", ),  # 98E5 => 9966
    u"飩" : (u"饨", ),  # 98E9 => 9968
    u"飪" : (u"饪", ),  # 98EA => 996A
    u"飫" : (u"饫", ),  # 98EB => 996B
    u"飭" : (u"饬", ),  # 98ED => 996C
    u"飯" : (u"饭", ),  # 98EF => 996D
    u"飲" : (u"饮", ),  # 98F2 => 996E
    u"飴" : (u"饴", ),  # 98F4 => 9974
    u"飼" : (u"饲", ),  # 98FC => 9972
    u"飽" : (u"饱", ),  # 98FD => 9971
    u"飾" : (u"饰", ),  # 98FE => 9970
    u"飿" : (u"饳", ),  # 98FF => 9973
    u"餃" : (u"饺", ),  # 9903 => 997A
    u"餄" : (u"饸", ),  # 9904 => 9978
    u"餅" : (u"饼", ),  # 9905 => 997C
    u"餉" : (u"饷", ),  # 9909 => 9977
    u"養" : (u"养", ),  # 990A => 517B
    u"餌" : (u"饵", ),  # 990C => 9975
    u"餎" : (u"饹", ),  # 990E => 9979
    u"餏" : (u"饻", ),  # 990F => 997B
    u"餑" : (u"饽", ),  # 9911 => 997D
    u"餒" : (u"馁", ),  # 9912 => 9981
    u"餓" : (u"饿", ),  # 9913 => 997F
    u"餘" : (u"余", u"馀"),  # 9918 => 4F59 9980
    u"餛" : (u"馄", ),  # 991B => 9984
    u"餜" : (u"馃", ),  # 991C => 9983
    u"餞" : (u"饯", ),  # 991E => 996F
    u"餠" : (u"饼", ),  # 9920 => 997C
    u"餡" : (u"馅", ),  # 9921 => 9985
    u"館" : (u"馆", ),  # 9928 => 9986
    u"餱" : (u"糇", ),  # 9931 => 7CC7
    u"餳" : (u"饧", ),  # 9933 => 9967
    u"餶" : (u"馉", ),  # 9936 => 9989
    u"餷" : (u"馇", ),  # 9937 => 9987
    u"餺" : (u"馎", ),  # 993A => 998E
    u"餼" : (u"饩", ),  # 993C => 9969
    u"餾" : (u"馏", ),  # 993E => 998F
    u"餿" : (u"馊", ),  # 993F => 998A
    u"饃" : (u"馍", ),  # 9943 => 998D
    u"饅" : (u"馒", ),  # 9945 => 9992
    u"饈" : (u"馐", ),  # 9948 => 9990
    u"饉" : (u"馑", ),  # 9949 => 9991
    u"饊" : (u"馓", ),  # 994A => 9993
    u"饋" : (u"馈", ),  # 994B => 9988
    u"饌" : (u"馔", ),  # 994C => 9994
    u"饑" : (u"饥", ),  # 9951 => 9965
    u"饒" : (u"饶", ),  # 9952 => 9976
    u"饗" : (u"飨", ),  # 9957 => 98E8
    u"饜" : (u"餍", ),  # 995C => 990D
    u"饞" : (u"馋", ),  # 995E => 998B
    u"饟" : (u"馕", ),  # 995F => 9995
    u"饢" : (u"馕", ),  # 9962 => 9995
    u"馬" : (u"马", ),  # 99AC => 9A6C
    u"馭" : (u"驭", ),  # 99AD => 9A6D
    u"馮" : (u"冯", ),  # 99AE => 51AF
    u"馱" : (u"驮", ),  # 99B1 => 9A6E
    u"馳" : (u"驰", ),  # 99B3 => 9A70
    u"馴" : (u"驯", ),  # 99B4 => 9A6F
    u"駁" : (u"驳", ),  # 99C1 => 9A73
    u"駐" : (u"驻", ),  # 99D0 => 9A7B
    u"駑" : (u"驽", ),  # 99D1 => 9A7D
    u"駒" : (u"驹", ),  # 99D2 => 9A79
    u"駔" : (u"驵", ),  # 99D4 => 9A75
    u"駕" : (u"驾", ),  # 99D5 => 9A7E
    u"駘" : (u"骀", ),  # 99D8 => 9A80
    u"駙" : (u"驸", ),  # 99D9 => 9A78
    u"駛" : (u"驶", ),  # 99DB => 9A76
    u"駝" : (u"驼", ),  # 99DD => 9A7C
    u"駟" : (u"驷", ),  # 99DF => 9A77
    u"駡" : (u"骂", ),  # 99E1 => 9A82
    u"駢" : (u"骈", ),  # 99E2 => 9A88
    u"駭" : (u"骇", ),  # 99ED => 9A87
    u"駱" : (u"骆", ),  # 99F1 => 9A86
    u"駸" : (u"骎", ),  # 99F8 => 9A8E
    u"駿" : (u"骏", ),  # 99FF => 9A8F
    u"騁" : (u"骋", ),  # 9A01 => 9A8B
    u"騅" : (u"骓", ),  # 9A05 => 9A93
    u"騍" : (u"骒", ),  # 9A0D => 9A92
    u"騎" : (u"骑", ),  # 9A0E => 9A91
    u"騏" : (u"骐", ),  # 9A0F => 9A90
    u"騖" : (u"骛", ),  # 9A16 => 9A9B
    u"騙" : (u"骗", ),  # 9A19 => 9A97
    u"騫" : (u"骞", ),  # 9A2B => 9A9E
    u"騭" : (u"骘", ),  # 9A2D => 9A98
    u"騮" : (u"骝", ),  # 9A2E => 9A9D
    u"騰" : (u"腾", ),  # 9A30 => 817E
    u"騶" : (u"驺", ),  # 9A36 => 9A7A
    u"騷" : (u"骚", ),  # 9A37 => 9A9A
    u"騸" : (u"骟", ),  # 9A38 => 9A9F
    u"騾" : (u"骡", ),  # 9A3E => 9AA1
    u"驀" : (u"蓦", ),  # 9A40 => 84E6
    u"驁" : (u"骜", ),  # 9A41 => 9A9C
    u"驂" : (u"骖", ),  # 9A42 => 9A96
    u"驃" : (u"骠", ),  # 9A43 => 9AA0
    u"驄" : (u"骢", ),  # 9A44 => 9AA2
    u"驅" : (u"驱", ),  # 9A45 => 9A71
    u"驊" : (u"骅", ),  # 9A4A => 9A85
    u"驍" : (u"骁", ),  # 9A4D => 9A81
    u"驏" : (u"骣", ),  # 9A4F => 9AA3
    u"驕" : (u"骄", ),  # 9A55 => 9A84
    u"驗" : (u"验", ),  # 9A57 => 9A8C
    u"驚" : (u"惊", ),  # 9A5A => 60CA
    u"驛" : (u"驿", ),  # 9A5B => 9A7F
    u"驟" : (u"骤", ),  # 9A5F => 9AA4
    u"驢" : (u"驴", ),  # 9A62 => 9A74
    u"驤" : (u"骧", ),  # 9A64 => 9AA7
    u"驥" : (u"骥", ),  # 9A65 => 9AA5
    u"驪" : (u"骊", ),  # 9A6A => 9A8A
    u"骯" : (u"肮", ),  # 9AAF => 80AE
    u"髏" : (u"髅", ),  # 9ACF => 9AC5
    u"髒" : (u"脏", ),  # 9AD2 => 810F
    u"體" : (u"体", ),  # 9AD4 => 4F53
    u"髕" : (u"髌", ),  # 9AD5 => 9ACC
    u"髖" : (u"髋", ),  # 9AD6 => 9ACB
    u"髮" : (u"发", ),  # 9AEE => 53D1
    u"鬁" : (u"疬", ),  # 9B01 => 75AC
    u"鬆" : (u"松", ),  # 9B06 => 677E
    u"鬍" : (u"胡", ),  # 9B0D => 80E1
    u"鬚" : (u"须", ),  # 9B1A => 987B
    u"鬢" : (u"鬓", ),  # 9B22 => 9B13
    u"鬥" : (u"斗", ),  # 9B25 => 6597
    u"鬧" : (u"闹", ),  # 9B27 => 95F9
    u"鬩" : (u"阋", ),  # 9B29 => 960B
    u"鬮" : (u"阄", ),  # 9B2E => 9604
    u"鬱" : (u"郁", ),  # 9B31 => 90C1
    u"魎" : (u"魉", ),  # 9B4E => 9B49
    u"魘" : (u"魇", ),  # 9B58 => 9B47
    u"魚" : (u"鱼", ),  # 9B5A => 9C7C
    u"魛" : (u"鱽", ),  # 9B5B => 9C7D
    u"魯" : (u"鲁", ),  # 9B6F => 9C81
    u"魴" : (u"鲂", ),  # 9B74 => 9C82
    u"魷" : (u"鱿", ),  # 9B77 => 9C7F
    u"鮁" : (u"鲅", ),  # 9B81 => 9C85
    u"鮃" : (u"鲆", ),  # 9B83 => 9C86
    u"鮍" : (u"鲏", ),  # 9B8D => 9C8F
    u"鮐" : (u"鲐", ),  # 9B90 => 9C90
    u"鮑" : (u"鲍", ),  # 9B91 => 9C8D
    u"鮒" : (u"鲋", ),  # 9B92 => 9C8B
    u"鮓" : (u"鲊", ),  # 9B93 => 9C8A
    u"鮚" : (u"鲒", ),  # 9B9A => 9C92
    u"鮞" : (u"鲕", ),  # 9B9E => 9C95
    u"鮣" : (u"䲟", ),  # 9BA3 => 4C9F
    u"鮦" : (u"鲖", ),  # 9BA6 => 9C96
    u"鮪" : (u"鲔", ),  # 9BAA => 9C94
    u"鮫" : (u"鲛", ),  # 9BAB => 9C9B
    u"鮭" : (u"鲑", ),  # 9BAD => 9C91
    u"鮮" : (u"鲜", ),  # 9BAE => 9C9C
    u"鮺" : (u"鲝", ),  # 9BBA => 9C9D
    u"鯀" : (u"鲧", ),  # 9BC0 => 9CA7
    u"鯁" : (u"鲠", ),  # 9BC1 => 9CA0
    u"鯇" : (u"鲩", ),  # 9BC7 => 9CA9
    u"鯉" : (u"鲤", ),  # 9BC9 => 9CA4
    u"鯊" : (u"鲨", ),  # 9BCA => 9CA8
    u"鯔" : (u"鲻", ),  # 9BD4 => 9CBB
    u"鯖" : (u"鲭", ),  # 9BD6 => 9CAD
    u"鯗" : (u"鲞", ),  # 9BD7 => 9C9E
    u"鯛" : (u"鲷", ),  # 9BDB => 9CB7
    u"鯝" : (u"鲴", ),  # 9BDD => 9CB4
    u"鯡" : (u"鲱", ),  # 9BE1 => 9CB1
    u"鯢" : (u"鲵", ),  # 9BE2 => 9CB5
    u"鯤" : (u"鲲", ),  # 9BE4 => 9CB2
    u"鯧" : (u"鲳", ),  # 9BE7 => 9CB3
    u"鯨" : (u"鲸", ),  # 9BE8 => 9CB8
    u"鯪" : (u"鲮", ),  # 9BEA => 9CAE
    u"鯫" : (u"鲰", ),  # 9BEB => 9CB0
    u"鯰" : (u"鲇", u"鲶"),  # 9BF0 => 9C87 9CB6
    u"鯴" : (u"鲺", ),  # 9BF4 => 9CBA
    u"鯽" : (u"鲫", ),  # 9BFD => 9CAB
    u"鯿" : (u"鳊", ),  # 9BFF => 9CCA
    u"鰂" : (u"鲗", ),  # 9C02 => 9C97
    u"鰆" : (u"䲠", ),  # 9C06 => 4CA0
    u"鰈" : (u"鲽", ),  # 9C08 => 9CBD
    u"鰉" : (u"鳇", ),  # 9C09 => 9CC7
    u"鰌" : (u"䲡", ),  # 9C0C => 4CA1
    u"鰍" : (u"鳅", ),  # 9C0D => 9CC5
    u"鰐" : (u"鳄", ),  # 9C10 => 9CC4
    u"鰒" : (u"鳆", ),  # 9C12 => 9CC6
    u"鰓" : (u"鳃", ),  # 9C13 => 9CC3
    u"鰛" : (u"鳁", ),  # 9C1B => 9CC1
    u"鰜" : (u"鳒", ),  # 9C1C => 9CD2
    u"鰟" : (u"鳑", ),  # 9C1F => 9CD1
    u"鰠" : (u"鳋", ),  # 9C20 => 9CCB
    u"鰣" : (u"鲥", ),  # 9C23 => 9CA5
    u"鰥" : (u"鳏", ),  # 9C25 => 9CCF
    u"鰧" : (u"䲢", ),  # 9C27 => 4CA2
    u"鰨" : (u"鳎", ),  # 9C28 => 9CCE
    u"鰩" : (u"鳐", ),  # 9C29 => 9CD0
    u"鰭" : (u"鳍", ),  # 9C2D => 9CCD
    u"鰱" : (u"鲢", ),  # 9C31 => 9CA2
    u"鰲" : (u"鳌", ),  # 9C32 => 9CCC
    u"鰳" : (u"鳓", ),  # 9C33 => 9CD3
    u"鰵" : (u"鳘", ),  # 9C35 => 9CD8
    u"鰷" : (u"鲦", ),  # 9C37 => 9CA6
    u"鰹" : (u"鲣", ),  # 9C39 => 9CA3
    u"鰻" : (u"鳗", ),  # 9C3B => 9CD7
    u"鰼" : (u"鳛", ),  # 9C3C => 9CDB
    u"鰾" : (u"鳔", ),  # 9C3E => 9CD4
    u"鱅" : (u"鳙", ),  # 9C45 => 9CD9
    u"鱈" : (u"鳕", ),  # 9C48 => 9CD5
    u"鱉" : (u"鳖", ),  # 9C49 => 9CD6
    u"鱒" : (u"鳟", ),  # 9C52 => 9CDF
    u"鱔" : (u"鳝", ),  # 9C54 => 9CDD
    u"鱖" : (u"鳜", ),  # 9C56 => 9CDC
    u"鱗" : (u"鳞", ),  # 9C57 => 9CDE
    u"鱘" : (u"鲟", ),  # 9C58 => 9C9F
    u"鱝" : (u"鲼", ),  # 9C5D => 9CBC
    u"鱟" : (u"鲎", ),  # 9C5F => 9C8E
    u"鱠" : (u"鲙", ),  # 9C60 => 9C99
    u"鱣" : (u"鳣", ),  # 9C63 => 9CE3
    u"鱧" : (u"鳢", ),  # 9C67 => 9CE2
    u"鱨" : (u"鲿", ),  # 9C68 => 9CBF
    u"鱭" : (u"鲚", ),  # 9C6D => 9C9A
    u"鱷" : (u"鳄", ),  # 9C77 => 9CC4
    u"鱸" : (u"鲈", ),  # 9C78 => 9C88
    u"鱺" : (u"鲡", ),  # 9C7A => 9CA1
    u"鳥" : (u"鸟", ),  # 9CE5 => 9E1F
    u"鳧" : (u"凫", ),  # 9CE7 => 51EB
    u"鳩" : (u"鸠", ),  # 9CE9 => 9E20
    u"鳬" : (u"凫", ),  # 9CEC => 51EB
    u"鳳" : (u"凤", ),  # 9CF3 => 51E4
    u"鳴" : (u"鸣", ),  # 9CF4 => 9E23
    u"鳶" : (u"鸢", ),  # 9CF6 => 9E22
    u"鳾" : (u"䴓", ),  # 9CFE => 4D13
    u"鴆" : (u"鸩", ),  # 9D06 => 9E29
    u"鴇" : (u"鸨", ),  # 9D07 => 9E28
    u"鴉" : (u"鸦", ),  # 9D09 => 9E26
    u"鴒" : (u"鸰", ),  # 9D12 => 9E30
    u"鴕" : (u"鸵", ),  # 9D15 => 9E35
    u"鴛" : (u"鸳", ),  # 9D1B => 9E33
    u"鴝" : (u"鸲", ),  # 9D1D => 9E32
    u"鴞" : (u"鸮", ),  # 9D1E => 9E2E
    u"鴟" : (u"鸱", ),  # 9D1F => 9E31
    u"鴣" : (u"鸪", ),  # 9D23 => 9E2A
    u"鴦" : (u"鸯", ),  # 9D26 => 9E2F
    u"鴨" : (u"鸭", ),  # 9D28 => 9E2D
    u"鴯" : (u"鸸", ),  # 9D2F => 9E38
    u"鴰" : (u"鸹", ),  # 9D30 => 9E39
    u"鴴" : (u"鸻", ),  # 9D34 => 9E3B
    u"鴷" : (u"䴕", ),  # 9D37 => 4D15
    u"鴻" : (u"鸿", ),  # 9D3B => 9E3F
    u"鴿" : (u"鸽", ),  # 9D3F => 9E3D
    u"鵁" : (u"䴔", ),  # 9D41 => 4D14
    u"鵂" : (u"鸺", ),  # 9D42 => 9E3A
    u"鵃" : (u"鸼", ),  # 9D43 => 9E3C
    u"鵉" : (u"鸾", ),  # 9D49 => 9E3E
    u"鵑" : (u"鹃", ),  # 9D51 => 9E43
    u"鵒" : (u"鹆", ),  # 9D52 => 9E46
    u"鵓" : (u"鹁", ),  # 9D53 => 9E41
    u"鵜" : (u"鹈", ),  # 9D5C => 9E48
    u"鵝" : (u"鹅", ),  # 9D5D => 9E45
    u"鵠" : (u"鹄", ),  # 9D60 => 9E44
    u"鵡" : (u"鹉", ),  # 9D61 => 9E49
    u"鵪" : (u"鹌", ),  # 9D6A => 9E4C
    u"鵬" : (u"鹏", ),  # 9D6C => 9E4F
    u"鵮" : (u"鹐", ),  # 9D6E => 9E50
    u"鵯" : (u"鹎", ),  # 9D6F => 9E4E
    u"鵲" : (u"鹊", ),  # 9D72 => 9E4A
    u"鶄" : (u"䴖", ),  # 9D84 => 4D16
    u"鶇" : (u"鸫", ),  # 9D87 => 9E2B
    u"鶉" : (u"鹑", ),  # 9D89 => 9E51
    u"鶊" : (u"鹒", ),  # 9D8A => 9E52
    u"鶓" : (u"鹋", ),  # 9D93 => 9E4B
    u"鶖" : (u"鹙", ),  # 9D96 => 9E59
    u"鶘" : (u"鹕", ),  # 9D98 => 9E55
    u"鶚" : (u"鹗", ),  # 9D9A => 9E57
    u"鶡" : (u"鹖", ),  # 9DA1 => 9E56
    u"鶥" : (u"鹛", ),  # 9DA5 => 9E5B
    u"鶩" : (u"鹜", ),  # 9DA9 => 9E5C
    u"鶪" : (u"䴗", ),  # 9DAA => 4D17
    u"鶬" : (u"鸧", ),  # 9DAC => 9E27
    u"鶯" : (u"莺", ),  # 9DAF => 83BA
    u"鶴" : (u"鹤", ),  # 9DB4 => 9E64
    u"鶺" : (u"鹡", ),  # 9DBA => 9E61
    u"鶻" : (u"鹘", ),  # 9DBB => 9E58
    u"鶼" : (u"鹣", ),  # 9DBC => 9E63
    u"鶿" : (u"鹚", ),  # 9DBF => 9E5A
    u"鷀" : (u"鹚", ),  # 9DC0 => 9E5A
    u"鷂" : (u"鹞", ),  # 9DC2 => 9E5E
    u"鷄" : (u"鸡", ),  # 9DC4 => 9E21
    u"鷉" : (u"䴘", ),  # 9DC9 => 4D18
    u"鷓" : (u"鹧", ),  # 9DD3 => 9E67
    u"鷖" : (u"鹥", ),  # 9DD6 => 9E65
    u"鷗" : (u"鸥", ),  # 9DD7 => 9E25
    u"鷙" : (u"鸷", ),  # 9DD9 => 9E37
    u"鷚" : (u"鹨", ),  # 9DDA => 9E68
    u"鷥" : (u"鸶", ),  # 9DE5 => 9E36
    u"鷦" : (u"鹪", ),  # 9DE6 => 9E6A
    u"鷯" : (u"鹩", ),  # 9DEF => 9E69
    u"鷲" : (u"鹫", ),  # 9DF2 => 9E6B
    u"鷳" : (u"鹇", ),  # 9DF3 => 9E47
    u"鷸" : (u"鹬", ),  # 9DF8 => 9E6C
    u"鷹" : (u"鹰", ),  # 9DF9 => 9E70
    u"鷺" : (u"鹭", ),  # 9DFA => 9E6D
    u"鸇" : (u"鹯", ),  # 9E07 => 9E6F
    u"鸊" : (u"䴙", ),  # 9E0A => 4D19
    u"鸌" : (u"鹱", ),  # 9E0C => 9E71
    u"鸕" : (u"鸬", ),  # 9E15 => 9E2C
    u"鸚" : (u"鹦", ),  # 9E1A => 9E66
    u"鸛" : (u"鹳", ),  # 9E1B => 9E73
    u"鸝" : (u"鹂", ),  # 9E1D => 9E42
    u"鸞" : (u"鸾", ),  # 9E1E => 9E3E
    u"鹵" : (u"卤", ),  # 9E75 => 5364
    u"鹸" : (u"硷", ),  # 9E78 => 7877
    u"鹹" : (u"咸", ),  # 9E79 => 54B8
    u"鹺" : (u"鹾", ),  # 9E7A => 9E7E
    u"鹼" : (u"硷", ),  # 9E7C => 7877
    u"鹽" : (u"盐", ),  # 9E7D => 76D0
    u"麅" : (u"狍", ),  # 9E85 => 72CD
    u"麗" : (u"丽", ),  # 9E97 => 4E3D
    u"麥" : (u"麦", ),  # 9EA5 => 9EA6
    u"麩" : (u"麸", ),  # 9EA9 => 9EB8
    u"麯" : (u"曲", ),  # 9EAF => 66F2
    u"麵" : (u"面", ),  # 9EB5 => 9762
    u"麼" : (u"么", ),  # 9EBC => 4E48
    u"麽" : (u"么", ),  # 9EBD => 4E48
    u"黃" : (u"黄", ),  # 9EC3 => 9EC4
    u"黌" : (u"黉", ),  # 9ECC => 9EC9
    u"點" : (u"点", ),  # 9EDE => 70B9
    u"黨" : (u"党", ),  # 9EE8 => 515A
    u"黲" : (u"黪", ),  # 9EF2 => 9EEA
    u"黴" : (u"霉", ),  # 9EF4 => 9709
    u"黶" : (u"黡", ),  # 9EF6 => 9EE1
    u"黷" : (u"黩", ),  # 9EF7 => 9EE9
    u"黽" : (u"黾", ),  # 9EFD => 9EFE
    u"黿" : (u"鼋", ),  # 9EFF => 9F0B
    u"鼇" : (u"鳌", ),  # 9F07 => 9CCC
    u"鼉" : (u"鼍", ),  # 9F09 => 9F0D
    u"鼕" : (u"冬", ),  # 9F15 => 51AC
    u"鼴" : (u"鼹", ),  # 9F34 => 9F39
    u"齇" : (u"齄", ),  # 9F47 => 9F44
    u"齊" : (u"齐", ),  # 9F4A => 9F50
    u"齋" : (u"斋", ),  # 9F4B => 658B
    u"齎" : (u"赍", ),  # 9F4E => 8D4D
    u"齏" : (u"齑", ),  # 9F4F => 9F51
    u"齒" : (u"齿", ),  # 9F52 => 9F7F
    u"齔" : (u"龀", ),  # 9F54 => 9F80
    u"齙" : (u"龅", ),  # 9F59 => 9F85
    u"齜" : (u"龇", ),  # 9F5C => 9F87
    u"齟" : (u"龃", ),  # 9F5F => 9F83
    u"齠" : (u"龆", ),  # 9F60 => 9F86
    u"齡" : (u"龄", ),  # 9F61 => 9F84
    u"齣" : (u"出", ),  # 9F63 => 51FA
    u"齦" : (u"龈", ),  # 9F66 => 9F88
    u"齧" : (u"啮", ),  # 9F67 => 556E
    u"齪" : (u"龊", ),  # 9F6A => 9F8A
    u"齬" : (u"龉", ),  # 9F6C => 9F89
    u"齲" : (u"龋", ),  # 9F72 => 9F8B
    u"齶" : (u"腭", ),  # 9F76 => 816D
    u"齷" : (u"龌", ),  # 9F77 => 9F8C
    u"龍" : (u"龙", ),  # 9F8D => 9F99
    u"龐" : (u"庞", ),  # 9F90 => 5E9E
    u"龑" : (u"䶮", ),  # 9F91 => 4DAE
    u"龔" : (u"龚", ),  # 9F94 => 9F9A
    u"龕" : (u"龛", ),  # 9F95 => 9F9B
    u"龜" : (u"龟", ),  # 9F9C => 9F9F
}
