#include <stdlib.h>
#include <stdio.h>

#include "unity-webapps-service.h"
#include "unity-webapps-context.h"
#include "uwa-test-client.h"

#define ICON_URL "http://www.ubuntu.com/sites/www.ubuntu.com/files/active/02_ubuntu/U_homepage/picto-desktop.png"

static GMainLoop *mainloop = NULL;

static void
fake_callback (UnityWebappsContext *context, gpointer user_data)
{
}

static void
context_ready (UnityWebappsContext *context, gpointer user_data)
{
  UnityWebappsApplicationActionDesc arg[] = {{"/Action 1", fake_callback, NULL},
                                             {"/Action 2", fake_callback, NULL}};

  unity_webapps_context_add_application_actions (context, arg, 2);
  unity_webapps_context_remove_application_action (context, "/Action 1");
  unity_webapps_context_remove_application_action (context, "/Action 2");
  uwa_emit_test_finished();
}

gint
main (gint argc, gchar **argv)
{
  UnityWebappsService *service;
  
  g_type_init ();
  
  service = unity_webapps_service_new ();
  
  unity_webapps_context_new (service, "Test", "test.ts", ICON_URL, NULL, context_ready, NULL);
  
  mainloop = g_main_loop_new (NULL, FALSE);
  
  g_main_loop_run (mainloop);
  
  return 0;  
}
