#!/usr/bin/perl

use strict;
use warnings;

use XML::Twig;
use Test::More tests => 2;

use utf8;

{
my $doc=q{<d><title>title</title><para>p 1</para><para>p 2</para></d>};
my $out;
open( my $out_fh, '>', \$out);
my $t= XML::Twig->new ( twig_handlers => { _default_ => sub { $_->flush( $out_fh); } });
$t->parse( $doc);
is( $out, $doc, 'flush with _default_ handler');
}

{
my $doc=q{<d><title>title</title><para>p 1</para><para>p 2</para></d>};
my $out;
open( my $out_fh, '>', \$out);
my $t= XML::Twig->new ( twig_handlers => { 'd' => sub { $_->flush( $out_fh); } });
$t->parse( $doc);
is( $out, $doc, 'flush with handler on the root');
}


exit;



