/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.awt.Point;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import org.fest.swing.core.KeyPressInfo;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.JScrollPaneDriver;
import org.fest.swing.fixture.CommonComponentFixture;
import org.fest.swing.fixture.ComponentFixture;
import org.fest.swing.fixture.JComponentFixture;
import org.fest.swing.fixture.JPopupMenuFixture;
import org.fest.swing.fixture.JPopupMenuInvokerFixture;
import org.fest.swing.fixture.JScrollBarFixture;
import org.fest.swing.timing.Timeout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JScrollPaneFixture
extends ComponentFixture<JScrollPane>
implements CommonComponentFixture,
JPopupMenuInvokerFixture,
JComponentFixture {
    private JScrollPaneDriver driver;

    public JScrollPaneFixture(Robot robot, JScrollPane target) {
        super(robot, target);
        this.driver(this.newComponentDriver());
    }

    protected final void driver(JScrollPaneDriver newDriver) {
        JScrollPaneFixture.validateNotNull(newDriver);
        this.driver = newDriver;
    }

    public JScrollPaneFixture(Robot robot, String panelName) {
        super(robot, panelName, JScrollPane.class);
        this.driver = this.newComponentDriver();
    }

    private JScrollPaneDriver newComponentDriver() {
        return new JScrollPaneDriver(this.robot);
    }

    public JScrollBarFixture horizontalScrollBar() {
        return this.scrollBarFixture(this.driver.horizontalScrollBarIn((JScrollPane)this.target));
    }

    public JScrollBarFixture verticalScrollBar() {
        return this.scrollBarFixture(this.driver.verticalScrollBarIn((JScrollPane)this.target));
    }

    private JScrollBarFixture scrollBarFixture(JScrollBar scrollBar) {
        return new JScrollBarFixture(this.robot, scrollBar);
    }

    @Override
    public JScrollPaneFixture click() {
        this.driver.click(this.target);
        return this;
    }

    @Override
    public JScrollPaneFixture click(MouseButton button) {
        this.driver.click(this.target, button);
        return this;
    }

    @Override
    public JScrollPaneFixture click(MouseClickInfo mouseClickInfo) {
        this.driver.click(this.target, mouseClickInfo);
        return this;
    }

    @Override
    public JScrollPaneFixture doubleClick() {
        this.driver.doubleClick(this.target);
        return this;
    }

    @Override
    public JScrollPaneFixture rightClick() {
        this.driver.rightClick(this.target);
        return this;
    }

    @Override
    public JScrollPaneFixture focus() {
        this.driver.focus(this.target);
        return this;
    }

    @Override
    public JScrollPaneFixture pressAndReleaseKey(KeyPressInfo keyPressInfo) {
        this.driver.pressAndReleaseKey(this.target, keyPressInfo);
        return this;
    }

    @Override
    public JScrollPaneFixture pressAndReleaseKeys(int ... keyCodes) {
        this.driver.pressAndReleaseKeys(this.target, keyCodes);
        return this;
    }

    @Override
    public JScrollPaneFixture pressKey(int keyCode) {
        this.driver.pressKey(this.target, keyCode);
        return this;
    }

    @Override
    public JScrollPaneFixture releaseKey(int keyCode) {
        this.driver.releaseKey(this.target, keyCode);
        return this;
    }

    @Override
    public JScrollPaneFixture requireFocused() {
        this.driver.requireFocused(this.target);
        return this;
    }

    @Override
    public JScrollPaneFixture requireEnabled() {
        this.driver.requireEnabled(this.target);
        return this;
    }

    @Override
    public JScrollPaneFixture requireEnabled(Timeout timeout) {
        this.driver.requireEnabled(this.target, timeout);
        return this;
    }

    @Override
    public JScrollPaneFixture requireDisabled() {
        this.driver.requireDisabled(this.target);
        return this;
    }

    @Override
    public JScrollPaneFixture requireVisible() {
        this.driver.requireVisible(this.target);
        return this;
    }

    @Override
    public JScrollPaneFixture requireNotVisible() {
        this.driver.requireNotVisible(this.target);
        return this;
    }

    @Override
    public JScrollPaneFixture requireToolTip(String expected) {
        this.driver.requireToolTip((JComponent)this.target, expected);
        return this;
    }

    @Override
    public JScrollPaneFixture requireToolTip(Pattern pattern) {
        this.driver.requireToolTip((JComponent)this.target, pattern);
        return this;
    }

    @Override
    public Object clientProperty(Object key) {
        return this.driver.clientProperty((JComponent)this.target, key);
    }

    @Override
    public JPopupMenuFixture showPopupMenu() {
        return new JPopupMenuFixture(this.robot, this.driver.invokePopupMenu(this.target));
    }

    @Override
    public JPopupMenuFixture showPopupMenuAt(Point p) {
        return new JPopupMenuFixture(this.robot, this.driver.invokePopupMenu(this.target, p));
    }
}

