/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import picard.illumina.parser.CycleIlluminaFileMap;
import picard.illumina.parser.IlluminaFileMap;
import picard.illumina.parser.IlluminaFileUtil;
import picard.illumina.parser.ParameterizedFileUtil;
import picard.illumina.parser.TileIndex;
import picard.illumina.parser.fakers.FileFaker;
import picard.illumina.parser.fakers.MultiTileBclFileFaker;

public class MultiTileBclFileUtil
extends ParameterizedFileUtil {
    final File basecallLaneDir;
    final File bci;
    final TileIndex tileIndex;
    final CycleIlluminaFileMap cycleFileMap = new CycleIlluminaFileMap();

    MultiTileBclFileUtil(File basecallLaneDir, int lane) {
        super("^(\\d{4}).bcl.bgzf$", ".bcl.bgzf", basecallLaneDir, (FileFaker)new MultiTileBclFileFaker(), lane);
        this.basecallLaneDir = basecallLaneDir;
        this.bci = new File(basecallLaneDir, "s_" + lane + ".bci");
        File[] cycleFiles = IOUtil.getFilesMatchingRegexp((File)this.base, (Pattern)this.matchPattern);
        if (this.bci.exists()) {
            this.tileIndex = new TileIndex(this.bci);
            if (cycleFiles != null) {
                for (File file : cycleFiles) {
                    String fileName = file.getName();
                    String cycleNum = fileName.substring(0, fileName.indexOf(46));
                    IlluminaFileMap fileMap = new IlluminaFileMap();
                    for (Integer tile : this.tileIndex.getTiles()) {
                        fileMap.put(tile, file);
                    }
                    this.cycleFileMap.put(Integer.valueOf(cycleNum), fileMap);
                }
            }
        } else {
            this.tileIndex = null;
        }
    }

    public CycleIlluminaFileMap getFiles(List<Integer> tiles, int[] cycles) {
        ArrayList<Integer> goodCycleList = new ArrayList<Integer>(cycles.length);
        for (int cycle : cycles) {
            if (!this.cycleFileMap.containsKey(cycle)) continue;
            goodCycleList.add(cycle);
        }
        Collections.sort(goodCycleList);
        int[] goodCycles = new int[goodCycleList.size()];
        for (int i = 0; i < goodCycles.length; ++i) {
            goodCycles[i] = (Integer)goodCycleList.get(i);
        }
        CycleIlluminaFileMap cycledMap = new CycleIlluminaFileMap();
        if (goodCycles.length > 0) {
            for (int cycle : goodCycles) {
                IlluminaFileMap fileMap = ((IlluminaFileMap)this.cycleFileMap.get(cycle)).keep(tiles);
                cycledMap.put(cycle, fileMap);
            }
        }
        return cycledMap;
    }

    @Override
    public boolean filesAvailable() {
        return this.bci.exists() && this.cycleFileMap.size() > 0;
    }

    @Override
    public List<Integer> getTiles() {
        if (this.tileIndex == null) {
            return Collections.emptyList();
        }
        return this.tileIndex.getTiles();
    }

    @Override
    public List<String> verify(List<Integer> expectedTiles, int[] expectedCycles) {
        if (this.tileIndex == null) {
            return Collections.singletonList("Tile index(" + this.bci.getAbsolutePath() + ") does not exist!");
        }
        List<String> ret = this.tileIndex.verify(expectedTiles);
        for (int expectedCycle : expectedCycles) {
            if (this.cycleFileMap.containsKey(expectedCycle)) continue;
            ret.add(expectedCycle + ".bcl.bgzf not found in " + this.base);
        }
        return ret;
    }

    @Override
    public List<String> fakeFiles(List<Integer> expectedTiles, int[] expectedCycles, IlluminaFileUtil.SupportedIlluminaFormat format) {
        if (this.tileIndex == null) {
            return Collections.singletonList("Tile index(" + this.bci.getAbsolutePath() + ") does not exist!");
        }
        List<String> ret = this.tileIndex.verify(expectedTiles);
        for (int expectedCycle : expectedCycles) {
            if (this.cycleFileMap.containsKey(expectedCycle)) continue;
            ret.add(expectedCycle + ".bcl.bgzf not found in " + this.base);
        }
        return ret;
    }
}

