#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
set -o errexit

###
# Wingspan
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220330.3

# Set game-specific variables

GAME_ID='wingspan'
GAME_NAME='Wingspan'

ARCHIVE_BASE_1='setup_wingspan_102_(53871).exe'
ARCHIVE_BASE_1_MD5='1628a30ffccd86d875895e2d166c1cde'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_PART1='setup_wingspan_102_(53871)-1.bin'
ARCHIVE_BASE_1_PART1_MD5='7a2baede2444e183941698a73e7a3044'
ARCHIVE_BASE_1_PART1_TYPE='innosetup'
ARCHIVE_BASE_1_SIZE='1100000'
ARCHIVE_BASE_1_VERSION='102-gog53871'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/wingspan'

ARCHIVE_BASE_0='setup_wingspan_83_(50869).exe'
ARCHIVE_BASE_0_MD5='5d68e6a8027e34504e86075a96e8bc15'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1='setup_wingspan_83_(50869)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='110175d9b0bca8b33b13e826da0a7b99'
ARCHIVE_BASE_0_PART1_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='1100000'
ARCHIVE_BASE_0_VERSION='83-gog50869'

UNITY3D_NAME='wingspan'

CONTENT_PATH_DEFAULT='.'
ARCHIVE_GAME_BIN_FILES="
${UNITY3D_NAME}.exe
${UNITY3D_NAME}_data/plugins
*.dll
unitycrashhandler32.exe"
ARCHIVE_GAME_DATA_FILES="
${UNITY3D_NAME}_data"

APP_MAIN_TYPE='wine'
APP_MAIN_EXE="${UNITY3D_NAME}.exe"
APP_MAIN_ICON="${UNITY3D_NAME}.exe"

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID wine"

# Use persistent storage for user data

APP_WINE_LINK_DIRS="$APP_WINE_LINK_DIRS"'
userdata:users/$(id -un)/AppData/LocalLow/Monster Couch/Wingspan'
DATA_DIRS="$DATA_DIRS ./userdata"

# Load common functions

target_version='2.15'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icon

PKG='PKG_BIN'
icons_get_from_package 'APP_MAIN'
icons_move_to 'PKG_DATA'

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
