/*
 * SPDX-FileCopyrightText: Copyright (c) 2016-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/* THIS FILE IS AUTOMATICALLY GENERATED, DO NOT EDIT! */

#include "core/bin_data.h"
#include "rmflcnbl.h"
#include "nvBinSegment.h"
#include "../src/kernel/core/bin_data_pvt.h"

//
// Forward declarations.
// These are needed for generating the bindata access functions, which use
// "struct X" as a parameter. This is easier than #include-ing all the necessary
// headers. TODO: consider sharing a list of forward struct declarations with
// e.g. eng_desc.h?
//

struct KernelPmu;
struct KernelGsp;
struct KernelSec2;
struct KernelGsplite;

//
// Default segment for bindata to put the data arrays to paged memory.
// This segment is never locked.
//
CONS_SEGMENT("PAGErGEN")

#if !defined(NVLOG_PARSING)

typedef enum
{
    BINDATA_INDEX_ZERO_UNUSED                                                                                      = 0,
    __idx_kgspBinArchiveGspRmBoot_TU102_ucode_image                                                                = 1,
    __idx_kgspBinArchiveGspRmBoot_TU102_ucode_desc                                                                 = 2,
    __idx_kgspBinArchiveGspRmBoot_GA100_ucode_image                                                                = 3,
    __idx_kgspBinArchiveGspRmBoot_GA100_ucode_desc                                                                 = 4,
    __idx_kgspBinArchiveGspRmBoot_GA102_ucode_image_dbg                                                            = 5,
    __idx_kgspBinArchiveGspRmBoot_GA102_ucode_desc_dbg                                                             = 6,
    __idx_kgspBinArchiveGspRmBoot_GA102_ucode_image_prod                                                           = 7,
    __idx_kgspBinArchiveGspRmBoot_GA102_ucode_desc_prod                                                            = 8,
    __idx_kgspBinArchiveGspRmBoot_AD102_ucode_image_dbg                                                            = 9,
    __idx_kgspBinArchiveGspRmBoot_AD102_ucode_desc_dbg                                                             = 10,
    __idx_kgspBinArchiveGspRmBoot_AD102_ucode_image_prod                                                           = 11,
    __idx_kgspBinArchiveGspRmBoot_AD102_ucode_desc_prod                                                            = 12,
    __idx_kgspBinArchiveGspRmBoot_GH100_ucode_image_dbg                                                            = 13,
    __idx_kgspBinArchiveGspRmBoot_GH100_ucode_desc_dbg                                                             = 14,
    __idx_kgspBinArchiveGspRmBoot_GH100_ucode_image_prod                                                           = 15,
    __idx_kgspBinArchiveGspRmBoot_GH100_ucode_desc_prod                                                            = 16,
    __idx_kgspBinArchiveGspRmBoot_GB100_ucode_image_dbg                                                            = 17,
    __idx_kgspBinArchiveGspRmBoot_GB100_ucode_desc_dbg                                                             = 18,
    __idx_kgspBinArchiveGspRmBoot_GB100_ucode_image_prod                                                           = 19,
    __idx_kgspBinArchiveGspRmBoot_GB100_ucode_desc_prod                                                            = 20,
    __idx_kgspBinArchiveGspRmBoot_GB202_ucode_image_dbg                                                            = 21,
    __idx_kgspBinArchiveGspRmBoot_GB202_ucode_desc_dbg                                                             = 22,
    __idx_kgspBinArchiveGspRmBoot_GB202_ucode_image_prod                                                           = 23,
    __idx_kgspBinArchiveGspRmBoot_GB202_ucode_desc_prod                                                            = 24,
    __idx_kgspBinArchiveConcatenatedFMCDesc_GH100_ucode_desc_prod                                                  = 25,
    __idx_kgspBinArchiveConcatenatedFMCDesc_GB100_ucode_desc_prod                                                  = 26,
    __idx_kgspBinArchiveConcatenatedFMC_GH100_ucode_image_prod                                                     = 27,
    __idx_kgspBinArchiveConcatenatedFMC_GB100_ucode_image_prod                                                     = 28,
    __idx_kgspBinArchiveGspRmFmcGfwDebugSigned_GH100_ucode_image                                                   = 29,
    __idx_kgspBinArchiveGspRmFmcGfwDebugSigned_GH100_ucode_hash                                                    = 30,
    __idx_kgspBinArchiveGspRmFmcGfwDebugSigned_GH100_ucode_sig                                                     = 31,
    __idx_kgspBinArchiveGspRmFmcGfwDebugSigned_GH100_ucode_pkey                                                    = 32,
    __idx_kgspBinArchiveGspRmFmcGfwDebugSigned_GB100_ucode_image                                                   = 33,
    __idx_kgspBinArchiveGspRmFmcGfwDebugSigned_GB100_ucode_hash                                                    = 34,
    __idx_kgspBinArchiveGspRmFmcGfwDebugSigned_GB100_ucode_sig                                                     = 35,
    __idx_kgspBinArchiveGspRmFmcGfwDebugSigned_GB100_ucode_pkey                                                    = 36,
    __idx_kgspBinArchiveGspRmFmcGfwDebugSigned_GB202_ucode_image                                                   = 37,
    __idx_kgspBinArchiveGspRmFmcGfwDebugSigned_GB202_ucode_hash                                                    = 38,
    __idx_kgspBinArchiveGspRmFmcGfwDebugSigned_GB202_ucode_sig                                                     = 39,
    __idx_kgspBinArchiveGspRmFmcGfwDebugSigned_GB202_ucode_pkey                                                    = 40,
    __idx_kgspBinArchiveGspRmFmcGfwProdSigned_GH100_ucode_image                                                    = 41,
    __idx_kgspBinArchiveGspRmFmcGfwProdSigned_GH100_ucode_hash                                                     = 42,
    __idx_kgspBinArchiveGspRmFmcGfwProdSigned_GH100_ucode_sig                                                      = 43,
    __idx_kgspBinArchiveGspRmFmcGfwProdSigned_GH100_ucode_pkey                                                     = 44,
    __idx_kgspBinArchiveGspRmFmcGfwProdSigned_GB100_ucode_image                                                    = 45,
    __idx_kgspBinArchiveGspRmFmcGfwProdSigned_GB100_ucode_hash                                                     = 46,
    __idx_kgspBinArchiveGspRmFmcGfwProdSigned_GB100_ucode_sig                                                      = 47,
    __idx_kgspBinArchiveGspRmFmcGfwProdSigned_GB100_ucode_pkey                                                     = 48,
    __idx_kgspBinArchiveGspRmFmcGfwProdSigned_GB202_ucode_image                                                    = 49,
    __idx_kgspBinArchiveGspRmFmcGfwProdSigned_GB202_ucode_hash                                                     = 50,
    __idx_kgspBinArchiveGspRmFmcGfwProdSigned_GB202_ucode_sig                                                      = 51,
    __idx_kgspBinArchiveGspRmFmcGfwProdSigned_GB202_ucode_pkey                                                     = 52,
    __idx_kgspBinArchiveGspRmCcFmcGfwProdSigned_GH100_ucode_image                                                  = 53,
    __idx_kgspBinArchiveGspRmCcFmcGfwProdSigned_GH100_ucode_hash                                                   = 54,
    __idx_kgspBinArchiveGspRmCcFmcGfwProdSigned_GH100_ucode_sig                                                    = 55,
    __idx_kgspBinArchiveGspRmCcFmcGfwProdSigned_GH100_ucode_pkey                                                   = 56,
    __idx_kgspBinArchiveGspRmCcFmcGfwProdSigned_GB100_ucode_image                                                  = 57,
    __idx_kgspBinArchiveGspRmCcFmcGfwProdSigned_GB100_ucode_hash                                                   = 58,
    __idx_kgspBinArchiveGspRmCcFmcGfwProdSigned_GB100_ucode_sig                                                    = 59,
    __idx_kgspBinArchiveGspRmCcFmcGfwProdSigned_GB100_ucode_pkey                                                   = 60,
    __idx_kgspBinArchiveBooterLoadUcode_TU102_image_dbg                                                            = 61,
    __idx_kgspBinArchiveBooterLoadUcode_TU102_header_dbg                                                           = 62,
    __idx_kgspBinArchiveBooterLoadUcode_TU102_image_prod                                                           = 63,
    __idx_kgspBinArchiveBooterLoadUcode_TU102_header_prod                                                          = 64,
    __idx_kgspBinArchiveBooterLoadUcode_TU102_sig_dbg                                                              = 65,
    __idx_kgspBinArchiveBooterLoadUcode_TU102_sig_prod                                                             = 66,
    __idx_kgspBinArchiveBooterLoadUcode_TU102_patch_loc                                                            = 67,
    __idx_kgspBinArchiveBooterLoadUcode_TU102_patch_sig                                                            = 68,
    __idx_kgspBinArchiveBooterLoadUcode_TU102_patch_meta                                                           = 69,
    __idx_kgspBinArchiveBooterLoadUcode_TU102_num_sigs                                                             = 70,
    __idx_kgspBinArchiveBooterLoadUcode_TU116_image_dbg                                                            = 71,
    __idx_kgspBinArchiveBooterLoadUcode_TU116_header_dbg                                                           = 72,
    __idx_kgspBinArchiveBooterLoadUcode_TU116_image_prod                                                           = 73,
    __idx_kgspBinArchiveBooterLoadUcode_TU116_header_prod                                                          = 74,
    __idx_kgspBinArchiveBooterLoadUcode_TU116_sig_dbg                                                              = 75,
    __idx_kgspBinArchiveBooterLoadUcode_TU116_sig_prod                                                             = 76,
    __idx_kgspBinArchiveBooterLoadUcode_TU116_patch_loc                                                            = 77,
    __idx_kgspBinArchiveBooterLoadUcode_TU116_patch_sig                                                            = 78,
    __idx_kgspBinArchiveBooterLoadUcode_TU116_patch_meta                                                           = 79,
    __idx_kgspBinArchiveBooterLoadUcode_TU116_num_sigs                                                             = 80,
    __idx_kgspBinArchiveBooterLoadUcode_GA100_image_dbg                                                            = 81,
    __idx_kgspBinArchiveBooterLoadUcode_GA100_header_dbg                                                           = 82,
    __idx_kgspBinArchiveBooterLoadUcode_GA100_image_prod                                                           = 83,
    __idx_kgspBinArchiveBooterLoadUcode_GA100_header_prod                                                          = 84,
    __idx_kgspBinArchiveBooterLoadUcode_GA100_sig_dbg                                                              = 85,
    __idx_kgspBinArchiveBooterLoadUcode_GA100_sig_prod                                                             = 86,
    __idx_kgspBinArchiveBooterLoadUcode_GA100_patch_loc                                                            = 87,
    __idx_kgspBinArchiveBooterLoadUcode_GA100_patch_sig                                                            = 88,
    __idx_kgspBinArchiveBooterLoadUcode_GA100_patch_meta                                                           = 89,
    __idx_kgspBinArchiveBooterLoadUcode_GA100_num_sigs                                                             = 90,
    __idx_kgspBinArchiveBooterLoadUcode_GA102_image_dbg                                                            = 91,
    __idx_kgspBinArchiveBooterLoadUcode_GA102_header_dbg                                                           = 92,
    __idx_kgspBinArchiveBooterLoadUcode_GA102_image_prod                                                           = 93,
    __idx_kgspBinArchiveBooterLoadUcode_GA102_header_prod                                                          = 94,
    __idx_kgspBinArchiveBooterLoadUcode_GA102_sig_dbg                                                              = 95,
    __idx_kgspBinArchiveBooterLoadUcode_GA102_sig_prod                                                             = 96,
    __idx_kgspBinArchiveBooterLoadUcode_GA102_patch_loc                                                            = 97,
    __idx_kgspBinArchiveBooterLoadUcode_GA102_patch_sig                                                            = 98,
    __idx_kgspBinArchiveBooterLoadUcode_GA102_patch_meta                                                           = 99,
    __idx_kgspBinArchiveBooterLoadUcode_GA102_num_sigs                                                             = 100,
    __idx_kgspBinArchiveBooterLoadUcode_AD102_image_dbg                                                            = 101,
    __idx_kgspBinArchiveBooterLoadUcode_AD102_header_dbg                                                           = 102,
    __idx_kgspBinArchiveBooterLoadUcode_AD102_image_prod                                                           = 103,
    __idx_kgspBinArchiveBooterLoadUcode_AD102_header_prod                                                          = 104,
    __idx_kgspBinArchiveBooterLoadUcode_AD102_sig_dbg                                                              = 105,
    __idx_kgspBinArchiveBooterLoadUcode_AD102_sig_prod                                                             = 106,
    __idx_kgspBinArchiveBooterLoadUcode_AD102_patch_loc                                                            = 107,
    __idx_kgspBinArchiveBooterLoadUcode_AD102_patch_sig                                                            = 108,
    __idx_kgspBinArchiveBooterLoadUcode_AD102_patch_meta                                                           = 109,
    __idx_kgspBinArchiveBooterLoadUcode_AD102_num_sigs                                                             = 110,
    __idx_kgspBinArchiveBooterUnloadUcode_TU102_image_dbg                                                          = 111,
    __idx_kgspBinArchiveBooterUnloadUcode_TU102_header_dbg                                                         = 112,
    __idx_kgspBinArchiveBooterUnloadUcode_TU102_image_prod                                                         = 113,
    __idx_kgspBinArchiveBooterUnloadUcode_TU102_header_prod                                                        = 114,
    __idx_kgspBinArchiveBooterUnloadUcode_TU102_sig_dbg                                                            = 115,
    __idx_kgspBinArchiveBooterUnloadUcode_TU102_sig_prod                                                           = 116,
    __idx_kgspBinArchiveBooterUnloadUcode_TU102_patch_loc                                                          = 117,
    __idx_kgspBinArchiveBooterUnloadUcode_TU102_patch_sig                                                          = 118,
    __idx_kgspBinArchiveBooterUnloadUcode_TU102_patch_meta                                                         = 119,
    __idx_kgspBinArchiveBooterUnloadUcode_TU102_num_sigs                                                           = 120,
    __idx_kgspBinArchiveBooterUnloadUcode_TU116_image_dbg                                                          = 121,
    __idx_kgspBinArchiveBooterUnloadUcode_TU116_header_dbg                                                         = 122,
    __idx_kgspBinArchiveBooterUnloadUcode_TU116_image_prod                                                         = 123,
    __idx_kgspBinArchiveBooterUnloadUcode_TU116_header_prod                                                        = 124,
    __idx_kgspBinArchiveBooterUnloadUcode_TU116_sig_dbg                                                            = 125,
    __idx_kgspBinArchiveBooterUnloadUcode_TU116_sig_prod                                                           = 126,
    __idx_kgspBinArchiveBooterUnloadUcode_TU116_patch_loc                                                          = 127,
    __idx_kgspBinArchiveBooterUnloadUcode_TU116_patch_sig                                                          = 128,
    __idx_kgspBinArchiveBooterUnloadUcode_TU116_patch_meta                                                         = 129,
    __idx_kgspBinArchiveBooterUnloadUcode_TU116_num_sigs                                                           = 130,
    __idx_kgspBinArchiveBooterUnloadUcode_GA100_image_dbg                                                          = 131,
    __idx_kgspBinArchiveBooterUnloadUcode_GA100_header_dbg                                                         = 132,
    __idx_kgspBinArchiveBooterUnloadUcode_GA100_image_prod                                                         = 133,
    __idx_kgspBinArchiveBooterUnloadUcode_GA100_header_prod                                                        = 134,
    __idx_kgspBinArchiveBooterUnloadUcode_GA100_sig_dbg                                                            = 135,
    __idx_kgspBinArchiveBooterUnloadUcode_GA100_sig_prod                                                           = 136,
    __idx_kgspBinArchiveBooterUnloadUcode_GA100_patch_loc                                                          = 137,
    __idx_kgspBinArchiveBooterUnloadUcode_GA100_patch_sig                                                          = 138,
    __idx_kgspBinArchiveBooterUnloadUcode_GA100_patch_meta                                                         = 139,
    __idx_kgspBinArchiveBooterUnloadUcode_GA100_num_sigs                                                           = 140,
    __idx_kgspBinArchiveBooterUnloadUcode_GA102_image_dbg                                                          = 141,
    __idx_kgspBinArchiveBooterUnloadUcode_GA102_header_dbg                                                         = 142,
    __idx_kgspBinArchiveBooterUnloadUcode_GA102_image_prod                                                         = 143,
    __idx_kgspBinArchiveBooterUnloadUcode_GA102_header_prod                                                        = 144,
    __idx_kgspBinArchiveBooterUnloadUcode_GA102_sig_dbg                                                            = 145,
    __idx_kgspBinArchiveBooterUnloadUcode_GA102_sig_prod                                                           = 146,
    __idx_kgspBinArchiveBooterUnloadUcode_GA102_patch_loc                                                          = 147,
    __idx_kgspBinArchiveBooterUnloadUcode_GA102_patch_sig                                                          = 148,
    __idx_kgspBinArchiveBooterUnloadUcode_GA102_patch_meta                                                         = 149,
    __idx_kgspBinArchiveBooterUnloadUcode_GA102_num_sigs                                                           = 150,
    __idx_kgspBinArchiveBooterUnloadUcode_AD102_image_dbg                                                          = 151,
    __idx_kgspBinArchiveBooterUnloadUcode_AD102_header_dbg                                                         = 152,
    __idx_kgspBinArchiveBooterUnloadUcode_AD102_image_prod                                                         = 153,
    __idx_kgspBinArchiveBooterUnloadUcode_AD102_header_prod                                                        = 154,
    __idx_kgspBinArchiveBooterUnloadUcode_AD102_sig_dbg                                                            = 155,
    __idx_kgspBinArchiveBooterUnloadUcode_AD102_sig_prod                                                           = 156,
    __idx_kgspBinArchiveBooterUnloadUcode_AD102_patch_loc                                                          = 157,
    __idx_kgspBinArchiveBooterUnloadUcode_AD102_patch_sig                                                          = 158,
    __idx_kgspBinArchiveBooterUnloadUcode_AD102_patch_meta                                                         = 159,
    __idx_kgspBinArchiveBooterUnloadUcode_AD102_num_sigs                                                           = 160,
    __idx_ksec2BinArchiveBlUcode_TU102_ucode_image                                                                 = 161,
    __idx_ksec2BinArchiveBlUcode_TU102_ucode_desc                                                                  = 162,
    __idx_ksec2BinArchiveSecurescrubUcode_AD10X_image_dbg                                                          = 163,
    __idx_ksec2BinArchiveSecurescrubUcode_AD10X_header_dbg                                                         = 164,
    __idx_ksec2BinArchiveSecurescrubUcode_AD10X_image_prod                                                         = 165,
    __idx_ksec2BinArchiveSecurescrubUcode_AD10X_header_prod                                                        = 166,
    __idx_ksec2BinArchiveSecurescrubUcode_AD10X_sig_dbg                                                            = 167,
    __idx_ksec2BinArchiveSecurescrubUcode_AD10X_sig_prod                                                           = 168,
    __idx_ksec2BinArchiveSecurescrubUcode_AD10X_patch_loc                                                          = 169,
    __idx_ksec2BinArchiveSecurescrubUcode_AD10X_patch_sig                                                          = 170,
    __idx_ksec2BinArchiveSecurescrubUcode_AD10X_patch_meta                                                         = 171,
    __idx_ksec2BinArchiveSecurescrubUcode_AD10X_num_sigs                                                           = 172,

    BINDATA_INDEX_END
} bindata_index_t;

struct BINDATA_STORAGE_PVT_ALL
{
#define BINDATA_NO_SEGMENTS
#define BINDATA_INCLUDE_STORAGE_PVT_DECL

#include "g_bindata_kgspGetBinArchiveGspRmBoot_TU102.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GA100.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GA102.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_AD102.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GH100.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GB100.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GB202.c"
#include "g_bindata_kgspGetBinArchiveConcatenatedFMCDesc_GH100.c"
#include "g_bindata_kgspGetBinArchiveConcatenatedFMCDesc_GB100.c"
#include "g_bindata_kgspGetBinArchiveConcatenatedFMC_GH100.c"
#include "g_bindata_kgspGetBinArchiveConcatenatedFMC_GB100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwDebugSigned_GH100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwDebugSigned_GB100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwDebugSigned_GB202.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwProdSigned_GH100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwProdSigned_GB100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwProdSigned_GB202.c"
#include "g_bindata_kgspGetBinArchiveGspRmCcFmcGfwProdSigned_GH100.c"
#include "g_bindata_kgspGetBinArchiveGspRmCcFmcGfwProdSigned_GB100.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_TU102.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_TU116.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_GA100.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_GA102.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_AD102.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_TU102.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_TU116.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_GA100.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_GA102.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_AD102.c"
#include "g_bindata_ksec2GetBinArchiveBlUcode_TU102.c"
#include "g_bindata_ksec2GetBinArchiveSecurescrubUcode_AD10X.c"

#undef BINDATA_INCLUDE_STORAGE_PVT_DECL
#undef BINDATA_NO_SEGMENTS
};

// First include the data as it's referenced by storage_pvt
// Also useful to keep the NvU8 data packed together so we can merge multiple
// buffers into a single chunk for allocations.
#define BINDATA_INCLUDE_DATA

#include "g_bindata_kgspGetBinArchiveGspRmBoot_TU102.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GA100.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GA102.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_AD102.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GH100.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GB100.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GB202.c"
#include "g_bindata_kgspGetBinArchiveConcatenatedFMCDesc_GH100.c"
#include "g_bindata_kgspGetBinArchiveConcatenatedFMCDesc_GB100.c"
#include "g_bindata_kgspGetBinArchiveConcatenatedFMC_GH100.c"
#include "g_bindata_kgspGetBinArchiveConcatenatedFMC_GB100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwDebugSigned_GH100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwDebugSigned_GB100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwDebugSigned_GB202.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwProdSigned_GH100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwProdSigned_GB100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwProdSigned_GB202.c"
#include "g_bindata_kgspGetBinArchiveGspRmCcFmcGfwProdSigned_GH100.c"
#include "g_bindata_kgspGetBinArchiveGspRmCcFmcGfwProdSigned_GB100.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_TU102.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_TU116.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_GA100.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_GA102.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_AD102.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_TU102.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_TU116.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_GA100.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_GA102.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_AD102.c"
#include "g_bindata_ksec2GetBinArchiveBlUcode_TU102.c"
#include "g_bindata_ksec2GetBinArchiveSecurescrubUcode_AD10X.c"

#undef BINDATA_INCLUDE_DATA

BINDATA_CONST BINDATA_STORAGE_PVT g_bindata_pvt[] =
{
#define BINDATA_NO_SEGMENTS
#define BINDATA_INCLUDE_STORAGE_PVT_DEFN
// Add a dummy entry at index 0 which will be mapped to BINDATA_INDEX_ZERO_UNUSED in bindata_index_t
{
    0,
    0,
    NULL,
    0,
    0,
    0,
},

#include "g_bindata_kgspGetBinArchiveGspRmBoot_TU102.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GA100.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GA102.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_AD102.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GH100.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GB100.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GB202.c"
#include "g_bindata_kgspGetBinArchiveConcatenatedFMCDesc_GH100.c"
#include "g_bindata_kgspGetBinArchiveConcatenatedFMCDesc_GB100.c"
#include "g_bindata_kgspGetBinArchiveConcatenatedFMC_GH100.c"
#include "g_bindata_kgspGetBinArchiveConcatenatedFMC_GB100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwDebugSigned_GH100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwDebugSigned_GB100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwDebugSigned_GB202.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwProdSigned_GH100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwProdSigned_GB100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwProdSigned_GB202.c"
#include "g_bindata_kgspGetBinArchiveGspRmCcFmcGfwProdSigned_GH100.c"
#include "g_bindata_kgspGetBinArchiveGspRmCcFmcGfwProdSigned_GB100.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_TU102.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_TU116.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_GA100.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_GA102.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_AD102.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_TU102.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_TU116.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_GA100.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_GA102.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_AD102.c"
#include "g_bindata_ksec2GetBinArchiveBlUcode_TU102.c"
#include "g_bindata_ksec2GetBinArchiveSecurescrubUcode_AD10X.c"

#undef BINDATA_INCLUDE_STORAGE_PVT_DEFN
#undef BINDATA_NO_SEGMENTS
};

const NvU32 g_bindata_pvt_count = sizeof(g_bindata_pvt) / sizeof(BINDATA_STORAGE_PVT);

// Lastly, include everything else..
#define BINDATA_INCLUDE_ARCHIVE
#define BINDATA_INCLUDE_FUNCTION

#include "g_bindata_kgspGetBinArchiveGspRmBoot_TU102.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GA100.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GA102.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_AD102.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GH100.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GB100.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GB202.c"
#include "g_bindata_kgspGetBinArchiveConcatenatedFMCDesc_GH100.c"
#include "g_bindata_kgspGetBinArchiveConcatenatedFMCDesc_GB100.c"
#include "g_bindata_kgspGetBinArchiveConcatenatedFMC_GH100.c"
#include "g_bindata_kgspGetBinArchiveConcatenatedFMC_GB100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwDebugSigned_GH100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwDebugSigned_GB100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwDebugSigned_GB202.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwProdSigned_GH100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwProdSigned_GB100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwProdSigned_GB202.c"
#include "g_bindata_kgspGetBinArchiveGspRmCcFmcGfwProdSigned_GH100.c"
#include "g_bindata_kgspGetBinArchiveGspRmCcFmcGfwProdSigned_GB100.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_TU102.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_TU116.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_GA100.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_GA102.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_AD102.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_TU102.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_TU116.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_GA100.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_GA102.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_AD102.c"
#include "g_bindata_ksec2GetBinArchiveBlUcode_TU102.c"
#include "g_bindata_ksec2GetBinArchiveSecurescrubUcode_AD10X.c"

#undef BINDATA_INCLUDE_FUNCTION
#undef BINDATA_INCLUDE_ARCHIVE

#endif // !defined(NVLOG_PARSING)
