/* ----- decode/857x5167, derived from supercop/crypto_decode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *decode_857x5167_checksums[] = {
  "c94e8ca6f25f8ffbec28769f741ba6613b6de2ed3bbda148d4e973175b80545c",
  "43714f0e17a461bbd8215bb53713169845c361f105bcf4ca966b7b86b5de28c6",
} ;

static void (*crypto_decode)(void *,const unsigned char *);
#define crypto_decode_STRBYTES ntruprime_decode_857x5167_STRBYTES
#define crypto_decode_ITEMS ntruprime_decode_857x5167_ITEMS
#define crypto_decode_ITEMBYTES ntruprime_decode_857x5167_ITEMBYTES

static void *storage_decode_857x5167_x;
static unsigned char *test_decode_857x5167_x;
static void *storage_decode_857x5167_s;
static unsigned char *test_decode_857x5167_s;
static void *storage_decode_857x5167_x2;
static unsigned char *test_decode_857x5167_x2;
static void *storage_decode_857x5167_s2;
static unsigned char *test_decode_857x5167_s2;

#define precomputed_decode_857x5167_NUM 4

static const int16_t precomputed_decode_857x5167_x[precomputed_decode_857x5167_NUM][crypto_decode_ITEMS] = {
  {2190,-1263,-1665,-960,-1480,2512,2355,-666,360,-2138,-699,-2221,1875,1368,643,-1815,-2453,-630,-1146,139,-659,1254,-280,-1939,-1942,1308,2444,314,1079,2419,934,2448,1721,-734,286,1889,1048,-676,86,-449,511,1732,-2464,1790,503,2102,-1203,497,-1338,2446,-1904,1575,-2226,1670,-1503,2420,776,-2378,1935,1196,617,1230,890,-1304,1681,934,1025,1148,1095,-1657,1025,-876,-2036,-1931,-1078,-1614,1057,2464,-2338,1162,2116,-682,1941,-138,-2552,497,-1069,927,-1464,2534,1290,36,-2086,645,-147,2035,-204,-939,-567,1547,2243,-2240,2121,-2482,145,2540,-1479,-863,1665,1190,-1797,-822,741,-1540,2003,-1864,1479,1598,1797,886,523,2554,1605,-1127,-256,-273,-294,-1478,-2257,-1888,858,-992,1834,1590,-226,-1652,848,1748,-663,-1011,330,-1885,-1800,-1499,-2179,864,-311,2093,-2033,-784,1103,-1476,2476,-2108,640,360,995,-1069,-2477,2326,-180,-509,1519,-1740,-1485,-1622,-1030,-729,-1166,36,-1827,-1280,-2082,2529,-2039,-2576,-2201,935,721,1301,-426,1397,278,2384,1167,57,-1085,-2260,952,-1209,2249,965,2348,-1073,-1069,-879,2167,1789,2456,-1755,2390,-212,-2387,-448,-227,-1332,2040,-896,1365,1689,-1538,91,-2544,2142,-282,229,1263,-2450,443,-1387,1993,-1244,1833,-2029,2506,1294,-559,936,-713,1740,1870,1812,706,-1080,1891,-1754,2301,-1147,1896,2464,-1909,-1130,1465,666,1329,1222,1456,-1473,2213,711,-245,2216,-922,2327,649,-961,-1318,-164,1531,-1266,-2246,2224,2369,1032,-871,-2080,988,2125,-1741,471,-2200,1789,-1797,-2072,1903,-2322,-2383,-1281,2212,565,2033,1644,1789,1921,-1576,2121,-1382,2560,-1160,-1652,-2453,-1450,13,1152,1504,297,1855,-2307,-590,1862,2016,1438,598,1936,1933,-845,-69,-1345,-1768,-1012,-659,-990,-1254,-1932,-68,349,-746,1718,-674,-1745,1945,-741,-712,-698,1149,621,1106,-1266,-1637,1473,-843,-1355,1713,1489,-665,-1096,2395,-2301,1088,776,1447,-2494,-1995,2551,1146,1761,-2230,-1225,-512,1311,-1553,1223,235,22,-2421,-923,-1939,2521,-280,-371,808,2238,-684,1144,2417,1091,-849,-38,272,813,929,576,-1939,1649,-2497,-910,-1502,2300,927,136,491,-553,193,-706,23,-2165,-1475,-1883,-427,-387,1837,-1135,506,-1800,1987,2309,73,-566,367,-642,-916,-2302,-2191,-2261,-1953,-1920,2414,383,-252,-1890,-918,1801,-2447,-641,-1374,984,1035,555,1605,-1801,-1836,-1139,1021,-556,277,-2452,510,-1436,664,-862,-456,1692,900,2361,-1325,-1997,997,-1451,1641,-180,-704,1536,2165,1787,-705,-1983,-857,-2342,-1340,428,-1186,-501,-181,-196,-176,11,2279,-365,551,-1558,270,-2357,-1245,-2158,946,-1513,-1878,-259,2496,376,-508,-640,-1109,484,1469,2324,505,211,-1893,89,42,-2331,2291,-2301,1825,2408,-1682,1188,-1071,-1190,329,-943,307,-443,1143,769,1168,383,558,216,2354,-2466,263,371,-1667,1161,857,-1754,-1504,-998,-1463,1785,2032,2145,1492,2325,-1057,1401,2549,964,983,226,-603,1077,-1728,-2495,-183,-2219,-675,-827,-816,1979,2155,965,206,-168,690,-313,-670,559,552,-1950,-1596,191,-1812,1829,-1290,1995,-1122,-928,-1063,-1564,-864,1501,-2070,2440,-104,-1386,575,2483,546,-728,-1031,-1547,-491,1843,2274,-300,2274,-382,-1600,1098,-1377,2541,369,74,1305,629,205,-1234,-833,-1483,-1797,-587,1393,-1531,1124,-173,-343,1217,1861,-653,2250,-795,278,-155,-1042,2540,1558,-144,-2098,-2211,1252,-1721,-976,1489,-1959,-2043,2494,913,43,2018,-150,-836,1403,-1980,1264,2023,-1016,1599,1501,-250,522,-691,-1461,-1786,602,-946,-2437,-1679,-2029,-1463,999,-1879,2157,856,-2326,-915,1957,1397,-132,-1119,-2169,2259,113,2290,-577,871,-537,2282,-207,1282,-2329,-1954,538,1465,1978,-1698,-355,2285,1620,2177,295,-36,-798,205,79,479,-210,2002,-173,-1936,-1947,-482,939,-660,439,1625,-2357,2196,-2233,-2353,-2210,-1974,363,-204,-1484,1116,305,1582,-839,-1629,251,1996,2160,-2580,-506,-883,2267,-1371,209,-2263,1814,-914,1674,-1939,1922,885,858,510,-1134,-539,-347,-2342,1088,1283,819,-2189,2500,1780,751,1649,1589,1237,-1957,1962,-2233,2340,-938,-370,-1134,-1044,403,2503,-1446,-2549,-2318,1641,1496,-1991,883,-2488,-2230,-1276,15,-842,1850,-1445,-494,2492,2442,2160,1072,-655,1941,888,1194,2227,-83,1332,-1865,569,2186,2381,1733,-1923,-1284,175,-2363,-1777,1493,-2494,-934,1241,1118,1780,-96,-2052,1019,1925,-2544,541,-1354,1695,1477,-7,629,1787,-22,1321,-1786,-1033,-1633,-375,2537,1272,31,-1782,-244,-909,80,-1934,-2534,-78,399,277,-1059,675,406,-1942,1003,866,-1575,-1448,2561,1853,81,1771,-1877,371,-1028,-1748,400,-1396,-924,-344,286,-577,525,2062,-1812,54,-915,535,-1121,1979,2264,-996,-190,1184,-153,1629,2224,366,-1756,162,1363,-2243,-880,-1038,1112,-326,2271,1160,-523,1778,-1032},
  {551,2064,-1248,-2218,2192,-1905,-1566,-164,456,969,185,986,-993,-1204,-1085,-791,-1020,163,2537,-829,1593,2348,-1931,-353,-206,-334,2498,-2085,765,-658,-740,-1551,1033,-1752,2422,-1778,1499,-50,-1137,1417,-1020,-2500,740,-473,-2317,-2257,-2424,107,-2123,1582,-2535,662,1858,881,2009,805,835,1170,-1480,-2457,2164,-259,-1924,1177,1615,-273,618,1772,1159,-1462,-1154,1344,-2095,-1963,165,1202,1743,-1254,-2395,-2061,739,-989,1346,365,2246,-1416,-1753,-70,1709,8,2413,-163,-1496,1194,728,-306,-2251,-2346,-1220,1912,1067,1810,646,1154,-1543,-1929,-17,1896,2256,1958,1190,1234,-1025,-1434,-789,2265,-2179,-894,2372,-1373,-1397,-1681,-2431,1016,-1881,2043,-2044,1552,25,2216,1665,175,-752,-1893,2124,1685,825,376,-912,-1469,2304,-567,-633,-848,-1703,-470,173,-450,-1937,601,-2388,-2219,965,-2211,-1129,-1195,903,-908,1975,1447,-219,1435,2194,-1127,1199,-907,1681,-857,645,858,600,315,-1044,-712,-2482,1037,2019,1822,-2043,1201,85,823,-1658,-1471,1874,1369,-1859,-546,-1232,229,192,1360,-1357,81,-2340,616,1674,1573,428,2456,-1620,-1267,481,1176,-2278,-2525,1835,463,-1616,513,2530,-1774,-1408,-2134,2428,277,-1740,-319,-2200,2240,827,2106,2131,-625,289,-47,-1850,-1214,1207,614,1722,967,1338,902,-947,-2502,-1329,-534,-2076,-2144,2017,11,-1777,1226,544,2346,362,-580,-2165,552,-1151,-605,15,1987,128,-710,-505,-958,-2564,-1161,-1324,-1279,310,2297,-2073,587,-326,-549,-2517,431,757,-613,-1830,216,1183,419,-425,-1102,2574,1094,-2068,2153,-1025,303,-57,172,-1294,-791,-538,667,-1231,-2372,-1699,-1502,-2498,-1059,-2451,-1211,-1432,-818,-1906,-1911,-413,-1025,1561,-2308,-497,1648,-534,1194,-1395,-1482,-1084,789,-2209,-2152,-684,2362,-1968,177,1146,1516,-575,-756,-1524,2063,-1592,2390,1564,-1742,2150,1419,-2361,1771,-2008,-2581,1473,-1604,1155,-373,1801,-2334,-2023,169,-454,1503,-1139,-1794,-1180,1583,1531,1635,-468,972,-10,-173,-1247,1828,-723,-2166,-2200,1109,-2557,-2105,-314,795,-2533,329,2237,524,-1030,-2308,1300,512,1404,-1771,-2109,1398,1861,-131,-2018,1759,-2058,-2497,-205,807,791,-169,1730,-1133,-233,-1285,-1880,-720,-880,972,260,-1331,-1691,1222,-1810,-1988,1680,-1791,2233,765,-57,1273,-2225,-305,-1255,546,2065,-1853,-482,2019,1788,1619,-197,-97,-65,-1893,1878,85,1738,-875,861,-191,-253,-514,2562,2438,540,-1950,411,2107,-180,-1059,-1171,-1581,-1351,490,2290,1386,-298,-695,-1519,1777,506,2127,2242,-1946,-1505,-575,-1390,266,1108,74,200,-90,-1540,31,749,1710,-774,-314,-1575,1874,1811,-1131,2180,-778,2145,535,-139,-609,-1064,-1403,-751,-715,2396,-1154,166,1738,-1689,2346,2100,13,1295,-1651,1480,344,70,1150,-109,2073,2402,-1112,-2462,-879,-1656,2578,1388,-1940,-1487,1501,1227,-702,2053,609,450,-407,-1665,-451,-1958,-1057,339,1777,684,-578,-1590,2551,1676,2400,-1886,-1292,1782,-1636,2504,559,-71,-1898,-1544,-105,-133,-2113,-2543,1868,2295,-2492,1449,-2380,-2437,1904,1057,1768,-229,1584,-11,2257,264,-749,-718,-2474,291,-1175,-1972,151,-2223,-907,845,-1171,962,-889,606,1386,781,-1027,1669,258,1457,-1834,2093,-287,1817,2547,1738,1494,-55,519,1528,2108,-486,-1715,-2150,-478,-1490,-2352,899,1982,2319,869,1302,-25,-958,-1210,-792,1986,-852,-2158,117,-658,1199,1047,2530,-1870,-1186,-1235,-574,-658,805,1776,-660,2296,-1972,-1049,1173,-939,-892,-660,-1122,947,2424,1214,-1374,969,2479,-587,-1432,877,588,1596,-1268,-56,-1105,-1372,2375,510,-2311,-2070,1015,-860,-1611,608,-2114,-1698,345,1833,440,1048,1323,2228,2128,-2253,-340,525,-38,-1309,-2009,1830,-891,474,1335,2165,-543,-256,-1507,2295,-1083,2529,2326,-745,-1364,2117,-588,-2516,-1962,218,1419,472,-175,1696,661,-2015,2517,-51,1491,2106,-279,-2577,2139,-1504,2515,1510,-126,629,537,879,-2436,52,-1941,938,-1740,662,-224,-790,2232,254,-523,-289,278,1187,1087,2219,-1093,-1186,-570,-219,1895,699,2572,-2439,2536,1062,-311,-868,-1949,-2502,-1037,2346,567,1044,2359,-72,-1109,308,1631,-1999,-1597,743,-1143,1768,2338,-1537,2352,-2428,615,1929,-1552,688,-2108,1522,2404,1774,1933,263,857,573,920,-1148,-2472,312,1797,1178,-1510,1145,326,-441,-1414,-517,-2158,2098,-389,-2376,-1367,-2136,-358,-214,-2181,511,956,298,-2193,-478,2162,320,2338,880,-1015,1621,-736,2175,833,-2043,882,1610,-45,36,-2432,-846,1552,-2197,-328,656,284,2180,-794,764,1668,1214,212,-1186,2168,-2435,-106,1003,-587,2291,-1566,319,1562,-1579,-662,-1265,-284,1437,-2527,2423,1635,218,655,1781,-2402,-2092,539,-1221,-1420,2149,-1586,-205,-1259,383,1470,2392,-2570,-2057,310,3,461,-223,753,1756,1550,-1305,-1782,1186,-730},
  {-1134,1069,-2078,1445,-2146,-2030,2365,-445,-1201,-2439,-2351,2363,2523,1464,2139,-933,-668,-2527,-1507,541,-2230,2128,-515,-2372,1549,-634,-2262,2359,-1369,1533,1468,-1802,633,-571,-260,-1260,726,1931,1725,-2130,-777,608,-1496,-1379,-1098,614,-524,83,-434,408,2370,2157,-11,-766,-2502,-1502,2567,2159,-1075,-1091,1543,2524,1997,-374,-2078,-1075,821,2229,-950,2489,-2017,-1905,2107,-2057,-1147,-1024,1142,-429,-1031,-796,-83,-2257,466,-2135,-933,936,2153,284,-1163,-1423,-595,-466,-1812,-2294,-1426,2131,-612,-18,2302,-1028,880,-1220,1068,-138,-1934,1648,-950,-517,-325,-376,-1751,1405,-674,1984,-1782,-1536,529,705,-1788,-100,-1038,2270,-457,-1706,426,90,-667,599,-1681,1210,25,2361,-904,1223,206,-37,260,-306,1714,777,2258,-1447,-196,1635,1672,2489,1710,16,-2574,-1796,533,1229,-1861,-1962,-537,-1786,383,863,1786,-1476,-326,-4,1247,1614,1504,-602,-1116,-2402,-575,2380,-1238,95,-451,1673,-2235,2559,200,-2382,1309,2311,2420,-2298,2374,-1534,133,-2392,2334,-698,-2219,1461,-485,-1567,1703,689,1492,-698,281,-884,-369,2461,691,1733,377,-600,2354,-1000,-2033,1666,-1587,1856,2473,1956,769,2126,-397,2444,353,-1591,-4,2104,1716,2139,2462,-293,2476,2174,-1702,-75,1487,-2576,184,-362,2056,-39,-44,-846,1678,-2575,1216,-609,435,1085,1130,1727,964,464,1815,1186,-1589,-1787,-1933,2325,870,2246,1779,2302,630,-1137,-1719,-2018,-1119,-1265,1658,1922,1952,-672,689,258,-1912,-1915,-1395,-2419,-311,-622,2479,4,-1107,1408,1793,1552,45,-1339,-1588,-934,1632,-2530,1343,-2024,166,-1574,-473,-354,-1227,992,-907,-654,-540,1851,-1657,-732,-2396,-178,1921,-90,207,2228,-1429,-1892,-1991,-2016,-1505,-2271,1698,664,-946,-1437,-158,-1667,-1009,-1375,-121,-275,147,1059,-2261,379,-518,-1960,-294,88,-114,-69,-167,2539,1184,219,-791,-542,898,411,2513,741,-2017,-2189,1407,2494,360,1927,-1166,-1671,1564,-1655,-1156,660,582,-1111,-1736,956,2111,-1350,530,707,681,-461,2329,2537,-2234,-312,686,1864,1604,-929,-1929,2444,816,2393,2538,-717,-1809,2114,-1826,-620,2261,-2413,712,1035,-1870,-2192,1388,-1249,2277,112,-2189,2272,1500,-1723,999,215,-413,1702,-1936,110,-442,-1657,1020,-2353,-919,-2200,504,578,565,2533,1190,1250,483,65,2071,2339,-190,226,-1927,-2346,-1969,-1634,-392,1882,-313,1386,1212,127,645,277,2219,2176,1318,-1023,-953,334,-263,-244,-1115,-1522,1393,-407,-1351,438,2209,-568,1,-416,-277,1714,1572,-169,-954,812,811,1970,-2184,795,-170,-1379,1440,-2086,-47,943,680,-1314,252,941,-1537,2136,2018,-2387,1323,918,-1569,507,1517,-1265,1911,-892,-1363,692,1214,1838,181,940,1550,-1308,2475,-666,2234,539,-188,-780,1207,1593,-477,2241,1313,1673,-1117,336,-1779,1033,-2478,1102,540,-945,1484,1662,-1120,-1440,1394,2202,-82,2352,-480,951,-1670,-1142,-64,2303,-2356,1261,-1868,-2502,2296,459,1042,640,2543,-39,2159,550,602,-2371,901,-2547,863,-954,-106,386,661,-1630,-573,-2073,-2539,1266,-870,1386,-471,542,-746,-113,2092,-696,-397,-1396,606,-1308,-1216,927,2109,1330,-1929,-2128,-472,-630,871,889,-1485,729,410,1278,1359,-1560,2295,-661,275,-1405,-1307,1977,1257,1172,2272,1647,1922,25,881,-1023,-511,329,855,-576,-1046,-2238,637,-888,-759,-689,872,2270,-2108,-2082,-1546,411,-1949,-1098,1217,231,-690,-596,-753,-170,1155,-96,-2212,240,-2231,-500,1620,-1337,-215,117,-290,-2395,-772,-32,1665,511,-1689,1115,-349,996,1190,2453,-1193,-161,864,1218,-1719,-869,2424,2235,-1716,298,-871,-599,-2011,-1343,1569,-1759,624,-313,-2259,-1730,-2430,1168,-744,2106,-1702,2485,910,-1812,1654,1223,-1951,672,-1716,1660,-1156,1627,-318,-2239,2532,948,1613,-2266,621,301,1075,-1298,2539,-1408,-2059,-899,1759,-2548,-2461,-1993,1777,717,740,2486,-2237,-1343,1524,843,-1953,-382,1586,-1049,-2362,-2565,-1278,74,1390,217,-2538,1878,-1273,-2075,1221,1946,-871,705,783,2287,2310,1503,2289,-2227,-2243,-557,2436,1272,-1692,1170,2559,-2579,262,-423,829,-227,-1125,-1200,-414,-1532,-1451,-1223,271,1681,1613,1569,-2346,2357,2076,1926,-1379,1127,543,-1595,-2067,-1001,-227,-2198,-2549,-1908,1414,-2398,-1282,2478,2544,-43,-959,-1161,1661,261,578,-1150,-1576,2113,-1842,-1846,-1435,1492,-1897,1512,-1360,-186,2472,-173,892,-242,-1685,-1780,-131,1323,-844,-2403,-324,-2401,-122,1702,-1665,2574,-2106,2319,-1875,704,-1629,528,1658,305,1223,-2450,2488,-143,1984,-2503,-1184,-21,-1233,-1215,597,101,-2067,1416,2317,-1039,-400,-2415,1068,330,1573,-1547,-805,81,-678,210,-689,-1302,-241,356,572,808,755,1307,-1850,-1353,792,-1132,-2067,614,-240,-734,2434,-1788,-1027,-125,-208,-1996,403,634,1435},
  {153,1079,-2113,-1285,-2076,-1335,-2053,741,750,2267,-1789,60,1146,-679,1114,2212,1862,833,-2579,-2081,65,-376,-1397,299,-984,1331,-1360,891,2336,212,2230,-450,-754,-2048,361,1317,-872,-2349,229,1616,-1866,-1584,1828,140,-369,42,2106,-1184,420,-1924,-119,877,-905,-1738,-2198,-1920,-108,-613,-16,1712,946,-464,-1247,-89,54,-425,1659,-338,-402,1513,1668,-698,-2097,-95,1191,-1975,2142,-249,-496,538,893,-87,411,-932,-1194,-701,-420,-295,2041,-290,-143,416,-457,1700,-2543,2398,-2271,-593,28,2012,-1632,2125,2213,430,-440,-715,75,259,-1664,-951,-1346,1758,2468,-768,1482,-675,2148,110,1480,1679,-1015,1563,294,-182,-291,1572,-743,-642,503,-211,1332,-1807,-1644,1450,1447,88,-2160,-2481,-2242,-2213,-1152,-1202,-2319,-1077,432,715,1744,1151,-1152,-2326,-1163,-2065,1021,-1513,467,-2346,-891,1413,2531,-342,-1011,966,-45,-2490,758,-2141,298,1082,416,1990,1926,-1407,988,1635,-2039,-411,47,-317,1361,-2217,1484,2360,2125,655,1606,-457,731,1929,1413,796,-977,-2249,2089,937,-1623,1942,1156,-500,-2391,-1629,-97,510,-2280,-1566,91,1319,-1344,-897,1520,1672,-15,1030,-1213,551,-2492,2187,-2119,1301,-130,-967,2292,2539,-469,1727,2467,2329,415,-995,-2403,646,-572,300,-1216,-1849,-2539,414,-117,-130,-1289,1954,207,-1368,-1724,1934,-2522,698,1889,-1792,-2057,-2113,-460,1014,2515,-978,-124,136,2172,-1479,1797,551,-569,449,-1828,-925,658,2230,2535,-1118,-920,-67,803,-1231,2241,-817,-1578,-188,2213,-1475,-2144,1054,614,-1585,-1651,1582,234,896,-14,-1702,-9,-1405,-219,962,-1409,-702,-2299,-1539,-1691,-846,483,-1545,-1177,460,1012,1343,-2581,691,-2461,2534,34,1427,-2317,-651,-1529,2183,-513,-70,-2334,-160,1348,-2451,-1348,-2358,-954,-1927,-1907,-1587,1933,506,-128,-802,1810,1086,1977,1145,2501,795,-668,170,2198,1451,-1476,-737,-45,-709,976,153,2327,-954,1179,-1084,2024,-1412,-708,-1553,-2368,-2215,-1178,-1207,-1943,116,652,-971,-1532,2248,1910,998,133,755,-582,510,-310,-178,-2446,-497,1973,1776,-2050,-1083,1636,-2577,-993,-2035,-576,1695,-271,-2401,-1838,2149,2567,-1103,2344,-710,673,553,-702,897,826,1380,-1013,-224,2188,-1318,2117,-87,-2573,1874,-398,-2491,-1726,-1995,2368,460,-726,2577,-2280,2068,-499,-864,-565,1885,-1757,-960,1493,-2401,-961,1367,1576,-2244,-162,637,313,355,-1728,-1901,-2435,-1643,1192,1791,1681,184,-223,-1122,922,925,-1275,-969,1604,-2374,-424,-1572,-1059,-2234,1212,2409,2514,-470,-1593,2344,2417,1696,3,-2102,-90,2405,1446,661,1733,-2541,-1042,-1204,65,-2220,-1435,1010,-1287,2506,1004,-556,2176,-161,60,1247,361,-67,1196,-2291,-109,-1845,516,-693,1263,-1422,2329,-356,-2083,-1328,1523,467,-676,669,41,1883,-2242,-1632,1517,-1370,368,1778,2378,-1834,2552,-278,-753,-75,-827,1714,-652,2198,-2020,-1552,-715,-1040,-1477,1639,-1983,-1304,-243,-782,-2136,1367,-478,-2133,-420,-1809,2259,810,-2327,1518,-2248,595,-401,2382,433,-2523,-1146,-1108,-1163,2092,808,1437,255,1673,-992,1921,-1342,317,1528,-571,2134,-1719,-1872,-108,-1948,-838,705,2361,664,-373,844,1042,-2532,-2422,-2134,-1867,931,70,755,-1573,-1060,210,-2303,-1396,-1195,-1810,860,-2581,601,-1356,-152,88,-193,-404,61,-666,1809,951,-1741,1322,-2119,-1708,-1469,1218,-2045,843,-2312,1311,275,1950,904,-1585,229,1013,-1825,-449,458,-631,-1528,1210,577,1114,-1806,1343,-2208,2048,-1538,1510,851,-84,1378,569,-1143,-1582,129,-104,-2285,729,-1712,942,2103,75,329,-1550,2205,-1370,-331,-1862,1935,1224,-147,105,-2308,-1891,-1707,-1614,-1248,-1003,-1933,342,1992,-1279,-701,2459,-190,681,-1903,1764,-415,-1569,85,1728,-1387,2163,10,1905,-1586,1406,-1849,1342,-1328,-536,176,1280,-451,-2293,-359,-650,895,665,-668,465,2114,655,-1865,-1036,1660,908,-2524,-2574,699,-1228,2048,15,1396,-267,1425,413,1488,2472,-112,-819,457,1783,-1531,1810,-1674,-1707,978,454,1081,668,-197,233,-1613,-206,679,-686,774,2082,-1393,2164,1329,820,-668,-1379,-1066,-109,-2029,1099,2054,-1745,2035,1279,1508,-1900,-1390,-864,-1163,1182,378,344,-716,-2414,330,-735,319,546,2442,-1642,-1229,1688,1479,-1249,-1831,-1258,800,394,-2268,-407,2271,-21,1158,1224,599,-1343,-1378,-2583,1607,952,941,1453,1834,1528,1277,146,41,1429,1390,-2000,-2490,-2528,-1235,1860,-1361,-2152,1701,29,1138,1172,2259,2355,-715,-1366,-2392,-2348,-1798,-738,117,1114,-1884,1562,295,-2036,-2359,-1413,-1887,1592,260,266,-706,2452,-1398,709,-1796,2017,-1256,-212,-1969,2416,2256,-1667,-1977,-1059,-504,1070,247,-2137,730,1883,918,-2546,-1922,-2547,-2219,1748,252,870,-4,626,-2286,-110,-1603,-1561,1441,124,739,442,-2575},
} ;

static const unsigned char precomputed_decode_857x5167_s[precomputed_decode_857x5167_NUM][crypto_decode_STRBYTES] = {
  {253,36,143,249,184,183,61,55,50,33,210,145,203,146,154,153,17,251,91,161,247,139,59,207,222,200,130,123,164,108,102,181,71,216,61,160,76,104,55,74,75,64,82,199,49,108,220,218,40,132,9,214,56,82,189,118,194,54,115,3,139,172,98,228,91,90,21,55,96,16,125,163,215,105,200,107,209,248,132,68,94,243,143,214,151,213,84,194,210,115,246,139,149,130,90,33,31,167,30,166,211,29,235,8,53,243,24,160,75,137,97,218,121,72,235,193,121,179,255,145,65,15,172,219,49,41,208,39,223,204,138,125,100,19,34,112,140,132,28,248,135,19,19,122,109,198,92,179,111,216,163,85,248,134,232,20,240,107,173,9,41,142,203,134,185,200,115,50,94,130,45,190,125,12,10,240,96,95,252,69,33,211,22,167,86,51,39,125,17,98,68,206,125,32,194,94,58,197,179,91,186,2,189,84,225,170,200,19,188,223,3,215,162,135,65,189,113,139,102,87,181,163,246,190,172,191,249,121,251,220,74,148,202,140,173,109,184,74,24,252,101,145,79,56,219,13,145,147,126,199,51,102,239,35,106,238,14,189,221,229,218,255,9,23,9,175,79,62,252,203,43,180,227,76,113,165,210,167,175,68,21,86,252,43,143,227,234,128,124,108,133,84,221,131,183,32,2,212,220,123,50,24,22,86,186,24,28,165,156,223,251,159,182,88,31,52,208,32,79,25,222,75,98,165,208,170,52,228,90,204,64,216,96,28,127,68,56,79,8,227,21,20,222,200,25,140,179,18,1,11,200,22,69,109,102,225,148,107,27,111,90,38,172,223,14,190,5,174,163,202,177,29,124,171,125,231,182,0,231,108,180,24,115,7,236,254,216,52,152,43,28,59,210,199,254,195,175,16,225,19,26,46,166,100,47,72,15,236,86,172,97,171,18,29,154,63,64,118,238,183,7,220,57,222,57,95,170,122,166,188,44,21,75,217,128,56,208,77,173,133,144,199,218,156,126,85,253,6,168,105,179,43,159,59,165,141,52,242,109,220,163,220,65,135,59,106,109,61,24,95,212,56,215,212,185,240,6,85,66,173,133,232,208,78,137,145,218,83,167,217,120,88,46,196,246,85,49,231,38,186,196,76,116,241,244,50,163,105,54,251,80,102,15,214,255,4,102,33,65,187,165,133,176,151,127,243,52,188,216,121,117,180,230,205,70,114,139,5,83,192,118,244,37,185,7,221,139,245,142,129,5,93,131,4,50,8,114,105,108,118,202,76,68,180,194,252,30,18,16,155,166,59,114,1,87,135,228,76,143,102,202,192,134,97,172,0,241,16,104,162,178,59,37,11,241,120,146,238,246,91,49,86,61,5,223,17,148,149,173,181,249,202,62,198,71,154,169,52,233,189,71,0,125,55,181,218,252,28,138,70,202,79,62,143,229,53,61,131,112,220,91,118,148,194,47,61,248,89,45,153,223,194,121,152,97,51,76,216,112,214,83,90,219,218,213,214,144,116,12,135,51,12,55,168,207,170,94,208,71,202,152,35,68,5,71,156,104,167,243,107,246,61,191,15,20,79,57,16,118,161,168,69,152,167,221,214,77,126,76,233,237,44,251,8,29,220,160,29,224,16,254,181,160,61,225,88,51,37,184,128,54,92,108,9,175,178,137,8,159,188,251,138,86,13,201,77,63,202,230,39,106,6,63,16,237,186,215,73,137,180,126,133,253,113,8,26,109,119,214,140,67,20,129,132,122,11,52,231,182,121,179,77,55,78,204,40,218,150,193,214,175,55,22,25,193,3,69,49,121,4,142,53,24,128,186,136,26,228,92,149,57,251,81,128,132,210,198,81,24,233,96,219,148,161,140,141,127,51,239,68,38,235,246,218,68,179,76,50,242,8,202,30,50,148,50,111,214,221,78,214,206,0,39,46,179,220,208,57,195,215,169,222,146,170,145,86,148,33,180,63,0,140,165,217,83,181,149,210,227,30,121,219,187,25,146,97,69,94,110,161,93,175,143,53,229,63,211,251,94,59,197,97,168,20,7,240,123,90,0,172,218,241,169,196,14,41,114,212,115,235,230,178,111,48,8,166,21,234,33,238,229,157,33,179,91,131,113,36,63,185,214,231,222,83,253,226,116,225,227,21,145,128,200,93,213,119,238,140,14,113,47,217,122,159,213,145,132,119,77,220,46,169,252,193,33,140,35,225,5,104,137,201,191,188,60,226,221,166,178,231,91,161,27,2,98,70,170,60,221,172,237,142,35,107,245,147,125,49,3,113,195,48,214,135,31,91,171,0,255,153,173,55,243,177,77,139,146,131,208,105,238,225,74,139,147,95,5,198,134,193,157,47,97,160,176,91,32,12,103,109,241,14,11,163,46,159,43,225,26,145,23,121,128,86,29,213,12,72,41,207,48,76,197,148,181,70,145,187,124,54,26,192,138,215,21,48,78,18,196,116,97,145,184,199,78,40,251,129,114,27,17,148,177,102,153,249,28,149,168,254,131,35,197,192,193,9,147,122,41,225,152,102,193,34,185,111,125,188,159,77,129,101,186,244,9,175,193,243,191,204,225,40,103,32,225,88,251,71,209,161,144,185,34,6,185,60,3,135,62,112,250,237,86,181,215,78,34,83,6,235,194,148,207,181,16,65,29,200,140,219,129,175,48,144,69,106,83,38,92,41,154,45,51,213,140,105,138,196,84,219,207,95,135,211,141,27,189,189,163,102,236,47,196,164,37,72,180,108,160,22,251,119,215,49,84,164,186,86,41,85,120,54,126,105,249,119,28,175,185,12,87,95,81,18,184,118,12,26,181,26,65,226,205,252,22,206,209,26,73,3,127,85,218,153,97,16,245,95,184,120,175,27,89,155,172,86,152,148,123,140,57,15,205,181,206,36,131,116,23,67,208,191,95,6,223,134,67,38,167,163,71,112,247,240,56,15,20,193,89,79,27,16,18,249,85,199,177,32,149,80,133,104},
  {103,109,58,204,33,135,22,188,255,23,15,110,99,191,218,78,65,134,6,94,157,213,246,211,48,90,71,87,127,210,171,100,177,146,88,139,253,196,6,100,88,145,93,104,228,180,125,22,119,98,243,215,81,45,244,47,97,242,113,243,55,77,227,116,128,48,14,104,109,112,142,162,188,227,163,117,229,216,146,40,160,185,149,124,30,21,157,36,117,88,208,223,174,205,250,146,207,176,148,106,201,104,180,174,34,148,87,44,154,24,132,255,9,157,18,65,171,43,129,121,60,34,89,193,12,188,68,5,65,103,242,130,213,109,247,145,145,88,13,219,55,5,39,210,95,155,95,54,22,11,151,179,40,98,130,116,35,29,176,205,234,210,249,221,122,50,138,37,91,88,125,136,132,137,1,105,181,94,212,88,190,147,197,175,249,166,207,156,139,185,192,234,226,13,68,56,165,187,228,84,95,197,25,106,215,147,124,56,47,28,128,220,6,107,167,144,243,130,248,66,49,190,228,113,208,252,52,242,193,29,147,244,36,211,67,105,21,145,148,158,54,150,117,82,38,169,62,247,51,45,190,248,44,89,118,182,117,38,37,29,83,212,61,203,252,239,63,102,156,161,186,94,210,176,220,189,85,204,56,251,131,103,240,143,171,63,9,78,171,68,5,168,235,61,33,40,104,44,138,44,5,254,132,222,173,190,239,156,112,209,199,210,239,224,151,252,74,231,31,157,30,59,69,19,29,81,226,24,154,94,59,153,60,72,157,42,149,63,88,76,215,178,112,251,123,46,127,58,85,122,120,158,240,80,131,12,13,203,211,231,83,23,220,175,11,93,210,150,65,9,142,180,100,19,167,20,189,224,136,99,95,87,215,201,172,79,96,96,15,99,124,95,200,228,84,79,247,192,15,2,66,236,15,130,124,9,206,13,160,155,167,183,46,160,27,221,137,92,188,9,132,112,65,107,117,186,156,164,245,40,236,241,106,244,192,208,47,49,122,5,255,76,184,255,141,227,160,196,203,100,204,75,222,84,184,163,58,138,146,152,253,27,47,133,164,235,55,106,190,139,254,97,234,230,246,171,147,14,28,78,206,189,12,184,109,160,231,190,66,138,64,213,184,91,122,32,138,13,81,89,38,235,144,193,20,2,57,92,36,188,89,155,2,27,155,82,226,203,222,32,115,202,124,239,190,203,234,186,185,204,147,11,1,99,220,23,85,237,195,63,5,17,91,196,9,25,59,146,164,162,213,163,76,159,186,13,85,144,28,37,160,96,219,156,36,249,208,186,51,14,75,29,204,23,6,135,100,129,98,155,76,233,141,119,40,248,174,58,181,247,234,60,207,188,108,70,214,65,202,136,247,207,56,65,224,74,241,76,68,205,133,185,68,179,5,244,128,172,168,163,203,85,170,112,217,16,58,114,187,207,160,135,20,65,27,128,57,239,63,115,99,230,165,153,80,200,48,54,112,82,135,94,253,22,95,19,215,123,113,240,219,11,2,103,49,127,198,155,100,16,159,252,167,147,24,80,172,216,131,236,1,103,244,212,200,180,201,192,187,226,139,36,93,199,77,71,202,255,88,192,241,156,14,219,102,102,170,191,54,229,83,71,244,167,77,42,225,105,12,212,147,110,50,117,189,63,89,101,249,162,51,2,79,12,135,244,174,27,124,62,113,16,67,139,188,75,222,200,144,232,130,167,102,151,38,116,220,224,36,49,240,63,155,151,161,240,159,236,223,231,16,17,147,90,209,66,160,207,156,241,194,50,253,247,130,243,2,27,244,121,193,40,124,160,88,163,191,134,126,243,5,127,120,103,168,145,122,233,182,109,102,47,187,189,11,196,162,78,195,208,133,56,123,241,7,251,74,175,185,230,218,29,218,182,64,110,79,25,123,128,182,221,54,77,159,120,19,238,44,29,165,37,199,210,24,43,14,5,240,36,200,108,217,175,169,207,150,249,176,153,127,119,94,208,32,192,61,236,156,113,66,234,203,134,42,237,79,252,82,182,145,95,102,155,213,188,236,68,111,203,75,180,55,237,114,255,39,132,92,187,82,225,79,164,162,209,236,188,255,176,0,102,249,245,252,12,61,145,128,149,244,164,205,57,161,93,195,46,74,87,157,83,18,104,232,91,27,2,109,244,209,230,219,2,210,130,254,136,195,41,171,230,38,43,73,96,50,60,35,158,49,126,26,194,253,165,80,164,217,14,4,70,34,131,232,39,84,85,7,187,134,168,23,253,240,55,103,168,232,149,33,209,85,231,233,0,103,40,63,192,41,158,80,104,47,179,143,229,38,146,108,1,183,19,106,92,113,223,15,122,248,125,245,12,202,234,115,23,84,142,190,7,212,201,87,16,164,229,186,216,2,219,252,243,26,142,134,159,123,123,224,119,44,28,174,125,169,177,202,188,179,235,228,73,246,3,229,87,71,38,123,121,219,71,94,27,216,94,123,224,137,238,85,58,69,66,199,240,74,92,39,144,255,28,199,150,207,51,0,158,204,129,221,42,107,246,132,162,176,72,185,211,147,62,182,243,40,226,230,5,32,156,209,40,30,132,96,50,238,65,181,10,181,195,254,139,99,240,10,88,94,31,80,209,254,139,229,71,193,217,55,87,77,214,173,92,41,81,101,225,162,123,120,140,3,210,244,154,136,44,188,45,98,138,34,17,83,144,155,99,118,164,208,236,45,117,209,24,75,117,51,23,241,186,194,52,160,39,150,20,110,2,192,30,145,130,160,114,8,149,163,142,75,217,245,158,42,125,242,193,76,215,233,66,153,146,101,70,222,97,154,208,85,110,63,156,232,161,145,176,55,203,59,237,193,183,126,15,169,46,17,161,192,24,96,31,49,81,36,219,83,59,203,227,83,50,216,5,236,125,21,197,19,131,204,19,66,165,215,190,89,17,158,71,191,47,255,89,254,178,141,215,126,220,120,217,138,255,127,181,4,7,247,129,210,204,104,68,6,2,70,57},
  {37,244,125,149,60,155,218,163,214,95,246,244,243,38,96,41,195,113,192,81,74,110,209,170,247,185,147,164,106,136,54,163,244,173,248,87,171,241,255,199,231,156,75,241,192,20,129,57,134,217,149,201,163,75,200,58,184,242,208,167,187,181,115,59,213,230,192,112,145,233,176,118,228,138,213,239,3,226,37,234,158,189,41,94,131,120,221,28,132,122,111,240,18,204,251,173,158,66,146,172,196,131,38,211,82,151,175,233,3,10,108,111,238,25,90,143,208,71,248,198,4,165,81,45,128,202,174,231,229,15,224,213,81,25,83,198,38,145,169,249,121,163,185,151,207,243,238,249,134,12,8,152,213,248,81,222,64,188,78,88,78,94,129,245,170,63,246,74,5,83,235,40,180,149,102,105,198,227,182,233,222,139,244,199,173,25,72,177,224,215,186,34,118,9,254,173,29,255,178,182,46,85,161,99,234,225,61,2,221,254,21,241,163,81,119,95,152,65,148,146,185,91,35,160,30,33,229,191,47,157,146,38,47,165,210,252,29,178,65,177,54,61,203,221,68,73,37,57,6,198,158,247,16,200,229,53,7,14,27,143,178,239,168,63,144,188,95,10,67,173,192,242,231,164,187,10,125,174,65,20,168,30,162,6,50,62,247,33,252,151,121,197,165,225,179,28,9,158,115,243,70,158,75,159,43,90,95,127,105,182,126,157,218,16,203,96,165,65,238,67,90,1,80,47,16,137,114,38,82,159,51,63,206,221,37,249,183,241,71,27,44,38,140,18,177,87,129,159,249,236,147,58,248,180,157,26,12,9,181,72,47,112,86,90,48,191,78,14,54,169,5,120,123,89,215,94,151,50,93,85,90,199,34,122,29,77,146,214,109,60,197,141,227,200,215,221,176,167,45,223,242,84,95,10,77,48,209,56,102,68,144,103,116,66,34,210,212,33,16,129,19,178,161,212,78,16,141,245,93,184,176,137,123,72,165,13,233,1,125,114,135,172,8,159,115,51,169,240,241,227,233,209,109,99,170,177,41,5,189,85,121,246,246,62,66,9,186,25,15,226,119,18,245,133,5,22,68,163,254,249,3,100,9,58,128,158,153,205,58,150,181,55,255,55,96,48,126,77,226,93,152,156,163,41,4,27,244,136,237,48,62,191,144,35,8,82,206,31,9,169,32,160,225,66,159,18,170,101,141,233,226,41,22,167,185,21,93,195,56,228,137,124,196,30,163,47,124,61,211,118,96,243,251,105,167,196,180,216,119,158,138,146,193,193,187,148,23,226,206,2,238,202,90,36,140,116,55,183,236,155,112,235,44,138,101,28,145,147,105,176,240,11,184,158,231,73,88,57,197,175,218,90,122,172,214,129,187,17,29,23,122,235,50,176,41,70,51,35,188,147,205,59,45,77,244,232,121,219,108,39,162,0,108,146,207,53,81,27,24,250,78,187,14,38,29,240,82,40,240,114,228,197,128,7,73,5,223,65,66,189,14,184,229,149,50,215,79,35,17,164,96,138,129,242,1,40,64,120,151,14,0,110,53,94,187,183,56,199,99,211,204,132,228,62,158,179,2,197,9,45,141,138,235,1,43,108,232,128,149,209,48,183,98,18,91,34,88,66,64,3,71,57,100,36,74,189,92,3,130,232,115,197,173,87,224,205,155,15,110,229,28,62,254,57,172,106,225,123,6,146,214,133,154,241,118,188,227,99,15,56,148,165,64,10,91,86,106,35,184,74,112,7,23,66,52,30,161,76,127,222,218,0,53,22,94,159,239,82,178,254,215,55,61,98,80,224,97,154,215,125,61,42,227,74,201,194,73,139,199,115,135,96,213,3,110,224,48,169,53,76,156,206,95,71,18,185,112,190,10,16,56,60,149,6,187,192,228,102,56,191,175,252,148,115,247,16,158,208,142,193,90,209,12,81,73,174,87,235,3,111,20,243,145,124,94,43,203,172,99,7,237,226,126,7,153,201,225,69,235,94,58,107,125,30,24,203,118,66,35,236,115,121,175,94,0,183,187,236,207,199,167,198,239,190,226,61,244,100,85,147,102,84,111,232,136,8,105,72,110,20,146,47,150,84,186,202,146,36,55,89,117,29,139,108,112,176,30,1,98,51,192,110,88,159,223,175,43,219,142,76,67,82,237,73,70,244,44,226,65,174,188,2,160,109,127,38,219,190,90,70,87,134,118,245,239,27,181,212,12,70,233,223,77,209,50,149,9,191,191,112,64,112,11,111,38,204,68,252,178,133,248,132,224,213,181,19,101,71,173,108,148,212,36,169,147,93,83,67,52,137,107,89,92,80,83,238,219,188,82,236,177,133,25,68,32,3,226,31,207,130,29,235,63,195,237,150,246,72,248,226,113,141,32,131,38,198,123,211,80,82,219,49,253,114,141,187,16,20,214,102,243,92,166,162,153,123,43,173,14,215,58,237,233,10,97,20,162,224,208,220,0,19,251,107,159,235,98,172,45,246,123,84,152,182,157,209,8,219,249,141,175,92,158,51,226,85,182,181,182,255,250,199,115,223,103,228,105,83,155,78,153,50,163,171,109,212,131,138,166,146,32,10,132,127,24,137,229,22,78,210,241,90,181,69,228,167,157,121,93,16,132,182,0,115,97,172,51,135,226,145,55,227,93,22,104,174,4,144,235,241,196,165,30,178,223,29,56,218,28,218,89,36,199,151,155,139,96,202,184,202,0,51,7,157,100,197,60,85,87,19,75,170,120,15,44,147,173,115,109,181,241,73,81,185,14,205,58,154,207,106,114,139,44,92,181,200,162,240,162,199,118,37,24,20,24,66,7,164,38,249,179,33,253,27,64,63,186,202,6,81,73,30,201,91,235,9,120,250,71,98,211,2,37,248,210,47,180,19,136,125,73,32,7,59,138,81,141,142,73,76,2,142,254,3,253,51,164,250,252,181,178,41,254,36,114,87,191,56,39,80,9,17,20,116,220,6,12,69,100,29,81,213},
  {2,195,36,88,27,103,86,20,115,111,87,100,33,44,198,26,133,100,46,148,137,11,192,61,213,156,149,234,92,112,104,62,94,53,132,135,165,121,229,25,54,198,40,193,149,254,42,95,184,0,220,212,177,165,58,71,89,91,144,170,210,30,26,167,127,46,189,16,133,248,174,174,174,42,94,254,247,22,38,25,212,215,207,54,243,102,131,108,11,219,33,124,163,182,163,182,146,230,208,81,19,52,231,159,83,79,40,28,55,175,208,69,244,44,45,126,230,100,89,22,78,231,12,88,201,159,139,15,138,15,195,61,26,252,31,166,97,12,67,45,34,231,134,189,69,17,113,118,198,72,166,220,134,106,109,187,64,20,105,195,183,213,253,94,51,230,32,0,74,151,133,201,89,156,228,64,76,178,154,234,100,199,222,92,175,174,82,201,249,119,152,91,128,152,131,198,8,73,230,55,145,229,230,47,212,174,97,242,56,137,91,229,188,28,25,20,228,58,69,114,105,231,140,215,138,89,66,63,135,149,40,85,25,228,103,74,253,111,5,186,247,213,166,36,156,174,177,110,88,16,174,160,149,158,204,104,67,29,126,40,134,20,89,187,76,132,245,148,107,100,114,165,18,79,162,215,40,110,114,193,183,187,79,100,186,85,200,127,84,234,19,136,237,81,200,80,99,246,140,226,43,240,213,150,24,33,237,111,111,50,190,83,32,199,117,41,210,9,151,119,34,194,205,190,128,137,195,156,146,116,196,86,64,254,10,104,234,20,75,31,61,143,248,201,55,196,65,130,231,61,252,100,109,60,103,4,29,130,5,206,151,36,12,231,0,103,114,55,172,227,108,166,131,119,21,190,121,69,54,234,210,58,65,81,114,98,173,23,214,195,30,191,120,76,65,102,230,128,59,3,226,206,156,220,81,102,109,73,77,95,4,254,153,218,20,179,189,143,46,76,51,249,86,105,136,115,124,202,161,232,182,174,141,200,40,29,201,233,169,56,115,57,189,161,110,69,186,138,12,190,7,138,83,163,216,171,111,120,33,113,105,246,129,77,81,211,146,96,50,191,253,168,35,76,95,63,40,222,65,7,125,1,108,105,95,20,40,57,25,15,45,152,13,168,93,244,0,136,127,108,46,38,238,251,183,178,46,224,228,32,62,207,154,195,195,207,78,249,124,75,149,174,116,227,41,217,203,7,241,110,215,130,141,14,217,149,235,85,197,144,17,124,204,198,106,80,217,155,75,255,118,152,31,33,69,169,115,177,13,49,44,37,218,150,136,216,109,74,234,218,194,177,53,117,205,56,120,174,186,58,5,151,87,247,209,53,181,201,224,159,99,213,71,46,250,177,57,228,117,254,49,178,24,31,249,3,101,111,217,188,48,143,192,66,65,242,126,16,23,135,211,139,176,31,136,183,55,20,41,146,103,241,185,125,58,33,146,238,76,162,7,125,103,181,43,225,151,56,4,247,31,144,83,105,75,151,141,159,71,225,8,141,153,96,189,188,162,250,229,237,2,52,25,226,64,132,121,119,184,104,0,156,146,229,147,111,230,33,19,87,211,92,211,250,128,77,226,181,151,225,17,231,191,168,180,69,248,155,131,29,114,69,163,94,97,20,124,127,45,95,82,14,49,108,5,157,148,217,43,72,13,92,135,244,35,20,40,78,247,35,20,143,96,233,66,140,199,220,242,208,82,90,169,190,205,189,100,68,107,193,200,60,51,122,198,195,187,144,84,17,142,53,22,208,86,101,95,197,192,66,2,48,27,56,212,90,142,6,118,86,249,80,231,255,72,0,238,27,128,101,187,250,228,135,204,121,75,133,186,207,171,43,174,63,57,45,42,170,186,255,5,145,155,175,124,244,47,36,19,75,42,42,202,10,240,52,223,40,120,248,49,217,145,120,6,73,58,11,48,251,118,151,181,124,89,140,176,242,254,6,53,118,76,156,114,154,94,30,180,34,75,7,194,34,172,200,244,116,212,17,140,43,147,144,159,84,126,31,243,237,64,124,148,212,4,187,63,186,8,212,82,237,111,122,117,44,115,147,239,55,154,219,187,198,89,185,191,210,45,142,255,31,195,182,43,39,14,10,4,68,160,103,74,124,7,175,89,150,36,21,169,217,215,22,137,76,31,66,43,76,30,67,134,188,167,168,195,135,22,230,135,207,167,37,37,200,83,255,87,25,156,125,199,12,51,7,190,135,157,223,240,80,7,179,117,144,153,180,255,197,179,231,244,36,195,254,27,213,61,80,239,253,0,90,167,147,123,43,86,128,243,237,58,72,187,45,185,88,227,236,118,37,62,99,209,205,64,152,88,193,240,220,60,203,82,239,230,125,150,38,82,168,71,158,161,202,41,114,234,9,230,236,140,212,113,32,15,89,206,180,0,243,170,136,232,144,122,72,66,37,14,181,205,56,14,229,194,14,201,35,164,94,10,80,247,53,70,66,10,176,208,207,42,4,96,17,141,138,86,107,248,234,121,123,196,80,222,48,116,237,114,144,9,157,180,106,47,28,96,248,188,149,35,133,106,75,153,0,116,27,48,69,53,131,177,199,251,92,199,16,205,227,243,212,234,45,63,210,26,250,33,77,204,166,128,172,105,30,7,247,205,137,145,63,5,225,65,56,185,119,13,201,195,41,100,123,212,53,192,62,228,179,146,238,211,100,82,225,35,235,247,89,221,162,168,30,164,8,165,235,176,181,175,234,237,212,34,3,64,76,32,178,83,66,62,166,175,152,165,167,75,140,16,160,162,36,40,252,125,98,142,199,68,215,241,220,254,244,112,181,106,26,138,247,204,228,49,3,104,252,4,197,136,220,50,114,200,82,66,61,138,227,142,88,54,209,233,2,125,137,177,13,52,202,80,38,218,134,194,160,62,180,246,3,50,26,116,251,63,116,115,91,246,60,134,61,150,191,41,167,5,132,247,30,245,29,175,207,245,173,110,40,23,131,108,145,132,200,46,74,34,97},
} ;

static void test_decode_857x5167_impl(long long impl)
{
  unsigned char *x = test_decode_857x5167_x;
  unsigned char *s = test_decode_857x5167_s;
  unsigned char *x2 = test_decode_857x5167_x2;
  unsigned char *s2 = test_decode_857x5167_s2;
  long long xwords = crypto_decode_ITEMS;
  long long xlen;
  long long slen = crypto_decode_STRBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_decode_857x5167_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_decode = ntruprime_dispatch_decode_857x5167(impl);
    printf("decode_857x5167 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_857x5167_implementation(impl),ntruprime_dispatch_decode_857x5167_compiler(impl));
  } else {
    crypto_decode = ntruprime_decode_857x5167;
    printf("decode_857x5167 selected implementation %s compiler %s\n",ntruprime_decode_857x5167_implementation(),ntruprime_decode_857x5167_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_decode_ITEMBYTES;

      output_prepare(x2,x,xlen);
      input_prepare(s2,s,slen);
      secret(s,slen);
      crypto_decode(x,s);
      public(s,slen);
      public(x,xlen);
      endianness(x,xwords,crypto_decode_ITEMBYTES);
      checksum(x,xlen);
      output_compare(x2,x,xlen,"crypto_decode");
      input_compare(s2,s,slen,"crypto_decode");

      double_canary(x2,x,xlen);
      double_canary(s2,s,slen);
      secret(s2,slen);
      crypto_decode(x2,s2);
      public(s2,slen);
      public(x2,xlen);
      endianness(x2,xwords,crypto_decode_ITEMBYTES);
      if (memcmp(x2,x,xlen) != 0) fail("failure: crypto_decode is nondeterministic\n");
    }
    checksum_expected(decode_857x5167_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_decode_857x5167_NUM;++precomp) {
    output_prepare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
    input_prepare(s2,s,crypto_decode_STRBYTES);
    memcpy(s,precomputed_decode_857x5167_s[precomp],crypto_decode_STRBYTES);
    memcpy(s2,precomputed_decode_857x5167_s[precomp],crypto_decode_STRBYTES);
    crypto_decode(x,s);
    if (memcmp(x,precomputed_decode_857x5167_x[precomp],crypto_decode_ITEMS*crypto_decode_ITEMBYTES)) {
      fail("failure: crypto_decode fails precomputed test vectors\n");
      printf("expected x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",((unsigned char *) precomputed_decode_857x5167_x[precomp])[pos]);
      printf("\n");
      printf("received x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",x[pos]);
      printf("\n");
    }
    output_compare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES,"crypto_decode");
    input_compare(s2,s,crypto_decode_STRBYTES,"crypto_decode");
  }
}

void test_decode_857x5167(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"857x5167")) return;
  storage_decode_857x5167_x = callocplus(crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  test_decode_857x5167_x = aligned(storage_decode_857x5167_x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  if (crypto_decode_ITEMS*crypto_decode_ITEMBYTES > maxalloc) maxalloc = crypto_decode_ITEMS*crypto_decode_ITEMBYTES;
  storage_decode_857x5167_s = callocplus(crypto_decode_STRBYTES);
  test_decode_857x5167_s = aligned(storage_decode_857x5167_s,crypto_decode_STRBYTES);
  if (crypto_decode_STRBYTES > maxalloc) maxalloc = crypto_decode_STRBYTES;
  storage_decode_857x5167_x2 = callocplus(maxalloc);
  test_decode_857x5167_x2 = aligned(storage_decode_857x5167_x2,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  storage_decode_857x5167_s2 = callocplus(maxalloc);
  test_decode_857x5167_s2 = aligned(storage_decode_857x5167_s2,crypto_decode_STRBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("decode_857x5167 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_decode_857x5167();++impl)
      forked(test_decode_857x5167_impl,impl);
    ++test_decode_857x5167_x;
    ++test_decode_857x5167_s;
    ++test_decode_857x5167_x2;
    ++test_decode_857x5167_s2;
  }
  free(storage_decode_857x5167_s2);
  free(storage_decode_857x5167_x2);
  free(storage_decode_857x5167_s);
  free(storage_decode_857x5167_x);
}
#undef crypto_decode_STRBYTES
#undef crypto_decode_ITEMS
#undef crypto_decode_ITEMBYTES

